/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath;

import org.exolab.adaptx.xpath.XPathResult;

public final class BooleanResult
extends XPathResult {
    public static final BooleanResult FALSE = new BooleanResult(false);
    public static final BooleanResult TRUE = new BooleanResult(true);
    private final boolean _value;

    private BooleanResult(boolean bl) {
        this._value = bl;
    }

    public boolean booleanValue() {
        return this._value;
    }

    public boolean equals(XPathResult xPathResult) {
        return xPathResult == this;
    }

    public static BooleanResult from(XPathResult xPathResult) {
        return xPathResult.booleanValue() ? TRUE : FALSE;
    }

    public static BooleanResult from(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public int getResultType() {
        return 0;
    }

    public Object javaObject() {
        return this._value ? Boolean.TRUE : Boolean.FALSE;
    }

    public double numberValue() {
        return this._value ? 1.0 : 0.0;
    }

    public String stringValue() {
        return this._value ? "true" : "false";
    }

    public String toString() {
        return this._value ? "true" : "false";
    }
}

