/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.util.LDAPWriter;
import netscape.ldap.util.LDIF;

public class DSMLWriter
extends LDAPWriter {
    public DSMLWriter(PrintWriter printWriter) {
        super(printWriter);
    }

    protected void printAttribute(LDAPAttribute lDAPAttribute) {
        String string = lDAPAttribute.getName();
        if (string.equalsIgnoreCase("objectclass")) {
            Enumeration enumeration = lDAPAttribute.getStringValues();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    this.printString("    <dsml:objectclass>" + string2 + "</dsml:objectclass>");
                }
            }
            return;
        }
        this.printString("    <dsml:attr name=\"" + string + "\">");
        Enumeration enumeration = lDAPAttribute.getByteValues();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string3;
                byte[] byArray = (byte[])enumeration.nextElement();
                if (LDIF.isPrintable(byArray)) {
                    try {
                        string3 = new String(byArray, "UTF8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        string3 = "";
                    }
                    this.printEscapedValue("      <dsml:value>", string3, "</dsml:value>");
                    continue;
                }
                string3 = this.getPrintableValue(byArray);
                if (string3.length() <= 0) continue;
                this.printString("      <dsml:value encoding=\"base64\">");
                this.printString("       " + string3);
                this.printString("      </dsml:value>");
            }
        }
        this.printString("    </dsml:attr>");
    }

    protected void printAttributeSchema(LDAPSchema lDAPSchema) {
        Enumeration enumeration = lDAPSchema.getAttributes();
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            LDAPAttributeSchema lDAPAttributeSchema = (LDAPAttributeSchema)enumeration.nextElement();
            this.printString("    <dsml:attribute-type");
            this.printString("      id=\"" + lDAPAttributeSchema.getName() + "\"");
            this.printString("      oid=\"" + lDAPAttributeSchema.getID() + "\"");
            String string = lDAPAttributeSchema.getSuperior();
            if (string != null) {
                this.printString("      superior=\"#" + string + "\"");
            }
            if (lDAPAttributeSchema.isSingleValued()) {
                this.printString("      single-value=true");
            }
            if (lDAPAttributeSchema.isObsolete()) {
                this.printString("      obsolete=true");
            }
            if (lDAPAttributeSchema.getQualifier("NO-USER-MODIFICATION") != null) {
                this.printString("      user-modification=false");
            }
            if ((stringArray = lDAPAttributeSchema.getQualifier("EQUALITY")) != null && stringArray.length > 0) {
                this.printString("      equality=" + stringArray[0]);
            }
            if ((stringArray = lDAPAttributeSchema.getQualifier("ORDERING")) != null && stringArray.length > 0) {
                this.printString("      ordering=" + stringArray[0]);
            }
            if ((stringArray = lDAPAttributeSchema.getQualifier("SUBSTR")) != null && stringArray.length > 0) {
                this.printString("      substring=" + stringArray[0]);
            }
            this.printString("      <dsml:name>" + lDAPAttributeSchema.getName() + "</dsml:name>");
            this.printString("      <dsml:description>" + lDAPAttributeSchema.getDescription() + "</dsml:description>");
            this.printString("      <dsml:syntax>" + lDAPAttributeSchema.getSyntaxString() + "</dsml:syntax>");
            this.printString("    </dsml:attribute-type>");
        }
    }

    protected void printEntryEnd(String string) {
        this.printString("  </dsml:entry>");
    }

    protected void printEntryStart(String string) {
        if (string == null) {
            string = "";
        }
        this.printString("  <dsml:entry dn=\"" + string + "\">");
    }

    protected void printEscapedValue(String string, String string2, String string3) {
        this.m_pw.print(string);
        int n = string2.length();
        char[] cArray = new char[n];
        string2.getChars(0, n, cArray, 0);
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '<': {
                    this.m_pw.print("&lt;");
                    break;
                }
                case '&': {
                    this.m_pw.print("&amp;");
                    break;
                }
                default: {
                    this.m_pw.print(c);
                }
            }
            ++n2;
        }
        this.m_pw.print(string3);
        this.m_pw.print('\n');
    }

    protected void printObjectClassSchema(LDAPSchema lDAPSchema) {
        Enumeration enumeration = lDAPSchema.getObjectClasses();
        while (enumeration.hasMoreElements()) {
            LDAPObjectClassSchema lDAPObjectClassSchema = (LDAPObjectClassSchema)enumeration.nextElement();
            this.printString("    <dsml:class");
            this.printString("      id=\"" + lDAPObjectClassSchema.getName() + "\"");
            this.printString("      oid=\"" + lDAPObjectClassSchema.getID() + "\"");
            String[] stringArray = lDAPObjectClassSchema.getSuperiors();
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    this.printString("      superior=\"#" + stringArray[n] + "\"");
                    ++n;
                }
            }
            String string = "structural";
            switch (lDAPObjectClassSchema.getType()) {
                case 1: {
                    string = "abstract";
                    break;
                }
                case 2: {
                    string = "auxiliary";
                    break;
                }
            }
            this.printString("      type=\"" + string + "\">");
            if (lDAPObjectClassSchema.isObsolete()) {
                this.printString("      obsolete=true");
            }
            this.printString("      <dsml:name>" + lDAPObjectClassSchema.getName() + "</dsml:name>");
            this.printString("      <dsml:description>" + lDAPObjectClassSchema.getDescription() + "</dsml:description>");
            Enumeration enumeration2 = lDAPObjectClassSchema.getRequiredAttributes();
            while (enumeration2.hasMoreElements()) {
                this.printString("      <dsml:attribute ref=\"#" + (String)enumeration2.nextElement() + " required=\"true\"/>");
            }
            enumeration2 = lDAPObjectClassSchema.getOptionalAttributes();
            while (enumeration2.hasMoreElements()) {
                this.printString("      <dsml:attribute ref=\"#" + (String)enumeration2.nextElement() + " required=\"false\"/>");
            }
            this.printString("    </dsml:class>");
        }
    }

    public void printSchema(LDAPEntry lDAPEntry) {
        LDAPSchema lDAPSchema = new LDAPSchema(lDAPEntry);
        this.printString("  <dsml:directory-schema>");
        this.printObjectClassSchema(lDAPSchema);
        this.printAttributeSchema(lDAPSchema);
        this.printString("  </dsml:directory-schema>");
    }

    protected void printString(String string) {
        this.m_pw.print(string);
        this.m_pw.print('\n');
    }
}

