/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.utils.Base64;
import org.apache.xerces.validators.datatype.AbstractStringValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class Base64BinaryDatatypeValidator
extends AbstractStringValidator {
    public Base64BinaryDatatypeValidator() throws InvalidDatatypeFacetException {
        super(null, null, false);
    }

    public Base64BinaryDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_STRING_FACET, 0, new Object[]{string}));
    }

    protected void checkValueSpace(String string) throws InvalidDatatypeValueException {
        if (this.getLength(string) <= 0) {
            throw new InvalidDatatypeValueException("Value '" + string + "' is not encoded in Base64");
        }
    }

    protected int getLength(String string) {
        return Base64.getDecodedDataLength(string.getBytes());
    }
}

