'''OpenGL extension MESA.resize_buffers

Overview (from the spec)
	
	Mesa is often used as a client library with no integration with
	the computer's window system (an X server, for example).  And since
	Mesa does not have an event loop nor window system callbacks, it
	cannot properly respond to window system events.  In particular,
	Mesa cannot automatically detect when a window has been resized.
	
	Mesa's glViewport command queries the current window size and updates
	its internal data structors accordingly.  This normally works fine
	since most applications call glViewport in responce to window size
	changes.
	
	In some situations, however, the application may not call glViewport
	when a window size changes but would still like Mesa to adjust to
	the new window size.  This extension exports a new function to solve
	this problem.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/MESA/resize_buffers.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes

glResizeBuffersMESA = platform.createExtensionFunction( 
	'glResizeBuffersMESA', dll=platform.GL,
	resultType=None, 
	argTypes=(),
	doc = 'glResizeBuffersMESA(  ) -> None',
	argNames = (),
)


def glInitResizeBuffersMESA():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_MESA_resize_buffers' )
