/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class FTPFrame
extends JFrame
implements ActionListener,
MouseListener {
    VncViewer viewer;
    private JPanel jContentPane = null;
    private JPanel topPanel = null;
    private JPanel topPanelLocal = null;
    private JPanel topPanelRemote = null;
    private JPanel topPanelCenter = null;
    private JPanel statusPanel = null;
    private JPanel remotePanel = null;
    private JPanel localPanel = null;
    private JPanel buttonPanel = null;
    private JButton sendButton = null;
    private JButton receiveButton = null;
    private JButton deleteButton = null;
    private JButton newFolderButton = null;
    private JButton stopButton = null;
    private JButton closeButton = null;
    private JButton dummyButton = null;
    private JComboBox localDrivesComboBox = null;
    private JComboBox remoteDrivesComboBox = null;
    private JTextField localMachineLabel = null;
    private JTextField remoteMachineLabel = null;
    private JButton localTopButton = null;
    private JButton remoteTopButton = null;
    private JScrollPane localScrollPane = null;
    private JList localFileTable = null;
    private JScrollPane remoteScrollPane = null;
    private JList remoteFileTable = null;
    private JTextField remoteLocation = null;
    private JTextField localLocation = null;
    private JTextField localStatus = null;
    public JTextField remoteStatus = null;
    public JComboBox historyComboBox = null;
    public JProgressBar jProgressBar = null;
    public JTextField connectionStatus = null;
    public boolean updateDriveList;
    private Vector remoteList = null;
    private Vector localList = null;
    private File currentLocalDirectory = null;
    private File currentRemoteDirectory = null;
    private File localSelection = null;
    private String remoteSelection = null;
    public String selectedTable = null;
    private JButton viewButton = null;
    public File saveLocalDirectory = null;
    public long saveLocalDirectoryTime = 0L;
    public int saveLocalDirectoryCount = 0;
    public String saveRemoteDirectory = null;
    public long saveRemoteDirectoryTime = 0L;
    public int saveRemoteDirectoryCount = 0;
    private boolean localCurrentIsDir = true;
    private ArrayList DirsList;
    private ArrayList FilesList;

    public static void main(String[] stringArray) {
    }

    FTPFrame(VncViewer vncViewer) {
        super("Ultr@VNC File Transfer");
        this.viewer = vncViewer;
        this.setResizable(false);
        this.setSize(320, 240);
        this.DirsList = new ArrayList();
        this.FilesList = new ArrayList();
        this.initialize();
    }

    void refreshLocalLocation() {
        File file = new File(this.localLocation.getText());
        this.changeLocalDirectory(file);
    }

    void refreshRemoteLocation() {
        this.remoteList.clear();
        this.remoteFileTable.setListData(this.remoteList);
        System.out.println("refreshRemoteLocation '" + this.remoteLocation.getText() + "'");
        this.viewer.rfb.readServerDirectory(this.remoteLocation.getText());
    }

    public void setSavedLocations() {
        this.saveLocalDirectory = this.currentLocalDirectory;
        this.saveLocalDirectoryTime = System.currentTimeMillis();
        this.saveLocalDirectoryCount = 0;
        if (this.remoteLocation != null) {
            this.saveRemoteDirectory = this.remoteLocation.getText();
            System.out.println("RemoteSave '" + this.saveRemoteDirectory + "'");
        }
        this.saveRemoteDirectoryTime = System.currentTimeMillis();
        this.saveRemoteDirectoryCount = 0;
    }

    private File saveLocalHack(File file) {
        ++this.saveLocalDirectoryCount;
        System.out.println("L " + this.saveLocalDirectoryCount + " dt: " + (System.currentTimeMillis() - this.saveLocalDirectoryTime) + " - " + this.saveLocalDirectory);
        if (System.currentTimeMillis() > this.saveLocalDirectoryTime + 2000L || this.saveLocalDirectoryCount > 2) {
            this.saveLocalDirectory = null;
        }
        if (this.saveLocalDirectory != null) {
            this.currentLocalDirectory = this.saveLocalDirectory;
            this.localLocation.setText(this.saveLocalDirectory.toString());
            return this.saveLocalDirectory;
        }
        return file;
    }

    private String saveRemoteHack(String string) {
        ++this.saveRemoteDirectoryCount;
        System.out.println("R " + this.saveRemoteDirectoryCount + " - " + this.saveRemoteDirectory);
        if (this.saveRemoteDirectory != null && this.saveRemoteDirectoryCount > 1) {
            this.saveRemoteDirectory = null;
        }
        if (this.saveRemoteDirectory != null && !this.saveRemoteDirectory.equals("")) {
            System.out.println("saveRemoteHack setText + refreshRemoteLocation '" + this.saveRemoteDirectory + "'");
            return this.saveRemoteDirectory;
        }
        return string;
    }

    String[] printDrives(String string) {
        System.out.println(string);
        this.updateDriveList = true;
        this.remoteDrivesComboBox.removeAllItems();
        int n = string.length();
        String string2 = null;
        String[] stringArray = new String[string.length() / 3];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2 / 3] = string.substring(n2, n2 + 2);
            string2 = string.substring(n2 + 2, n2 + 3);
            if (string2.compareTo("f") == 0) {
                int n3 = n2 / 3;
                stringArray[n3] = stringArray[n3] + "\\ Floppy";
            }
            if (string2.compareTo("l") == 0) {
                int n4 = n2 / 3;
                stringArray[n4] = stringArray[n4] + "\\ Local Disk";
            }
            if (string2.compareTo("c") == 0) {
                int n5 = n2 / 3;
                stringArray[n5] = stringArray[n5] + "\\ CD-ROM";
            }
            if (string2.compareTo("n") == 0) {
                int n6 = n2 / 3;
                stringArray[n6] = stringArray[n6] + "\\ Network";
            }
            this.remoteDrivesComboBox.addItem(stringArray[n2 / 3]);
            n2 += 3;
        }
        boolean bl = false;
        int n7 = 0;
        while (n7 < this.remoteDrivesComboBox.getItemCount()) {
            if (this.remoteDrivesComboBox.getItemAt(n7).toString().substring(0, 1).toUpperCase().equals("C")) {
                this.remoteDrivesComboBox.setSelectedIndex(n7);
                bl = true;
            }
            ++n7;
        }
        if (!bl) {
            this.remoteDrivesComboBox.setSelectedIndex(0);
        }
        this.updateDriveList = false;
        return stringArray;
    }

    public void disableButtons() {
        this.closeButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.localTopButton.setEnabled(false);
        this.newFolderButton.setEnabled(false);
        this.stopButton.setVisible(true);
        this.stopButton.setEnabled(true);
        this.receiveButton.setEnabled(false);
        this.viewButton.setEnabled(false);
        this.remoteTopButton.setEnabled(false);
        this.sendButton.setEnabled(false);
        this.remoteFileTable.setEnabled(false);
        this.localFileTable.setEnabled(false);
        this.localLocation.setEnabled(false);
        this.remoteLocation.setEnabled(false);
        this.remoteDrivesComboBox.setEnabled(false);
        this.localDrivesComboBox.setEnabled(false);
        this.setDefaultCloseOperation(0);
    }

    public void enableButtons() {
        this.closeButton.setEnabled(true);
        this.deleteButton.setEnabled(true);
        this.localTopButton.setEnabled(true);
        this.newFolderButton.setEnabled(true);
        this.stopButton.setVisible(false);
        this.stopButton.setEnabled(false);
        this.receiveButton.setEnabled(true);
        this.viewButton.setEnabled(true);
        this.remoteTopButton.setEnabled(true);
        this.sendButton.setEnabled(true);
        this.remoteFileTable.setEnabled(true);
        this.localFileTable.setEnabled(true);
        this.localLocation.setEnabled(true);
        this.remoteLocation.setEnabled(true);
        this.remoteDrivesComboBox.setEnabled(true);
        this.localDrivesComboBox.setEnabled(true);
    }

    void printDirectory(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            this.remoteList.addElement(arrayList.get(n));
            ++n;
        }
        this.remoteFileTable.setListData(this.remoteList);
    }

    private void initialize() {
        this.setSize(794, 500);
        this.setContentPane(this.getJContentPane());
        this.updateDriveList = true;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getTopPanel(), "North");
            this.jContentPane.add((Component)this.getStatusPanel(), "South");
            this.jContentPane.add((Component)this.getRemotePanel(), "East");
            this.jContentPane.add((Component)this.getLocalPanel(), "West");
            this.jContentPane.add((Component)this.getButtonPanel(), "Center");
            System.out.println("getJContentPane");
        }
        return this.jContentPane;
    }

    private JPanel getTopPanelLocal() {
        if (this.topPanelLocal == null) {
            this.topPanelLocal = new JPanel();
            this.topPanelLocal.setLayout(new BorderLayout());
            this.topPanelLocal.setPreferredSize(new Dimension(325, 22));
            this.topPanelLocal.add((Component)this.getLocalDrivesComboBox(), "West");
            this.topPanelLocal.add((Component)this.getLocalMachineLabel(), "Center");
            this.topPanelLocal.add((Component)this.getLocalTopButton(), "East");
            this.topPanelLocal.setBackground(Color.lightGray);
            System.out.println("getTopPanelLocal");
        }
        return this.topPanelLocal;
    }

    private JPanel getTopPanelRemote() {
        if (this.topPanelRemote == null) {
            this.topPanelRemote = new JPanel();
            this.topPanelRemote.setLayout(new BorderLayout());
            this.topPanelRemote.setPreferredSize(new Dimension(325, 20));
            this.topPanelRemote.add((Component)this.getRemoteDrivesComboBox(), "West");
            this.topPanelRemote.add((Component)this.getRemoteMachineLabel(), "Center");
            this.topPanelRemote.add((Component)this.getRemoteTopButton(), "East");
            this.topPanelRemote.setBackground(Color.lightGray);
            System.out.println("getTopPanelRemote");
        }
        return this.topPanelRemote;
    }

    private JPanel getTopPanelCenter() {
        if (this.topPanelCenter == null) {
            this.topPanelCenter = new JPanel();
            this.topPanelCenter.add((Component)this.getDummyButton(), null);
            System.out.println("getTopPanelCenter");
        }
        return this.topPanelCenter;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BorderLayout());
            this.topPanel.add((Component)this.getTopPanelLocal(), "West");
            this.topPanel.add((Component)this.getTopPanelRemote(), "East");
            System.out.println("getTopPanel");
        }
        return this.topPanel;
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 1));
            this.statusPanel.add((Component)this.getHistoryComboBox(), null);
            this.statusPanel.add((Component)this.getJProgressBar(), null);
            this.statusPanel.add((Component)this.getConnectionStatus(), null);
            this.statusPanel.setBackground(Color.lightGray);
            System.out.println("getStatusPanel");
        }
        return this.statusPanel;
    }

    private JPanel getRemotePanel() {
        if (this.remotePanel == null) {
            this.remotePanel = new JPanel();
            this.remotePanel.setLayout(new BoxLayout(this.remotePanel, 1));
            this.remotePanel.add((Component)this.getRemoteLocation(), null);
            this.remotePanel.add((Component)this.getRemoteScrollPane(), null);
            this.remotePanel.add((Component)this.getRemoteStatus(), null);
            this.remotePanel.setBackground(Color.lightGray);
            System.out.println("getRemotePanel");
        }
        return this.remotePanel;
    }

    private JPanel getLocalPanel() {
        if (this.localPanel == null) {
            this.localPanel = new JPanel();
            this.localPanel.setLayout(new BoxLayout(this.localPanel, 1));
            this.localPanel.add((Component)this.getLocalLocation(), null);
            this.localPanel.add((Component)this.getLocalScrollPane(), null);
            this.localPanel.add((Component)this.getLocalStatus(), null);
            this.localPanel.setBackground(Color.lightGray);
            this.localPanel.setComponentOrientation(ComponentOrientation.UNKNOWN);
            this.localPanel.setName("localPanel");
            System.out.println("getLocalPanel");
        }
        return this.localPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(null);
            this.buttonPanel.add((Component)this.getReceiveButton(), null);
            this.buttonPanel.add((Component)this.getViewButton(), null);
            this.buttonPanel.add((Component)this.getNewFolderButton(), null);
            this.buttonPanel.add((Component)this.getCloseButton(), null);
            this.buttonPanel.add((Component)this.getDeleteButton(), null);
            this.buttonPanel.add((Component)this.getSendButton(), null);
            this.buttonPanel.add((Component)this.getStopButton(), null);
            this.buttonPanel.setBackground(Color.lightGray);
            System.out.println("getButtonPanel");
        }
        return this.buttonPanel;
    }

    private JButton getSendButton() {
        if (this.sendButton == null) {
            this.sendButton = new JButton();
            this.sendButton.setBounds(15, 30, 107, 25);
            this.sendButton.setText("Send >>");
            this.sendButton.setName("sendButton");
            this.sendButton.addActionListener(this);
            System.out.println("getSendButton");
        }
        return this.sendButton;
    }

    private JButton getReceiveButton() {
        if (this.receiveButton == null) {
            this.receiveButton = new JButton();
            this.receiveButton.setBounds(15, 60, 107, 25);
            this.receiveButton.setText("<< Receive");
            this.receiveButton.setName("receiveButton");
            this.receiveButton.addActionListener(this);
        }
        return this.receiveButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton();
            this.deleteButton.setBounds(15, 110, 107, 25);
            this.deleteButton.setText("Delete File");
            this.deleteButton.setName("deleteButton");
            this.deleteButton.addActionListener(this);
        }
        return this.deleteButton;
    }

    private JButton getNewFolderButton() {
        if (this.newFolderButton == null) {
            this.newFolderButton = new JButton();
            this.newFolderButton.setBounds(15, 140, 107, 25);
            this.newFolderButton.setText("New Folder");
            this.newFolderButton.setName("newFolderButton");
            this.newFolderButton.addActionListener(this);
        }
        return this.newFolderButton;
    }

    private JButton getViewButton() {
        if (this.viewButton == null) {
            this.viewButton = new JButton();
            this.viewButton.setBounds(15, 170, 107, 25);
            this.viewButton.setText("View File");
            this.viewButton.setName("viewButton");
            this.viewButton.addActionListener(this);
        }
        return this.viewButton;
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton();
            this.stopButton.setBounds(15, 200, 107, 25);
            this.stopButton.setText("Stop");
            this.stopButton.setName("stopButton");
            this.stopButton.addActionListener(this);
            this.stopButton.setVisible(false);
        }
        return this.stopButton;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton();
            this.closeButton.setBounds(15, 325, 107, 25);
            this.closeButton.setText("Close");
            this.closeButton.setName("closeButton");
            this.closeButton.addActionListener(this);
        }
        return this.closeButton;
    }

    private JButton getDummyButton() {
        if (this.dummyButton == null) {
            this.dummyButton = new JButton();
            this.dummyButton.setBounds(12, 206, 99, 25);
            this.dummyButton.setText("aaaaaaaaaaaaaaa");
            this.dummyButton.setName("DummyButton");
            this.dummyButton.setVisible(false);
        }
        return this.dummyButton;
    }

    private JComboBox getLocalDrivesComboBox() {
        this.updateDriveList = true;
        File[] fileArray = File.listRoots();
        String[] stringArray = new String[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            stringArray[n] = fileArray[n].toString();
            ++n;
        }
        if (this.localDrivesComboBox == null) {
            this.localDrivesComboBox = new JComboBox<String>(stringArray);
            this.localDrivesComboBox.setName("LocalDisks");
            this.localDrivesComboBox.setFont(new Font("Dialog", 0, 10));
            this.localDrivesComboBox.addActionListener(this);
            System.out.println("getLocalDrivesComboBox");
        }
        this.updateDriveList = false;
        return this.localDrivesComboBox;
    }

    public JComboBox getRemoteDrivesComboBox() {
        if (this.remoteDrivesComboBox == null) {
            this.remoteDrivesComboBox = new JComboBox();
            this.remoteDrivesComboBox.setName("remoteDisks");
            this.remoteDrivesComboBox.setFont(new Font("Dialog", 0, 10));
            this.remoteDrivesComboBox.addActionListener(this);
            System.out.println("getRemoteDrivesComboBox");
        }
        return this.remoteDrivesComboBox;
    }

    private JTextField getLocalMachineLabel() {
        if (this.localMachineLabel == null) {
            this.localMachineLabel = new JTextField();
            this.localMachineLabel.setAlignmentX(0.5f);
            this.localMachineLabel.setBackground(Color.lightGray);
            this.localMachineLabel.setText("             LOCAL MACHINE");
            this.localMachineLabel.setName("localLocation");
            this.localMachineLabel.setFont(new Font("Dialog", 1, 11));
            this.localMachineLabel.setEditable(false);
            System.out.println("getLocalMachineLabel");
        }
        return this.localMachineLabel;
    }

    private JTextField getRemoteMachineLabel() {
        if (this.remoteMachineLabel == null) {
            this.remoteMachineLabel = new JTextField();
            this.remoteMachineLabel.setName("remoteLocation");
            this.remoteMachineLabel.setText("        REMOTE MACHINE");
            this.remoteMachineLabel.setBackground(Color.lightGray);
            this.remoteMachineLabel.setFont(new Font("Dialog", 1, 11));
            this.remoteMachineLabel.setEditable(false);
        }
        return this.remoteMachineLabel;
    }

    private JButton getLocalTopButton() {
        if (this.localTopButton == null) {
            this.localTopButton = new JButton();
            this.localTopButton.setText("Root (\\)");
            this.localTopButton.setFont(new Font("Dialog", 1, 10));
            this.localTopButton.addActionListener(this);
            System.out.println("getLocalTopButton");
        }
        return this.localTopButton;
    }

    private JButton getRemoteTopButton() {
        if (this.remoteTopButton == null) {
            this.remoteTopButton = new JButton();
            this.remoteTopButton.setText("Root (\\)");
            this.remoteTopButton.setFont(new Font("Dialog", 1, 10));
            this.remoteTopButton.addActionListener(this);
            System.out.println("getRemoteTopButton");
        }
        return this.remoteTopButton;
    }

    private JList getLocalFileTable() {
        if (this.localFileTable == null) {
            this.localList = new Vector(0);
            this.localFileTable = new JList(this.localList);
            this.localFileTable.addMouseListener(this);
            this.localFileTable.setSelectionMode(0);
            System.out.println("getLocalFileTable");
        }
        return this.localFileTable;
    }

    private JScrollPane getLocalScrollPane() {
        if (this.localScrollPane == null) {
            this.localScrollPane = new JScrollPane();
            this.localScrollPane.setViewportView(this.getLocalFileTable());
            this.localScrollPane.setPreferredSize(new Dimension(325, 418));
            this.localScrollPane.setFont(new Font("Dialog", 0, 10));
            this.localScrollPane.setName("localFileList");
            System.out.println("getLocalScrollPane");
        }
        return this.localScrollPane;
    }

    private JList getRemoteFileTable() {
        if (this.remoteFileTable == null) {
            this.remoteList = new Vector(0);
            this.remoteFileTable = new JList(this.remoteList);
            this.remoteFileTable.addMouseListener(this);
            this.remoteFileTable.setSelectedValue("C:\\", false);
            this.remoteFileTable.setSelectionMode(0);
            System.out.println("getRemoteFileTable");
        }
        return this.remoteFileTable;
    }

    private JScrollPane getRemoteScrollPane() {
        if (this.remoteScrollPane == null) {
            this.remoteScrollPane = new JScrollPane();
            this.remoteScrollPane.setViewportView(this.getRemoteFileTable());
            this.remoteScrollPane.setPreferredSize(new Dimension(325, 418));
            System.out.println("getRemoteScrollPane");
        }
        return this.remoteScrollPane;
    }

    private JTextField getRemoteLocation() {
        if (this.remoteLocation == null) {
            this.remoteLocation = new JTextField();
            this.remoteLocation.setText("");
            this.remoteLocation.setEditable(false);
            this.remoteLocation.setBackground(new Color(255, 255, 238));
            this.remoteLocation.setFont(new Font("Dialog", 0, 10));
            System.out.println("getRemoteLocation");
        }
        return this.remoteLocation;
    }

    private JTextField getLocalLocation() {
        if (this.localLocation == null) {
            this.localLocation = new JTextField();
            this.localLocation.setText("");
            this.localLocation.setEditable(false);
            this.localLocation.setBackground(new Color(255, 255, 238));
            this.localLocation.setFont(new Font("Dialog", 0, 10));
            System.out.println("getLocalLocation");
        }
        return this.localLocation;
    }

    private JTextField getLocalStatus() {
        if (this.localStatus == null) {
            this.localStatus = new JTextField();
            this.localStatus.setBackground(Color.lightGray);
            this.localStatus.setFont(new Font("Dialog", 0, 10));
            this.localStatus.setEditable(false);
            System.out.println("getLocalStatus");
        }
        return this.localStatus;
    }

    private JTextField getRemoteStatus() {
        if (this.remoteStatus == null) {
            this.remoteStatus = new JTextField();
            this.remoteStatus.setBackground(Color.lightGray);
            this.remoteStatus.setFont(new Font("Dialog", 0, 10));
            this.remoteStatus.setEditable(false);
            System.out.println("getRemoteStatus");
        }
        return this.remoteStatus;
    }

    private JComboBox getHistoryComboBox() {
        if (this.historyComboBox == null) {
            this.historyComboBox = new JComboBox();
            this.historyComboBox.setFont(new Font("Dialog", 1, 10));
            this.historyComboBox.insertItemAt(new String("Pulldown to view history ..."), 0);
            this.historyComboBox.setSelectedIndex(0);
            this.historyComboBox.addActionListener(this);
            System.out.println("getHistoryComboBox");
        }
        return this.historyComboBox;
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar();
            System.out.println("getJProgressBar");
        }
        return this.jProgressBar;
    }

    private JTextField getConnectionStatus() {
        if (this.connectionStatus == null) {
            this.connectionStatus = new JTextField();
            this.connectionStatus.setText("Connected...");
            this.connectionStatus.setBackground(Color.lightGray);
            this.connectionStatus.setFont(new Font("Dialog", 0, 10));
            System.out.println("getConnectionStatus");
        }
        this.connectionStatus.setEditable(false);
        return this.connectionStatus;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println(actionEvent.getSource());
        if (actionEvent.getSource() == this.closeButton) {
            this.doClose();
        } else if (actionEvent.getSource() == this.sendButton) {
            this.doSend();
        } else if (actionEvent.getSource() == this.receiveButton) {
            this.doReceive();
        } else if (actionEvent.getSource() == this.viewButton) {
            this.doView();
        } else if (actionEvent.getSource() == this.localDrivesComboBox) {
            this.changeLocalDrive();
        } else if (actionEvent.getSource() == this.remoteDrivesComboBox) {
            System.out.println("remoteDrivesComboBox");
            this.changeRemoteDrive();
            this.remoteList.clear();
            this.remoteFileTable.setListData(this.remoteList);
        } else if (actionEvent.getSource() == this.localTopButton) {
            this.changeLocalDrive();
        } else if (actionEvent.getSource() == this.remoteTopButton) {
            System.out.println("remoteTopButton");
            this.changeRemoteDrive();
        } else if (actionEvent.getSource() == this.deleteButton) {
            this.doDelete();
        } else if (actionEvent.getSource() == this.newFolderButton) {
            this.doNewFolder();
        } else if (actionEvent.getSource() == this.stopButton) {
            this.doStop();
        }
    }

    private void doNewFolder() {
        String string = JOptionPane.showInputDialog(null, "Enter new directory name", "Create New Directory", 3);
        if (this.selectedTable.equals("remote")) {
            string = this.remoteLocation.getText() + string;
            this.viewer.rfb.createRemoteDirectory(string);
        } else {
            string = this.localLocation.getText() + string;
            File file = new File(string);
            file.mkdir();
            this.refreshLocalLocation();
            this.historyComboBox.insertItemAt(new String("Created Local Directory: " + string), 0);
            this.historyComboBox.setSelectedIndex(0);
        }
    }

    public void doClose() {
        try {
            this.setVisible(false);
            this.viewer.rfb.writeFramebufferUpdateRequest(0, 0, this.viewer.rfb.framebufferWidth, this.viewer.rfb.framebufferHeight, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void doOpen() {
        try {
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doDelete() {
        System.out.println("Delete Button Pressed");
        if (this.selectedTable.equals("remote")) {
            int n;
            String string = (String)this.remoteFileTable.getSelectedValue();
            if (string.substring(0, 2).equals(" [") && string.substring(string.length() - 1, string.length()).equals("]")) {
                JOptionPane.showMessageDialog(null, "Directory Deletion is not yet available in this version...", "FileTransfer Info", 1);
                return;
            }
            if (this.remoteList.contains(string) && (n = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the file \n< " + string + " >\n on Remote Machine ?", "File Transfer Warning", 0)) == 1) {
                return;
            }
            String string2 = this.remoteLocation.getText() + string.substring(1);
            this.viewer.rfb.deleteRemoteFile(string2);
        } else {
            int n;
            String string = (String)this.localFileTable.getSelectedValue();
            if (string.substring(0, 2).equals(" [") && string.substring(string.length() - 1, string.length()).equals("]")) {
                JOptionPane.showMessageDialog(null, "Directory Deletion is not yet available in this version...", "FileTransfer Info", 1);
                return;
            }
            if (this.localList.contains(string) && (n = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete the file \n< " + string + " >\n on Local Machine ?", "File Transfer Warning", 0)) == 1) {
                return;
            }
            String string3 = this.localLocation.getText() + string.substring(1);
            File file = new File(string3);
            file.delete();
            this.refreshLocalLocation();
            this.historyComboBox.insertItemAt(new String("Deleted On Local Disk: " + string3), 0);
            this.historyComboBox.setSelectedIndex(0);
        }
    }

    private void doReceive() {
        int n;
        System.out.println("Received Button Pressed");
        String string = (String)this.remoteFileTable.getSelectedValue();
        if (string.substring(0, 2).equals(" [") && string.substring(string.length() - 1, string.length()).equals("]")) {
            JOptionPane.showMessageDialog(null, "Directory Transfer is not yet available in this version...", "FileTransfer Info", 1);
            return;
        }
        if (this.localList.contains(string) && (n = JOptionPane.showConfirmDialog(null, "The file < " + string + " >\n already exists on Local Machine\n Are you sure you want to overwrite it ?", "File Transfer Warning", 0)) == 1) {
            return;
        }
        String string2 = this.remoteLocation.getText();
        string2 = string2 + ((String)this.remoteFileTable.getSelectedValue()).substring(1);
        String string3 = this.localLocation.getText() + ((String)this.remoteFileTable.getSelectedValue()).substring(1);
        this.viewer.rfb.requestRemoteFile(string2, string3);
    }

    private void doView() {
        System.out.println("View Button Pressed");
        if (this.selectedTable == null) {
            return;
        }
        if (this.selectedTable.equals("remote")) {
            this.viewRemote();
        } else if (this.selectedTable.equals("local")) {
            this.viewLocal();
        }
    }

    private File doReceiveTmp() {
        if (this.remoteFileTable == null) {
            return null;
        }
        String string = (String)this.remoteFileTable.getSelectedValue();
        if (string == null) {
            return null;
        }
        if (string.substring(0, 2).equals(" [") && string.substring(string.length() - 1, string.length()).equals("]")) {
            return null;
        }
        File file = null;
        try {
            file = File.createTempFile("ULTRAFTP", ".txt");
        }
        catch (Exception exception) {
            return null;
        }
        String string2 = this.remoteLocation.getText();
        string2 = string2 + ((String)this.remoteFileTable.getSelectedValue()).substring(1);
        String string3 = file.getAbsolutePath();
        this.viewer.rfb.requestRemoteFile(string2, string3);
        System.out.println("ReceiveTmp: " + string3);
        return file;
    }

    private void doSend() {
        int n;
        System.out.println("Send Button Pressed");
        String string = (String)this.localFileTable.getSelectedValue();
        if (string.substring(0, 2).equals(" [") && string.substring(string.length() - 1, string.length()).equals("]")) {
            JOptionPane.showMessageDialog(null, "Directory Transfer is not yet available in this version...", "FileTransfer Info", 1);
            return;
        }
        if (this.remoteList.contains(string) && (n = JOptionPane.showConfirmDialog(null, "The file < " + string + " >\n already exists on Remote Machine\n Are you sure you want to overwrite it ?", "File Transfer Warning", 0)) == 1) {
            return;
        }
        String string2 = this.localLocation.getText();
        string2 = string2 + ((String)this.localFileTable.getSelectedValue()).substring(1);
        String string3 = this.remoteLocation.getText();
        this.viewer.rfb.offerLocalFile(string2, string3);
    }

    private void doStop() {
        this.viewer.rfb.fAbort = true;
    }

    private void updateHistory(String string) {
        System.out.println("History: " + string);
        this.historyComboBox.insertItemAt(new String(string), 0);
    }

    public void changeRemoteDrive() {
        this.remoteSelection = null;
        if (!this.updateDriveList) {
            String string = this.remoteDrivesComboBox.getSelectedItem().toString().substring(0, 1) + ":\\";
            System.out.println("changeRemoteDrive-A " + string);
            string = this.saveRemoteHack(string);
            this.viewer.rfb.readServerDirectory(string);
            this.remoteLocation.setText(string);
            System.out.println("changeRemoteDrive-B " + string);
        }
        this.remoteList.clear();
        this.remoteFileTable.setListData(this.remoteList);
    }

    private void changeLocalDrive() {
        File file = new File(this.localDrivesComboBox.getSelectedItem().toString());
        System.out.println("changeLocalDrive " + file.toString());
        if (file.canRead()) {
            this.localSelection = null;
            this.localStatus.setText("");
            this.changeLocalDirectory(file);
        } else {
            this.localList.clear();
            this.localStatus.setText("WARNING: Drive " + this.localDrivesComboBox.getSelectedItem().toString());
            this.connectionStatus.setText(" > WARNING - Local Drive unavailable (possibly restricted access or media not present)");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 1) {
            if (mouseEvent.getSource() == this.localFileTable) {
                this.updateLocalFileTableSelection();
            } else if (mouseEvent.getSource() == this.remoteFileTable) {
                this.updateRemoteFileTableSelection();
            }
        } else if (mouseEvent.getClickCount() == 2) {
            if (mouseEvent.getSource() == this.localFileTable) {
                this.updateLocalFileTable();
            } else if (mouseEvent.getSource() == this.remoteFileTable) {
                this.updateRemoteFileTable();
            }
        }
    }

    private void updateRemoteFileTableSelection() {
        this.selectedTable = "remote";
        this.localFileTable.setBackground(new Color(238, 238, 238));
        this.remoteFileTable.setBackground(new Color(255, 255, 255));
        String string = this.remoteFileTable.getSelectedValue().toString().substring(1);
        if (!string.substring(0, 2).equals(" [")) {
            this.remoteSelection = this.remoteLocation.getText() + string.substring(0, string.length());
        }
    }

    private void updateLocalFileTableSelection() {
        this.selectedTable = "local";
        this.remoteFileTable.setBackground(new Color(238, 238, 238));
        this.localFileTable.setBackground(new Color(255, 255, 255));
        File file = new File(this.currentLocalDirectory, this.getTrimmedSelection());
        if (file.isFile()) {
            this.localSelection = file.getAbsoluteFile();
            this.localCurrentIsDir = false;
        } else {
            this.localCurrentIsDir = true;
        }
    }

    private void viewRemote() {
        File file = this.doReceiveTmp();
        if (file == null) {
            return;
        }
        TextViewer textViewer = new TextViewer("Remote: " + this.remoteSelection, file, true);
    }

    private void viewLocal() {
        if (this.localSelection == null) {
            return;
        }
        if (this.localCurrentIsDir) {
            return;
        }
        File file = new File(this.localSelection.toString());
        TextViewer textViewer = new TextViewer("Local: " + this.localSelection.toString(), file, false);
    }

    public void updateRemoteFileTable() {
        String string = null;
        String string2 = null;
        String string3 = null;
        string = this.remoteFileTable.getSelectedValue().toString().substring(1);
        if (string.equals("[..]")) {
            string2 = "up";
            this.remoteSelection = null;
            string3 = this.remoteLocation.getText().substring(0, this.remoteLocation.getText().length() - 1);
            int n = string3.lastIndexOf("\\");
            string3 = string3.substring(0, n + 1);
            this.remoteLocation.setText(string3);
            this.viewer.rfb.readServerDirectory(string3);
            this.remoteList.clear();
            this.remoteFileTable.setListData(this.remoteList);
        } else if (!string.substring(0, 2).equals(" [") && !string.substring(string.length() - 1, string.length()).equals("]")) {
            string2 = "file";
            this.remoteSelection = this.remoteLocation.getText() + string.substring(0, string.length());
            string3 = this.remoteLocation.getText();
            this.viewRemote();
        } else {
            string2 = "down";
            this.remoteSelection = null;
            string = string.substring(1, string.length() - 1);
            string3 = this.remoteLocation.getText() + string + "\\";
            this.remoteLocation.setText(string3);
            this.viewer.rfb.readServerDirectory(string3);
            this.remoteList.clear();
            this.remoteFileTable.setListData(this.remoteList);
        }
    }

    private void updateLocalFileTable() {
        this.localStatus.setText("");
        File file = new File(this.currentLocalDirectory, this.getTrimmedSelection());
        if (this.getTrimmedSelection().equals("..")) {
            this.localSelection = null;
            file = this.currentLocalDirectory.getParentFile();
            if (file != null) {
                this.changeLocalDirectory(file);
            } else {
                this.localStatus.setText("You are at the root !");
            }
        } else if (file.isFile()) {
            this.localSelection = file.getAbsoluteFile();
            this.viewLocal();
        } else if (file.isDirectory()) {
            this.localSelection = null;
            this.changeLocalDirectory(file);
        }
    }

    private String getTrimmedSelection() {
        String string = this.localFileTable.getSelectedValue().toString().substring(1);
        if (string.substring(0, 1).equals("[") && string.substring(string.length() - 1, string.length()).equals("]")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public File getFirstReadableLocalDrive() {
        File file;
        int n = 0;
        while (n < this.localDrivesComboBox.getItemCount()) {
            file = new File(this.localDrivesComboBox.getItemAt(n).toString());
            if (this.localDrivesComboBox.getItemAt(n).toString().substring(0, 1).toUpperCase().equals("C") && file.canRead()) {
                this.localDrivesComboBox.setSelectedIndex(n);
                return file;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.localDrivesComboBox.getItemCount()) {
            file = new File(this.localDrivesComboBox.getItemAt(n2).toString());
            if (file.canRead()) {
                this.localDrivesComboBox.setSelectedIndex(n2);
                return file;
            }
            ++n2;
        }
        this.localStatus.setText("ERROR!: No Local Drives are Readable");
        return null;
    }

    public void changeLocalDirectory(File file) {
        int n;
        if ((file = this.saveLocalHack(file)) == null) {
            this.connectionStatus.setText("Error changing local directory.");
            return;
        }
        File[] fileArray = file.listFiles();
        String[] stringArray = file.list();
        if (stringArray == null || fileArray == null) {
            this.connectionStatus.setText("Error changing local directory.");
            return;
        }
        this.currentLocalDirectory = file;
        System.out.println("changeLocalDirectory: " + file.toString());
        if (stringArray != null) {
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            n = 0;
            while (n < stringArray.length) {
                fileArray[n] = new File(file, stringArray[n]);
                ++n;
            }
        } else {
            return;
        }
        this.localList.clear();
        this.localList.addElement(" [..]");
        n = 0;
        while (n < stringArray.length) {
            if (fileArray[n].isDirectory()) {
                this.DirsList.add(" [" + stringArray[n] + "]");
            } else {
                this.FilesList.add(" " + stringArray[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.DirsList.size()) {
            this.localList.addElement(this.DirsList.get(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.FilesList.size()) {
            this.localList.addElement(this.FilesList.get(n3));
            ++n3;
        }
        this.FilesList.clear();
        this.DirsList.clear();
        this.localFileTable.setListData(this.localList);
        if (file.toString().charAt(file.toString().length() - 1) == File.separatorChar) {
            this.localLocation.setText(file.toString());
        } else {
            this.localLocation.setText(file.toString() + File.separator);
        }
        this.localStatus.setText("Total Files / Folders: " + (this.localList.size() - 1));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

