/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

//Own
#include "viewdevices.h"

//KGRUBEditor
#include "core/path.h"

ViewDevices::ViewDevices( QWidget *parent ) : KDialog( parent )
{
//SETUP UI
	QWidget *widget = new QWidget( this );
	setupUi( widget );
	setMainWidget( widget );

	setWindowIcon( KIcon( "drive-harddisk" ) );
	setCaption( i18nc( "@title:window", "View Devices" ) );
	setAttribute( Qt::WA_DeleteOnClose );
	setInitialSize( QSize( 600, 400 ) );
	setButtons( Close );
//SHOW DEVICES
	tableWidget->setRowCount( Core::Devices::DeviceList.size() );
 	for ( int i = 0; i < Core::Devices::DeviceList.size(); i++ )
 	{
		tableWidget->setItem( i, 0, new QTableWidgetItem( Core::Devices::DeviceList.at( i ).mountPoint() ) );
		tableWidget->setItem( i, 1, new QTableWidgetItem( Core::Devices::DeviceList.at( i ).partition() ) );
		tableWidget->setItem( i, 2, new QTableWidgetItem( Core::Devices::DeviceList.at( i ).grubPartition() ) );
		tableWidget->setItem( i, 3, new QTableWidgetItem( Core::Devices::DeviceList.at( i ).device() ) );
		tableWidget->setItem( i, 4, new QTableWidgetItem( Core::Devices::DeviceList.at( i ).grubDevice() ) );
		tableWidget->setItem( i, 5, new QTableWidgetItem( Core::Devices::DeviceList.at( i ).uuid() ) );
 	}
 	tableWidget->resizeColumnsToContents();
}

#include "viewdevices.moc"
