/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

//Own
#include "map.h"

//KDE
#include <klineedit.h>

MapEditor::MapEditor( GRUB::ComplexCommand::Map *map, QWidget *parent ) : KDialog( parent )
{
//SETUP UI
	QWidget *widget = new QWidget( this );
	setupUi( widget );
	setMainWidget( widget );

	setWindowIcon( KIcon( "drive-harddisk" ) );
	setCaption( i18nc( "@window:title", "Map Editor" ) );
	setAttribute( Qt::WA_DeleteOnClose );
//PROPERTY SETUP
	m_map = map;
//SHOW MAP
	if ( !map->isEmpty() )
	{
		grubdeviceeditor_from->lineEdit()->setText( map->fromDrive() );
		grubdeviceeditor_to->lineEdit()->setText( map->toDrive() );
	}
//MISC UI SETUP
	checkMaps();

	grubdeviceeditor_from->setMode( GRUBDeviceEditor::Device );
	grubdeviceeditor_to->setMode( GRUBDeviceEditor::Device );
//SETUP CONNECTIONS
	setupConnections();
}
MapEditor::~MapEditor()
{
	m_map = 0;
}

void MapEditor::setupConnections()
{
	connect( grubdeviceeditor_from->lineEdit(), SIGNAL( textChanged( const QString & ) ), SLOT( checkMaps() ) );
	connect( grubdeviceeditor_to->lineEdit(), SIGNAL( textChanged( const QString & ) ), SLOT( checkMaps() ) );
	connect( this, SIGNAL( okClicked() ), SLOT( okClicked() ) );
}

void MapEditor::checkMaps()
{
	enableButtonOk( !grubdeviceeditor_from->lineEdit()->text().trimmed().isEmpty() && !grubdeviceeditor_to->lineEdit()->text().trimmed().isEmpty() );
}
void MapEditor::okClicked()
{
	m_map->setFromDrive( grubdeviceeditor_from->lineEdit()->text() );
	m_map->setToDrive( grubdeviceeditor_to->lineEdit()->text() );
}

#include "map.moc"
