/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

#ifndef BACKUP_H
#define BACKUP_H

//Qt
class QWidget;

//KDE
class KUrl;

namespace Core
{
	namespace Backup
	{
		/**
		* Copies source to target (supports remote files too).
		*
		* If both source and target are local files and either
		* of them is not readable or not writable, it tries to
		* perform the copy operation using root permissions.
		*
		* @param source The file to copy.
		* @param target Where the file will be copied.
		* @param parent The QWidget parent.
		* @param verbose if true it uses MessageBoxes along with debug outputs
		*                to inform the user. If false, it only creates debug outputs.
		*
		* @return whether the operaion was successfully completed.
		*/
		bool backup( const KUrl &source, const KUrl &target, QWidget *parent, bool verbose = true );
		/**
		* Deletes backup (supports remote files too).
		*
		* If backup is a local file and is not writable,
		* it tries to perform the delete operation using
		* root permissions.
		*
		* @param backup The file to be deleted.
		* @param parent The QWidget parent.
		* @param verbose if true it uses MessageBoxes along with debug outputs
		*                to inform the user. If false, it only creates debug outputs.
		*
		* @return whether the operaion was successfully completed.
		*/
		bool deleteBackup( const KUrl &backup, QWidget *parent, bool verbose = true );
	}
}

#endif
