/* === S Y N F I G ========================================================= */
/*!	\file widget_waypoint.h
**	\brief Template Header
**
**	$Id: widget_waypoint.h 336 2007-03-16 00:39:42Z dooglus $
**
**	\legal
**	Copyright (c) 2002-2005 Robert B. Quattlebaum Jr., Adrian Bentley
**
**	This package is free software; you can redistribute it and/or
**	modify it under the terms of the GNU General Public License as
**	published by the Free Software Foundation; either version 2 of
**	the License, or (at your option) any later version.
**
**	This package is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**	General Public License for more details.
**	\endlegal
*/
/* ========================================================================= */

/* === S T A R T =========================================================== */

#ifndef __SYNFIG_GTKMM_WIDGET_WAYPOINT_H
#define __SYNFIG_GTKMM_WIDGET_WAYPOINT_H

/* === H E A D E R S ======================================================= */

//#include <gtk/gtk.h>
//#include <gtkmm/arrow.h>
//#include <gtkmm/image.h>
//#include <gdkmm/pixbufloader.h>
//#include <gtkmm/viewport.h>
#include <gtkmm/adjustment.h>
//#include <gtkmm/scrolledwindow.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
//#include <gtkmm/progressbar.h>
//#include <gtkmm/paned.h>
#include <gtkmm/box.h>
//#include <gtkmm/scrollbar.h>
#include <gtkmm/combo.h>
#include <gtkmm/optionmenu.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/alignment.h>

#include <synfigapp/value_desc.h>
#include <synfig/waypoint.h>
//#include <synfig/valuenode_dynamiclist.h>
#include <synfig/string.h>
#include <synfig/time.h>

/* === M A C R O S ========================================================= */

/* === T Y P E D E F S ===================================================== */


/* === C L A S S E S & S T R U C T S ======================================= */

namespace studio {

class Widget_ValueBase;
class Widget_Time;
class Widget_Waypoint;

class Widget_Waypoint : public Gtk::Alignment
{
    Widget_ValueBase *value_widget;
	Gtk::Label *value_node_label;
	Gtk::Label *label;
	Widget_Time *time_widget;
	mutable synfig::Waypoint waypoint;
	synfig::Canvas::Handle canvas;
	//Gtk::Adjustment time_adjustment;

	Gtk::Combo *in,*out;
	Gtk::OptionMenu *before, *after;
	Gtk::Menu *before_options,*after_options;

	Gtk::SpinButton *spin_tension, *spin_continuity, *spin_bias, *spin_temporal_tension;
	Gtk::Adjustment adj_tension, adj_continuity, adj_bias, adj_temporal_tension;
//	Gtk::ComboDropDownItem item;

public:
	Widget_Waypoint(etl::handle<synfig::Canvas> canvas);
	void set_canvas(synfig::Canvas::Handle x);
	void set_waypoint(synfig::Waypoint &x);
	const synfig::Waypoint &get_waypoint()const;
}; // END of class Widget_Waypoint

}; // END of namespace studio

/* === E N D =============================================================== */

#endif
