# -*- coding: utf-8 -*-
# vim: set noet ts=4:
#
# scim-python
#
# Copyright (c) 2007-2008 Yu Fan <yufanyufan@gmail.com>
#
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this program; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place, Suite 330,
# Boston, MA  02111-1307  USA
#
# $Id: $
#

from ZhengJu import *
import scim
import os
from scim import KeyCode
from scim import KeyMask
from scim import Property
from QuanPin import QuanPinEngine
import traceback
import sys
from PYDict import *
from gettext import dgettext

_ = lambda a : dgettext ("scim-python", a)
class JianPinEngine(QuanPinEngine):
	def __init__ (self, factory, config, encoding, id):
		QuanPinEngine.__init__(self, factory, config, encoding, id)
	def parse(self, str):
		str = str.strip("'")
		if str in PINYIN_LIST or str in SHENGMU_LIST or str in PINYIN_PARTIAL_LIST:
			return (str, )
		for i in range(len(str), 0, -1):
			if (str[:i] in PINYIN_LIST or str[:i] in SHENGMU_LIST) \
				and (str[i:] in PINYIN_LIST or str[i:] in SHENGMU_LIST or str[i:] in PINYIN_PARTIAL_LIST):
				return ( str[:i], str[i:])
		raise InputException()

class JianPinFactory (IMEngineFactory):
	def __init__ (self, config):
		IMEngineFactory.__init__ (self, config)
		self.name 		= _(u"JianPin")
		self.uuid 		= "908ce256-ddd8-44b7-b6c0-5833024bd445"
		self.authors	= u"Yu Fan <yufanyufan@gmail.com>"
		self.icon_file 	= "/usr/share/scim/icons/scim-python.png"
		self.credits 	= u"GPL"
		self.help		= _(u"Help For JianPin")
		self.set_languages ("zh")
		self._config	= config
	def create_instance (self, encoding, id):
		engine =  JianPinEngine (self, self._config, encoding, id)
		return engine

	def reload_config (self, config):
		pass
