/*
** PHREL
** $Id: phrel.h,v 1.17 2006/04/08 19:18:44 sella Exp $
** Copyright (c) 2004 James M. Sella. All Rights Reserved.
** Released under the GPL Version 2 License.
** http://www.digitalgenesis.com
*/

#ifndef __DGS_PHREL_H
#define __DGS_PHREL_H

#include "config.h"

#include "prefs.h"

#include <arpa/inet.h>

#define PROGRAM_PKGN PHREL_PACKAGE
#define PROGRAM_NAME PHREL_PROGRAM
#define PROGRAM_VERS PHREL_VERSION
#define PROGRAM_BUGS PHREL_BUGREPORT

#define DEBUG_ERROR		1 /* Near fatal condition. */
#define DEBUG_WARNING	3 /* Non-normal significant condition. */
#define DEBUG_NOTICE		5 /* Notice: Normal, but significant condition. */
#define DEBUG_INTERNAL	6 /* Internal debugging information. Low traffic. */
#define DEBUG_SQL			7 /* SQL statements. Medium traffic. */
#define DEBUG_DUMP1		8 /* Dump of internal raw data (level 1). High traffic. */
#define DEBUG_DUMP2		9 /* Dump of internal raw data (level 2). Very High traffic. */
#define DEBUG_MAXVAL		9

struct data_t {
	struct in_addr ip;
	time_t *last_update;
	unsigned int *samples;
	unsigned int threshold; /* last tripped threshold */
	unsigned int rate; /* rate limit for last tripped threshold */
	unsigned int burst; /* burst for rate limit */
	time_t decay;
};

/* Function definitions. */
int main(int argc, char **argv);
void sighandler(int sig);
int hash_test();

#endif

/*
** Local Variables:
** c-basic-offset: 3
** tab-width: 3
** End:
** vim: noet ts=3 sw=3
*/
