/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *      Gonzalo Paniagua Javier <gonzalo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_config_h__)
#  define __gnome_db_config_h__

#include <gconf/gconf-client.h>
#include <libgda/gda-config.h>
#include <libgda/gda-data-model.h>

G_BEGIN_DECLS

/*
 * CORBA components configuration
 */

typedef enum {
	GNOME_DB_COMPONENT_TYPE_INVALID = -1,
	GNOME_DB_COMPONENT_TYPE_EXE,
	GNOME_DB_COMPONENT_TYPE_SHLIB,
	GNOME_DB_COMPONENT_TYPE_FACTORY
} GnomeDbComponentType;

typedef struct {
	gchar *id;
	gchar *location;
	GnomeDbComponentType type;
	gchar *description;
	GList *repo_ids;
	gchar *username;
	gchar *hostname;
	gchar *domain;
	GdaParameterList *properties;
} GnomeDbComponentInfo;

GList        *gnome_db_config_get_component_list (const gchar *query);
void          gnome_db_config_free_component_list (GList *list);
GdaDataModel *gnome_db_config_get_component_data_model (const gchar *query);
gchar 	     *gnome_db_config_get_string (const gchar *path);
gint 	      gnome_db_config_get_int (const gchar *path);
gdouble       gnome_db_config_get_float (const gchar *path);
gboolean      gnome_db_config_get_boolean (const gchar *path);
void 	      gnome_db_config_set_string (const gchar *path,
					  const gchar *new_value);
void 	      gnome_db_config_set_int (const gchar *path, gint new_value);
void 	      gnome_db_config_set_float (const gchar *path, gdouble new_value);
void 	      gnome_db_config_set_boolean (const gchar *path,
					   gboolean new_value);

void 	      gnome_db_config_remove_section (const gchar *path);
void 	      gnome_db_config_remove_key (const gchar *path);

gboolean      gnome_db_config_has_section (const gchar *path);
gboolean      gnome_db_config_has_key (const gchar *path);

GList 	     *gnome_db_config_list_sections (const gchar *path);
GList        *gnome_db_config_list_keys (const gchar *path);
void          gnome_db_config_free_list (GList *list);

GList 	     *gnome_db_config_get_data_source_list (void);
GdaDataSourceInfo *gnome_db_config_find_data_source (const gchar *name);
GdaDataSourceInfo *gnome_db_config_copy_data_source_info (GdaDataSourceInfo *src);
void 	      gnome_db_config_free_data_source_info (GdaDataSourceInfo *info);
void 	      gnome_db_config_free_data_source_list (GList *list);
void	      gnome_db_config_remove_data_source (const gchar *name);
void	      gnome_db_config_save_data_source (const gchar *name,
					        const gchar *provider,
					        const gchar *cnc_string,
					        const gchar *description,
					        const gchar *username,
					        const gchar *password);


guint 	      gnome_db_config_add_listener (const gchar *path,
					    GConfClientNotifyFunc func,
					    gpointer user_data);

void          gnome_db_config_remove_listener (guint id);

/*
 * Known configuration entries
 */

#define GNOME_DB_CONFIG_KEY_BROWSER_PANED_POSITION   "/apps/gnome-db/Browser/PanedPosition"
#define GNOME_DB_CONFIG_KEY_EDITOR_HIGHLIGHT         "/apps/gnome-db/Editor/Highlight"
#define GNOME_DB_CONFIG_KEY_EDITOR_SHOW_LINE_NUMBERS "/apps/gnome-db/Editor/ShowLineNumbers"
#define GNOME_DB_CONFIG_KEY_EDITOR_TAB_STOP          "/apps/gnome-db/Editor/TabStop"

G_END_DECLS

#endif
