/***************************************************************************
 *   Copyright (C) 2004 by  ͤ                                            *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef ANTHY_H
#define ANTHY_H

#include "dictionary.h"
#include <qstringlist.h>

class Anthy : public Dictionary
{
	struct _anthy_api {
		void (*util_init)();
//		void (*util_set_personality)(char *);
//		const char *(*util_get_anthydir)(void);

//		void (*priv_dic_delete)(void);
		int (*priv_dic_select_first_entry)(void);
		int (*priv_dic_select_next_entry)(void);
//		int (*priv_dic_select_entry)(char *);

		char *(*priv_dic_get_index)(char *, int);
		int (*priv_dic_get_freq)(void);
		char *(*priv_dic_get_wtype)(char *, int);
		char *(*priv_dic_get_word)(char *, int);

		int (*priv_dic_add_entry)(const char *, const char *, const char *, int);
	};
public:
	Anthy( QString name );

	~Anthy();
	QString name(){ return m_dicname; };
	static bool isAvailable();
	static QStringList lsdic(){ return QStringList(); };
	static bool mkdic( QString& dicname ){ return false; };
	void rmdic(){};
	bool expand(  KListView* lvw );
	bool save( KListView* lvw );
	DictionaryType type(){ return Dictionary::Anthy; };
private:
	struct _anthy_api AnthyFunc;
	QWidget* m_parent;
	QString m_dicname;
	void* m_libanthy;

	bool addWord( Word word );
	bool delWord( Word& word );

	int m_count;
	int m_counter;
	int m_progress;
	void countup();

	QValueList<Word> m_add, m_del;
};

#endif //ANTHY_H
