#python

import k3d
import sys

class inspector:
	def print_properties(self, Node, Level):
		if not Node.is_property_collection:
			return

		for property in Node.properties:
			indentation = ""
			for j in range(Level):
				indentation += "  "

			record = indentation + "property: " + property.name + " - " + property.description + " - " + property.type + " - " + str(property.value)
			
			if property.is_writable:
				record += " (read/write)"
			else:
				record += " (read-only)"
			print record

	def print_node(self, Node, Level):
		for j in range(Level):
			print " ",

		print "node: " + Node.command_node_name

		self.print_properties(Node, Level + 1)

		for child in Node.children:
			self.print_node(child, Level + 1)

for node in k3d.command_nodes():
	inspector().print_node(node, 0)

sys.stdout.flush()

k3d.ui.message("Output sent to console")
