/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"


#include <glib-object.h>

#include "libgimpmath/gimpmath.h"

#include "pdb-types.h"
#include "gimppdb.h"
#include "gimpprocedure.h"
#include "core/gimpparamspecs.h"

#include "config/gimpcoreconfig.h"
#include "core/gimp-transform-utils.h"
#include "core/gimp.h"
#include "core/gimpdrawable-transform.h"
#include "core/gimpdrawable.h"
#include "core/gimpimage.h"
#include "core/gimpprogress.h"
#include "gimp-intl.h"

#include "internal_procs.h"


static GValueArray *
drawable_transform_flip_simple_invoker (GimpProcedure     *procedure,
                                        Gimp              *gimp,
                                        GimpContext       *context,
                                        GimpProgress      *progress,
                                        const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gint32 flip_type;
  gboolean auto_center;
  gdouble axis;
  gboolean clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  flip_type = g_value_get_enum (&args->values[1]);
  auto_center = g_value_get_boolean (&args->values[2]);
  axis = g_value_get_double (&args->values[3]);
  clip_result = g_value_get_boolean (&args->values[4]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          success = gimp_drawable_transform_flip (drawable, context,
                                                  flip_type,
                                                  auto_center, axis,
                                                  clip_result);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_flip_invoker (GimpProcedure     *procedure,
                                 Gimp              *gimp,
                                 GimpContext       *context,
                                 GimpProgress      *progress,
                                 const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble x0;
  gdouble y0;
  gdouble x1;
  gdouble y1;
  gint32 transform_direction;
  gint32 interpolation;
  gboolean supersample;
  gint32 recursion_level;
  gboolean clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  x0 = g_value_get_double (&args->values[1]);
  y0 = g_value_get_double (&args->values[2]);
  x1 = g_value_get_double (&args->values[3]);
  y1 = g_value_get_double (&args->values[4]);
  transform_direction = g_value_get_enum (&args->values[5]);
  interpolation = g_value_get_enum (&args->values[6]);
  supersample = g_value_get_boolean (&args->values[7]);
  recursion_level = g_value_get_int (&args->values[8]);
  clip_result = g_value_get_boolean (&args->values[9]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3 matrix;
          gint        off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity (&matrix);
          gimp_transform_matrix_flip_free (&matrix,
                                           x0, y0, x1, y1);

          if (progress)
            gimp_progress_start (progress, _("Flipping"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, transform_direction,
                                                    interpolation, recursion_level,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_flip_default_invoker (GimpProcedure     *procedure,
                                         Gimp              *gimp,
                                         GimpContext       *context,
                                         GimpProgress      *progress,
                                         const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble x0;
  gdouble y0;
  gdouble x1;
  gdouble y1;
  gboolean interpolate;
  gboolean clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  x0 = g_value_get_double (&args->values[1]);
  y0 = g_value_get_double (&args->values[2]);
  x1 = g_value_get_double (&args->values[3]);
  y1 = g_value_get_double (&args->values[4]);
  interpolate = g_value_get_boolean (&args->values[5]);
  clip_result = g_value_get_boolean (&args->values[6]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3           matrix;
          GimpInterpolationType interpolation_type = GIMP_INTERPOLATION_NONE;
          gint                  off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity (&matrix);
          gimp_transform_matrix_flip_free (&matrix,
                                           x0, y0, x1, y1);

          if (interpolate)
            interpolation_type = gimp->config->interpolation_type;

          if (progress)
            gimp_progress_start (progress, _("Flipping"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, GIMP_TRANSFORM_FORWARD,
                                                    interpolation_type, 3,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_perspective_invoker (GimpProcedure     *procedure,
                                        Gimp              *gimp,
                                        GimpContext       *context,
                                        GimpProgress      *progress,
                                        const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble x0;
  gdouble y0;
  gdouble x1;
  gdouble y1;
  gdouble x2;
  gdouble y2;
  gdouble x3;
  gdouble y3;
  gint32 transform_direction;
  gint32 interpolation;
  gboolean supersample;
  gint32 recursion_level;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  x0 = g_value_get_double (&args->values[1]);
  y0 = g_value_get_double (&args->values[2]);
  x1 = g_value_get_double (&args->values[3]);
  y1 = g_value_get_double (&args->values[4]);
  x2 = g_value_get_double (&args->values[5]);
  y2 = g_value_get_double (&args->values[6]);
  x3 = g_value_get_double (&args->values[7]);
  y3 = g_value_get_double (&args->values[8]);
  transform_direction = g_value_get_enum (&args->values[9]);
  interpolation = g_value_get_enum (&args->values[10]);
  supersample = g_value_get_boolean (&args->values[11]);
  recursion_level = g_value_get_int (&args->values[12]);
  clip_result = g_value_get_enum (&args->values[13]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3 matrix;
          gint        off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity (&matrix);
          gimp_transform_matrix_perspective (&matrix,
                                             x, y, width, height,
                                             x0, y0, x1, y1,
                                             x2, y2, x3, y3);

          if (progress)
            gimp_progress_start (progress, _("Perspective"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, transform_direction,
                                                    interpolation, recursion_level,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_perspective_default_invoker (GimpProcedure     *procedure,
                                                Gimp              *gimp,
                                                GimpContext       *context,
                                                GimpProgress      *progress,
                                                const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble x0;
  gdouble y0;
  gdouble x1;
  gdouble y1;
  gdouble x2;
  gdouble y2;
  gdouble x3;
  gdouble y3;
  gboolean interpolate;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  x0 = g_value_get_double (&args->values[1]);
  y0 = g_value_get_double (&args->values[2]);
  x1 = g_value_get_double (&args->values[3]);
  y1 = g_value_get_double (&args->values[4]);
  x2 = g_value_get_double (&args->values[5]);
  y2 = g_value_get_double (&args->values[6]);
  x3 = g_value_get_double (&args->values[7]);
  y3 = g_value_get_double (&args->values[8]);
  interpolate = g_value_get_boolean (&args->values[9]);
  clip_result = g_value_get_enum (&args->values[10]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3           matrix;
          GimpInterpolationType interpolation_type = GIMP_INTERPOLATION_NONE;
          gint                  off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity (&matrix);
          gimp_transform_matrix_perspective (&matrix,
                                             x, y, width, height,
                                             x0, y0, x1, y1,
                                             x2, y2, x3, y3);

          if (interpolate)
            interpolation_type = gimp->config->interpolation_type;

          if (progress)
            gimp_progress_start (progress, _("Perspective"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, GIMP_TRANSFORM_FORWARD,
                                                    interpolation_type, 3,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_rotate_simple_invoker (GimpProcedure     *procedure,
                                          Gimp              *gimp,
                                          GimpContext       *context,
                                          GimpProgress      *progress,
                                          const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gint32 rotate_type;
  gboolean auto_center;
  gint32 center_x;
  gint32 center_y;
  gboolean clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  rotate_type = g_value_get_enum (&args->values[1]);
  auto_center = g_value_get_boolean (&args->values[2]);
  center_x = g_value_get_int (&args->values[3]);
  center_y = g_value_get_int (&args->values[4]);
  clip_result = g_value_get_boolean (&args->values[5]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          success = gimp_drawable_transform_rotate (drawable, context,
                                                    rotate_type,
                                                    auto_center, center_x, center_y,
                                                    clip_result);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_rotate_invoker (GimpProcedure     *procedure,
                                   Gimp              *gimp,
                                   GimpContext       *context,
                                   GimpProgress      *progress,
                                   const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble angle;
  gboolean auto_center;
  gint32 center_x;
  gint32 center_y;
  gint32 transform_direction;
  gint32 interpolation;
  gboolean supersample;
  gint32 recursion_level;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  angle = g_value_get_double (&args->values[1]);
  auto_center = g_value_get_boolean (&args->values[2]);
  center_x = g_value_get_int (&args->values[3]);
  center_y = g_value_get_int (&args->values[4]);
  transform_direction = g_value_get_enum (&args->values[5]);
  interpolation = g_value_get_enum (&args->values[6]);
  supersample = g_value_get_boolean (&args->values[7]);
  recursion_level = g_value_get_int (&args->values[8]);
  clip_result = g_value_get_enum (&args->values[9]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3 matrix;
          gint        off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity (&matrix);
          if (auto_center)
            gimp_transform_matrix_rotate_rect (&matrix,
                                               x, y, width, height, angle);
          else
            gimp_transform_matrix_rotate_center (&matrix,
                                                 center_x, center_y, angle);

          if (progress)
            gimp_progress_start (progress, _("Rotating"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, transform_direction,
                                                    interpolation, recursion_level,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_rotate_default_invoker (GimpProcedure     *procedure,
                                           Gimp              *gimp,
                                           GimpContext       *context,
                                           GimpProgress      *progress,
                                           const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble angle;
  gboolean auto_center;
  gint32 center_x;
  gint32 center_y;
  gboolean interpolate;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  angle = g_value_get_double (&args->values[1]);
  auto_center = g_value_get_boolean (&args->values[2]);
  center_x = g_value_get_int (&args->values[3]);
  center_y = g_value_get_int (&args->values[4]);
  interpolate = g_value_get_boolean (&args->values[5]);
  clip_result = g_value_get_enum (&args->values[6]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3           matrix;
          GimpInterpolationType interpolation_type = GIMP_INTERPOLATION_NONE;
          gint                  off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity (&matrix);
          if (auto_center)
            gimp_transform_matrix_rotate_rect (&matrix,
                                               x, y, width, height, angle);
          else
            gimp_transform_matrix_rotate_center (&matrix,
                                                 center_x, center_y, angle);

          if (interpolate)
            interpolation_type = gimp->config->interpolation_type;

          if (progress)
            gimp_progress_start (progress, _("Rotating"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, GIMP_TRANSFORM_FORWARD,
                                                    interpolation_type, 3,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_scale_invoker (GimpProcedure     *procedure,
                                  Gimp              *gimp,
                                  GimpContext       *context,
                                  GimpProgress      *progress,
                                  const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble x0;
  gdouble y0;
  gdouble x1;
  gdouble y1;
  gint32 transform_direction;
  gint32 interpolation;
  gboolean supersample;
  gint32 recursion_level;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  x0 = g_value_get_double (&args->values[1]);
  y0 = g_value_get_double (&args->values[2]);
  x1 = g_value_get_double (&args->values[3]);
  y1 = g_value_get_double (&args->values[4]);
  transform_direction = g_value_get_enum (&args->values[5]);
  interpolation = g_value_get_enum (&args->values[6]);
  supersample = g_value_get_boolean (&args->values[7]);
  recursion_level = g_value_get_int (&args->values[8]);
  clip_result = g_value_get_enum (&args->values[9]);

  if (success)
    {
      gint x, y, width, height;

      success = (gimp_item_is_attached (GIMP_ITEM (drawable)) && x0 < x1 && y0 < y1);

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3 matrix;
          gint        off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity (&matrix);
          gimp_transform_matrix_scale (&matrix,
                                       x, y, width, height,
                                       x0, y0, x1 - x0, y1 - y0);

          if (progress)
            gimp_progress_start (progress, _("Scaling"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, transform_direction,
                                                    interpolation, recursion_level,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_scale_default_invoker (GimpProcedure     *procedure,
                                          Gimp              *gimp,
                                          GimpContext       *context,
                                          GimpProgress      *progress,
                                          const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble x0;
  gdouble y0;
  gdouble x1;
  gdouble y1;
  gboolean interpolate;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  x0 = g_value_get_double (&args->values[1]);
  y0 = g_value_get_double (&args->values[2]);
  x1 = g_value_get_double (&args->values[3]);
  y1 = g_value_get_double (&args->values[4]);
  interpolate = g_value_get_boolean (&args->values[5]);
  clip_result = g_value_get_enum (&args->values[6]);

  if (success)
    {
      gint x, y, width, height;

      success = (gimp_item_is_attached (GIMP_ITEM (drawable)) && x0 < x1 && y0 < y1);

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3           matrix;
          GimpInterpolationType interpolation_type = GIMP_INTERPOLATION_NONE;
          gint                  off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity (&matrix);
          gimp_transform_matrix_scale (&matrix,
                                       x, y, width, height,
                                       x0, y0, x1 - x0, y1 - y0);

          if (interpolate)
            interpolation_type = gimp->config->interpolation_type;

          if (progress)
            gimp_progress_start (progress, _("Scaling"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, GIMP_TRANSFORM_FORWARD,
                                                    interpolation_type, 3,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_shear_invoker (GimpProcedure     *procedure,
                                  Gimp              *gimp,
                                  GimpContext       *context,
                                  GimpProgress      *progress,
                                  const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gint32 shear_type;
  gdouble magnitude;
  gint32 transform_direction;
  gint32 interpolation;
  gboolean supersample;
  gint32 recursion_level;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  shear_type = g_value_get_enum (&args->values[1]);
  magnitude = g_value_get_double (&args->values[2]);
  transform_direction = g_value_get_enum (&args->values[3]);
  interpolation = g_value_get_enum (&args->values[4]);
  supersample = g_value_get_boolean (&args->values[5]);
  recursion_level = g_value_get_int (&args->values[6]);
  clip_result = g_value_get_enum (&args->values[7]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3 matrix;
          gint        off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity (&matrix);
          gimp_transform_matrix_shear (&matrix,
                                       x, y, width, height,
                                       shear_type, magnitude);

          if (progress)
            gimp_progress_start (progress, _("Shearing"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, transform_direction,
                                                    interpolation, recursion_level,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_shear_default_invoker (GimpProcedure     *procedure,
                                          Gimp              *gimp,
                                          GimpContext       *context,
                                          GimpProgress      *progress,
                                          const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gint32 shear_type;
  gdouble magnitude;
  gboolean interpolate;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  shear_type = g_value_get_enum (&args->values[1]);
  magnitude = g_value_get_double (&args->values[2]);
  interpolate = g_value_get_boolean (&args->values[3]);
  clip_result = g_value_get_enum (&args->values[4]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3           matrix;
          GimpInterpolationType interpolation_type = GIMP_INTERPOLATION_NONE;
          gint                  off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity (&matrix);
          gimp_transform_matrix_shear (&matrix,
                                       x, y, width, height,
                                       shear_type, magnitude);

          if (interpolate)
            interpolation_type = gimp->config->interpolation_type;

          if (progress)
            gimp_progress_start (progress, _("Shearing"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, GIMP_TRANSFORM_FORWARD,
                                                    interpolation_type, 3,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_2d_invoker (GimpProcedure     *procedure,
                               Gimp              *gimp,
                               GimpContext       *context,
                               GimpProgress      *progress,
                               const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble source_x;
  gdouble source_y;
  gdouble scale_x;
  gdouble scale_y;
  gdouble angle;
  gdouble dest_x;
  gdouble dest_y;
  gint32 transform_direction;
  gint32 interpolation;
  gboolean supersample;
  gint32 recursion_level;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  source_x = g_value_get_double (&args->values[1]);
  source_y = g_value_get_double (&args->values[2]);
  scale_x = g_value_get_double (&args->values[3]);
  scale_y = g_value_get_double (&args->values[4]);
  angle = g_value_get_double (&args->values[5]);
  dest_x = g_value_get_double (&args->values[6]);
  dest_y = g_value_get_double (&args->values[7]);
  transform_direction = g_value_get_enum (&args->values[8]);
  interpolation = g_value_get_enum (&args->values[9]);
  supersample = g_value_get_boolean (&args->values[10]);
  recursion_level = g_value_get_int (&args->values[11]);
  clip_result = g_value_get_enum (&args->values[12]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3 matrix;
          gint        off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity  (&matrix);
          gimp_matrix3_translate (&matrix, -source_x, -source_y);
          gimp_matrix3_scale     (&matrix, scale_x, scale_y);
          gimp_matrix3_rotate    (&matrix, angle);
          gimp_matrix3_translate (&matrix, dest_x, dest_y);

          if (progress)
            gimp_progress_start (progress, _("2D Transform"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, transform_direction,
                                                    interpolation, recursion_level,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_2d_default_invoker (GimpProcedure     *procedure,
                                       Gimp              *gimp,
                                       GimpContext       *context,
                                       GimpProgress      *progress,
                                       const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble source_x;
  gdouble source_y;
  gdouble scale_x;
  gdouble scale_y;
  gdouble angle;
  gdouble dest_x;
  gdouble dest_y;
  gboolean interpolate;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  source_x = g_value_get_double (&args->values[1]);
  source_y = g_value_get_double (&args->values[2]);
  scale_x = g_value_get_double (&args->values[3]);
  scale_y = g_value_get_double (&args->values[4]);
  angle = g_value_get_double (&args->values[5]);
  dest_x = g_value_get_double (&args->values[6]);
  dest_y = g_value_get_double (&args->values[7]);
  interpolate = g_value_get_boolean (&args->values[8]);
  clip_result = g_value_get_enum (&args->values[9]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3           matrix;
          GimpInterpolationType interpolation_type = GIMP_INTERPOLATION_NONE;
          gint                  off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          gimp_matrix3_identity  (&matrix);
          gimp_matrix3_translate (&matrix, -source_x, -source_y);
          gimp_matrix3_scale     (&matrix, scale_x, scale_y);
          gimp_matrix3_rotate    (&matrix, angle);
          gimp_matrix3_translate (&matrix, dest_x, dest_y);

          if (interpolate)
            interpolation_type = gimp->config->interpolation_type;

          if (progress)
            gimp_progress_start (progress, _("2D Transforming"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, GIMP_TRANSFORM_FORWARD,
                                                    interpolation_type, 3,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_matrix_invoker (GimpProcedure     *procedure,
                                   Gimp              *gimp,
                                   GimpContext       *context,
                                   GimpProgress      *progress,
                                   const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble coeff_0_0;
  gdouble coeff_0_1;
  gdouble coeff_0_2;
  gdouble coeff_1_0;
  gdouble coeff_1_1;
  gdouble coeff_1_2;
  gdouble coeff_2_0;
  gdouble coeff_2_1;
  gdouble coeff_2_2;
  gint32 transform_direction;
  gint32 interpolation;
  gboolean supersample;
  gint32 recursion_level;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  coeff_0_0 = g_value_get_double (&args->values[1]);
  coeff_0_1 = g_value_get_double (&args->values[2]);
  coeff_0_2 = g_value_get_double (&args->values[3]);
  coeff_1_0 = g_value_get_double (&args->values[4]);
  coeff_1_1 = g_value_get_double (&args->values[5]);
  coeff_1_2 = g_value_get_double (&args->values[6]);
  coeff_2_0 = g_value_get_double (&args->values[7]);
  coeff_2_1 = g_value_get_double (&args->values[8]);
  coeff_2_2 = g_value_get_double (&args->values[9]);
  transform_direction = g_value_get_enum (&args->values[10]);
  interpolation = g_value_get_enum (&args->values[11]);
  supersample = g_value_get_boolean (&args->values[12]);
  recursion_level = g_value_get_int (&args->values[13]);
  clip_result = g_value_get_enum (&args->values[14]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3 matrix;
          gint        off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          matrix.coeff[0][0] = coeff_0_0;
          matrix.coeff[0][1] = coeff_0_1;
          matrix.coeff[0][2] = coeff_0_2;
          matrix.coeff[1][0] = coeff_1_0;
          matrix.coeff[1][1] = coeff_1_1;
          matrix.coeff[1][2] = coeff_1_2;
          matrix.coeff[2][0] = coeff_2_0;
          matrix.coeff[2][1] = coeff_2_1;
          matrix.coeff[2][2] = coeff_2_2;

          if (progress)
            gimp_progress_start (progress, _("2D Transforming"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, transform_direction,
                                                    interpolation, recursion_level,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

static GValueArray *
drawable_transform_matrix_default_invoker (GimpProcedure     *procedure,
                                           Gimp              *gimp,
                                           GimpContext       *context,
                                           GimpProgress      *progress,
                                           const GValueArray *args)
{
  gboolean success = TRUE;
  GValueArray *return_vals;
  GimpDrawable *drawable;
  gdouble coeff_0_0;
  gdouble coeff_0_1;
  gdouble coeff_0_2;
  gdouble coeff_1_0;
  gdouble coeff_1_1;
  gdouble coeff_1_2;
  gdouble coeff_2_0;
  gdouble coeff_2_1;
  gdouble coeff_2_2;
  gboolean interpolate;
  gint32 clip_result;

  drawable = gimp_value_get_drawable (&args->values[0], gimp);
  coeff_0_0 = g_value_get_double (&args->values[1]);
  coeff_0_1 = g_value_get_double (&args->values[2]);
  coeff_0_2 = g_value_get_double (&args->values[3]);
  coeff_1_0 = g_value_get_double (&args->values[4]);
  coeff_1_1 = g_value_get_double (&args->values[5]);
  coeff_1_2 = g_value_get_double (&args->values[6]);
  coeff_2_0 = g_value_get_double (&args->values[7]);
  coeff_2_1 = g_value_get_double (&args->values[8]);
  coeff_2_2 = g_value_get_double (&args->values[9]);
  interpolate = g_value_get_boolean (&args->values[10]);
  clip_result = g_value_get_enum (&args->values[11]);

  if (success)
    {
      gint x, y, width, height;

      success = gimp_item_is_attached (GIMP_ITEM (drawable));

      if (success &&
          gimp_drawable_mask_intersect (drawable, &x, &y, &width, &height))
        {
          GimpMatrix3           matrix;
          GimpInterpolationType interpolation_type = GIMP_INTERPOLATION_NONE;
          gint                  off_x, off_y;

          gimp_item_offsets (GIMP_ITEM (drawable), &off_x, &off_y);

          x += off_x;
          y += off_y;

          /* Assemble the transformation matrix */
          matrix.coeff[0][0] = coeff_0_0;
          matrix.coeff[0][1] = coeff_0_1;
          matrix.coeff[0][2] = coeff_0_2;
          matrix.coeff[1][0] = coeff_1_0;
          matrix.coeff[1][1] = coeff_1_1;
          matrix.coeff[1][2] = coeff_1_2;
          matrix.coeff[2][0] = coeff_2_0;
          matrix.coeff[2][1] = coeff_2_1;
          matrix.coeff[2][2] = coeff_2_2;

          if (interpolate)
            interpolation_type = gimp->config->interpolation_type;

          if (progress)
            gimp_progress_start (progress, _("2D Transforming"), FALSE);

          /* Transform the selection */
          success = gimp_drawable_transform_affine (drawable, context,
                                                    &matrix, GIMP_TRANSFORM_FORWARD,
                                                    interpolation_type, 3,
                                                    clip_result, progress);

          if (progress)
            gimp_progress_end (progress);
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success);

  if (success)
    gimp_value_set_drawable (&return_vals->values[1], drawable);

  return return_vals;
}

void
register_drawable_transform_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-drawable-transform-flip-simple
   */
  procedure = gimp_procedure_new (drawable_transform_flip_simple_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-flip-simple");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-flip-simple",
                                     "Flip the specified drawable either vertically or horizontally.",
                                     "This procedure flips the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then flipped. If auto_center is set to TRUE, the flip is around the selection's center. Otherwise, the coordinate of the axis needs to be specified. The return value is the ID of the flipped drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and flipped drawable.",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_enum ("flip-type",
                                                     "flip type",
                                                     "Type of flip",
                                                     GIMP_TYPE_ORIENTATION_TYPE,
                                                     GIMP_ORIENTATION_HORIZONTAL,
                                                     GIMP_PARAM_READWRITE));
  gimp_param_spec_enum_exclude_value (GIMP_PARAM_SPEC_ENUM (procedure->args[1]),
                                      GIMP_ORIENTATION_UNKNOWN);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("auto-center",
                                                     "auto center",
                                                     "Whether to automatically position the axis in the selection center",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("axis",
                                                    "axis",
                                                    "coord. of flip axis",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("clip-result",
                                                     "clip result",
                                                     "Whether to clip results",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The flipped drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-flip
   */
  procedure = gimp_procedure_new (drawable_transform_flip_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-flip");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-flip",
                                     "Flip the specified drawable around a given line.",
                                     "This procedure flips the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then flipped. The axis to flip around is specified by specifying two points from that line. The return value is the ID of the flipped drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and flipped drawable. The clip results parameter specifies wheter current selection will affect the transform.",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x0",
                                                    "x0",
                                                    "horz. coord. of one end of axis",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y0",
                                                    "y0",
                                                    "vert. coord. of one end of axis",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x1",
                                                    "x1",
                                                    "horz. coord. of other end of axis",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y1",
                                                    "y1",
                                                    "vert. coord. of other end of axis",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-direction",
                                                  "transform direction",
                                                  "Direction of transformation",
                                                  GIMP_TYPE_TRANSFORM_DIRECTION,
                                                  GIMP_TRANSFORM_FORWARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("interpolation",
                                                  "interpolation",
                                                  "Type of interpolation",
                                                  GIMP_TYPE_INTERPOLATION_TYPE,
                                                  GIMP_INTERPOLATION_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("supersample",
                                                     "supersample",
                                                     "This parameter is ignored, supersampling is performed based on the interpolation type",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("recursion-level",
                                                      "recursion level",
                                                      "Maximum recursion level used for supersampling (3 is a nice value)",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("clip-result",
                                                     "clip result",
                                                     "Whether to clip results",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The flipped drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-flip-default
   */
  procedure = gimp_procedure_new (drawable_transform_flip_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-flip-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-flip-default",
                                     "Flip the specified drawable around a given line.",
                                     "This procedure is a variant of 'gimp-drawable-transform-flip' which uses no interpolation/supersampling at all, or default values (depending on the 'interpolate' parameter).",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x0",
                                                    "x0",
                                                    "horz. coord. of one end of axis",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y0",
                                                    "y0",
                                                    "vert. coord. of one end of axis",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x1",
                                                    "x1",
                                                    "horz. coord. of other end of axis",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y1",
                                                    "y1",
                                                    "vert. coord. of other end of axis",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("interpolate",
                                                     "interpolate",
                                                     "Whether to use interpolation and supersampling",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("clip-result",
                                                     "clip result",
                                                     "Whether to clip results",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The flipped drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-perspective
   */
  procedure = gimp_procedure_new (drawable_transform_perspective_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-perspective");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-perspective",
                                     "Perform a possibly non-affine transformation on the specified drawable, with extra parameters.",
                                     "This procedure performs a possibly non-affine transformation on the specified drawable by allowing the corners of the original bounding box to be arbitrarily remapped to any values. The specified drawable is remapped if no selection exists. However, if a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then remapped as specified. The return value is the ID of the remapped drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and remapped drawable. The 4 coordinates specify the new locations of each corner of the original bounding box. By specifying these values, any affine transformation (rotation, scaling, translation) can be affected. Additionally, these values can be specified such that the resulting transformed drawable will appear to have been projected via a perspective transform.",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x0",
                                                    "x0",
                                                    "The new x coordinate of upper-left corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y0",
                                                    "y0",
                                                    "The new y coordinate of upper-left corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x1",
                                                    "x1",
                                                    "The new x coordinate of upper-right corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y1",
                                                    "y1",
                                                    "The new y coordinate of upper-right corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x2",
                                                    "x2",
                                                    "The new x coordinate of lower-left corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y2",
                                                    "y2",
                                                    "The new y coordinate of lower-left corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x3",
                                                    "x3",
                                                    "The new x coordinate of lower-right corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y3",
                                                    "y3",
                                                    "The new y coordinate of lower-right corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-direction",
                                                  "transform direction",
                                                  "Direction of transformation",
                                                  GIMP_TYPE_TRANSFORM_DIRECTION,
                                                  GIMP_TRANSFORM_FORWARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("interpolation",
                                                  "interpolation",
                                                  "Type of interpolation",
                                                  GIMP_TYPE_INTERPOLATION_TYPE,
                                                  GIMP_INTERPOLATION_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("supersample",
                                                     "supersample",
                                                     "This parameter is ignored, supersampling is performed based on the interpolation type",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("recursion-level",
                                                      "recursion level",
                                                      "Maximum recursion level used for supersampling (3 is a nice value)",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The newly mapped drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-perspective-default
   */
  procedure = gimp_procedure_new (drawable_transform_perspective_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-perspective-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-perspective-default",
                                     "Perform a possibly non-affine transformation on the specified drawable, with extra parameters.",
                                     "This procedure is a variant of 'gimp-drawable-transform-perspective' which uses no interpolation/supersampling at all, or default values (depending on the 'interpolate' parameter).",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x0",
                                                    "x0",
                                                    "The new x coordinate of upper-left corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y0",
                                                    "y0",
                                                    "The new y coordinate of upper-left corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x1",
                                                    "x1",
                                                    "The new x coordinate of upper-right corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y1",
                                                    "y1",
                                                    "The new y coordinate of upper-right corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x2",
                                                    "x2",
                                                    "The new x coordinate of lower-left corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y2",
                                                    "y2",
                                                    "The new y coordinate of lower-left corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x3",
                                                    "x3",
                                                    "The new x coordinate of lower-right corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y3",
                                                    "y3",
                                                    "The new y coordinate of lower-right corner of original bounding box",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("interpolate",
                                                     "interpolate",
                                                     "Whether to use interpolation and supersampling",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The newly mapped drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-rotate-simple
   */
  procedure = gimp_procedure_new (drawable_transform_rotate_simple_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-rotate-simple");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-rotate-simple",
                                     "Rotate the specified drawable about given coordinates through the specified angle.",
                                     "This function rotates the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then rotated by the specified amount. The return value is the ID of the rotated drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and rotated drawable.",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("rotate-type",
                                                  "rotate type",
                                                  "Type of rotation",
                                                  GIMP_TYPE_ROTATION_TYPE,
                                                  GIMP_ROTATE_90,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("auto-center",
                                                     "auto center",
                                                     "Whether to automatically rotate around the selection center",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("center-x",
                                                      "center x",
                                                      "The hor. coordinate of the center of rotation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("center-y",
                                                      "center y",
                                                      "The vert. coordinate of the center of rotation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("clip-result",
                                                     "clip result",
                                                     "Whether to clip results",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The rotated drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-rotate
   */
  procedure = gimp_procedure_new (drawable_transform_rotate_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-rotate");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-rotate",
                                     "Rotate the specified drawable about given coordinates through the specified angle.",
                                     "This function rotates the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then rotated by the specified amount. The return value is the ID of the rotated drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and rotated drawable.",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("angle",
                                                    "angle",
                                                    "The angle of rotation (radians)",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("auto-center",
                                                     "auto center",
                                                     "Whether to automatically rotate around the selection center",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("center-x",
                                                      "center x",
                                                      "The hor. coordinate of the center of rotation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("center-y",
                                                      "center y",
                                                      "The vert. coordinate of the center of rotation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-direction",
                                                  "transform direction",
                                                  "Direction of transformation",
                                                  GIMP_TYPE_TRANSFORM_DIRECTION,
                                                  GIMP_TRANSFORM_FORWARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("interpolation",
                                                  "interpolation",
                                                  "Type of interpolation",
                                                  GIMP_TYPE_INTERPOLATION_TYPE,
                                                  GIMP_INTERPOLATION_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("supersample",
                                                     "supersample",
                                                     "This parameter is ignored, supersampling is performed based on the interpolation type",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("recursion-level",
                                                      "recursion level",
                                                      "Maximum recursion level used for supersampling (3 is a nice value)",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The rotated drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-rotate-default
   */
  procedure = gimp_procedure_new (drawable_transform_rotate_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-rotate-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-rotate-default",
                                     "Rotate the specified drawable about given coordinates through the specified angle.",
                                     "This procedure is a variant of 'gimp-drawable-transform-rotate' which uses no interpolation/supersampling at all, or default values (depending on the 'interpolate' parameter).",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("angle",
                                                    "angle",
                                                    "The angle of rotation (radians)",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("auto-center",
                                                     "auto center",
                                                     "Whether to automatically rotate around the selection center",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("center-x",
                                                      "center x",
                                                      "The hor. coordinate of the center of rotation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("center-y",
                                                      "center y",
                                                      "The vert. coordinate of the center of rotation",
                                                      G_MININT32, G_MAXINT32, 0,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("interpolate",
                                                     "interpolate",
                                                     "Whether to use interpolation and supersampling",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The rotated drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-scale
   */
  procedure = gimp_procedure_new (drawable_transform_scale_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-scale");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-scale",
                                     "Scale the specified drawable with extra parameters",
                                     "This procedure scales the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then scaled by the specified amount. The return value is the ID of the scaled drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and scaled drawable.",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x0",
                                                    "x0",
                                                    "The new x coordinate of the upper-left corner of the scaled region",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y0",
                                                    "y0",
                                                    "The new y coordinate of the upper-left corner of the scaled region",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x1",
                                                    "x1",
                                                    "The new x coordinate of the lower-right corner of the scaled region",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y1",
                                                    "y1",
                                                    "The new y coordinate of the lower-right corner of the scaled region",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-direction",
                                                  "transform direction",
                                                  "Direction of transformation",
                                                  GIMP_TYPE_TRANSFORM_DIRECTION,
                                                  GIMP_TRANSFORM_FORWARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("interpolation",
                                                  "interpolation",
                                                  "Type of interpolation",
                                                  GIMP_TYPE_INTERPOLATION_TYPE,
                                                  GIMP_INTERPOLATION_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("supersample",
                                                     "supersample",
                                                     "This parameter is ignored, supersampling is performed based on the interpolation type",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("recursion-level",
                                                      "recursion level",
                                                      "Maximum recursion level used for supersampling (3 is a nice value)",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The scaled drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-scale-default
   */
  procedure = gimp_procedure_new (drawable_transform_scale_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-scale-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-scale-default",
                                     "Scale the specified drawable with extra parameters",
                                     "This procedure is a variant of 'gimp-drawable-transform-scale' which uses no interpolation/supersampling at all, or default values (depending on the 'interpolate' parameter).",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x0",
                                                    "x0",
                                                    "The new x coordinate of the upper-left corner of the scaled region",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y0",
                                                    "y0",
                                                    "The new y coordinate of the upper-left corner of the scaled region",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("x1",
                                                    "x1",
                                                    "The new x coordinate of the lower-right corner of the scaled region",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("y1",
                                                    "y1",
                                                    "The new y coordinate of the lower-right corner of the scaled region",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("interpolate",
                                                     "interpolate",
                                                     "Whether to use interpolation and supersampling",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The scaled drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-shear
   */
  procedure = gimp_procedure_new (drawable_transform_shear_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-shear");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-shear",
                                     "Shear the specified drawable about its center by the specified magnitude, with extra parameters.",
                                     "This procedure shears the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then sheard by the specified amount. The return value is the ID of the sheard drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and sheard drawable. The shear type parameter indicates whether the shear will be applied horizontally or vertically. The magnitude can be either positive or negative and indicates the extent (in pixels) to shear by.",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_enum ("shear-type",
                                                     "shear type",
                                                     "Type of shear",
                                                     GIMP_TYPE_ORIENTATION_TYPE,
                                                     GIMP_ORIENTATION_HORIZONTAL,
                                                     GIMP_PARAM_READWRITE));
  gimp_param_spec_enum_exclude_value (GIMP_PARAM_SPEC_ENUM (procedure->args[1]),
                                      GIMP_ORIENTATION_UNKNOWN);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("magnitude",
                                                    "magnitude",
                                                    "The magnitude of the shear",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-direction",
                                                  "transform direction",
                                                  "Direction of transformation",
                                                  GIMP_TYPE_TRANSFORM_DIRECTION,
                                                  GIMP_TRANSFORM_FORWARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("interpolation",
                                                  "interpolation",
                                                  "Type of interpolation",
                                                  GIMP_TYPE_INTERPOLATION_TYPE,
                                                  GIMP_INTERPOLATION_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("supersample",
                                                     "supersample",
                                                     "This parameter is ignored, supersampling is performed based on the interpolation type",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("recursion-level",
                                                      "recursion level",
                                                      "Maximum recursion level used for supersampling (3 is a nice value)",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The sheared drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-shear-default
   */
  procedure = gimp_procedure_new (drawable_transform_shear_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-shear-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-shear-default",
                                     "Shear the specified drawable about its center by the specified magnitude, with extra parameters.",
                                     "This procedure is a variant of 'gimp-drawable-transform-shear' which uses no interpolation/supersampling at all, or default values (depending on the 'interpolate' parameter).",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_enum ("shear-type",
                                                     "shear type",
                                                     "Type of shear",
                                                     GIMP_TYPE_ORIENTATION_TYPE,
                                                     GIMP_ORIENTATION_HORIZONTAL,
                                                     GIMP_PARAM_READWRITE));
  gimp_param_spec_enum_exclude_value (GIMP_PARAM_SPEC_ENUM (procedure->args[1]),
                                      GIMP_ORIENTATION_UNKNOWN);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("magnitude",
                                                    "magnitude",
                                                    "The magnitude of the shear",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("interpolate",
                                                     "interpolate",
                                                     "Whether to use interpolation and supersampling",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The sheared drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-2d
   */
  procedure = gimp_procedure_new (drawable_transform_2d_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-2d");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-2d",
                                     "Transform the specified drawable in 2d, with extra parameters.",
                                     "This procedure transforms the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then transformed. The transformation is done by scaling the image by the x and y scale factors about the point (source_x, source_y), then rotating around the same point, then translating that point to the new position (dest_x, dest_y). The return value is the ID of the rotated drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and transformed drawable.",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("source-x",
                                                    "source x",
                                                    "X coordinate of the transformation center",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("source-y",
                                                    "source y",
                                                    "Y coordinate of the transformation center",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("scale-x",
                                                    "scale x",
                                                    "Amount to scale in x direction",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("scale-y",
                                                    "scale y",
                                                    "Amount to scale in y direction",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("angle",
                                                    "angle",
                                                    "The angle of rotation (radians)",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("dest-x",
                                                    "dest x",
                                                    "X coordinate of where the center goes",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("dest-y",
                                                    "dest y",
                                                    "Y coordinate of where the center goes",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-direction",
                                                  "transform direction",
                                                  "Direction of transformation",
                                                  GIMP_TYPE_TRANSFORM_DIRECTION,
                                                  GIMP_TRANSFORM_FORWARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("interpolation",
                                                  "interpolation",
                                                  "Type of interpolation",
                                                  GIMP_TYPE_INTERPOLATION_TYPE,
                                                  GIMP_INTERPOLATION_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("supersample",
                                                     "supersample",
                                                     "This parameter is ignored, supersampling is performed based on the interpolation type",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("recursion-level",
                                                      "recursion level",
                                                      "Maximum recursion level used for supersampling (3 is a nice value)",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The transformed drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-2d-default
   */
  procedure = gimp_procedure_new (drawable_transform_2d_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-2d-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-2d-default",
                                     "Transform the specified drawable in 2d, with extra parameters.",
                                     "This procedure is a variant of 'gimp-drawable-transform-2d' which uses no interpolation/supersampling at all, or default values (depending on the 'interpolate' parameter).",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("source-x",
                                                    "source x",
                                                    "X coordinate of the transformation center",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("source-y",
                                                    "source y",
                                                    "Y coordinate of the transformation center",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("scale-x",
                                                    "scale x",
                                                    "Amount to scale in x direction",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("scale-y",
                                                    "scale y",
                                                    "Amount to scale in y direction",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("angle",
                                                    "angle",
                                                    "The angle of rotation (radians)",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("dest-x",
                                                    "dest x",
                                                    "X coordinate of where the center goes",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("dest-y",
                                                    "dest y",
                                                    "Y coordinate of where the center goes",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("interpolate",
                                                     "interpolate",
                                                     "Whether to use interpolation and supersampling",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The transformed drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-matrix
   */
  procedure = gimp_procedure_new (drawable_transform_matrix_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-matrix");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-matrix",
                                     "Transform the specified drawable in 2d, with extra parameters.",
                                     "This procedure transforms the specified drawable if no selection exists. If a selection exists, the portion of the drawable which lies under the selection is cut from the drawable and made into a floating selection which is then transformed. The transformation is done by assembling a 3x3 matrix from the coefficients passed. The return value is the ID of the rotated drawable. If there was no selection, this will be equal to the drawable ID supplied as input. Otherwise, this will be the newly created and transformed drawable.",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-0-0",
                                                    "coeff 0 0",
                                                    "coefficient (0,0) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-0-1",
                                                    "coeff 0 1",
                                                    "coefficient (0,1) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-0-2",
                                                    "coeff 0 2",
                                                    "coefficient (0,2) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-1-0",
                                                    "coeff 1 0",
                                                    "coefficient (1,0) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-1-1",
                                                    "coeff 1 1",
                                                    "coefficient (1,1) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-1-2",
                                                    "coeff 1 2",
                                                    "coefficient (1,2) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-2-0",
                                                    "coeff 2 0",
                                                    "coefficient (2,0) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-2-1",
                                                    "coeff 2 1",
                                                    "coefficient (2,1) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-2-2",
                                                    "coeff 2 2",
                                                    "coefficient (2,2) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("transform-direction",
                                                  "transform direction",
                                                  "Direction of transformation",
                                                  GIMP_TYPE_TRANSFORM_DIRECTION,
                                                  GIMP_TRANSFORM_FORWARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("interpolation",
                                                  "interpolation",
                                                  "Type of interpolation",
                                                  GIMP_TYPE_INTERPOLATION_TYPE,
                                                  GIMP_INTERPOLATION_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("supersample",
                                                     "supersample",
                                                     "This parameter is ignored, supersampling is performed based on the interpolation type",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_int32 ("recursion-level",
                                                      "recursion level",
                                                      "Maximum recursion level used for supersampling (3 is a nice value)",
                                                      1, G_MAXINT32, 1,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The transformed drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-drawable-transform-matrix-default
   */
  procedure = gimp_procedure_new (drawable_transform_matrix_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure), "gimp-drawable-transform-matrix-default");
  gimp_procedure_set_static_strings (procedure,
                                     "gimp-drawable-transform-matrix-default",
                                     "Transform the specified drawable in 2d, with extra parameters.",
                                     "This procedure is a variant of 'gimp-drawable-transform-matrix' which uses no interpolation/supersampling at all, or default values (depending on the 'interpolate' parameter).",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "Jo\xc3\xa3o S. O. Bueno Calligaris",
                                     "2004",
                                     NULL);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable_id ("drawable",
                                                            "drawable",
                                                            "The affected drawable",
                                                            pdb->gimp, FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-0-0",
                                                    "coeff 0 0",
                                                    "coefficient (0,0) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-0-1",
                                                    "coeff 0 1",
                                                    "coefficient (0,1) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-0-2",
                                                    "coeff 0 2",
                                                    "coefficient (0,2) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-1-0",
                                                    "coeff 1 0",
                                                    "coefficient (1,0) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-1-1",
                                                    "coeff 1 1",
                                                    "coefficient (1,1) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-1-2",
                                                    "coeff 1 2",
                                                    "coefficient (1,2) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-2-0",
                                                    "coeff 2 0",
                                                    "coefficient (2,0) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-2-1",
                                                    "coeff 2 1",
                                                    "coefficient (2,1) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("coeff-2-2",
                                                    "coeff 2 2",
                                                    "coefficient (2,2) of the transformation matrix",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("interpolate",
                                                     "interpolate",
                                                     "Whether to use interpolation and supersampling",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clip-result",
                                                  "clip result",
                                                  "How to clip results",
                                                  GIMP_TYPE_TRANSFORM_RESIZE,
                                                  GIMP_TRANSFORM_RESIZE_ADJUST,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_drawable_id ("drawable",
                                                                "drawable",
                                                                "The transformed drawable",
                                                                pdb->gimp, FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
