/*******************************************************************************
 * Copyright (c) 2007 Red Hat, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Red Hat Incorporated - initial API and implementation
 *******************************************************************************/
package com.redhat.eclipse.cdt.autotools.ui.editors.parser;

public class AutoconfMacroElement extends AutoconfElement {

	protected int parmCount; // Macro parameter count
	protected int depth; // Macro parenthesis depth
	protected int quoteDepth; // Macro quoted argument depth
	
	public AutoconfMacroElement(String name) {
		super(name);
	}
	
	public AutoconfMacroElement(String name, int lineNumber, int offset) {
		super(name, null, lineNumber, offset);
	}

	public AutoconfMacroElement(String name, String var, int lineNumber, int offset) {
		super(name, var, lineNumber, offset);
	}
	
	public void setParmCount(int val) {
		parmCount = val;
	}
	
	public int getParmCount() {
		return parmCount;
	}
	
	public void setQuoteDepth(int val) {
		quoteDepth = val;
	}
	
	public int getQuoteDepth() {
		return quoteDepth;
	}
	public void setDepth(int val) {
		depth = val;
	}
	
	public int getDepth() {
		return depth;
	}
}
