/*******************************************************************************
 * Copyright (c) 2007 Red Hat, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Red Hat Incorporated - initial API and implementation
 *******************************************************************************/
package com.redhat.eclipse.cdt.autotools.ui.editors.parser;

import java.util.ArrayList;

public class AutoconfElement {
	
	protected String name;
	protected String var;
	protected int lineNumber;
	protected int startOffset;
	protected int endLineNumber;
	protected int endOffset;
	protected ArrayList children;
	protected AutoconfElement parent;
	
	public AutoconfElement(String name) {
		this(name, null, -1);
	}
	
	public AutoconfElement(String name, int lineNumber) {
		this(name, null, lineNumber);
	}

	public AutoconfElement(String name, String var, int lineNumber) {
		this(name, var, lineNumber, 0);
	}
	
	public AutoconfElement(String name, String var, int lineNumber, int offset) {
		this.name = name;
		this.var = var;
		this.lineNumber = lineNumber;
		this.startOffset = offset;
		this.children = new ArrayList();
	}
	
	
	public void addChild(AutoconfElement element) {
		children.add(element);
		if (element.getParent() == null)
			element.setParent(this);
	}
	
	public void addSibling(AutoconfElement element) {
		parent.addChild(element);
	}
	
	public AutoconfElement getLastChild() {
		if (hasChildren())
			return (AutoconfElement)children.get(children.size() - 1);
		return null;
	}
	
	public AutoconfElement getParent() {
		return parent;
	}
	
	public void setParent(AutoconfElement parent) {
		this.parent = parent;
	}
	
	public Object[] getChildren() {
		return children.toArray();
	}
	
	public boolean hasChildren() {
		return !children.isEmpty();
	}

	public String getName() {
		return name;
	}
	
	public String getVar() {
		return var;
	}
	
	public void setVar(String value) {
		var = value;
	}
	
	public void setLineNumber(int lineNumber) {
		this.lineNumber = lineNumber;
	}
	
	public int getLineNumber() {
		return lineNumber;
	}
	
	public void setEndLineNumber(int lineNumber) {
		this.endLineNumber = lineNumber;
	}
	
	public int getEndLineNumber() {
		if (endLineNumber > lineNumber)
			return endLineNumber;
		return lineNumber;
	}
	
	public void setStartOffset(int offset) {
		this.startOffset = offset;
	}
	
	public int getStartOffset() {
		return startOffset;
	}
	
	public void setEndOffset(int offset) {
		this.endOffset = offset;
	}
	
	public int getEndOffset() {
		return endOffset;
	}
}
