/*******************************************************************************
 * Copyright (c) 2007 Red Hat, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Red Hat Incorporated - initial API and implementation
 *******************************************************************************/
package com.redhat.eclipse.cdt.autotools.ui.editors.outline;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

import com.redhat.eclipse.cdt.autotools.internal.ui.AutotoolsPluginImages;
import com.redhat.eclipse.cdt.autotools.ui.editors.parser.AutoconfCaseConditionElement;
import com.redhat.eclipse.cdt.autotools.ui.editors.parser.AutoconfCaseElement;
import com.redhat.eclipse.cdt.autotools.ui.editors.parser.AutoconfElement;
import com.redhat.eclipse.cdt.autotools.ui.editors.parser.AutoconfElifElement;
import com.redhat.eclipse.cdt.autotools.ui.editors.parser.AutoconfElseElement;
import com.redhat.eclipse.cdt.autotools.ui.editors.parser.AutoconfForElement;
import com.redhat.eclipse.cdt.autotools.ui.editors.parser.AutoconfIfElement;
import com.redhat.eclipse.cdt.autotools.ui.editors.parser.AutoconfMacroElement;
import com.redhat.eclipse.cdt.autotools.ui.editors.parser.AutoconfWhileElement;

public class AutoconfLabelProvider implements ILabelProvider {

	public AutoconfLabelProvider() {
		super();
	}
	
	public void addListener(ILabelProviderListener listener) {
	}

	public void dispose() {
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
	}

	public Image getImage(Object element) {
		if (element instanceof AutoconfIfElement)
			return AutotoolsPluginImages.get(AutotoolsPluginImages.IMG_OBJS_IF);
		else if (element instanceof AutoconfElseElement)
			return AutotoolsPluginImages.get(AutotoolsPluginImages.IMG_OBJS_ELSE);
		else if (element instanceof AutoconfElifElement)
			return AutotoolsPluginImages.get(AutotoolsPluginImages.IMG_OBJS_ELIF);
		else if (element instanceof AutoconfCaseElement)
			return AutotoolsPluginImages.get(AutotoolsPluginImages.IMG_OBJS_CASE);
		else if (element instanceof AutoconfCaseConditionElement)
			return AutotoolsPluginImages.get(AutotoolsPluginImages.IMG_OBJS_CONDITION);
		else if (element instanceof AutoconfForElement)
			return AutotoolsPluginImages.get(AutotoolsPluginImages.IMG_OBJS_FOR);
		else if (element instanceof AutoconfWhileElement)
			return AutotoolsPluginImages.get(AutotoolsPluginImages.IMG_OBJS_WHILE);
		else if (element instanceof AutoconfMacroElement)
			return AutotoolsPluginImages.get(AutotoolsPluginImages.IMG_OBJS_ACMACRO);
		return null;
	}

	public String getText(Object element) {
		if (element instanceof AutoconfElement) {
			AutoconfElement e = (AutoconfElement)element;
			if (e.getVar() != null)
				return e.getName() + " " + e.getVar(); //$NON-NLS-1$
			return e.getName();
		} else if (element instanceof String) {
			return (String) element;
		}
		return "";
	}

}
