/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import org.exolab.adaptx.util.ErrorObserver;
import org.exolab.adaptx.util.NestedRuntimeException;
import org.exolab.adaptx.xslt.util.MessageObserver;

public class DefaultObserver
implements MessageObserver,
ErrorObserver {
    private static final String ERROR_PREFIX = "error: ";
    private static final String FATAL_PREFIX = "fatal error: ";
    private static final String WARNING_PREFIX = "warning: ";
    private Vector _errorObservers = null;
    private Vector _messageObservers = null;
    private PrintWriter _out = null;
    private boolean _allErrorsFatal = false;

    public DefaultObserver() {
        this._out = new PrintWriter(System.out, true);
    }

    public DefaultObserver(Writer writer) {
        this.setWriter(writer);
    }

    public DefaultObserver(Writer writer, boolean bl) {
        this.setWriter(writer);
        this._allErrorsFatal = bl;
    }

    public DefaultObserver(boolean bl) {
        this._out = new PrintWriter(System.out, true);
        this._allErrorsFatal = bl;
    }

    public void addErrorObserver(ErrorObserver errorObserver) {
        if (errorObserver == null) {
            return;
        }
        if (this._errorObservers == null) {
            this._errorObservers = new Vector(3);
            this._errorObservers.addElement(errorObserver);
        } else if (!this._errorObservers.contains(errorObserver)) {
            this._errorObservers.addElement(errorObserver);
        }
    }

    public void addMessageObserver(MessageObserver messageObserver) {
        if (messageObserver == null) {
            return;
        }
        if (this._messageObservers == null) {
            this._messageObservers = new Vector(3);
            this._messageObservers.addElement(messageObserver);
        } else if (!this._messageObservers.contains(messageObserver)) {
            this._messageObservers.addElement(messageObserver);
        }
    }

    public void receiveError(Exception exception) {
        this.receiveError(exception, null, 1);
    }

    public void receiveError(Exception exception, int n) {
        this.receiveError(exception, null, n);
    }

    public void receiveError(Exception exception, String string) {
        this.receiveError(exception, string, 1);
    }

    public void receiveError(Exception exception, String string, int n) {
        String string2 = null;
        boolean bl = false;
        switch (n) {
            case 0: {
                string2 = FATAL_PREFIX;
                bl = true;
                break;
            }
            case 2: {
                string2 = WARNING_PREFIX;
                break;
            }
            default: {
                string2 = ERROR_PREFIX;
                bl = this._allErrorsFatal;
            }
        }
        if (this._out != null && !bl) {
            this._out.print(string2);
            if (exception != null) {
                this._out.print(exception.toString());
                if (string != null) {
                    this._out.print("; ");
                    this._out.println(string);
                } else {
                    this._out.println();
                }
                exception.printStackTrace(this._out);
            } else if (string != null) {
                this._out.println(string);
            } else {
                this._out.println("no exception or error message given.");
            }
            this._out.flush();
        }
        if (this._errorObservers != null) {
            int n2 = 0;
            while (n2 < this._errorObservers.size()) {
                ErrorObserver errorObserver = (ErrorObserver)this._errorObservers.elementAt(n2);
                errorObserver.receiveError(exception, string, n);
                ++n2;
            }
        }
        if (bl) {
            String string3 = null;
            string3 = string == null && exception == null ? "no exception or error message given." : (string == null ? exception.toString() : (exception == null ? string : String.valueOf(exception.toString()) + "; " + string));
            throw new NestedRuntimeException(String.valueOf(string2) + string3, exception);
        }
    }

    public void receiveError(String string) {
        this.receiveError(null, string, 1);
    }

    public void receiveError(String string, int n) {
        this.receiveError(null, string, n);
    }

    public void receiveMessage(String string) {
        if (this._out == null) {
            return;
        }
        this._out.print("xsl:message - ");
        this._out.println(string);
        this._out.flush();
        if (this._messageObservers != null) {
            int n = 0;
            while (n < this._messageObservers.size()) {
                MessageObserver messageObserver = (MessageObserver)this._messageObservers.elementAt(n);
                messageObserver.receiveMessage(string);
                ++n;
            }
        }
    }

    public void removeAllErrorObservers() {
        if (this._errorObservers != null) {
            this._errorObservers.removeAllElements();
        }
    }

    public void removeAllMessageObservers() {
        if (this._messageObservers != null) {
            this._messageObservers.removeAllElements();
        }
    }

    public void removeErrorObserver(ErrorObserver errorObserver) {
        if (errorObserver == null) {
            return;
        }
        if (this._errorObservers != null) {
            this._errorObservers.removeElement(errorObserver);
        }
    }

    public void removeMessageObserver(MessageObserver messageObserver) {
        if (messageObserver == null) {
            return;
        }
        if (this._messageObservers != null) {
            this._messageObservers.removeElement(messageObserver);
        }
    }

    public void setWriter(Writer writer) {
        this._out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer, true);
    }
}

