/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.exolab.adaptx.net.URIException;
import org.exolab.adaptx.net.URILocation;
import org.exolab.adaptx.net.URIResolver;
import org.exolab.adaptx.net.impl.URILocationImpl;
import org.exolab.adaptx.net.impl.URIResolverImpl;
import org.exolab.adaptx.util.ConsoleDialog;
import org.exolab.adaptx.util.ErrorObserver;
import org.exolab.adaptx.util.ErrorObserverAdapter;
import org.exolab.adaptx.util.List;
import org.exolab.adaptx.xml.dom2xpn.DocumentWrapperXPathNode;
import org.exolab.adaptx.xml.parser.DOMParser;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xslt.FunctionResolver;
import org.exolab.adaptx.xslt.ResultHandler;
import org.exolab.adaptx.xslt.RuleProcessor;
import org.exolab.adaptx.xslt.XSLException;
import org.exolab.adaptx.xslt.XSLPIHandler;
import org.exolab.adaptx.xslt.XSLTReader;
import org.exolab.adaptx.xslt.XSLTStylesheet;
import org.exolab.adaptx.xslt.dom.XPNBuilder;
import org.exolab.adaptx.xslt.handlers.DOMBuilder;
import org.exolab.adaptx.xslt.handlers.DefaultHandler;
import org.exolab.adaptx.xslt.util.Configuration;
import org.exolab.adaptx.xslt.util.DefaultObserver;
import org.exolab.adaptx.xslt.util.MessageObserver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XSLTProcessor
extends ErrorObserverAdapter
implements MessageObserver {
    public static final String HELP_FLAG = "h";
    public static final String INPUT_FLAG = "i";
    public static final String OUTPUT_FLAG = "o";
    public static final String STYLESHEET_FLAG = "s";
    public static final String VALIDATE_FLAG = "val";
    public static final String VERSION_FLAG = "v";
    public static final String ERR_OUTPUT_FLAG = "e";
    private final String ERR_PROPERTIES_NOT_FOUND = "unable to load properties file";
    public static final String INDENT_SIZE = "indent-size";
    private static final String FORMATTER_PREFIX = "formatter.";
    private static final String NULL_HANDLER_ERR = "The ResultHandler passed to #process() must not be null.";
    private static final String NULL_DOCUMENT_ERR = "The XML Source Document passed to #process() must not be null.";
    private static final String NULL_XML_FILENAME_ERR = "The XML filename, passed to #process(), must not be null.";
    private static final String NULL_XML_LOCATION_ERR = "The XML URILocation, passed to #process(), must not be null.";
    private static final String NULL_XML_NODE_ERR = "The XML Source Node passed to #process() must not be null.";
    private final String HTML_RESULT_NS = "http://www.w3.org/TR/REC-html";
    private final String HTML = "html";
    private final String DEFAULT_NS = "";
    private static final String appName = "Adaptx";
    private static final String appVersion = "0.9 (20010716)";
    private String documentBase = null;
    private List fnResolvers = null;
    private List msgObservers = null;
    private Properties params = new Properties();
    private static final DefaultObserver _defaultObserver = new DefaultObserver();
    private boolean validate = false;
    private URIResolver _uriResolver = null;

    public XSLTProcessor() {
        this.msgObservers = new List(3);
        this.msgObservers.add(_defaultObserver);
        this.addErrorObserver(_defaultObserver);
        this.fnResolvers = new List(3);
        this._uriResolver = new URIResolverImpl();
    }

    public void addErrorObserver(ErrorObserver errorObserver) {
        if (errorObserver == null) {
            return;
        }
        this.removeErrorObserver(_defaultObserver);
        super.addErrorObserver(errorObserver);
    }

    public void addFunctionResolver(FunctionResolver functionResolver) {
        if (functionResolver != null) {
            this.fnResolvers.add(functionResolver);
        }
    }

    public void addMessageObserver(MessageObserver messageObserver) {
        this.msgObservers.add(messageObserver);
    }

    private void copyParams(RuleProcessor ruleProcessor) {
        Enumeration enumeration = ((Hashtable)this.params).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ruleProcessor.setParameter(string, this.params.getProperty(string));
        }
    }

    public static URILocation createURILocation(Reader reader, String string) {
        return new URILocationImpl(reader, string);
    }

    public static String getAppInfo() {
        return "Adaptx 0.9 (20010716)";
    }

    private static Hashtable getOptions(String[] stringArray, List list) {
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                if (string != null) {
                    hashtable.put(string, stringArray[n]);
                    hashtable.put(new Integer(n), stringArray[n]);
                }
                if (!list.contains(string = stringArray[n].substring(1))) {
                    int n2 = 1;
                    while (n2 <= string.length()) {
                        if (list.contains(string.substring(0, n2))) {
                            if (n2 < string.length()) {
                                hashtable.put(string.substring(0, n2), string.substring(n2));
                                break;
                            }
                        } else if (n2 == string.length()) {
                            XSLTProcessor.printError("invalid option: -" + string, true);
                        }
                        ++n2;
                    }
                }
            } else {
                if (string != null) {
                    hashtable.put(string, stringArray[n]);
                }
                hashtable.put(new Integer(n), stringArray[n]);
                string = null;
            }
            ++n;
        }
        if (string != null) {
            hashtable.put(string, "no value");
        }
        return hashtable;
    }

    public String getParameter(String string) {
        if (string == null) {
            return null;
        }
        return this.params.getProperty(string);
    }

    public Enumeration getParameterNames() {
        return ((Hashtable)this.params).keys();
    }

    public String getProperty(String string) {
        return Configuration.getProperty(string);
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Object object3;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var4_4 = null;
        String string4 = null;
        FileWriter fileWriter = null;
        List list = new List(8);
        list.add(HELP_FLAG);
        list.add(STYLESHEET_FLAG);
        list.add(OUTPUT_FLAG);
        list.add(INPUT_FLAG);
        list.add(VALIDATE_FLAG);
        list.add(VERSION_FLAG);
        list.add(ERR_OUTPUT_FLAG);
        list.add("d");
        list.add("f");
        boolean bl = false;
        Hashtable hashtable = XSLTProcessor.getOptions(stringArray, list);
        if (hashtable == null || hashtable.size() == 0) {
            XSLTProcessor.printUsage(System.out);
            return;
        }
        if (hashtable.containsKey(HELP_FLAG)) {
            XSLTProcessor.printHelp(System.out);
            return;
        }
        if (hashtable.containsKey(VERSION_FLAG)) {
            System.out.println("Adaptx 0.9 (20010716)");
            return;
        }
        string3 = (String)hashtable.get(STYLESHEET_FLAG);
        string = (String)hashtable.get(INPUT_FLAG);
        string2 = (String)hashtable.get(OUTPUT_FLAG);
        bl = hashtable.containsKey("d");
        string4 = (String)hashtable.get(ERR_OUTPUT_FLAG);
        if (string4 != null) {
            try {
                fileWriter = new FileWriter(string4);
            }
            catch (IOException iOException) {
                XSLTProcessor.printError("Cannot open error file: " + string4, false);
            }
        }
        if (string == null) {
            XSLTProcessor.printError("XML filename missing.", true);
        }
        Writer writer = null;
        if (string2 == null) {
            writer = new PrintWriter(System.out);
        } else {
            try {
                object3 = new File(string2);
                if (((File)object3).exists() && !hashtable.containsKey("f")) {
                    object2 = new ConsoleDialog();
                    object = "File '" + string2;
                    if (!((ConsoleDialog)object2).confirm((String)(object = String.valueOf(object) + "' already exists! Overwrite?"))) {
                        System.out.println("processing halted!");
                        return;
                    }
                }
                writer = new FileWriter((File)object3);
            }
            catch (IOException iOException) {
                System.out.println("XSLProcessor error: " + iOException.getMessage());
            }
        }
        object3 = new XSLTProcessor();
        ((XSLTProcessor)object3).addErrorObserver(new DefaultObserver(true));
        ((XSLTProcessor)object3).setValidation(hashtable.containsKey(VALIDATE_FLAG));
        if (bl) {
            System.out.println("Adaptx invoked using: ");
            System.out.print("parser.dom: ");
            object2 = Configuration.getDOMParser();
            if (object2 == null) {
                System.out.println("<none>");
            } else {
                System.out.println(object2.getClass().getName());
            }
            System.out.print("parser.sax: ");
            object = Configuration.getSAXParser();
            if (object == null) {
                System.out.println("<none>");
            } else {
                System.out.println(object.getClass().getName());
            }
        }
        if (fileWriter != null) {
            ((XSLTProcessor)object3).addErrorObserver(new DefaultObserver(fileWriter));
        }
        ((XSLTProcessor)object3).process(string, string3, writer);
        try {
            if (fileWriter != null) {
                ((Writer)fileWriter).close();
            }
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void parsePIs(XPathNode xPathNode, XSLPIHandler xSLPIHandler) {
        if (xPathNode == null || xSLPIHandler == null) {
            return;
        }
        XPathNode xPathNode2 = xPathNode.getRootNode();
        xPathNode2 = xPathNode2.getFirstChild();
        while (xPathNode2 != null) {
            if (xPathNode2.getNodeType() == 7) {
                xSLPIHandler.handlePI(xPathNode2.getLocalName(), xPathNode2.getStringValue());
            }
            xPathNode2 = xPathNode2.getNext();
        }
    }

    private void parsePIs(Document document, XSLPIHandler xSLPIHandler) {
        if (document == null || xSLPIHandler == null) {
            return;
        }
        NodeList nodeList = document.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 7) {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                xSLPIHandler.handlePI(processingInstruction.getTarget(), processingInstruction.getData());
            }
            ++n;
        }
    }

    private static void printError(String string, boolean bl) {
        System.out.println();
        System.out.println(XSLTProcessor.getAppInfo());
        System.out.println("#error: " + string);
        XSLTProcessor.printUsage(System.out, false);
        if (bl) {
            System.exit(0);
        }
    }

    private static void printHelp(PrintStream printStream) {
        printStream.println();
        printStream.println(XSLTProcessor.getAppInfo());
        printStream.print("The following flags are available for use with ");
        printStream.println("Adaptx -");
        printStream.println();
        printStream.println("-i  filename       : The XML file to process");
        printStream.println("-o  filename       : The Output file to create");
        printStream.println("-s  filename       : The XSL file to use for processing  (Optional)");
        printStream.println("-handler classname : Formatter (for Formatting Objects)  (Optional)");
        printStream.println("-val               : Turns on xml validation if using    (Optional)");
        printStream.println("                     a validating DOM parser");
        printStream.println("-f                 : Force overwriting output file       (Optional)");
        printStream.println("-h                 : This help screen                    (Optional)");
        printStream.println();
    }

    private static void printUsage(PrintStream printStream) {
        XSLTProcessor.printUsage(printStream, true);
    }

    private static void printUsage(PrintStream printStream, boolean bl) {
        printStream.println();
        if (bl) {
            printStream.println(XSLTProcessor.getAppInfo());
        }
        printStream.println("usage:");
        printStream.print("java org.exolab.adaptx.xslt.XSLProcessor -");
        printStream.print("i xml-file [-");
        printStream.print("s xsl-file] [-");
        printStream.println("o output-file] [-val][-f]");
        printStream.println();
        printStream.println("for more infomation use the -h flag");
    }

    public Document process(String string) {
        String string2 = null;
        return this.process(string, string2);
    }

    public void process(String string, Writer writer) {
        String string2 = null;
        this.process(string, string2, writer);
    }

    public Document process(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException(NULL_XML_FILENAME_ERR);
        }
        URILocation uRILocation = null;
        URILocation uRILocation2 = null;
        try {
            uRILocation = this._uriResolver.resolve(string, this.documentBase);
            uRILocation2 = this._uriResolver.resolve(string2, uRILocation.getBaseURI());
        }
        catch (Exception exception) {
            this.receiveError(exception, "processing aborted", 0);
            return null;
        }
        DOMParser dOMParser = Configuration.getDOMParser();
        Document document = dOMParser.createDocument();
        DOMBuilder dOMBuilder = new DOMBuilder(document);
        this.process(uRILocation, uRILocation2, (ResultHandler)dOMBuilder);
        return document;
    }

    public void process(String string, String string2, Writer writer) {
        this.process(string, string2, (ResultHandler)new DefaultHandler(writer));
    }

    public void process(String string, String string2, ResultHandler resultHandler) {
        Serializable serializable;
        Object object;
        if (resultHandler == null) {
            throw new IllegalArgumentException(NULL_HANDLER_ERR);
        }
        URILocation uRILocation = null;
        try {
            uRILocation = this._uriResolver.resolve(string, this.documentBase);
        }
        catch (URIException uRIException) {
            object = "Error reading stylesheet: " + uRIException.getMessage();
            object = String.valueOf(object) + "\n -- processing with default rules";
            this.receiveError((String)object);
        }
        URILocation uRILocation2 = null;
        if (string2 != null && string2.length() > 0) {
            try {
                uRILocation2 = this._uriResolver.resolve(string2, this.documentBase);
            }
            catch (URIException uRIException) {
                serializable = new StringBuffer();
                ((StringBuffer)serializable).append("Error reading stylesheet: ");
                ((StringBuffer)serializable).append(uRIException.getMessage());
                ((StringBuffer)serializable).append("\n -- processing with default rules");
                this.receiveError(((StringBuffer)serializable).toString());
            }
        }
        object = new XSLPIHandler();
        ((XSLPIHandler)object).setDocumentBase(uRILocation.getBaseURI());
        serializable = this.readXMLDocument(uRILocation);
        if (serializable == null) {
            String string3 = "unable to read XML document, processing halted.";
            this.receiveError(string3, 0);
            return;
        }
        this.parsePIs((XPathNode)serializable, (XSLPIHandler)object);
        XSLTStylesheet xSLTStylesheet = this.readXSLStylesheet(uRILocation2, (XSLPIHandler)object);
        this.process((XPathNode)serializable, xSLTStylesheet, resultHandler);
    }

    public void process(String string, XSLTStylesheet xSLTStylesheet, Writer writer) {
        this.process(string, xSLTStylesheet, (ResultHandler)new DefaultHandler(writer));
    }

    public void process(String string, XSLTStylesheet xSLTStylesheet, ResultHandler resultHandler) {
        if (resultHandler == null) {
            throw new IllegalArgumentException(NULL_HANDLER_ERR);
        }
        URILocation uRILocation = null;
        try {
            uRILocation = this._uriResolver.resolve(string, this.documentBase);
        }
        catch (Exception exception) {
            String string2 = "Unable to read XML document: " + string;
            string2 = String.valueOf(string2) + "; " + exception.getMessage();
            this.receiveError(string2, 0);
            return;
        }
        XPathNode xPathNode = this.readXMLDocument(uRILocation);
        this.process(xPathNode, xSLTStylesheet, resultHandler);
    }

    public Document process(URILocation uRILocation, URILocation uRILocation2) {
        if (uRILocation == null) {
            throw new IllegalArgumentException(NULL_XML_LOCATION_ERR);
        }
        XPathNode xPathNode = this.readXMLDocument(uRILocation);
        XSLPIHandler xSLPIHandler = new XSLPIHandler();
        xSLPIHandler.setDocumentBase(uRILocation.getBaseURI());
        this.parsePIs(xPathNode, xSLPIHandler);
        XSLTStylesheet xSLTStylesheet = this.readXSLStylesheet(uRILocation2, xSLPIHandler);
        DOMParser dOMParser = Configuration.getDOMParser();
        Document document = dOMParser.createDocument();
        DOMBuilder dOMBuilder = new DOMBuilder(document);
        this.process(xPathNode, xSLTStylesheet, (ResultHandler)dOMBuilder);
        return document;
    }

    public void process(URILocation uRILocation, URILocation uRILocation2, ResultHandler resultHandler) {
        if (resultHandler == null) {
            throw new IllegalArgumentException(NULL_HANDLER_ERR);
        }
        if (uRILocation == null) {
            throw new IllegalArgumentException(NULL_XML_LOCATION_ERR);
        }
        XPathNode xPathNode = this.readXMLDocument(uRILocation);
        XSLPIHandler xSLPIHandler = new XSLPIHandler();
        xSLPIHandler.setDocumentBase(uRILocation.getBaseURI());
        this.parsePIs(xPathNode, xSLPIHandler);
        XSLTStylesheet xSLTStylesheet = this.readXSLStylesheet(uRILocation2, xSLPIHandler);
        this.process(xPathNode, xSLTStylesheet, resultHandler);
    }

    public XPathNode process(XPathNode xPathNode, XSLTStylesheet xSLTStylesheet) {
        Object object;
        if (xPathNode == null) {
            throw new IllegalArgumentException(NULL_XML_NODE_ERR);
        }
        if (xSLTStylesheet == null) {
            object = new XSLPIHandler();
            this.parsePIs(xPathNode, (XSLPIHandler)object);
            xSLTStylesheet = this.readXSLStylesheet(null, (XSLPIHandler)object);
        }
        object = new RuleProcessor(xSLTStylesheet);
        ((RuleProcessor)object).setURIResolver(this._uriResolver);
        this.copyParams((RuleProcessor)object);
        ((RuleProcessor)object).addMessageObserver(this);
        ((ErrorObserverAdapter)object).addErrorObserver(this);
        int n = 0;
        while (n < this.fnResolvers.size()) {
            ((RuleProcessor)object).addFunctionResolver((FunctionResolver)this.fnResolvers.get(n));
            ++n;
        }
        XPNBuilder xPNBuilder = new XPNBuilder();
        ((RuleProcessor)object).process(xPathNode, xPNBuilder);
        return xPNBuilder.getRoot();
    }

    public void process(XPathNode xPathNode, XSLTStylesheet xSLTStylesheet, Writer writer) {
        DefaultHandler defaultHandler = null;
        defaultHandler = xSLTStylesheet != null ? new DefaultHandler(writer, xSLTStylesheet.getOutput()) : new DefaultHandler(writer);
        this.process(xPathNode, xSLTStylesheet, (ResultHandler)defaultHandler);
    }

    public void process(XPathNode xPathNode, XSLTStylesheet xSLTStylesheet, ResultHandler resultHandler) {
        Object object;
        if (resultHandler == null) {
            throw new IllegalArgumentException(NULL_HANDLER_ERR);
        }
        if (xPathNode == null) {
            throw new IllegalArgumentException(NULL_XML_NODE_ERR);
        }
        if (xSLTStylesheet == null) {
            object = new XSLPIHandler();
            this.parsePIs(xPathNode, (XSLPIHandler)object);
            xSLTStylesheet = this.readXSLStylesheet(null, (XSLPIHandler)object);
        }
        resultHandler.setOutputFormat(xSLTStylesheet.getOutput());
        object = this.getProperty(INDENT_SIZE);
        if (object != null) {
            try {
                resultHandler.setIndentSize((short)Integer.parseInt((String)object));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        RuleProcessor ruleProcessor = new RuleProcessor(xSLTStylesheet);
        ruleProcessor.setURIResolver(this._uriResolver);
        this.copyParams(ruleProcessor);
        ruleProcessor.addMessageObserver(this);
        ruleProcessor.addErrorObserver(this);
        int n = 0;
        while (n < this.fnResolvers.size()) {
            ruleProcessor.addFunctionResolver((FunctionResolver)this.fnResolvers.get(n));
            ++n;
        }
        ruleProcessor.process(xPathNode, resultHandler);
    }

    public Document process(Document document, XSLTStylesheet xSLTStylesheet) {
        Object object;
        if (document == null) {
            throw new IllegalArgumentException(NULL_DOCUMENT_ERR);
        }
        if (xSLTStylesheet == null) {
            object = new XSLPIHandler();
            this.parsePIs(document, (XSLPIHandler)object);
            xSLTStylesheet = this.readXSLStylesheet(null, (XSLPIHandler)object);
        }
        object = new RuleProcessor(xSLTStylesheet);
        ((RuleProcessor)object).setURIResolver(this._uriResolver);
        this.copyParams((RuleProcessor)object);
        ((RuleProcessor)object).addMessageObserver(this);
        ((ErrorObserverAdapter)object).addErrorObserver(this);
        int n = 0;
        while (n < this.fnResolvers.size()) {
            ((RuleProcessor)object).addFunctionResolver((FunctionResolver)this.fnResolvers.get(n));
            ++n;
        }
        DOMParser dOMParser = Configuration.getDOMParser();
        Document document2 = dOMParser.createDocument();
        DOMBuilder dOMBuilder = new DOMBuilder(document2);
        ((RuleProcessor)object).process(new DocumentWrapperXPathNode(document), dOMBuilder);
        return document2;
    }

    public void process(Document document, XSLTStylesheet xSLTStylesheet, Writer writer) {
        DefaultHandler defaultHandler = null;
        defaultHandler = xSLTStylesheet != null ? new DefaultHandler(writer, xSLTStylesheet.getOutput()) : new DefaultHandler(writer);
        DocumentWrapperXPathNode documentWrapperXPathNode = new DocumentWrapperXPathNode(document);
        this.process((XPathNode)documentWrapperXPathNode, xSLTStylesheet, (ResultHandler)defaultHandler);
    }

    public void process(Document document, XSLTStylesheet xSLTStylesheet, ResultHandler resultHandler) {
        DocumentWrapperXPathNode documentWrapperXPathNode = new DocumentWrapperXPathNode(document);
        this.process((XPathNode)documentWrapperXPathNode, xSLTStylesheet, resultHandler);
    }

    public Document process(Document document, Document document2) {
        if (document == null) {
            throw new IllegalArgumentException(NULL_DOCUMENT_ERR);
        }
        XSLTStylesheet xSLTStylesheet = null;
        if (document2 == null) {
            XSLPIHandler xSLPIHandler = new XSLPIHandler();
            this.parsePIs(document, xSLPIHandler);
            xSLTStylesheet = this.readXSLStylesheet(null, xSLPIHandler);
        } else {
            xSLTStylesheet = this.readXSLStylesheet(document2, "XSL Document");
        }
        return this.process(document, xSLTStylesheet);
    }

    public void process(Document document, Document document2, Writer writer) {
        this.process(document, document2, (ResultHandler)new DefaultHandler(writer));
    }

    public void process(Document document, Document document2, ResultHandler resultHandler) {
        if (resultHandler == null) {
            throw new IllegalArgumentException(NULL_HANDLER_ERR);
        }
        if (document == null) {
            throw new IllegalArgumentException(NULL_DOCUMENT_ERR);
        }
        XSLTStylesheet xSLTStylesheet = null;
        if (document2 == null) {
            XSLPIHandler xSLPIHandler = new XSLPIHandler();
            this.parsePIs(document, xSLPIHandler);
            xSLTStylesheet = this.readXSLStylesheet(null, xSLPIHandler);
        } else {
            xSLTStylesheet = this.readXSLStylesheet(document2, "XSL Document");
        }
        this.process(document, xSLTStylesheet, resultHandler);
    }

    private XPathNode readXMLDocument(URILocation uRILocation) {
        Parser parser = Configuration.getSAXParser();
        if (parser == null) {
            this.receiveError("unable to create SAX parser. ", 0);
            return null;
        }
        XPNBuilder xPNBuilder = new XPNBuilder();
        try {
            InputSource inputSource = new InputSource();
            inputSource.setSystemId(uRILocation.getAbsoluteURI());
            inputSource.setCharacterStream(uRILocation.getReader());
            parser.setDocumentHandler(xPNBuilder);
            parser.parse(inputSource);
        }
        catch (SAXException sAXException) {
            SAXParseException sAXParseException = null;
            Exception exception = sAXException.getException();
            if (sAXException instanceof SAXParseException) {
                sAXParseException = (SAXParseException)sAXException;
            } else if (exception != null && exception instanceof SAXParseException) {
                sAXParseException = (SAXParseException)exception;
            }
            if (sAXParseException != null) {
                StringBuffer stringBuffer = new StringBuffer(((SAXException)sAXParseException).toString());
                stringBuffer.append("\n - ");
                stringBuffer.append(sAXParseException.getSystemId());
                stringBuffer.append("; line: ");
                stringBuffer.append(sAXParseException.getLineNumber());
                stringBuffer.append(", column: ");
                stringBuffer.append(sAXParseException.getColumnNumber());
                this.receiveError(stringBuffer.toString(), 0);
                return null;
            }
            this.receiveError((Exception)sAXException, 0);
            return null;
        }
        catch (IOException iOException) {
            this.receiveError((Exception)iOException, 0);
            return null;
        }
        return xPNBuilder.getRoot();
    }

    private XSLTStylesheet readXSLStylesheet(URILocation uRILocation, XSLPIHandler xSLPIHandler) {
        if (uRILocation == null && xSLPIHandler != null) {
            try {
                uRILocation = this._uriResolver.resolve(xSLPIHandler.getStylesheetHref(), xSLPIHandler.getDocumentBase());
            }
            catch (URIException uRIException) {
                this.receiveError(uRIException);
                this.receiveError("continuing processing with default rules", 2);
                return new XSLTStylesheet();
            }
        }
        if (uRILocation == null) {
            String string = "No stylesheet specified. Use `-s' option onthe command line, or `xml-stylesheet' PI in the XML document";
            this.receiveError(string);
            this.receiveError("continuing processing with default rules", 2);
            return new XSLTStylesheet();
        }
        XSLTStylesheet xSLTStylesheet = null;
        XSLTReader xSLTReader = new XSLTReader(this._uriResolver);
        xSLTReader.addErrorObserver(this);
        try {
            xSLTStylesheet = xSLTReader.read(uRILocation);
        }
        catch (Exception exception) {
            this.receiveError(exception);
        }
        if (xSLTStylesheet == null) {
            this.receiveError("Unable to resolve stylesheet: " + uRILocation);
            this.receiveError("continuing processing with default rules", 2);
            xSLTStylesheet = new XSLTStylesheet();
        }
        return xSLTStylesheet;
    }

    private XSLTStylesheet readXSLStylesheet(Document document, String string) {
        XSLTStylesheet xSLTStylesheet = null;
        if (document != null) {
            XSLTReader xSLTReader = new XSLTReader();
            xSLTReader.addErrorObserver(this);
            try {
                xSLTStylesheet = xSLTReader.read(document, string);
            }
            catch (XSLException xSLException) {
                this.receiveError(xSLException);
                this.receiveError("continuing processing with default rules", 2);
                xSLTStylesheet = new XSLTStylesheet();
            }
        } else {
            xSLTStylesheet = new XSLTStylesheet();
        }
        return xSLTStylesheet;
    }

    public void receiveMessage(String string) {
        int n = 0;
        while (n < this.msgObservers.size()) {
            ((MessageObserver)this.msgObservers.get(n)).receiveMessage(string);
            ++n;
        }
    }

    public void removeAllParameters() {
        ((Hashtable)this.params).clear();
    }

    public void removeFunctionResolver(FunctionResolver functionResolver) {
        this.fnResolvers.remove(functionResolver);
    }

    public MessageObserver removeMessageObserver(MessageObserver messageObserver) {
        if (this.msgObservers.remove(messageObserver)) {
            return messageObserver;
        }
        return null;
    }

    public void removeParameter(String string) {
        if (string == null) {
            return;
        }
        ((Hashtable)this.params).remove(string);
    }

    public void setDOMParser(DOMParser dOMParser) {
        Configuration.setDOMParser(dOMParser);
    }

    public void setDocumentBase(String string) {
        this.documentBase = string;
    }

    public void setParameter(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        if (string.length() > 0) {
            ((Hashtable)this.params).put(string, string2);
        }
    }

    public void setProperty(String string, String string2) {
        Configuration.setProperty(string, string2);
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this._uriResolver = uRIResolver != null ? uRIResolver : new URIResolverImpl();
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
        DOMParser dOMParser = Configuration.getDOMParser();
        if (dOMParser != null) {
            dOMParser.setValidation(bl);
        }
    }
}

