/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xslt;

import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathNode;
import org.exolab.adaptx.xpath.functions.ErrorFunctionCall;
import org.exolab.adaptx.xslt.Pattern;
import org.exolab.adaptx.xslt.PatternException;
import org.exolab.adaptx.xslt.ProcessorState;
import org.exolab.adaptx.xslt.XSLException;
import org.exolab.adaptx.xslt.XSLObject;
import org.mitre.tjt.xsl.XslNumberFormat;

public class XSLNumber
extends XSLObject {
    private XPathExpression expr = null;
    private Pattern count = null;
    private Pattern from = null;
    private String level = "single";

    public XSLNumber() {
        super((short)23);
    }

    private static int countPreceedingSiblings(Pattern pattern, XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        if (xPathNode == null) {
            return 0;
        }
        int n = 1;
        XPathNode xPathNode2 = xPathNode.getPrevious();
        while (xPathNode2 != null) {
            if (xPathNode2.getNodeType() == 1 && pattern.matches(xPathNode2, xPathContext)) {
                ++n;
            }
            xPathNode2 = xPathNode2.getPrevious();
        }
        return n;
    }

    public int[] doNumbering(XPathNode xPathNode, ProcessorState processorState) throws XPathException {
        if (xPathNode.getNodeType() != 1) {
            String string = "XPathNode must be of type XPathNode.ELEMENT";
            throw new IllegalArgumentException(string);
        }
        int[] nArray = null;
        if (this.expr != null) {
            nArray = new int[1];
            XPathContext xPathContext = processorState.newContext(xPathNode);
            double d = this.expr.evaluate(xPathContext).numberValue();
            nArray[0] = (int)d;
            return nArray;
        }
        if (xPathNode == null) {
            return new int[0];
        }
        Pattern pattern = this.count;
        if (pattern == null) {
            try {
                pattern = new Pattern(xPathNode.getLocalName());
            }
            catch (PatternException patternException) {
                throw new XPathException(patternException);
            }
        }
        if ("multiple".equals(this.level)) {
            NodeSet nodeSet = this.getAncestorsOrSelf(pattern, xPathNode, processorState, false);
            nArray = new int[nodeSet.size()];
            int n = 0;
            int n2 = nodeSet.size() - 1;
            while (n2 >= 0) {
                nArray[n++] = XSLNumber.countPreceedingSiblings(pattern, nodeSet.item(n2), processorState);
                --n2;
            }
        } else if ("any".equals(this.level)) {
            NodeSet nodeSet = this.getAnyPreviousNodes(pattern, xPathNode, processorState);
            nArray = new int[]{nodeSet.size()};
        } else {
            NodeSet nodeSet = this.getAncestorsOrSelf(pattern, xPathNode, processorState, true);
            nArray = new int[nodeSet.size()];
            if (nodeSet.size() > 0) {
                nArray[0] = XSLNumber.countPreceedingSiblings(pattern, nodeSet.item(0), processorState);
            }
        }
        return nArray;
    }

    private NodeSet getAncestorsOrSelf(Pattern pattern, XPathNode xPathNode, XPathContext xPathContext, boolean bl) throws XPathException {
        NodeSet nodeSet = new NodeSet();
        XPathNode xPathNode2 = xPathNode;
        while (xPathNode2 != null && xPathNode2.getNodeType() == 1) {
            if (this.from != null && this.from.matches(xPathNode2, xPathContext)) break;
            if (pattern.matches(xPathNode2, xPathContext)) {
                nodeSet.add(xPathNode2);
                if (bl) break;
            }
            xPathNode2 = xPathNode2.getParentNode();
        }
        return nodeSet;
    }

    private NodeSet getAnyPreviousNodes(Pattern pattern, XPathNode xPathNode, XPathContext xPathContext) throws XPathException {
        NodeSet nodeSet = new NodeSet();
        if (xPathNode.getNodeType() != 1) {
            return nodeSet;
        }
        XPathNode xPathNode2 = xPathNode;
        while (xPathNode2 != null) {
            if (this.from != null && this.from.matches(xPathNode2, xPathContext)) {
                return nodeSet;
            }
            if (pattern.matches(xPathNode2, xPathContext)) {
                nodeSet.add(xPathNode2);
            }
            XPathNode xPathNode3 = xPathNode2;
            while ((xPathNode3 = xPathNode3.getPrevious()) != null) {
                if (xPathNode3.getNodeType() == 1) break;
            }
            if (xPathNode3 == null) {
                XPathNode xPathNode4 = xPathNode2.getParentNode();
                if (xPathNode4.getNodeType() != 1) break;
                xPathNode2 = xPathNode4;
                continue;
            }
            xPathNode2 = xPathNode3;
        }
        return nodeSet;
    }

    public String getFormattedNumber(XPathNode xPathNode, ProcessorState processorState) {
        try {
            int[] nArray = this.doNumbering(xPathNode, processorState);
            String string = this.getAttribute("format");
            if (string == null) {
                string = "1";
            }
            return XslNumberFormat.format(nArray, string);
        }
        catch (XPathException xPathException) {
            return "";
        }
    }

    public void setAttribute(String string, String string2) throws XSLException {
        ErrorFunctionCall errorFunctionCall = null;
        if ("value".equals(string)) {
            if (string2 == null) {
                this.expr = null;
            } else {
                try {
                    this.expr = this.createExpression(string2);
                }
                catch (XPathException xPathException) {
                    errorFunctionCall = new ErrorFunctionCall();
                    errorFunctionCall.setError("invalid 'value' attribute of xsl:number" + xPathException.getMessage());
                    this.expr = errorFunctionCall;
                }
            }
        } else if ("count".equals(string)) {
            if (string2 == null) {
                this.count = null;
            } else {
                try {
                    this.count = new Pattern(string2);
                }
                catch (PatternException patternException) {
                    errorFunctionCall = new ErrorFunctionCall();
                    errorFunctionCall.setError("invalid 'count' attribute of xsl:number" + patternException.getMessage());
                    this.expr = errorFunctionCall;
                }
            }
        } else if ("from".equals(string)) {
            if (string2 == null) {
                this.from = null;
            } else {
                try {
                    this.from = new Pattern(string2);
                }
                catch (PatternException patternException) {
                    errorFunctionCall = new ErrorFunctionCall();
                    errorFunctionCall.setError("invalid 'from' attribute of xsl:number" + patternException.getMessage());
                    this.expr = errorFunctionCall;
                }
            }
        } else if ("level".equals(string)) {
            this.level = string2;
        }
        super.setAttribute(string, string2);
    }

    public void setCountAttr(String string) {
        try {
            this.setAttribute("count", string);
        }
        catch (XSLException xSLException) {}
    }

    public void setFormatAttr(String string) {
        try {
            this.setAttribute("format", string);
        }
        catch (XSLException xSLException) {}
    }

    public void setFromAttr(String string) {
        try {
            this.setAttribute("from", string);
        }
        catch (XSLException xSLException) {}
    }

    public void setLevel(String string) {
        try {
            this.setAttribute("level", string);
        }
        catch (XSLException xSLException) {}
    }
}

