/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.functions;

import org.exolab.adaptx.xpath.NumberResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathResult;
import org.exolab.adaptx.xpath.engine.FunctionCall;

public class NumberFunctionCall
extends FunctionCall {
    public static final short NUMBER = 0;
    public static final short ROUND = 1;
    public static final short FLOOR = 2;
    public static final short CEILING = 3;
    short functionType = 0;

    public NumberFunctionCall() {
        super("number");
    }

    public NumberFunctionCall(short s) {
        super(NumberFunctionCall.getFunctionName(s));
        this.functionType = s;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.getParameterCount() != 1) {
            throw new XPathException("invalid number of parameters for function: " + this);
        }
        double d = this.getParameter(0).evaluate(xPathContext).numberValue();
        switch (this.functionType) {
            case 2: {
                d = Math.floor(d);
                break;
            }
            case 1: {
                if (Double.isNaN(d)) {
                    return NumberResult.NaN;
                }
                if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) break;
                d = Math.round(d);
                break;
            }
            case 3: {
                d = Math.ceil(d);
                break;
            }
        }
        return new NumberResult(d);
    }

    private static String getFunctionName(short s) {
        switch (s) {
            case 2: {
                return "floor";
            }
            case 1: {
                return "round";
            }
            case 3: {
                return "ceiling";
            }
        }
        return "number";
    }
}

