/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.engine.PrimaryExpr;

public abstract class FunctionCall
extends PrimaryExpr {
    public static final String INVALID_NUMBER_PARAMS = "invalid number of parameters for function: ";
    public static final String INVALID_RESULT = "unexpected result for function: ";
    private static String START_PARAMLIST = "(";
    private static String END_PARAMLIST = ")";
    private static String EMPTY_PARAMLIST = "()";
    private static String PARAMETER_SEP = ",";
    private int DefaultSize = 3;
    private XPathExpression[] params;
    private int count = 0;
    String name = "undefined";

    public FunctionCall(String string) {
        super((short)4);
        this.name = string;
    }

    public final void addParameter(XPathExpression xPathExpression) throws XPathException {
        if (xPathExpression == null) {
            throw new XPathException("Cannot add empty parameter");
        }
        if (this.params == null) {
            this.params = new XPathExpression[this.DefaultSize];
        } else if (this.count == this.params.length) {
            XPathExpression[] xPathExpressionArray = new XPathExpression[this.count + this.DefaultSize];
            int n = 0;
            while (n < this.count) {
                xPathExpressionArray[n] = this.params[n];
                ++n;
            }
            this.params = xPathExpressionArray;
        }
        this.params[this.count++] = xPathExpression;
    }

    public String getFunctionName() {
        return this.name;
    }

    public final XPathExpression getParameter(int n) throws IndexOutOfBoundsException {
        if (this.params == null) {
            throw new IndexOutOfBoundsException();
        }
        if (n < 0 || n >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.params[n];
    }

    public final int getParameterCount() {
        return this.count;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getFunctionName());
        stringBuffer.append(START_PARAMLIST);
        int n = 0;
        while (n < this.getParameterCount()) {
            if (n > 0) {
                stringBuffer.append(PARAMETER_SEP);
            }
            stringBuffer.append(this.getParameter(n));
            ++n;
        }
        stringBuffer.append(END_PARAMLIST);
        return stringBuffer.toString();
    }
}

