/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.BooleanResult;
import org.exolab.adaptx.xpath.NodeSet;
import org.exolab.adaptx.xpath.StringResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;

class EqualityExpr
extends XPathExpression {
    public static final short EQUAL = 0;
    public static final short LESS_THAN = 1;
    public static final short GREATER_THAN = 2;
    public static final short LT_OR_EQUAL = 3;
    public static final short GT_OR_EQUAL = 4;
    public static final short NOT_EQUAL = 5;
    private XPathExpression leftExpr = null;
    private XPathExpression rightExpr = null;
    private short op = 0;
    private static String[] ops = new String[]{"=", "<", ">", "<=", ">=", "!="};

    public EqualityExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2) throws XPathException {
        this(xPathExpression, xPathExpression2, 0);
    }

    public EqualityExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2, short s) throws XPathException {
        if (xPathExpression == null) {
            throw new XPathException("Argument leftExpr is null");
        }
        if (xPathExpression2 == null) {
            throw new XPathException("Argument rightExpr is null");
        }
        this.leftExpr = xPathExpression;
        this.rightExpr = xPathExpression2;
        if (s < 0 || s >= ops.length) {
            throw new XPathException("invalid operator for relational expression");
        }
        this.op = s;
    }

    private boolean compare(XPathResult xPathResult, XPathResult xPathResult2) {
        int n = xPathResult.getResultType();
        int n2 = xPathResult2.getResultType();
        boolean bl = false;
        boolean bl2 = false;
        switch (this.op) {
            case 5: {
                bl2 = true;
            }
            case 0: {
                bl = n != n2 ? (n == 0 || n2 == 0 ? xPathResult2.booleanValue() == xPathResult.booleanValue() : (n == 1 || n2 == 1 ? xPathResult2.numberValue() == xPathResult.numberValue() : xPathResult2.stringValue().equals(xPathResult.stringValue()))) : (n == 3 ? xPathResult2.stringValue().equals(xPathResult.stringValue()) : xPathResult.equals(xPathResult2));
                if (!bl2) break;
                bl ^= true;
                break;
            }
            case 1: {
                bl = xPathResult.numberValue() < xPathResult2.numberValue();
                break;
            }
            case 2: {
                bl = xPathResult.numberValue() > xPathResult2.numberValue();
                break;
            }
            case 3: {
                bl = xPathResult.numberValue() <= xPathResult2.numberValue();
                break;
            }
            case 4: {
                bl = xPathResult.numberValue() >= xPathResult2.numberValue();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.leftExpr == null || this.rightExpr == null) {
            return BooleanResult.FALSE;
        }
        XPathResult xPathResult = this.leftExpr.evaluate(xPathContext);
        XPathResult xPathResult2 = this.rightExpr.evaluate(xPathContext);
        int n = xPathResult.getResultType();
        int n2 = xPathResult2.getResultType();
        if (n == 3) {
            NodeSet nodeSet = (NodeSet)xPathResult;
            if (n2 == n) {
                NodeSet nodeSet2 = (NodeSet)xPathResult2;
                int n3 = 0;
                while (n3 < nodeSet.size()) {
                    xPathResult = new StringResult(nodeSet.item(n3).getStringValue());
                    int n4 = 0;
                    while (n4 < nodeSet2.size()) {
                        xPathResult2 = new StringResult(nodeSet2.item(n4).getStringValue());
                        if (this.compare(xPathResult, xPathResult2)) {
                            return BooleanResult.TRUE;
                        }
                        ++n4;
                    }
                    ++n3;
                }
            } else if (n2 != 0) {
                int n5 = 0;
                while (n5 < nodeSet.size()) {
                    xPathResult = new StringResult(nodeSet.item(n5).getStringValue());
                    if (this.compare(xPathResult, xPathResult2)) {
                        return BooleanResult.TRUE;
                    }
                    ++n5;
                }
            }
            return BooleanResult.FALSE;
        }
        if (n2 == 3 && n != 0) {
            NodeSet nodeSet = (NodeSet)xPathResult2;
            int n6 = 0;
            while (n6 < nodeSet.size()) {
                xPathResult2 = new StringResult(nodeSet.item(n6).getStringValue());
                if (this.compare(xPathResult, xPathResult2)) {
                    return BooleanResult.TRUE;
                }
                ++n6;
            }
            return BooleanResult.FALSE;
        }
        return BooleanResult.from(this.compare(xPathResult, xPathResult2));
    }

    public short getExprType() {
        return 0;
    }

    public static boolean isRelationalOperator(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < ops.length) {
            if (ops[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.leftExpr != null) {
            stringBuffer.append(this.leftExpr.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(" ");
        stringBuffer.append(ops[this.op]);
        stringBuffer.append(" ");
        if (this.rightExpr != null) {
            stringBuffer.append(this.rightExpr.toString());
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

