/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.adaptx.xpath.engine;

import org.exolab.adaptx.xpath.BooleanResult;
import org.exolab.adaptx.xpath.XPathContext;
import org.exolab.adaptx.xpath.XPathException;
import org.exolab.adaptx.xpath.XPathExpression;
import org.exolab.adaptx.xpath.XPathResult;

class AndExpr
extends XPathExpression {
    private static String AND = " and ";
    private static String NULL = "null";
    private XPathExpression leftExpr = null;
    private XPathExpression rightExpr = null;

    public AndExpr(XPathExpression xPathExpression, XPathExpression xPathExpression2) {
        if (xPathExpression == null) {
            throw new IllegalArgumentException("Argument leftExpr is null");
        }
        if (xPathExpression2 == null) {
            throw new IllegalArgumentException("Argument rightExpr is null");
        }
        this.leftExpr = xPathExpression;
        this.rightExpr = xPathExpression2;
    }

    public XPathResult evaluate(XPathContext xPathContext) throws XPathException {
        if (this.leftExpr == null || this.rightExpr == null) {
            return BooleanResult.FALSE;
        }
        if (!this.leftExpr.evaluate(xPathContext).booleanValue()) {
            return BooleanResult.FALSE;
        }
        return BooleanResult.from(this.rightExpr.evaluate(xPathContext));
    }

    public short getExprType() {
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.leftExpr != null) {
            stringBuffer.append(this.leftExpr.toString());
        } else {
            stringBuffer.append(NULL);
        }
        stringBuffer.append(AND);
        if (this.rightExpr != null) {
            stringBuffer.append(this.rightExpr.toString());
        } else {
            stringBuffer.append(NULL);
        }
        return stringBuffer.toString();
    }
}

