/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DateTimeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.SchemaDateTimeException;

public class MonthDatatypeValidator
extends DateTimeValidator {
    public MonthDatatypeValidator() throws InvalidDatatypeFacetException {
    }

    public MonthDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }

    protected short compareDates(int[] nArray, int[] nArray2) {
        if (nArray[7] == nArray2[7]) {
            return (short)(nArray[1] >= nArray2[1] ? (nArray[1] > nArray2[1] ? -1 : 0) : 1);
        }
        if (nArray[7] == 90 || nArray2[7] == 90) {
            if (nArray[1] == nArray2[1]) {
                return 2;
            }
            if (nArray[1] + 1 == nArray2[1] || nArray[1] - 1 == nArray2[1]) {
                return 2;
            }
        }
        if (nArray[1] < nArray2[1]) {
            return -1;
        }
        return 1;
    }

    protected String dateToString(int[] nArray) {
        this.message.setLength(0);
        this.message.append('-');
        this.message.append('-');
        this.message.append(nArray[1]);
        this.message.append('-');
        this.message.append('-');
        this.message.append((char)nArray[7]);
        return this.message.toString();
    }

    protected int[] parse(String string, int[] nArray) throws SchemaDateTimeException {
        this.resetBuffer(string);
        if (nArray == null) {
            nArray = new int[8];
        }
        this.resetDateObj(nArray);
        nArray[0] = 2000;
        nArray[2] = 15;
        nArray[1] = this.parseInt(this.fStart + 2, this.fStart + 4);
        if (this.fEnd > 6) {
            int n = this.findUTCSign(6, this.fEnd);
            if (n < 0) {
                throw new SchemaDateTimeException("Error in month parsing");
            }
            this.getTimeZone(nArray, n);
        }
        if (!this.validateDateTime(nArray)) {
            throw new SchemaDateTimeException();
        }
        if (nArray[7] != 0 && nArray[7] != 90) {
            this.normalize(nArray);
        }
        return nArray;
    }
}

