/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.validators.datatype.AbstractNumericValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class FloatDatatypeValidator
extends AbstractNumericValidator {
    public FloatDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public FloatDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        super(datatypeValidator, hashtable, bl);
    }

    protected void assignAdditionalFacets(String string, Hashtable hashtable) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(this.getErrorString(DatatypeMessageProvider.ILLEGAL_FLOAT_FACET, 0, new Object[]{string}));
    }

    protected void checkContent(String string, Object object, Vector vector, boolean bl) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((FloatDatatypeValidator)this.fBaseValidator).checkContent(string, object, vector, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
        }
        if (bl) {
            return;
        }
        Float f = null;
        try {
            f = FloatDatatypeValidator.fValueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_FLOAT, 0, new Object[]{string}));
        }
        if (vector != null) {
            int n = vector.size();
            Float[] floatArray = new Float[n];
            int n2 = 0;
            try {
                while (n2 < n) {
                    floatArray[n2] = FloatDatatypeValidator.fValueOf((String)vector.elementAt(n2));
                    ++n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.INVALID_ENUM_VALUE, 0, new Object[]{vector.elementAt(n2)}));
            }
            this.enumCheck(f.floatValue(), floatArray);
        }
        this.boundsCheck(f);
        if ((this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
            this.enumCheck(f.floatValue(), (Float[])this.fEnumeration);
        }
    }

    public int compare(String string, String string2) {
        try {
            float f = FloatDatatypeValidator.fValueOf(string).floatValue();
            float f2 = FloatDatatypeValidator.fValueOf(string2).floatValue();
            return this.compareFloats(f, f2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private int compareFloats(float f, float f2) {
        int n = Float.floatToIntBits(f);
        int n2 = Float.floatToIntBits(f2);
        if (f > f2) {
            return 1;
        }
        if (f < f2) {
            return -1;
        }
        if (n == n2) {
            return 0;
        }
        return n < n2 ? -1 : 1;
    }

    protected int compareValues(Object object, Object object2) {
        float f = ((Float)object).floatValue();
        float f2 = ((Float)object2).floatValue();
        return this.compareFloats(f, f2);
    }

    private void enumCheck(float f, Float[] floatArray) throws InvalidDatatypeValueException {
        int n = 0;
        while (n < floatArray.length) {
            if (f == floatArray[n].floatValue()) {
                return;
            }
            ++n;
        }
        throw new InvalidDatatypeValueException(this.getErrorString(DatatypeMessageProvider.NOT_ENUM_VALUE, 0, new Object[]{new Float(f)}));
    }

    private static Float fValueOf(String string) throws NumberFormatException {
        Float f = null;
        try {
            f = Float.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF")) {
                f = new Float(Float.POSITIVE_INFINITY);
            }
            if (string.equals("-INF")) {
                f = new Float(Float.NEGATIVE_INFINITY);
            }
            if (string.equals("NaN")) {
                f = new Float(Float.NaN);
            }
            throw numberFormatException;
        }
        return f;
    }

    protected int getInvalidFacetMsg() {
        return DatatypeMessageProvider.ILLEGAL_FLOAT_FACET;
    }

    protected String getMaxExclusive(boolean bl) {
        return bl ? ((FloatDatatypeValidator)this.fBaseValidator).fMaxExclusive.toString() : ((Float)this.fMaxExclusive).toString();
    }

    protected String getMaxInclusive(boolean bl) {
        return bl ? ((FloatDatatypeValidator)this.fBaseValidator).fMaxInclusive.toString() : ((Float)this.fMaxInclusive).toString();
    }

    protected String getMinExclusive(boolean bl) {
        return bl ? ((FloatDatatypeValidator)this.fBaseValidator).fMinExclusive.toString() : ((Float)this.fMinExclusive).toString();
    }

    protected String getMinInclusive(boolean bl) {
        return bl ? ((FloatDatatypeValidator)this.fBaseValidator).fMinInclusive.toString() : ((Float)this.fMinInclusive).toString();
    }

    protected void setEnumeration(Vector vector) throws InvalidDatatypeValueException {
        if (vector != null) {
            this.fEnumeration = new Float[vector.size()];
            Object var2_2 = null;
            int n = 0;
            while (n < vector.size()) {
                this.fEnumeration[n] = FloatDatatypeValidator.fValueOf((String)vector.elementAt(n));
                ((FloatDatatypeValidator)this.fBaseValidator).validate((String)vector.elementAt(n), null);
                ++n;
            }
        }
    }

    protected void setMaxExclusive(String string) {
        this.fMaxExclusive = FloatDatatypeValidator.fValueOf(string);
    }

    protected void setMaxInclusive(String string) {
        this.fMaxInclusive = FloatDatatypeValidator.fValueOf(string);
    }

    protected void setMinExclusive(String string) {
        this.fMinExclusive = FloatDatatypeValidator.fValueOf(string);
    }

    protected void setMinInclusive(String string) {
        this.fMinInclusive = FloatDatatypeValidator.fValueOf(string);
    }
}

