/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

//Own
#include "viewfiles.h"

//KGRUBEditor
#include "core/fileio.h"

ViewFiles::ViewFiles( const QString &menulst, const QString &devicemap, QWidget *parent ) : KDialog( parent )
{
//SETUP UI
	QWidget *widget = new QWidget( this );
	setupUi( widget );
	setMainWidget( widget );

	setWindowIcon( KIcon( "view-list-text" ) );
	setCaption( i18nc( "@title:window", "View Files" ) );
	setAttribute( Qt::WA_DeleteOnClose );
	setInitialSize( QSize( 600, 400 ) );
	setButtons( Close );
//SHOW FILES
	tabWidget->setTabText( 0, menulst );
	ktextedit_menulst->setPlainText( Core::FileIO::view( KUrl( menulst ), this ) );
	tabWidget->setTabText( 1, devicemap );
	ktextedit_devicemap->setPlainText( Core::FileIO::view( KUrl( devicemap ), this ) );

}

#include "viewfiles.moc"
