 /***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

#ifndef QUICKEDITOR_H
#define QUICKEDITOR_H

//KDE
#include <kdialog.h>
class KMenu;

//Ui
#include "ui_quickeditor.h"

//KGRUBEditor
#include "core/datatypes.h"

/**
 * @brief KDialog for quick-editing some entry attributes (not all).
 *
 * Allows to edit the most common entry attributes such as title, root
 * initrd, chainloader, makeactive, savedefault and lock.
 */
class QuickEditor : public KDialog, private Ui::QuickEditor
{
Q_OBJECT
public:
	/**
	* Sets up the GUI and shows the entry.
	*
	* @param entry The entry to edit.
	* @param parent QWidget parent. Self explanatory.
	*/
	QuickEditor( GRUB::ConfigFile::Entry *entry, QWidget *parent = 0 );
	/**
	* Desctructor.
	*/
	~QuickEditor();
private:
	/**
	* Connects all signals to their slots.
	*/
	void setupConnections();
private slots:
	/**
	* Checks whether klineedit_title is empty
	* and if not, it allows the user to procede.
	*/
	void checkTitle( const QString &text );
	/**
	* A suggestion was chosen from the drop-down list
	* of the kpushbutton_suggestions.
	*
	* Fills-in the klineedit_root with the appropriate
	* root device (using standard GRUB device naming).
	*/
	void rootSuggestionTriggered( QAction *action );
	/**
	* Triggered when OK is clicked in order to save all
	* changes done to the original entry.
	*/
	void okClicked();
private:
	KMenu *menu_rootSuggestions;

	GRUB::ConfigFile::Entry *m_entry;
};

#endif
