/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

//Own
#include "map.h"

//KGRUBEditor
#include "core/path.h"

MapAssistant::MapAssistant( GRUB::ComplexCommand::Map *map, QWidget *parent ) : KAssistantDialog( parent )
{
//SETUP UI
	setWindowIcon( KIcon( "drive-harddisk" ) );
	setCaption( i18nc( "@window:title", "Map Assistant" ) );
	setAttribute( Qt::WA_DeleteOnClose );
	showButton( KDialog::Help, false );

	QWidget *intro = new QWidget( this );
	ui_intro.setupUi( intro );
	addPage( intro, i18nc( "@title", "Introduction" ) );
	QWidget *step1 = new QWidget( this );
	ui_step1.setupUi( step1 );
	addPage( step1, i18nc( "@title", "Step 1/2 - From Drive" ) );
	QWidget *step2 = new QWidget( this );
	ui_step2.setupUi( step2 );
	addPage( step2, i18nc( "@title", "Step 2/2 - To Drive" ) );
	QWidget *summary = new QWidget( this );
	ui_summary.setupUi( summary );
	summaryPage = addPage( summary, i18nc( "@title", "Summary" ) );

	foreach( const GRUB::Misc::Device device, Core::Devices::DeviceList )
	{
		if ( !alreadyExists( device.grubDevice() ) )
		{
			ui_step1.comboBox_fromDrive->addItem( device.grubDevice() );
			ui_step2.comboBox_toDrive->addItem( device.grubDevice() );
		}
	}
//ATTRIBUTE SETUP
	m_map = map;
//SHOW MAP
	if ( !map->isEmpty() )
	{
		for ( int i = 0; i < ui_step1.comboBox_fromDrive->count(); i++ )
		{
			if ( ui_step1.comboBox_fromDrive->itemText( i ) == map->fromDrive() )
			{
				ui_step1.comboBox_fromDrive->setCurrentIndex( i );
				break;
			}
		}
		for ( int i = 0; i < ui_step2.comboBox_toDrive->count(); i++ )
		{
			if ( ui_step2.comboBox_toDrive->itemText( i ) == map->toDrive() )
			{
				ui_step2.comboBox_toDrive->setCurrentIndex( i );
				break;
			}
		}
	}
//SETUP CONNECTIONS
	setupConnections();
}
MapAssistant::~MapAssistant()
{
	m_map = 0;
}

void MapAssistant::setupConnections()
{
	connect( this, SIGNAL( user2Clicked() ), SLOT( nextClicked() ) );
	connect( this, SIGNAL( user1Clicked() ), SLOT( finishClicked() ) );
}

bool MapAssistant::alreadyExists( const QString &device )
{
	for ( int i = 0; i < ui_step1.comboBox_fromDrive->count(); i++ )
		if ( ui_step1.comboBox_fromDrive->itemText( i ) == device )
			return true;
	return false;
}

void MapAssistant::nextClicked()
{
	if ( currentPage() == summaryPage )
	{
		GRUB::ComplexCommand::Map tmp_map( ui_step2.comboBox_toDrive->currentText(), ui_step1.comboBox_fromDrive->currentText() );
		ui_summary.label_map->setText( "<b>" + tmp_map.result() + "</b>" );
	}
}
void MapAssistant::finishClicked()
{
	m_map->setFromDrive( ui_step1.comboBox_fromDrive->currentText() );
	m_map->setToDrive( ui_step2.comboBox_toDrive->currentText() );
}

#include "map.moc"
