/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

#ifndef SPLASH_PREVIEW_JOB_H
#define SPLASH_PREVIEW_JOB_H

//Qt
#include <qimage.h>

//KDE
#include <threadweaver/Job.h>

/**
 * @short Splash Preview Job
 *
 * Decompresses a GRUB splash image and returns its contents.
 */
class SplashPreviewJob : public ThreadWeaver::Job
{
Q_OBJECT
public:
	/**
	* Constructor.
	*/
	SplashPreviewJob( const QString &splashImagePath, QObject *parent = 0 );

	/**
	* @return If the job was successfully completed, it returns
	* a real-size QImage of the splash image.
	* Otherwise returns a null QImage.
	*/
	QImage splashImage() const;
	/**
	* @return If the job was successfully completed, it returns
	* a 64x48 QImage thumbnail of the splash image.
	* Otherwise returns a null QImage.
	*/
	QImage splashImageThumb() const;
	/**
	* @return Returns the splash image's absolute file path.
	*/
	QString absoluteFilePath() const;
protected:
	/**
	* This is where all the job is done.
	*/
	void run();
private:
	QImage m_splashImage;
	const QString m_splashImagePath;
};

#endif
