/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

#ifndef ROOT_H
#define ROOT_H

//Qt
#include <qstring.h>
class QWidget;

namespace Core
{
	namespace Root
	{
		extern QString Password;

		/**
		* Pops up a dialog asking for the root password in order to be able
		* to operate with root previliges.
		*
		* @param parent Needed so that the password doesn't popup in the middle
		*               of...nowhere. It needs to be centred over the parent.
		*
		* @return whether the password was successfully acquired or not.
		*/
		bool requestPassword( QWidget *parent );

		/**
		* Makes the folder specified, readable by the user's group.
		* You may also specify whether or not subfiles will be made
		* readable too.
		*
		* @param path The folder to make readable. Only folders 
		*             should be specified.
		* @param filter The filter which will be used to specify
		*               which subfiles will be made readable.
		*               If no filter is passed (default) then no
		*               subfile's permissions change.
		*               Example for splashimages: *.xpm.gz
		*
		* @return If no folder is specified or the folder doesn't exist
		*         or the procedure failed it returns false.
		*         It returns true on success.
		*/
		bool makeReadableByUserGroup( const QString &folderPath, const QString &filter = QString(), QWidget *parent = 0 );
		/**
		* Makes the folder specified writable by the user's group.
		* Only folders should be specified.
		*
		* @param path The folder to make writable.
		*
		* @return If no folder is specified or the folder doesn't exist
		*         or the procedure failed it returns false.
		*         It returns true on success.
		*/
		bool makeWritableByUserGroup( const QString &folderPath, QWidget *parent );
	}
}

#endif
