/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with parent program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

//Own
#include "root.h"

//Qt
#include <qwidget.h>
#include <qfileinfo.h>

//KDE
#include <kprocess.h>

//Ui
#include "../passworddialog.h"

QString Core::Root::Password;

namespace Core
{
	namespace Root
	{
		bool requestPassword( QWidget *parent )
		{
			if ( Password.isEmpty() || KDESu::SuProcess( "root" ).checkInstall( Password.toLocal8Bit() ) != 0 )
			{
				PasswordDialog dlg( parent );
				if ( !dlg.exec() )
					return false;

				Password = dlg.password().toLocal8Bit();
			}
			return true;
		}


		bool makeReadableByUserGroup( const QString &folderPath, const QString &filter, QWidget *parent )
		{
			const QFileInfo fi( folderPath );
			if ( !fi.exists() || !fi.isDir() )
				return false;

			KProcess groups( parent );
			groups.setProgram( "groups" );
			groups.setOutputChannelMode( KProcess::MergedChannels );
			groups.start();
			groups.waitForFinished();

			QString userGroup( groups.readAllStandardOutput().split( ' ' ).first() );
			if ( userGroup.isEmpty() )
				return false;

			if ( requestPassword( parent ) )
			{
				KDESu::SuProcess chgrp( QByteArray( "root" ), QByteArray( "chgrp -hR " ).append( userGroup ).append( " " ).append( folderPath ) );
				chgrp.exec( Password.toLocal8Bit() );
			}
			else
				return false;

			if ( !fi.isReadable() || !fi.isExecutable() )
			{
				if ( requestPassword( parent ) )
				{
					KDESu::SuProcess chmod( QByteArray( "root" ), QByteArray( "chmod g+rx " ).append( folderPath ) );
					chmod.exec( Password.toLocal8Bit() );
				}
				else
					return false;
			}

			if ( !filter.isEmpty() )
			{
				if ( requestPassword( parent ) )
				{
					KDESu::SuProcess chmod( QByteArray( "root" ), QByteArray( "chmod g+r " ).append( folderPath ).append( "/" ).append( filter ) );
					chmod.exec( Password.toLocal8Bit() );
				}
				else
					return false;
			}

			return true;
		}
		bool makeWritableByUserGroup( const QString &folderPath, QWidget *parent )
		{
			const QFileInfo fi( folderPath );
			if ( !fi.exists() || !fi.isDir() )
				return false;

			KProcess groups( parent );
			groups.setProgram( "groups" );
			groups.setOutputChannelMode( KProcess::MergedChannels );
			groups.start();
			groups.waitForFinished();

			QString userGroup( groups.readAllStandardOutput().split( ' ' ).first() );
			if ( userGroup.isEmpty() )
				return false;

			if ( requestPassword( parent ) )
			{
				KDESu::SuProcess chgrp( QByteArray( "root" ), QByteArray( "chgrp -hR " ).append( userGroup ).append( " " ).append( folderPath ) );
				chgrp.exec( Password.toLocal8Bit() );
			}
			else
				return false;

			if ( !fi.isWritable() )
			{
				if ( requestPassword( parent ) )
				{
					KDESu::SuProcess chmod( QByteArray( "root" ), QByteArray( "chmod g+w " ).append( folderPath ) );
					chmod.exec( Password.toLocal8Bit() );
				}
				else
					return false;
			}

			return true;
		}
	}
}
