/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

#include "path.h"

//KDE
#include <kmountpoint.h>

QVector<GRUB::Misc::Device> Core::Devices::DeviceList;

namespace Core
{
	namespace Path
	{
		QString convertToGRUBPath( const QString path, const QVector<GRUB::Misc::Device> &devices )
		{
			if ( path.isEmpty() )
				return QString();

			if ( KMountPoint::Ptr mp = KMountPoint::currentMountPoints().findByPath( path ) )
			{
				foreach( const GRUB::Misc::Device device, devices )
				{
					if ( mp->mountPoint() == device.mountPoint() )
					{
						if ( mp->mountPoint() == "/" ) //Unix-specific check
							return QString( path ).prepend( device.grubPartition() );
						else
							return QString( path ).replace( mp->mountPoint(), device.grubPartition() );
					}
				}
			}
			return path;
		}
		QString convertToGenericPath( const QString path, const QVector<GRUB::Misc::Device> &devices )
		{
			if ( path.isEmpty() )
				return QString();

			foreach( const GRUB::Misc::Device device, devices )
			{
				if ( path.startsWith( device.grubPartition() ) )
				{
					if ( device.mountPoint() == "/" ) //Unix-specific check
						return QString( path ).remove( device.grubPartition() );
					else
						return QString( path ).replace( device.grubPartition(), device.mountPoint() );
				}
			}
			return path;
		}
	}
}
