/* r128_cce.c -- ATI Rage 128 driver -*- linux-c -*-
 * radeon_cp.c -- CP support for Radeon -*- linux-c -*-
 *
 * Copyright 2000 Precision Insight, Inc., Cedar Park, Texas.
 * Copyright 2000 VA Linux Systems, Inc., Fremont, California.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *    Kevin E. Martin <martin@valinux.com>
 *    Gareth Hughes <gareth@valinux.com>
 */

/* CCE microcode (from ATI) */

#include "ati.h"

CARD32 r128_cce_microcode[] = {
	0, 276838400, 0, 268449792, 2, 142, 2, 145, 0, 1076765731, 0,
	1617039951, 0, 774592877, 0, 1987540286, 0, 2307490946U, 0,
	599558925, 0, 589505315, 0, 596487092, 0, 589505315, 1,
	11544576, 1, 206848, 1, 311296, 1, 198656, 2, 912273422, 11,
	262144, 0, 0, 1, 33559837, 1, 7438, 1, 14809, 1, 6615, 12, 28,
	1, 6614, 12, 28, 2, 23, 11, 18874368, 0, 16790922, 1, 409600, 9,
	30, 1, 147854772, 16, 420483072, 3, 8192, 0, 10240, 1, 198656,
	1, 15630, 1, 51200, 10, 34858, 9, 42, 1, 33559823, 2, 10276, 1,
	15717, 1, 15718, 2, 43, 1, 15936948, 1, 570480831, 1, 14715071,
	12, 322123831, 1, 33953125, 12, 55, 1, 33559908, 1, 15718, 2,
	46, 4, 2099258, 1, 526336, 1, 442623, 4, 4194365, 1, 509952, 1,
	459007, 3, 0, 12, 92, 2, 46, 12, 176, 1, 15734, 1, 206848, 1,
	18432, 1, 133120, 1, 100670734, 1, 149504, 1, 165888, 1,
	15975928, 1, 1048576, 6, 3145806, 1, 15715, 16, 2150645232U, 2,
	268449859, 2, 10307, 12, 176, 1, 15734, 1, 15735, 1, 15630, 1,
	15631, 1, 5253120, 6, 3145810, 16, 2150645232U, 1, 15864, 2, 82,
	1, 343310, 1, 1064207, 2, 3145813, 1, 15728, 1, 7817, 1, 15729,
	3, 15730, 12, 92, 2, 98, 1, 16168, 1, 16167, 1, 16002, 1, 16008,
	1, 15974, 1, 15975, 1, 15990, 1, 15976, 1, 15977, 1, 15980, 0,
	15981, 1, 10240, 1, 5253120, 1, 15720, 1, 198656, 6, 110, 1,
	180224, 1, 103824738, 2, 112, 2, 3145839, 0, 536885440, 1,
	114880, 14, 125, 12, 206975, 1, 33559995, 12, 198784, 0,
	33570236, 1, 15803, 0, 15804, 3, 294912, 1, 294912, 3, 442370,
	1, 11544576, 0, 811612160, 1, 12593152, 1, 11536384, 1,
	14024704, 7, 310382726, 0, 10240, 1, 14796, 1, 14797, 1, 14793,
	1, 14794, 0, 14795, 1, 268679168, 1, 9437184, 1, 268449792, 1,
	198656, 1, 9452827, 1, 1075854602, 1, 1075854603, 1, 557056, 1,
	114880, 14, 159, 12, 198784, 1, 1109409213, 12, 198783, 1,
	1107312059, 12, 198784, 1, 1109409212, 2, 162, 1, 1075854781, 1,
	1073757627, 1, 1075854780, 1, 540672, 1, 10485760, 6, 3145894,
	16, 274741248, 9, 168, 3, 4194304, 3, 4209949, 0, 0, 0, 256, 14,
	174, 1, 114857, 1, 33560007, 12, 176, 0, 10240, 1, 114858, 1,
	33560018, 1, 114857, 3, 33560007, 1, 16008, 1, 114874, 1,
	33560360, 1, 114875, 1, 33560154, 0, 15963, 0, 256, 0, 4096, 1,
	409611, 9, 188, 0, 10240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

CARD32 radeon_cp_microcode[][2] = {
	{ 0x21007000, 0000000000 },
	{ 0x20007000, 0000000000 },
	{ 0x000000b4, 0x00000004 },
	{ 0x000000b8, 0x00000004 },
	{ 0x6f5b4d4c, 0000000000 },
	{ 0x4c4c427f, 0000000000 },
	{ 0x5b568a92, 0000000000 },
	{ 0x4ca09c6d, 0000000000 },
	{ 0xad4c4c4c, 0000000000 },
	{ 0x4ce1af3d, 0000000000 },
	{ 0xd8afafaf, 0000000000 },
	{ 0xd64c4cdc, 0000000000 },
	{ 0x4cd10d10, 0000000000 },
	{ 0x000f0000, 0x00000016 },
	{ 0x362f242d, 0000000000 },
	{ 0x00000012, 0x00000004 },
	{ 0x000f0000, 0x00000016 },
	{ 0x362f282d, 0000000000 },
	{ 0x000380e7, 0x00000002 },
	{ 0x04002c97, 0x00000002 },
	{ 0x000f0001, 0x00000016 },
	{ 0x333a3730, 0000000000 },
	{ 0x000077ef, 0x00000002 },
	{ 0x00061000, 0x00000002 },
	{ 0x00000021, 0x0000001a },
	{ 0x00004000, 0x0000001e },
	{ 0x00061000, 0x00000002 },
	{ 0x00000021, 0x0000001a },
	{ 0x00004000, 0x0000001e },
	{ 0x00061000, 0x00000002 },
	{ 0x00000021, 0x0000001a },
	{ 0x00004000, 0x0000001e },
	{ 0x00000017, 0x00000004 },
	{ 0x0003802b, 0x00000002 },
	{ 0x040067e0, 0x00000002 },
	{ 0x00000017, 0x00000004 },
	{ 0x000077e0, 0x00000002 },
	{ 0x00065000, 0x00000002 },
	{ 0x000037e1, 0x00000002 },
	{ 0x040067e1, 0x00000006 },
	{ 0x000077e0, 0x00000002 },
	{ 0x000077e1, 0x00000002 },
	{ 0x000077e1, 0x00000006 },
	{ 0xffffffff, 0000000000 },
	{ 0x10000000, 0000000000 },
	{ 0x0003802b, 0x00000002 },
	{ 0x040067e0, 0x00000006 },
	{ 0x00007675, 0x00000002 },
	{ 0x00007676, 0x00000002 },
	{ 0x00007677, 0x00000002 },
	{ 0x00007678, 0x00000006 },
	{ 0x0003802c, 0x00000002 },
	{ 0x04002676, 0x00000002 },
	{ 0x00007677, 0x00000002 },
	{ 0x00007678, 0x00000006 },
	{ 0x0000002f, 0x00000018 },
	{ 0x0000002f, 0x00000018 },
	{ 0000000000, 0x00000006 },
	{ 0x00000030, 0x00000018 },
	{ 0x00000030, 0x00000018 },
	{ 0000000000, 0x00000006 },
	{ 0x01605000, 0x00000002 },
	{ 0x00065000, 0x00000002 },
	{ 0x00098000, 0x00000002 },
	{ 0x00061000, 0x00000002 },
	{ 0x64c0603e, 0x00000004 },
	{ 0x000380e6, 0x00000002 },
	{ 0x040025c5, 0x00000002 },
	{ 0x00080000, 0x00000016 },
	{ 0000000000, 0000000000 },
	{ 0x0400251d, 0x00000002 },
	{ 0x00007580, 0x00000002 },
	{ 0x00067581, 0x00000002 },
	{ 0x04002580, 0x00000002 },
	{ 0x00067581, 0x00000002 },
	{ 0x00000049, 0x00000004 },
	{ 0x00005000, 0000000000 },
	{ 0x000380e6, 0x00000002 },
	{ 0x040025c5, 0x00000002 },
	{ 0x00061000, 0x00000002 },
	{ 0x0000750e, 0x00000002 },
	{ 0x00019000, 0x00000002 },
	{ 0x00011055, 0x00000014 },
	{ 0x00000055, 0x00000012 },
	{ 0x0400250f, 0x00000002 },
	{ 0x0000504f, 0x00000004 },
	{ 0x000380e6, 0x00000002 },
	{ 0x040025c5, 0x00000002 },
	{ 0x00007565, 0x00000002 },
	{ 0x00007566, 0x00000002 },
	{ 0x00000058, 0x00000004 },
	{ 0x000380e6, 0x00000002 },
	{ 0x040025c5, 0x00000002 },
	{ 0x01e655b4, 0x00000002 },
	{ 0x4401b0e4, 0x00000002 },
	{ 0x01c110e4, 0x00000002 },
	{ 0x26667066, 0x00000018 },
	{ 0x040c2565, 0x00000002 },
	{ 0x00000066, 0x00000018 },
	{ 0x04002564, 0x00000002 },
	{ 0x00007566, 0x00000002 },
	{ 0x0000005d, 0x00000004 },
	{ 0x00401069, 0x00000008 },
	{ 0x00101000, 0x00000002 },
	{ 0x000d80ff, 0x00000002 },
	{ 0x0080006c, 0x00000008 },
	{ 0x000f9000, 0x00000002 },
	{ 0x000e00ff, 0x00000002 },
	{ 0000000000, 0x00000006 },
	{ 0x0000008f, 0x00000018 },
	{ 0x0000005b, 0x00000004 },
	{ 0x000380e6, 0x00000002 },
	{ 0x040025c5, 0x00000002 },
	{ 0x00007576, 0x00000002 },
	{ 0x00065000, 0x00000002 },
	{ 0x00009000, 0x00000002 },
	{ 0x00041000, 0x00000002 },
	{ 0x0c00350e, 0x00000002 },
	{ 0x00049000, 0x00000002 },
	{ 0x00051000, 0x00000002 },
	{ 0x01e785f8, 0x00000002 },
	{ 0x00200000, 0x00000002 },
	{ 0x0060007e, 0x0000000c },
	{ 0x00007563, 0x00000002 },
	{ 0x006075f0, 0x00000021 },
	{ 0x20007073, 0x00000004 },
	{ 0x00005073, 0x00000004 },
	{ 0x000380e6, 0x00000002 },
	{ 0x040025c5, 0x00000002 },
	{ 0x00007576, 0x00000002 },
	{ 0x00007577, 0x00000002 },
	{ 0x0000750e, 0x00000002 },
	{ 0x0000750f, 0x00000002 },
	{ 0x00a05000, 0x00000002 },
	{ 0x00600083, 0x0000000c },
	{ 0x006075f0, 0x00000021 },
	{ 0x000075f8, 0x00000002 },
	{ 0x00000083, 0x00000004 },
	{ 0x000a750e, 0x00000002 },
	{ 0x000380e6, 0x00000002 },
	{ 0x040025c5, 0x00000002 },
	{ 0x0020750f, 0x00000002 },
	{ 0x00600086, 0x00000004 },
	{ 0x00007570, 0x00000002 },
	{ 0x00007571, 0x00000002 },
	{ 0x00007572, 0x00000006 },
	{ 0x000380e6, 0x00000002 },
	{ 0x040025c5, 0x00000002 },
	{ 0x00005000, 0x00000002 },
	{ 0x00a05000, 0x00000002 },
	{ 0x00007568, 0x00000002 },
	{ 0x00061000, 0x00000002 },
	{ 0x00000095, 0x0000000c },
	{ 0x00058000, 0x00000002 },
	{ 0x0c607562, 0x00000002 },
	{ 0x00000097, 0x00000004 },
	{ 0x000380e6, 0x00000002 },
	{ 0x040025c5, 0x00000002 },
	{ 0x00600096, 0x00000004 },
	{ 0x400070e5, 0000000000 },
	{ 0x000380e6, 0x00000002 },
	{ 0x040025c5, 0x00000002 },
	{ 0x000380e5, 0x00000002 },
	{ 0x000000a8, 0x0000001c },
	{ 0x000650aa, 0x00000018 },
	{ 0x040025bb, 0x00000002 },
	{ 0x000610ab, 0x00000018 },
	{ 0x040075bc, 0000000000 },
	{ 0x000075bb, 0x00000002 },
	{ 0x000075bc, 0000000000 },
	{ 0x00090000, 0x00000006 },
	{ 0x00090000, 0x00000002 },
	{ 0x000d8002, 0x00000006 },
	{ 0x00007832, 0x00000002 },
	{ 0x00005000, 0x00000002 },
	{ 0x000380e7, 0x00000002 },
	{ 0x04002c97, 0x00000002 },
	{ 0x00007820, 0x00000002 },
	{ 0x00007821, 0x00000002 },
	{ 0x00007800, 0000000000 },
	{ 0x01200000, 0x00000002 },
	{ 0x20077000, 0x00000002 },
	{ 0x01200000, 0x00000002 },
	{ 0x20007000, 0x00000002 },
	{ 0x00061000, 0x00000002 },
	{ 0x0120751b, 0x00000002 },
	{ 0x8040750a, 0x00000002 },
	{ 0x8040750b, 0x00000002 },
	{ 0x00110000, 0x00000002 },
	{ 0x000380e5, 0x00000002 },
	{ 0x000000c6, 0x0000001c },
	{ 0x000610ab, 0x00000018 },
	{ 0x844075bd, 0x00000002 },
	{ 0x000610aa, 0x00000018 },
	{ 0x840075bb, 0x00000002 },
	{ 0x000610ab, 0x00000018 },
	{ 0x844075bc, 0x00000002 },
	{ 0x000000c9, 0x00000004 },
	{ 0x804075bd, 0x00000002 },
	{ 0x800075bb, 0x00000002 },
	{ 0x804075bc, 0x00000002 },
	{ 0x00108000, 0x00000002 },
	{ 0x01400000, 0x00000002 },
	{ 0x006000cd, 0x0000000c },
	{ 0x20c07000, 0x00000020 },
	{ 0x000000cf, 0x00000012 },
	{ 0x00800000, 0x00000006 },
	{ 0x0080751d, 0x00000006 },
	{ 0000000000, 0000000000 },
	{ 0x0000775c, 0x00000002 },
	{ 0x00a05000, 0x00000002 },
	{ 0x00661000, 0x00000002 },
	{ 0x0460275d, 0x00000020 },
	{ 0x00004000, 0000000000 },
	{ 0x01e00830, 0x00000002 },
	{ 0x21007000, 0000000000 },
	{ 0x6464614d, 0000000000 },
	{ 0x69687420, 0000000000 },
	{ 0x00000073, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0x00005000, 0x00000002 },
	{ 0x000380d0, 0x00000002 },
	{ 0x040025e0, 0x00000002 },
	{ 0x000075e1, 0000000000 },
	{ 0x00000001, 0000000000 },
	{ 0x000380e0, 0x00000002 },
	{ 0x04002394, 0x00000002 },
	{ 0x00005000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0x00000008, 0000000000 },
	{ 0x00000004, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
};

CARD32 r200_cp_microcode[][2] = {
	{ 0x21007000, 0000000000 },        
	{ 0x20007000, 0000000000 }, 
	{ 0x000000ab, 0x00000004 },
	{ 0x000000af, 0x00000004 },
	{ 0x66544a49, 0000000000 },
	{ 0x49494174, 0000000000 },
	{ 0x54517d83, 0000000000 },
	{ 0x498d8b64, 0000000000 },
	{ 0x49494949, 0000000000 },
	{ 0x49da493c, 0000000000 },
	{ 0x49989898, 0000000000 },
	{ 0xd34949d5, 0000000000 },
	{ 0x9dc90e11, 0000000000 },
	{ 0xce9b9b9b, 0000000000 },
	{ 0x000f0000, 0x00000016 },
	{ 0x352e232c, 0000000000 },
	{ 0x00000013, 0x00000004 },
	{ 0x000f0000, 0x00000016 },
	{ 0x352e272c, 0000000000 },
	{ 0x000f0001, 0x00000016 },
	{ 0x3239362f, 0000000000 },
	{ 0x000077ef, 0x00000002 },
	{ 0x00061000, 0x00000002 },
	{ 0x00000020, 0x0000001a },
	{ 0x00004000, 0x0000001e },
	{ 0x00061000, 0x00000002 },
	{ 0x00000020, 0x0000001a },
	{ 0x00004000, 0x0000001e },
	{ 0x00061000, 0x00000002 },
	{ 0x00000020, 0x0000001a },
	{ 0x00004000, 0x0000001e },
	{ 0x00000016, 0x00000004 },
	{ 0x0003802a, 0x00000002 },
	{ 0x040067e0, 0x00000002 },
	{ 0x00000016, 0x00000004 },
	{ 0x000077e0, 0x00000002 },
	{ 0x00065000, 0x00000002 },
	{ 0x000037e1, 0x00000002 },
	{ 0x040067e1, 0x00000006 },
	{ 0x000077e0, 0x00000002 },
	{ 0x000077e1, 0x00000002 },
	{ 0x000077e1, 0x00000006 },
	{ 0xffffffff, 0000000000 },
	{ 0x10000000, 0000000000 },
	{ 0x0003802a, 0x00000002 },
	{ 0x040067e0, 0x00000006 },
	{ 0x00007675, 0x00000002 },
	{ 0x00007676, 0x00000002 },
	{ 0x00007677, 0x00000002 },
	{ 0x00007678, 0x00000006 },
	{ 0x0003802b, 0x00000002 },
	{ 0x04002676, 0x00000002 },
	{ 0x00007677, 0x00000002 },
	{ 0x00007678, 0x00000006 },
	{ 0x0000002e, 0x00000018 },
	{ 0x0000002e, 0x00000018 },
	{ 0000000000, 0x00000006 },
	{ 0x0000002f, 0x00000018 },
	{ 0x0000002f, 0x00000018 },
	{ 0000000000, 0x00000006 },
	{ 0x01605000, 0x00000002 },
	{ 0x00065000, 0x00000002 },
	{ 0x00098000, 0x00000002 },
	{ 0x00061000, 0x00000002 },
	{ 0x64c0603d, 0x00000004 },
	{ 0x00080000, 0x00000016 },
	{ 0000000000, 0000000000 },
	{ 0x0400251d, 0x00000002 },
	{ 0x00007580, 0x00000002 },
	{ 0x00067581, 0x00000002 },
	{ 0x04002580, 0x00000002 },
	{ 0x00067581, 0x00000002 },
	{ 0x00000046, 0x00000004 },
	{ 0x00005000, 0000000000 },
	{ 0x00061000, 0x00000002 },
	{ 0x0000750e, 0x00000002 },
	{ 0x00019000, 0x00000002 },
	{ 0x00011055, 0x00000014 },
	{ 0x00000055, 0x00000012 },
	{ 0x0400250f, 0x00000002 },
	{ 0x0000504a, 0x00000004 },
	{ 0x00007565, 0x00000002 },
	{ 0x00007566, 0x00000002 },
	{ 0x00000051, 0x00000004 },
	{ 0x01e655b4, 0x00000002 },
	{ 0x4401b0dc, 0x00000002 },
	{ 0x01c110dc, 0x00000002 },
	{ 0x2666705d, 0x00000018 },
	{ 0x040c2565, 0x00000002 },
	{ 0x0000005d, 0x00000018 },
	{ 0x04002564, 0x00000002 },
	{ 0x00007566, 0x00000002 },
	{ 0x00000054, 0x00000004 },
	{ 0x00401060, 0x00000008 },
	{ 0x00101000, 0x00000002 },
	{ 0x000d80ff, 0x00000002 },
	{ 0x00800063, 0x00000008 },
	{ 0x000f9000, 0x00000002 },
	{ 0x000e00ff, 0x00000002 },
	{ 0000000000, 0x00000006 },
	{ 0x00000080, 0x00000018 },
	{ 0x00000054, 0x00000004 },
	{ 0x00007576, 0x00000002 },
	{ 0x00065000, 0x00000002 },
	{ 0x00009000, 0x00000002 },
	{ 0x00041000, 0x00000002 },
	{ 0x0c00350e, 0x00000002 },
	{ 0x00049000, 0x00000002 },
	{ 0x00051000, 0x00000002 },
	{ 0x01e785f8, 0x00000002 },
	{ 0x00200000, 0x00000002 },
	{ 0x00600073, 0x0000000c },
	{ 0x00007563, 0x00000002 },
	{ 0x006075f0, 0x00000021 },
	{ 0x20007068, 0x00000004 },
	{ 0x00005068, 0x00000004 },
	{ 0x00007576, 0x00000002 },
	{ 0x00007577, 0x00000002 },
	{ 0x0000750e, 0x00000002 },
	{ 0x0000750f, 0x00000002 },
	{ 0x00a05000, 0x00000002 },
	{ 0x00600076, 0x0000000c },
	{ 0x006075f0, 0x00000021 },
	{ 0x000075f8, 0x00000002 },
	{ 0x00000076, 0x00000004 },
	{ 0x000a750e, 0x00000002 },
	{ 0x0020750f, 0x00000002 },
	{ 0x00600079, 0x00000004 },
	{ 0x00007570, 0x00000002 },
	{ 0x00007571, 0x00000002 },
	{ 0x00007572, 0x00000006 },
	{ 0x00005000, 0x00000002 },
	{ 0x00a05000, 0x00000002 },
	{ 0x00007568, 0x00000002 },
	{ 0x00061000, 0x00000002 },
	{ 0x00000084, 0x0000000c },
	{ 0x00058000, 0x00000002 },
	{ 0x0c607562, 0x00000002 },
	{ 0x00000086, 0x00000004 },
	{ 0x00600085, 0x00000004 },
	{ 0x400070dd, 0000000000 },
	{ 0x000380dd, 0x00000002 },
	{ 0x00000093, 0x0000001c },
	{ 0x00065095, 0x00000018 },
	{ 0x040025bb, 0x00000002 },
	{ 0x00061096, 0x00000018 },
	{ 0x040075bc, 0000000000 },
	{ 0x000075bb, 0x00000002 },
	{ 0x000075bc, 0000000000 },
	{ 0x00090000, 0x00000006 },
	{ 0x00090000, 0x00000002 },
	{ 0x000d8002, 0x00000006 },
	{ 0x00005000, 0x00000002 },
	{ 0x00007821, 0x00000002 },
	{ 0x00007800, 0000000000 },
	{ 0x00007821, 0x00000002 },
	{ 0x00007800, 0000000000 },
	{ 0x01665000, 0x00000002 },
	{ 0x000a0000, 0x00000002 },
	{ 0x000671cc, 0x00000002 },
	{ 0x0286f1cd, 0x00000002 },
	{ 0x000000a3, 0x00000010 },
	{ 0x21007000, 0000000000 },
	{ 0x000000aa, 0x0000001c },
	{ 0x00065000, 0x00000002 },
	{ 0x000a0000, 0x00000002 },
	{ 0x00061000, 0x00000002 },
	{ 0x000b0000, 0x00000002 },
	{ 0x38067000, 0x00000002 },
	{ 0x000a00a6, 0x00000004 },
	{ 0x20007000, 0000000000 },
	{ 0x01200000, 0x00000002 },
	{ 0x20077000, 0x00000002 },
	{ 0x01200000, 0x00000002 },
	{ 0x20007000, 0000000000 },
	{ 0x00061000, 0x00000002 },
	{ 0x0120751b, 0x00000002 },
	{ 0x8040750a, 0x00000002 },
	{ 0x8040750b, 0x00000002 },
	{ 0x00110000, 0x00000002 },
	{ 0x000380dd, 0x00000002 },
	{ 0x000000bd, 0x0000001c },
	{ 0x00061096, 0x00000018 },
	{ 0x844075bd, 0x00000002 },
	{ 0x00061095, 0x00000018 },
	{ 0x840075bb, 0x00000002 },
	{ 0x00061096, 0x00000018 },
	{ 0x844075bc, 0x00000002 },
	{ 0x000000c0, 0x00000004 },
	{ 0x804075bd, 0x00000002 },
	{ 0x800075bb, 0x00000002 },
	{ 0x804075bc, 0x00000002 },
	{ 0x00108000, 0x00000002 },
	{ 0x01400000, 0x00000002 },
	{ 0x006000c4, 0x0000000c },
	{ 0x20c07000, 0x00000020 },
	{ 0x000000c6, 0x00000012 },
	{ 0x00800000, 0x00000006 },
	{ 0x0080751d, 0x00000006 },
	{ 0x000025bb, 0x00000002 },
	{ 0x000040c0, 0x00000004 },
	{ 0x0000775c, 0x00000002 },
	{ 0x00a05000, 0x00000002 },
	{ 0x00661000, 0x00000002 },
	{ 0x0460275d, 0x00000020 },
	{ 0x00004000, 0000000000 },
	{ 0x00007999, 0x00000002 },
	{ 0x00a05000, 0x00000002 },
	{ 0x00661000, 0x00000002 },
	{ 0x0460299b, 0x00000020 },
	{ 0x00004000, 0000000000 },
	{ 0x01e00830, 0x00000002 },
	{ 0x21007000, 0000000000 },
	{ 0x00005000, 0x00000002 },
	{ 0x00038042, 0x00000002 },
	{ 0x040025e0, 0x00000002 },
	{ 0x000075e1, 0000000000 },
	{ 0x00000001, 0000000000 },
	{ 0x000380d9, 0x00000002 },
	{ 0x04007394, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
};

/* Microcode from http://volodya-project.sourceforge.net/ */

CARD32 r300_cp_microcode[][2] = {
	{ 0x4200e000, 0000000000 },
	{ 0x4000e000, 0000000000 },
	{ 0x000000af, 0x00000008 },
	{ 0x000000b3, 0x00000008 },
	{ 0x6c5a504f, 0000000000 },
	{ 0x4f4f497a, 0000000000 },
	{ 0x5a578288, 0000000000 },
	{ 0x4f91906a, 0000000000 },
	{ 0x4f4f4f4f, 0000000000 },
	{ 0x4fe24f44, 0000000000 },
	{ 0x4f9c9c9c, 0000000000 },
	{ 0xdc4f4fde, 0000000000 },
	{ 0xa1cd4f4f, 0000000000 },
	{ 0xd29d9d9d, 0000000000 },
	{ 0x4f0f9fd7, 0000000000 },
	{ 0x000ca000, 0x00000004 },
	{ 0x000d0012, 0x00000038 },
	{ 0x0000e8b4, 0x00000004 },
	{ 0x000d0014, 0x00000038 },
	{ 0x0000e8b6, 0x00000004 },
	{ 0x000d0016, 0x00000038 },
	{ 0x0000e854, 0x00000004 },
	{ 0x000d0018, 0x00000038 },
	{ 0x0000e855, 0x00000004 },
	{ 0x000d001a, 0x00000038 },
	{ 0x0000e856, 0x00000004 },
	{ 0x000d001c, 0x00000038 },
	{ 0x0000e857, 0x00000004 },
	{ 0x000d001e, 0x00000038 },
	{ 0x0000e824, 0x00000004 },
	{ 0x000d0020, 0x00000038 },
	{ 0x0000e825, 0x00000004 },
	{ 0x000d0022, 0x00000038 },
	{ 0x0000e830, 0x00000004 },
	{ 0x000d0024, 0x00000038 },
	{ 0x0000f0c0, 0x00000004 },
	{ 0x000d0026, 0x00000038 },
	{ 0x0000f0c1, 0x00000004 },
	{ 0x000d0028, 0x00000038 },
	{ 0x0000f041, 0x00000004 },
	{ 0x000d002a, 0x00000038 },
	{ 0x0000f184, 0x00000004 },
	{ 0x000d002c, 0x00000038 },
	{ 0x0000f185, 0x00000004 },
	{ 0x000d002e, 0x00000038 },
	{ 0x0000f186, 0x00000004 },
	{ 0x000d0030, 0x00000038 },
	{ 0x0000f187, 0x00000004 },
	{ 0x000d0032, 0x00000038 },
	{ 0x0000f180, 0x00000004 },
	{ 0x000d0034, 0x00000038 },
	{ 0x0000f393, 0x00000004 },
	{ 0x000d0036, 0x00000038 },
	{ 0x0000f38a, 0x00000004 },
	{ 0x000d0038, 0x00000038 },
	{ 0x0000f38e, 0x00000004 },
	{ 0x0000e821, 0x00000004 },
	{ 0x0140a000, 0x00000004 },
	{ 0x00000043, 0x00000018 },
	{ 0x00cce800, 0x00000004 },
	{ 0x001b0001, 0x00000004 },
	{ 0x08004800, 0x00000004 },
	{ 0x001b0001, 0x00000004 },
	{ 0x08004800, 0x00000004 },
	{ 0x001b0001, 0x00000004 },
	{ 0x08004800, 0x00000004 },
	{ 0x0000003a, 0x00000008 },
	{ 0x0000a000, 0000000000 },
	{ 0x02c0a000, 0x00000004 },
	{ 0x000ca000, 0x00000004 },
	{ 0x00130000, 0x00000004 },
	{ 0x000c2000, 0x00000004 },
	{ 0xc980c045, 0x00000008 },
	{ 0x2000451d, 0x00000004 },
	{ 0x0000e580, 0x00000004 },
	{ 0x000ce581, 0x00000004 },
	{ 0x08004580, 0x00000004 },
	{ 0x000ce581, 0x00000004 },
	{ 0x0000004c, 0x00000008 },
	{ 0x0000a000, 0000000000 },
	{ 0x000c2000, 0x00000004 },
	{ 0x0000e50e, 0x00000004 },
	{ 0x00032000, 0x00000004 },
	{ 0x00022056, 0x00000028 },
	{ 0x00000056, 0x00000024 },
	{ 0x0800450f, 0x00000004 },
	{ 0x0000a050, 0x00000008 },
	{ 0x0000e565, 0x00000004 },
	{ 0x0000e566, 0x00000004 },
	{ 0x00000057, 0x00000008 },
	{ 0x03cca5b4, 0x00000004 },
	{ 0x05432000, 0x00000004 },
	{ 0x00022000, 0x00000004 },
	{ 0x4ccce063, 0x00000030 },
	{ 0x08274565, 0x00000004 },
	{ 0x00000063, 0x00000030 },
	{ 0x08004564, 0x00000004 },
	{ 0x0000e566, 0x00000004 },
	{ 0x0000005a, 0x00000008 },
	{ 0x00802066, 0x00000010 },
	{ 0x00202000, 0x00000004 },
	{ 0x001b00ff, 0x00000004 },
	{ 0x01000069, 0x00000010 },
	{ 0x001f2000, 0x00000004 },
	{ 0x001c00ff, 0x00000004 },
	{ 0000000000, 0x0000000c },
	{ 0x00000085, 0x00000030 },
	{ 0x0000005a, 0x00000008 },
	{ 0x0000e576, 0x00000004 },
	{ 0x000ca000, 0x00000004 },
	{ 0x00012000, 0x00000004 },
	{ 0x00082000, 0x00000004 },
	{ 0x1800650e, 0x00000004 },
	{ 0x00092000, 0x00000004 },
	{ 0x000a2000, 0x00000004 },
	{ 0x000f0000, 0x00000004 },
	{ 0x00400000, 0x00000004 },
	{ 0x00000079, 0x00000018 },
	{ 0x0000e563, 0x00000004 },
	{ 0x00c0e5f9, 0x000000c2 },
	{ 0x0000006e, 0x00000008 },
	{ 0x0000a06e, 0x00000008 },
	{ 0x0000e576, 0x00000004 },
	{ 0x0000e577, 0x00000004 },
	{ 0x0000e50e, 0x00000004 },
	{ 0x0000e50f, 0x00000004 },
	{ 0x0140a000, 0x00000004 },
	{ 0x0000007c, 0x00000018 },
	{ 0x00c0e5f9, 0x000000c2 },
	{ 0x0000007c, 0x00000008 },
	{ 0x0014e50e, 0x00000004 },
	{ 0x0040e50f, 0x00000004 },
	{ 0x00c0007f, 0x00000008 },
	{ 0x0000e570, 0x00000004 },
	{ 0x0000e571, 0x00000004 },
	{ 0x0000e572, 0x0000000c },
	{ 0x0000a000, 0x00000004 },
	{ 0x0140a000, 0x00000004 }, 
	{ 0x0000e568, 0x00000004 },
	{ 0x000c2000, 0x00000004 },
	{ 0x00000089, 0x00000018 },
	{ 0x000b0000, 0x00000004 },
	{ 0x18c0e562, 0x00000004 },
	{ 0x0000008b, 0x00000008 },
	{ 0x00c0008a, 0x00000008 },
	{ 0x000700e4, 0x00000004 },
	{ 0x00000097, 0x00000038 },
	{ 0x000ca099, 0x00000030 },
	{ 0x080045bb, 0x00000004 },
	{ 0x000c209a, 0x00000030 },
	{ 0x0800e5bc, 0000000000 },
	{ 0x0000e5bb, 0x00000004 },
	{ 0x0000e5bc, 0000000000 },
	{ 0x00120000, 0x0000000c },
	{ 0x00120000, 0x00000004 },
	{ 0x001b0002, 0x0000000c },
	{ 0x0000a000, 0x00000004 },
	{ 0x0000e821, 0x00000004 },
	{ 0x0000e800, 0000000000 },
	{ 0x0000e821, 0x00000004 },
	{ 0x0000e82e, 0000000000 },
	{ 0x02cca000, 0x00000004 },
	{ 0x00140000, 0x00000004 },
	{ 0x000ce1cc, 0x00000004 },
	{ 0x050de1cd, 0x00000004 },
	{ 0x000000a7, 0x00000020 },
	{ 0x4200e000, 0000000000 },
	{ 0x000000ae, 0x00000038 },
	{ 0x000ca000, 0x00000004 },
	{ 0x00140000, 0x00000004 },
	{ 0x000c2000, 0x00000004 },
	{ 0x00160000, 0x00000004 },
	{ 0x700ce000, 0x00000004 },
	{ 0x001400aa, 0x00000008 },
	{ 0x4000e000, 0000000000 },
	{ 0x02400000, 0x00000004 },
	{ 0x400ee000, 0x00000004 },
	{ 0x02400000, 0x00000004 },
	{ 0x4000e000, 0000000000 },
	{ 0x000c2000, 0x00000004 },
	{ 0x0240e51b, 0x00000004 },
	{ 0x0080e50a, 0x00000005 },
	{ 0x0080e50b, 0x00000005 },
	{ 0x00220000, 0x00000004 },
	{ 0x000700e4, 0x00000004 },
	{ 0x000000c1, 0x00000038 },
	{ 0x000c209a, 0x00000030 },
	{ 0x0880e5bd, 0x00000005 },
	{ 0x000c2099, 0x00000030 },
	{ 0x0800e5bb, 0x00000005 },
	{ 0x000c209a, 0x00000030 },
	{ 0x0880e5bc, 0x00000005 },
	{ 0x000000c4, 0x00000008 },
	{ 0x0080e5bd, 0x00000005 },
	{ 0x0000e5bb, 0x00000005 },
	{ 0x0080e5bc, 0x00000005 },
	{ 0x00210000, 0x00000004 },
	{ 0x02800000, 0x00000004 },
	{ 0x00c000c8, 0x00000018 },
	{ 0x4180e000, 0x00000040 },
	{ 0x000000ca, 0x00000024 },
	{ 0x01000000, 0x0000000c },
	{ 0x0100e51d, 0x0000000c },
	{ 0x000045bb, 0x00000004 },
	{ 0x000080c4, 0x00000008 },
	{ 0x0000f3ce, 0x00000004 },
	{ 0x0140a000, 0x00000004 },
	{ 0x00cc2000, 0x00000004 },
	{ 0x08c053cf, 0x00000040 },
	{ 0x00008000, 0000000000 },
	{ 0x0000f3d2, 0x00000004 },
	{ 0x0140a000, 0x00000004 },
	{ 0x00cc2000, 0x00000004 },
	{ 0x08c053d3, 0x00000040 },
	{ 0x00008000, 0000000000 },
	{ 0x0000f39d, 0x00000004 },
	{ 0x0140a000, 0x00000004 },
	{ 0x00cc2000, 0x00000004 },
	{ 0x08c0539e, 0x00000040 },
	{ 0x00008000, 0000000000 },
	{ 0x03c00830, 0x00000004 },
	{ 0x4200e000, 0000000000 },
	{ 0x0000a000, 0x00000004 },
	{ 0x200045e0, 0x00000004 },
	{ 0x0000e5e1, 0000000000 },
	{ 0x00000001, 0000000000 },
	{ 0x000700e1, 0x00000004 },
	{ 0x0800e394, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
	{ 0000000000, 0000000000 },
};
