/* Analog VU meter plugin for xmms
 *
 * Copyright (C) 2002 Pekka Harjamki <analogvu@mcfish.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include <math.h>
#include <stdio.h> 
#include <stdlib.h> 
#include <string.h> 

#include "vumeter.h"

extern GtkWidget *area;

GtkWidget	*vumeter_about_win=NULL,
		*vumeter_config_win=NULL,
		*clist_skinlist;

extern struct vumeter_skin_info vumeter_skin;
extern struct vumeter_cfg_info vumeter_cfg;

gint	old_delay,old_av_samples,old_accuracy;

/****************************************************************************
			Configure box
*****************************************************************************/

static void cancel_button_pressed(GtkWidget *widget, GtkWidget *entry)
{
 // restore old values
 vumeter_cfg.frame_delay=old_delay;
 vumeter_cfg.av_samples=old_av_samples;
 vumeter_cfg.accuracy=old_accuracy;
}

static void slider_adjusted_1(GtkAdjustment *adj, gint *data)
{
	*data=(gint)adj->value;
}

static void select_skin(GtkCList *widget,gint row,gint column,GtkWidget *data)
{
 	char *teksti;
 	gtk_clist_get_text(widget,row,0,&teksti);
	vumeter_load_skin(teksti);
	gtk_widget_draw(area,NULL);
}


void vumeter_config(void)
{
	GtkWidget 	*vbox_1=NULL, *hbox_1=NULL,
			*frame=NULL, *table=NULL,
			*button_1, *button_2, *button_3 ,
			*label_1, *notebook,*window_1,
			*hscale_1, *hscale_3,*hscale_4;

	GtkObject	*adjustment_1,
			*adjustment_3,
			*adjustment_4;

 	if(vumeter_config_win) return;

 	old_delay=vumeter_cfg.frame_delay;
 	old_av_samples=vumeter_cfg.av_samples;
	old_accuracy=vumeter_cfg.accuracy;

 	vumeter_config_win = gtk_window_new(GTK_WINDOW_DIALOG);

 	gtk_window_set_title(GTK_WINDOW(vumeter_config_win), "Analog VU meter Configuration");
 	gtk_window_set_policy(GTK_WINDOW(vumeter_config_win), TRUE, TRUE, FALSE);
 	gtk_window_set_position(GTK_WINDOW(vumeter_config_win), GTK_WIN_POS_MOUSE);
 	gtk_container_border_width(GTK_CONTAINER(vumeter_config_win), 10);

        gtk_widget_set_usize (vumeter_config_win, 500 , 240);

	gtk_signal_connect(GTK_OBJECT(vumeter_config_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &vumeter_config_win);

	/* Create vertical box, to store notebook and buttons (in hbox) */
	vbox_1 = gtk_vbox_new(FALSE,5);
 	gtk_container_add(GTK_CONTAINER(vumeter_config_win), vbox_1);

	/* Create notebook widget where we can store main & skin configs */
	notebook=gtk_notebook_new();
        gtk_box_pack_start(GTK_BOX(vbox_1), notebook, TRUE, TRUE, 0);
        gtk_container_set_border_width (GTK_CONTAINER (notebook), 5);


	/********************************************************************************
  					Notebook page 1
	********************************************************************************/

        frame = gtk_frame_new("Main options");
	gtk_container_add (GTK_CONTAINER (notebook), frame);

	table = gtk_table_new (2, 3, FALSE);
        gtk_container_add (GTK_CONTAINER (frame), table);
        gtk_container_set_border_width (GTK_CONTAINER (table), 5);
	
	/* Label and adjustment for avarage samples */

	label_1=gtk_label_new ("Avarage sample count:");
	gtk_misc_set_alignment(GTK_MISC(label_1),1,1);

//	adjustment_1=gtk_adjustment_new(vumeter_cfg.av_samples,1,max_avarage_samples,0,0,0);
	adjustment_1=gtk_adjustment_new(vumeter_cfg.av_samples,1,10,0,0,0);
	hscale_1=gtk_hscale_new(GTK_ADJUSTMENT (adjustment_1));
	gtk_scale_set_digits (GTK_SCALE (hscale_1), 0);
        gtk_widget_set_usize(hscale_1,240,32);

        gtk_table_attach (GTK_TABLE (table), label_1, 0, 1, 0, 1,
                         GTK_FILL,
                         GTK_FILL, 10, 0);

        gtk_table_attach (GTK_TABLE (table), hscale_1, 1, 2, 0, 1,
                         (GtkAttachOptions) (0),
                         (GtkAttachOptions) (0), 0, 0);

	/* Label and adjustment for frame delay */

	label_1=gtk_label_new ("Frame skip:");
	gtk_misc_set_alignment(GTK_MISC(label_1),1,1);

	adjustment_3=gtk_adjustment_new(vumeter_cfg.frame_delay,0,3,0,0,0);
	hscale_3=gtk_hscale_new(GTK_ADJUSTMENT (adjustment_3));
	gtk_scale_set_digits (GTK_SCALE (hscale_3), 0);
        gtk_widget_set_usize(hscale_3,240,32);

        gtk_table_attach (GTK_TABLE (table), label_1, 0, 1, 1, 2,
                         GTK_FILL,
                         GTK_FILL, 10, 0);

        gtk_table_attach (GTK_TABLE (table), hscale_3, 1, 2, 1, 2,
                         (GtkAttachOptions) (0),
                         (GtkAttachOptions) (0), 0, 0);

	/* Label and adjustment for render accuracy */

	label_1=gtk_label_new ("Render sample skip:");
	gtk_misc_set_alignment(GTK_MISC(label_1),1,1);

	adjustment_4=gtk_adjustment_new(vumeter_cfg.accuracy,0,15,0,0,0);
	hscale_4=gtk_hscale_new(GTK_ADJUSTMENT (adjustment_4));
	gtk_scale_set_digits (GTK_SCALE (hscale_4), 0);
        gtk_widget_set_usize(hscale_4,240,32);

        gtk_table_attach (GTK_TABLE (table), label_1, 0, 1, 2, 3,
                         GTK_FILL,
                         GTK_FILL, 10, 0);

        gtk_table_attach (GTK_TABLE (table), hscale_4, 1, 2, 2, 3,
                         (GtkAttachOptions) (0),
                         (GtkAttachOptions) (0), 0, 0);

	/* add label and turn page */

        label_1 = gtk_label_new ("Options");
        gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 0), label_1);
        gtk_misc_set_padding (GTK_MISC (label_1), 10, 0);

	/********************************************************************************
  					Notebook page 2
	********************************************************************************/

        frame = gtk_frame_new("Skin selection");
	gtk_container_add (GTK_CONTAINER (notebook), frame);

        window_1 = gtk_scrolled_window_new (NULL, NULL);
        gtk_container_add (GTK_CONTAINER (frame), window_1);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (window_1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);


	clist_skinlist=gtk_clist_new (2);
        gtk_clist_set_column_width (GTK_CLIST (clist_skinlist), 0, 60);
        gtk_clist_set_column_width (GTK_CLIST (clist_skinlist), 1, 300);
        gtk_clist_set_selection_mode (GTK_CLIST (clist_skinlist), GTK_SELECTION_BROWSE);
        gtk_clist_column_titles_show (GTK_CLIST (clist_skinlist));

        label_1 = gtk_label_new ("Name");
        gtk_clist_set_column_widget (GTK_CLIST (clist_skinlist), 0, label_1);

        label_1 = gtk_label_new ("Path");
        gtk_clist_set_column_widget (GTK_CLIST (clist_skinlist), 1, label_1);

        gtk_container_add (GTK_CONTAINER (window_1), clist_skinlist);

	gtk_clist_freeze(GTK_CLIST(clist_skinlist));
	gtk_clist_clear(GTK_CLIST(clist_skinlist));

	scan_skin_dir("home");
	scan_skin_dir("global");

	gtk_clist_thaw(GTK_CLIST(clist_skinlist));

	/* add label and turn page */

        label_1 = gtk_label_new ("Skins");
        gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), 1), label_1);
        gtk_misc_set_padding (GTK_MISC (label_1), 10, 0);

	gtk_signal_connect(GTK_OBJECT(clist_skinlist), "select-row", GTK_SIGNAL_FUNC(select_skin),NULL);


	/********************************************************************************
  				Buttons for save and exit
	********************************************************************************/

	hbox_1 = gtk_hbox_new(TRUE,5);
        gtk_box_pack_start(GTK_BOX(vbox_1), hbox_1, TRUE, FALSE, 0);

        button_1 = gtk_button_new_with_label("OK");
        gtk_box_pack_start(GTK_BOX(hbox_1), button_1, TRUE, TRUE, 0);

        button_3 = gtk_button_new_with_label("Apply");
        gtk_box_pack_start(GTK_BOX(hbox_1), button_3, TRUE, TRUE, 0);

        button_2 = gtk_button_new_with_label("Cancel");
        gtk_box_pack_start(GTK_BOX(hbox_1), button_2, TRUE, TRUE, 0);
	
	/* Add events for buttons, etc */
	gtk_signal_connect_object(GTK_OBJECT(button_2), "clicked", GTK_SIGNAL_FUNC(cancel_button_pressed),NULL);
	gtk_signal_connect_object(GTK_OBJECT(button_2), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(vumeter_config_win));

	gtk_signal_connect_object(GTK_OBJECT(button_1), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(vumeter_config_win));

	gtk_signal_connect(GTK_OBJECT(adjustment_1), "value_changed",  GTK_SIGNAL_FUNC(slider_adjusted_1),&vumeter_cfg.av_samples);
	gtk_signal_connect(GTK_OBJECT(adjustment_3), "value_changed",  GTK_SIGNAL_FUNC(slider_adjusted_1),&vumeter_cfg.frame_delay);


	/********************************************************************************
				End of config window building
	********************************************************************************/

	/* Show all widgets inside window */
	gtk_widget_show_all (vumeter_config_win);
}


/****************************************************************************
			 About box
*****************************************************************************/

void vumeter_about(void)
{
 	GtkWidget *vbox, *frame, *label,  *box, *button;

 	if(vumeter_about_win) return;
 	vumeter_about_win = gtk_window_new(GTK_WINDOW_DIALOG);
 	gtk_window_set_title(GTK_WINDOW(vumeter_about_win), "Analog VU meter About");
 	gtk_window_set_policy(GTK_WINDOW(vumeter_about_win), FALSE, FALSE, FALSE);
 	gtk_window_set_position(GTK_WINDOW(vumeter_about_win), GTK_WIN_POS_MOUSE);
 	gtk_container_border_width(GTK_CONTAINER(vumeter_about_win), 10);
	gtk_signal_connect(GTK_OBJECT(vumeter_about_win), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &vumeter_about_win);

 	vbox = gtk_vbox_new(FALSE, 10);
 	gtk_container_add(GTK_CONTAINER(vumeter_about_win), vbox);

        frame = gtk_frame_new(window_topic);
        gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);

        label = gtk_label_new("Created by Pekka Harjamki\n\nEmail:\nanalogvu@mcfish.org\n\nPlugin homepage:\nhttp://sourceforge.net/projects/vumeterplugin/\n\nFeel free to send feedback, bug reports,\nand ofcourse any ideas for this plugin!\n\nAlso thanks to msa xmms plugin for giving\nme ideas how to make xmms plugins.\n");
        gtk_container_add(GTK_CONTAINER(frame), label);

        box = gtk_hbutton_box_new();
        gtk_button_box_set_spacing(GTK_BUTTON_BOX(box), 5);
        gtk_box_pack_start(GTK_BOX(vbox), box, FALSE, FALSE, 0);

        button = gtk_button_new_with_label("Ok");
        gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(vumeter_about_win));
        GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(box), button, TRUE, TRUE, 0);
        gtk_widget_grab_default(button);

	gtk_widget_show_all (vumeter_about_win);
}
