;;  Filename : test-string-cmp.scm
;;  About    : unit test for R5RS string
;;
;;  Copyright (C) 2006 YAMAMOTO Kengo <yamaken AT bp.iij4u.or.jp>
;;  Copyright (c) 2007 SigScheme Project <uim AT freedesktop.org>
;;
;;  All rights reserved.
;;
;;  Redistribution and use in source and binary forms, with or without
;;  modification, are permitted provided that the following conditions
;;  are met:
;;
;;  1. Redistributions of source code must retain the above copyright
;;     notice, this list of conditions and the following disclaimer.
;;  2. Redistributions in binary form must reproduce the above copyright
;;     notice, this list of conditions and the following disclaimer in the
;;     documentation and/or other materials provided with the distribution.
;;  3. Neither the name of authors nor the names of its contributors
;;     may be used to endorse or promote products derived from this software
;;     without specific prior written permission.
;;
;;  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
;;  IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
;;  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;;  PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
;;  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
;;  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
;;  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
;;  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
;;  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

(load "./test/unittest.scm")

(if (not (symbol-bound? 'string<?))
    (test-skip "R5RS string procedures are not enabled"))

(define tn test-name)

;; TODO: immutable

;; Upper case letters are less than lower.

;;
;; string mutability acceptance
;;

;; Each test consist of immutable/immutable, immutable/mutable,
;; mutable/immutable, and mutable/mutable.

(tn "string-ci=? string mutability acceptance")
(assert-true (tn) (boolean? (string-ci=? "abc" "abc")))
(assert-true (tn) (boolean? (string-ci=? "abc" (string-copy "abc"))))
(assert-true (tn) (boolean? (string-ci=? (string-copy "abc") "abc")))
(assert-true (tn) (boolean? (string-ci=? (string-copy "abc")
                                         (string-copy "abc"))))
(tn "string<? string mutability acceptance")
(assert-true (tn) (boolean? (string<? "abc" "abc")))
(assert-true (tn) (boolean? (string<? "abc" (string-copy "abc"))))
(assert-true (tn) (boolean? (string<? (string-copy "abc") "abc")))
(assert-true (tn) (boolean? (string<? (string-copy "abc")
                                      (string-copy "abc"))))
(tn "string>? string mutability acceptance")
(assert-true (tn) (boolean? (string>? "abc" "abc")))
(assert-true (tn) (boolean? (string>? "abc" (string-copy "abc"))))
(assert-true (tn) (boolean? (string>? (string-copy "abc") "abc")))
(assert-true (tn) (boolean? (string>? (string-copy "abc")
                                      (string-copy "abc"))))
(tn "string<=? string mutability acceptance")
(assert-true (tn) (boolean? (string<=? "abc" "abc")))
(assert-true (tn) (boolean? (string<=? "abc" (string-copy "abc"))))
(assert-true (tn) (boolean? (string<=? (string-copy "abc") "abc")))
(assert-true (tn) (boolean? (string<=? (string-copy "abc")
                                       (string-copy "abc"))))
(tn "string>=? string mutability acceptance")
(assert-true (tn) (boolean? (string>=? "abc" "abc")))
(assert-true (tn) (boolean? (string>=? "abc" (string-copy "abc"))))
(assert-true (tn) (boolean? (string>=? (string-copy "abc") "abc")))
(assert-true (tn) (boolean? (string>=? (string-copy "abc")
                                       (string-copy "abc"))))
(tn "string-ci<? string mutability acceptance")
(assert-true (tn) (boolean? (string-ci<? "abc" "abc")))
(assert-true (tn) (boolean? (string-ci<? "abc" (string-copy "abc"))))
(assert-true (tn) (boolean? (string-ci<? (string-copy "abc") "abc")))
(assert-true (tn) (boolean? (string-ci<? (string-copy "abc")
                                         (string-copy "abc"))))
(tn "string-ci>? string mutability acceptance")
(assert-true (tn) (boolean? (string-ci>? "abc" "abc")))
(assert-true (tn) (boolean? (string-ci>? "abc" (string-copy "abc"))))
(assert-true (tn) (boolean? (string-ci>? (string-copy "abc") "abc")))
(assert-true (tn) (boolean? (string-ci>? (string-copy "abc")
                                         (string-copy "abc"))))
(tn "string-ci<=? string mutability acceptance")
(assert-true (tn) (boolean? (string-ci<=? "abc" "abc")))
(assert-true (tn) (boolean? (string-ci<=? "abc" (string-copy "abc"))))
(assert-true (tn) (boolean? (string-ci<=? (string-copy "abc") "abc")))
(assert-true (tn) (boolean? (string-ci<=? (string-copy "abc")
                                          (string-copy "abc"))))
(tn "string-ci>=? string mutability acceptance")
(assert-true (tn) (boolean? (string-ci>=? "abc" "abc")))
(assert-true (tn) (boolean? (string-ci>=? "abc" (string-copy "abc"))))
(assert-true (tn) (boolean? (string-ci>=? (string-copy "abc") "abc")))
(assert-true (tn) (boolean? (string-ci>=? (string-copy "abc")
                                          (string-copy "abc"))))

;;
;; comparison
;;

;; string-ci=?
(tn "string-ci=? \"\"")
(assert-true   (tn) (string-ci=? "" ""))
(assert-false  (tn) (string-ci=? "" "\n"))
(assert-false  (tn) (string-ci=? "" " "))
(assert-false  (tn) (string-ci=? "" "!"))
(assert-false  (tn) (string-ci=? "" "0"))
(assert-false  (tn) (string-ci=? "" "9"))
(assert-false  (tn) (string-ci=? "" "A"))
(assert-false  (tn) (string-ci=? "" "B"))
(assert-false  (tn) (string-ci=? "" "Z"))
(assert-false  (tn) (string-ci=? "" "_"))
(assert-false  (tn) (string-ci=? "" "a"))
(assert-false  (tn) (string-ci=? "" "b"))
(assert-false  (tn) (string-ci=? "" "z"))
(assert-false  (tn) (string-ci=? "" "~"))
(assert-false  (tn) (string-ci=? "" "\x7f"))
(tn "string-ci=? \"\\n\"")
(assert-false  (tn) (string-ci=? "\n" ""))
(assert-true   (tn) (string-ci=? "\n" "\n"))
(assert-false  (tn) (string-ci=? "\n" " "))
(assert-false  (tn) (string-ci=? "\n" "!"))
(assert-false  (tn) (string-ci=? "\n" "0"))
(assert-false  (tn) (string-ci=? "\n" "9"))
(assert-false  (tn) (string-ci=? "\n" "A"))
(assert-false  (tn) (string-ci=? "\n" "B"))
(assert-false  (tn) (string-ci=? "\n" "Z"))
(assert-false  (tn) (string-ci=? "\n" "_"))
(assert-false  (tn) (string-ci=? "\n" "a"))
(assert-false  (tn) (string-ci=? "\n" "b"))
(assert-false  (tn) (string-ci=? "\n" "z"))
(assert-false  (tn) (string-ci=? "\n" "~"))
(assert-false  (tn) (string-ci=? "\n" "\x7f"))
(tn "string-ci=? \" \"")
(assert-false  (tn) (string-ci=? " " ""))
(assert-false  (tn) (string-ci=? " " "\n"))
(assert-true   (tn) (string-ci=? " " " "))
(assert-false  (tn) (string-ci=? " " "!"))
(assert-false  (tn) (string-ci=? " " "0"))
(assert-false  (tn) (string-ci=? " " "9"))
(assert-false  (tn) (string-ci=? " " "A"))
(assert-false  (tn) (string-ci=? " " "B"))
(assert-false  (tn) (string-ci=? " " "Z"))
(assert-false  (tn) (string-ci=? " " "_"))
(assert-false  (tn) (string-ci=? " " "a"))
(assert-false  (tn) (string-ci=? " " "b"))
(assert-false  (tn) (string-ci=? " " "z"))
(assert-false  (tn) (string-ci=? " " "~"))
(assert-false  (tn) (string-ci=? " " "\x7f"))
(tn "string-ci=? \"!\"")
(assert-false  (tn) (string-ci=? "!" ""))
(assert-false  (tn) (string-ci=? "!" "\n"))
(assert-false  (tn) (string-ci=? "!" " "))
(assert-true   (tn) (string-ci=? "!" "!"))
(assert-false  (tn) (string-ci=? "!" "0"))
(assert-false  (tn) (string-ci=? "!" "9"))
(assert-false  (tn) (string-ci=? "!" "A"))
(assert-false  (tn) (string-ci=? "!" "B"))
(assert-false  (tn) (string-ci=? "!" "Z"))
(assert-false  (tn) (string-ci=? "!" "_"))
(assert-false  (tn) (string-ci=? "!" "a"))
(assert-false  (tn) (string-ci=? "!" "b"))
(assert-false  (tn) (string-ci=? "!" "z"))
(assert-false  (tn) (string-ci=? "!" "~"))
(assert-false  (tn) (string-ci=? "!" "\x7f"))
(tn "string-ci=? \"0\"")
(assert-false  (tn) (string-ci=? "0" ""))
(assert-false  (tn) (string-ci=? "0" "\n"))
(assert-false  (tn) (string-ci=? "0" " "))
(assert-false  (tn) (string-ci=? "0" "!"))
(assert-true   (tn) (string-ci=? "0" "0"))
(assert-false  (tn) (string-ci=? "0" "9"))
(assert-false  (tn) (string-ci=? "0" "A"))
(assert-false  (tn) (string-ci=? "0" "B"))
(assert-false  (tn) (string-ci=? "0" "Z"))
(assert-false  (tn) (string-ci=? "0" "_"))
(assert-false  (tn) (string-ci=? "0" "a"))
(assert-false  (tn) (string-ci=? "0" "b"))
(assert-false  (tn) (string-ci=? "0" "z"))
(assert-false  (tn) (string-ci=? "0" "~"))
(assert-false  (tn) (string-ci=? "0" "\x7f"))
(tn "string-ci=? \"9\"")
(assert-false  (tn) (string-ci=? "9" ""))
(assert-false  (tn) (string-ci=? "9" "\n"))
(assert-false  (tn) (string-ci=? "9" " "))
(assert-false  (tn) (string-ci=? "9" "!"))
(assert-false  (tn) (string-ci=? "9" "0"))
(assert-true   (tn) (string-ci=? "9" "9"))
(assert-false  (tn) (string-ci=? "9" "A"))
(assert-false  (tn) (string-ci=? "9" "B"))
(assert-false  (tn) (string-ci=? "9" "Z"))
(assert-false  (tn) (string-ci=? "9" "_"))
(assert-false  (tn) (string-ci=? "9" "a"))
(assert-false  (tn) (string-ci=? "9" "b"))
(assert-false  (tn) (string-ci=? "9" "z"))
(assert-false  (tn) (string-ci=? "9" "~"))
(assert-false  (tn) (string-ci=? "9" "\x7f"))
(tn "string-ci=? \"A\"")
(assert-false  (tn) (string-ci=? "A" ""))
(assert-false  (tn) (string-ci=? "A" "\n"))
(assert-false  (tn) (string-ci=? "A" " "))
(assert-false  (tn) (string-ci=? "A" "!"))
(assert-false  (tn) (string-ci=? "A" "0"))
(assert-false  (tn) (string-ci=? "A" "9"))
(assert-true   (tn) (string-ci=? "A" "A"))
(assert-false  (tn) (string-ci=? "A" "B"))
(assert-false  (tn) (string-ci=? "A" "Z"))
(assert-false  (tn) (string-ci=? "A" "_"))
(assert-true   (tn) (string-ci=? "A" "a"))
(assert-false  (tn) (string-ci=? "A" "b"))
(assert-false  (tn) (string-ci=? "A" "z"))
(assert-false  (tn) (string-ci=? "A" "~"))
(assert-false  (tn) (string-ci=? "A" "\x7f"))
(tn "string-ci=? \"B\"")
(assert-false  (tn) (string-ci=? "B" ""))
(assert-false  (tn) (string-ci=? "B" "\n"))
(assert-false  (tn) (string-ci=? "B" " "))
(assert-false  (tn) (string-ci=? "B" "!"))
(assert-false  (tn) (string-ci=? "B" "0"))
(assert-false  (tn) (string-ci=? "B" "9"))
(assert-false  (tn) (string-ci=? "B" "A"))
(assert-true   (tn) (string-ci=? "B" "B"))
(assert-false  (tn) (string-ci=? "B" "Z"))
(assert-false  (tn) (string-ci=? "B" "_"))
(assert-false  (tn) (string-ci=? "B" "a"))
(assert-true   (tn) (string-ci=? "B" "b"))
(assert-false  (tn) (string-ci=? "B" "z"))
(assert-false  (tn) (string-ci=? "B" "~"))
(assert-false  (tn) (string-ci=? "B" "\x7f"))
(tn "string-ci=? \"Z\"")
(assert-false  (tn) (string-ci=? "Z" ""))
(assert-false  (tn) (string-ci=? "Z" "\n"))
(assert-false  (tn) (string-ci=? "Z" " "))
(assert-false  (tn) (string-ci=? "Z" "!"))
(assert-false  (tn) (string-ci=? "Z" "0"))
(assert-false  (tn) (string-ci=? "Z" "9"))
(assert-false  (tn) (string-ci=? "Z" "A"))
(assert-false  (tn) (string-ci=? "Z" "B"))
(assert-true   (tn) (string-ci=? "Z" "Z"))
(assert-false  (tn) (string-ci=? "Z" "_"))
(assert-false  (tn) (string-ci=? "Z" "a"))
(assert-false  (tn) (string-ci=? "Z" "b"))
(assert-true   (tn) (string-ci=? "Z" "z"))
(assert-false  (tn) (string-ci=? "Z" "~"))
(assert-false  (tn) (string-ci=? "Z" "\x7f"))
(tn "string-ci=? \"_\"")
(assert-false  (tn) (string-ci=? "_" ""))
(assert-false  (tn) (string-ci=? "_" "\n"))
(assert-false  (tn) (string-ci=? "_" " "))
(assert-false  (tn) (string-ci=? "_" "!"))
(assert-false  (tn) (string-ci=? "_" "0"))
(assert-false  (tn) (string-ci=? "_" "9"))
(assert-false  (tn) (string-ci=? "_" "A"))
(assert-false  (tn) (string-ci=? "_" "B"))
(assert-false  (tn) (string-ci=? "_" "Z"))
(assert-true   (tn) (string-ci=? "_" "_"))
(assert-false  (tn) (string-ci=? "_" "a"))
(assert-false  (tn) (string-ci=? "_" "b"))
(assert-false  (tn) (string-ci=? "_" "z"))
(assert-false  (tn) (string-ci=? "_" "~"))
(assert-false  (tn) (string-ci=? "_" "\x7f"))
(tn "string-ci=? \"a\"")
(assert-false  (tn) (string-ci=? "a" ""))
(assert-false  (tn) (string-ci=? "a" "\n"))
(assert-false  (tn) (string-ci=? "a" " "))
(assert-false  (tn) (string-ci=? "a" "!"))
(assert-false  (tn) (string-ci=? "a" "0"))
(assert-false  (tn) (string-ci=? "a" "9"))
(assert-true   (tn) (string-ci=? "a" "A"))
(assert-false  (tn) (string-ci=? "a" "B"))
(assert-false  (tn) (string-ci=? "a" "Z"))
(assert-false  (tn) (string-ci=? "a" "_"))
(assert-true   (tn) (string-ci=? "a" "a"))
(assert-false  (tn) (string-ci=? "a" "b"))
(assert-false  (tn) (string-ci=? "a" "z"))
(assert-false  (tn) (string-ci=? "a" "~"))
(assert-false  (tn) (string-ci=? "a" "\x7f"))
(tn "string-ci=? \"b\"")
(assert-false  (tn) (string-ci=? "b" ""))
(assert-false  (tn) (string-ci=? "b" "\n"))
(assert-false  (tn) (string-ci=? "b" " "))
(assert-false  (tn) (string-ci=? "b" "!"))
(assert-false  (tn) (string-ci=? "b" "0"))
(assert-false  (tn) (string-ci=? "b" "9"))
(assert-false  (tn) (string-ci=? "b" "A"))
(assert-true   (tn) (string-ci=? "b" "B"))
(assert-false  (tn) (string-ci=? "b" "Z"))
(assert-false  (tn) (string-ci=? "b" "_"))
(assert-false  (tn) (string-ci=? "b" "a"))
(assert-true   (tn) (string-ci=? "b" "b"))
(assert-false  (tn) (string-ci=? "b" "z"))
(assert-false  (tn) (string-ci=? "b" "~"))
(assert-false  (tn) (string-ci=? "b" "\x7f"))
(tn "string-ci=? \"z\"")
(assert-false  (tn) (string-ci=? "z" ""))
(assert-false  (tn) (string-ci=? "z" "\n"))
(assert-false  (tn) (string-ci=? "z" " "))
(assert-false  (tn) (string-ci=? "z" "!"))
(assert-false  (tn) (string-ci=? "z" "0"))
(assert-false  (tn) (string-ci=? "z" "9"))
(assert-false  (tn) (string-ci=? "z" "A"))
(assert-false  (tn) (string-ci=? "z" "B"))
(assert-true   (tn) (string-ci=? "z" "Z"))
(assert-false  (tn) (string-ci=? "z" "_"))
(assert-false  (tn) (string-ci=? "z" "a"))
(assert-false  (tn) (string-ci=? "z" "b"))
(assert-true   (tn) (string-ci=? "z" "z"))
(assert-false  (tn) (string-ci=? "z" "~"))
(assert-false  (tn) (string-ci=? "z" "\x7f"))
(tn "string-ci=? \"~\"")
(assert-false  (tn) (string-ci=? "~" ""))
(assert-false  (tn) (string-ci=? "~" "\n"))
(assert-false  (tn) (string-ci=? "~" " "))
(assert-false  (tn) (string-ci=? "~" "!"))
(assert-false  (tn) (string-ci=? "~" "0"))
(assert-false  (tn) (string-ci=? "~" "9"))
(assert-false  (tn) (string-ci=? "~" "A"))
(assert-false  (tn) (string-ci=? "~" "B"))
(assert-false  (tn) (string-ci=? "~" "Z"))
(assert-false  (tn) (string-ci=? "~" "_"))
(assert-false  (tn) (string-ci=? "~" "a"))
(assert-false  (tn) (string-ci=? "~" "b"))
(assert-false  (tn) (string-ci=? "~" "z"))
(assert-true   (tn) (string-ci=? "~" "~"))
(assert-false  (tn) (string-ci=? "~" "\x7f"))
(tn "string-ci=? \"\\x7f\"")
(assert-false  (tn) (string-ci=? "\x7f" ""))
(assert-false  (tn) (string-ci=? "\x7f" "\n"))
(assert-false  (tn) (string-ci=? "\x7f" " "))
(assert-false  (tn) (string-ci=? "\x7f" "!"))
(assert-false  (tn) (string-ci=? "\x7f" "0"))
(assert-false  (tn) (string-ci=? "\x7f" "9"))
(assert-false  (tn) (string-ci=? "\x7f" "A"))
(assert-false  (tn) (string-ci=? "\x7f" "B"))
(assert-false  (tn) (string-ci=? "\x7f" "Z"))
(assert-false  (tn) (string-ci=? "\x7f" "_"))
(assert-false  (tn) (string-ci=? "\x7f" "a"))
(assert-false  (tn) (string-ci=? "\x7f" "b"))
(assert-false  (tn) (string-ci=? "\x7f" "z"))
(assert-false  (tn) (string-ci=? "\x7f" "~"))
(assert-true   (tn) (string-ci=? "\x7f" "\x7f"))
(tn "string-ci=? alphabets")
(assert-true   (tn) (string-ci=? "aa" "aa"))
(assert-true   (tn) (string-ci=? "aa" "AA"))
(assert-true   (tn) (string-ci=? "aa" "aA"))
(assert-true   (tn) (string-ci=? "aa" "Aa"))
(assert-true   (tn) (string-ci=? "AA" "aa"))
(assert-true   (tn) (string-ci=? "aA" "aa"))
(assert-true   (tn) (string-ci=? "Aa" "aa"))
(assert-true   (tn) (string-ci=? "abc" "abc"))
(assert-true   (tn) (string-ci=? "abc" "ABC"))
(assert-true   (tn) (string-ci=? "abc" "ABc"))
(assert-false  (tn) (string-ci=? "abc" "abcd"))
(assert-true   (tn) (string-ci=? "ABC" "abc"))
(assert-true   (tn) (string-ci=? "ABc" "abc"))
(assert-false  (tn) (string-ci=? "abcd" "abc"))

;; string<?
(tn "string<? \"\"")
(assert-false  (tn) (string<? "" ""))
(assert-true   (tn) (string<? "" "\n"))
(assert-true   (tn) (string<? "" " "))
(assert-true   (tn) (string<? "" "!"))
(assert-true   (tn) (string<? "" "0"))
(assert-true   (tn) (string<? "" "9"))
(assert-true   (tn) (string<? "" "A"))
(assert-true   (tn) (string<? "" "B"))
(assert-true   (tn) (string<? "" "Z"))
(assert-true   (tn) (string<? "" "_"))
(assert-true   (tn) (string<? "" "a"))
(assert-true   (tn) (string<? "" "b"))
(assert-true   (tn) (string<? "" "z"))
(assert-true   (tn) (string<? "" "~"))
(assert-true   (tn) (string<? "" "\x7f"))
(tn "string<? \"\\n\"")
(assert-false  (tn) (string<? "\n" ""))
(assert-false  (tn) (string<? "\n" "\n"))
(assert-true   (tn) (string<? "\n" " "))
(assert-true   (tn) (string<? "\n" "!"))
(assert-true   (tn) (string<? "\n" "0"))
(assert-true   (tn) (string<? "\n" "9"))
(assert-true   (tn) (string<? "\n" "A"))
(assert-true   (tn) (string<? "\n" "B"))
(assert-true   (tn) (string<? "\n" "Z"))
(assert-true   (tn) (string<? "\n" "_"))
(assert-true   (tn) (string<? "\n" "a"))
(assert-true   (tn) (string<? "\n" "b"))
(assert-true   (tn) (string<? "\n" "z"))
(assert-true   (tn) (string<? "\n" "~"))
(assert-true   (tn) (string<? "\n" "\x7f"))
(tn "string<? \" \"")
(assert-false  (tn) (string<? " " ""))
(assert-false  (tn) (string<? " " "\n"))
(assert-false  (tn) (string<? " " " "))
(assert-true   (tn) (string<? " " "!"))
(assert-true   (tn) (string<? " " "0"))
(assert-true   (tn) (string<? " " "9"))
(assert-true   (tn) (string<? " " "A"))
(assert-true   (tn) (string<? " " "B"))
(assert-true   (tn) (string<? " " "Z"))
(assert-true   (tn) (string<? " " "_"))
(assert-true   (tn) (string<? " " "a"))
(assert-true   (tn) (string<? " " "b"))
(assert-true   (tn) (string<? " " "z"))
(assert-true   (tn) (string<? " " "~"))
(assert-true   (tn) (string<? " " "\x7f"))
(tn "string<? \"!\"")
(assert-false  (tn) (string<? "!" ""))
(assert-false  (tn) (string<? "!" "\n"))
(assert-false  (tn) (string<? "!" " "))
(assert-false  (tn) (string<? "!" "!"))
(assert-true   (tn) (string<? "!" "0"))
(assert-true   (tn) (string<? "!" "9"))
(assert-true   (tn) (string<? "!" "A"))
(assert-true   (tn) (string<? "!" "B"))
(assert-true   (tn) (string<? "!" "Z"))
(assert-true   (tn) (string<? "!" "_"))
(assert-true   (tn) (string<? "!" "a"))
(assert-true   (tn) (string<? "!" "b"))
(assert-true   (tn) (string<? "!" "z"))
(assert-true   (tn) (string<? "!" "~"))
(assert-true   (tn) (string<? "!" "\x7f"))
(tn "string<? \"0\"")
(assert-false  (tn) (string<? "0" ""))
(assert-false  (tn) (string<? "0" "\n"))
(assert-false  (tn) (string<? "0" " "))
(assert-false  (tn) (string<? "0" "!"))
(assert-false  (tn) (string<? "0" "0"))
(assert-true   (tn) (string<? "0" "9"))
(assert-true   (tn) (string<? "0" "A"))
(assert-true   (tn) (string<? "0" "B"))
(assert-true   (tn) (string<? "0" "Z"))
(assert-true   (tn) (string<? "0" "_"))
(assert-true   (tn) (string<? "0" "a"))
(assert-true   (tn) (string<? "0" "b"))
(assert-true   (tn) (string<? "0" "z"))
(assert-true   (tn) (string<? "0" "~"))
(assert-true   (tn) (string<? "0" "\x7f"))
(tn "string<? \"9\"")
(assert-false  (tn) (string<? "9" ""))
(assert-false  (tn) (string<? "9" "\n"))
(assert-false  (tn) (string<? "9" " "))
(assert-false  (tn) (string<? "9" "!"))
(assert-false  (tn) (string<? "9" "0"))
(assert-false  (tn) (string<? "9" "9"))
(assert-true   (tn) (string<? "9" "A"))
(assert-true   (tn) (string<? "9" "B"))
(assert-true   (tn) (string<? "9" "Z"))
(assert-true   (tn) (string<? "9" "_"))
(assert-true   (tn) (string<? "9" "a"))
(assert-true   (tn) (string<? "9" "b"))
(assert-true   (tn) (string<? "9" "z"))
(assert-true   (tn) (string<? "9" "~"))
(assert-true   (tn) (string<? "9" "\x7f"))
(tn "string<? \"A\"")
(assert-false  (tn) (string<? "A" ""))
(assert-false  (tn) (string<? "A" "\n"))
(assert-false  (tn) (string<? "A" " "))
(assert-false  (tn) (string<? "A" "!"))
(assert-false  (tn) (string<? "A" "0"))
(assert-false  (tn) (string<? "A" "9"))
(assert-false  (tn) (string<? "A" "A"))
(assert-true   (tn) (string<? "A" "B"))
(assert-true   (tn) (string<? "A" "Z"))
(assert-true   (tn) (string<? "A" "_"))
(assert-true   (tn) (string<? "A" "a"))
(assert-true   (tn) (string<? "A" "b"))
(assert-true   (tn) (string<? "A" "z"))
(assert-true   (tn) (string<? "A" "~"))
(assert-true   (tn) (string<? "A" "\x7f"))
(tn "string<? \"B\"")
(assert-false  (tn) (string<? "B" ""))
(assert-false  (tn) (string<? "B" "\n"))
(assert-false  (tn) (string<? "B" " "))
(assert-false  (tn) (string<? "B" "!"))
(assert-false  (tn) (string<? "B" "0"))
(assert-false  (tn) (string<? "B" "9"))
(assert-false  (tn) (string<? "B" "A"))
(assert-false  (tn) (string<? "B" "B"))
(assert-true   (tn) (string<? "B" "Z"))
(assert-true   (tn) (string<? "B" "_"))
(assert-true   (tn) (string<? "B" "a"))
(assert-true   (tn) (string<? "B" "b"))
(assert-true   (tn) (string<? "B" "z"))
(assert-true   (tn) (string<? "B" "~"))
(assert-true   (tn) (string<? "B" "\x7f"))
(tn "string<? \"Z\"")
(assert-false  (tn) (string<? "Z" ""))
(assert-false  (tn) (string<? "Z" "\n"))
(assert-false  (tn) (string<? "Z" " "))
(assert-false  (tn) (string<? "Z" "!"))
(assert-false  (tn) (string<? "Z" "0"))
(assert-false  (tn) (string<? "Z" "9"))
(assert-false  (tn) (string<? "Z" "A"))
(assert-false  (tn) (string<? "Z" "B"))
(assert-false  (tn) (string<? "Z" "Z"))
(assert-true   (tn) (string<? "Z" "_"))
(assert-true   (tn) (string<? "Z" "a"))
(assert-true   (tn) (string<? "Z" "b"))
(assert-true   (tn) (string<? "Z" "z"))
(assert-true   (tn) (string<? "Z" "~"))
(assert-true   (tn) (string<? "Z" "\x7f"))
(tn "string<? \"_\"")
(assert-false  (tn) (string<? "_" ""))
(assert-false  (tn) (string<? "_" "\n"))
(assert-false  (tn) (string<? "_" " "))
(assert-false  (tn) (string<? "_" "!"))
(assert-false  (tn) (string<? "_" "0"))
(assert-false  (tn) (string<? "_" "9"))
(assert-false  (tn) (string<? "_" "A"))
(assert-false  (tn) (string<? "_" "B"))
(assert-false  (tn) (string<? "_" "Z"))
(assert-false  (tn) (string<? "_" "_"))
(assert-true   (tn) (string<? "_" "a"))
(assert-true   (tn) (string<? "_" "b"))
(assert-true   (tn) (string<? "_" "z"))
(assert-true   (tn) (string<? "_" "~"))
(assert-true   (tn) (string<? "_" "\x7f"))
(tn "string<? \"a\"")
(assert-false  (tn) (string<? "a" ""))
(assert-false  (tn) (string<? "a" "\n"))
(assert-false  (tn) (string<? "a" " "))
(assert-false  (tn) (string<? "a" "!"))
(assert-false  (tn) (string<? "a" "0"))
(assert-false  (tn) (string<? "a" "9"))
(assert-false  (tn) (string<? "a" "A"))
(assert-false  (tn) (string<? "a" "B"))
(assert-false  (tn) (string<? "a" "Z"))
(assert-false  (tn) (string<? "a" "_"))
(assert-false  (tn) (string<? "a" "a"))
(assert-true   (tn) (string<? "a" "b"))
(assert-true   (tn) (string<? "a" "z"))
(assert-true   (tn) (string<? "a" "~"))
(assert-true   (tn) (string<? "a" "\x7f"))
(tn "string<? \"b\"")
(assert-false  (tn) (string<? "b" ""))
(assert-false  (tn) (string<? "b" "\n"))
(assert-false  (tn) (string<? "b" " "))
(assert-false  (tn) (string<? "b" "!"))
(assert-false  (tn) (string<? "b" "0"))
(assert-false  (tn) (string<? "b" "9"))
(assert-false  (tn) (string<? "b" "A"))
(assert-false  (tn) (string<? "b" "B"))
(assert-false  (tn) (string<? "b" "Z"))
(assert-false  (tn) (string<? "b" "_"))
(assert-false  (tn) (string<? "b" "a"))
(assert-false  (tn) (string<? "b" "b"))
(assert-true   (tn) (string<? "b" "z"))
(assert-true   (tn) (string<? "b" "~"))
(assert-true   (tn) (string<? "b" "\x7f"))
(tn "string<? \"z\"")
(assert-false  (tn) (string<? "z" ""))
(assert-false  (tn) (string<? "z" "\n"))
(assert-false  (tn) (string<? "z" " "))
(assert-false  (tn) (string<? "z" "!"))
(assert-false  (tn) (string<? "z" "0"))
(assert-false  (tn) (string<? "z" "9"))
(assert-false  (tn) (string<? "z" "A"))
(assert-false  (tn) (string<? "z" "B"))
(assert-false  (tn) (string<? "z" "Z"))
(assert-false  (tn) (string<? "z" "_"))
(assert-false  (tn) (string<? "z" "a"))
(assert-false  (tn) (string<? "z" "b"))
(assert-false  (tn) (string<? "z" "z"))
(assert-true   (tn) (string<? "z" "~"))
(assert-true   (tn) (string<? "z" "\x7f"))
(tn "string<? \"~\"")
(assert-false  (tn) (string<? "~" ""))
(assert-false  (tn) (string<? "~" "\n"))
(assert-false  (tn) (string<? "~" " "))
(assert-false  (tn) (string<? "~" "!"))
(assert-false  (tn) (string<? "~" "0"))
(assert-false  (tn) (string<? "~" "9"))
(assert-false  (tn) (string<? "~" "A"))
(assert-false  (tn) (string<? "~" "B"))
(assert-false  (tn) (string<? "~" "Z"))
(assert-false  (tn) (string<? "~" "_"))
(assert-false  (tn) (string<? "~" "a"))
(assert-false  (tn) (string<? "~" "b"))
(assert-false  (tn) (string<? "~" "z"))
(assert-false  (tn) (string<? "~" "~"))
(assert-true   (tn) (string<? "~" "\x7f"))
(tn "string<? \"\\x7f\"")
(assert-false  (tn) (string<? "\x7f" ""))
(assert-false  (tn) (string<? "\x7f" "\n"))
(assert-false  (tn) (string<? "\x7f" " "))
(assert-false  (tn) (string<? "\x7f" "!"))
(assert-false  (tn) (string<? "\x7f" "0"))
(assert-false  (tn) (string<? "\x7f" "9"))
(assert-false  (tn) (string<? "\x7f" "A"))
(assert-false  (tn) (string<? "\x7f" "B"))
(assert-false  (tn) (string<? "\x7f" "Z"))
(assert-false  (tn) (string<? "\x7f" "_"))
(assert-false  (tn) (string<? "\x7f" "a"))
(assert-false  (tn) (string<? "\x7f" "b"))
(assert-false  (tn) (string<? "\x7f" "z"))
(assert-false  (tn) (string<? "\x7f" "~"))
(assert-false  (tn) (string<? "\x7f" "\x7f"))
(tn "string<? alphabets")
(assert-false  (tn) (string<? "aa" "aa"))
(assert-false  (tn) (string<? "aa" "AA"))
(assert-false  (tn) (string<? "aa" "aA"))
(assert-false  (tn) (string<? "aa" "Aa"))
(assert-true   (tn) (string<? "AA" "aa"))
(assert-true   (tn) (string<? "aA" "aa"))
(assert-true   (tn) (string<? "Aa" "aa"))
(assert-false  (tn) (string<? "abc" "abc"))
(assert-false  (tn) (string<? "abc" "ABC"))
(assert-false  (tn) (string<? "abc" "ABc"))
(assert-true   (tn) (string<? "abc" "abcd"))
(assert-true   (tn) (string<? "ABC" "abc"))
(assert-true   (tn) (string<? "ABc" "abc"))
(assert-false  (tn) (string<? "abcd" "abc"))

;; string>?
(tn "string>? \"\"")
(assert-false  (tn) (string>? "" ""))
(assert-false  (tn) (string>? "" "\n"))
(assert-false  (tn) (string>? "" " "))
(assert-false  (tn) (string>? "" "!"))
(assert-false  (tn) (string>? "" "0"))
(assert-false  (tn) (string>? "" "9"))
(assert-false  (tn) (string>? "" "A"))
(assert-false  (tn) (string>? "" "B"))
(assert-false  (tn) (string>? "" "Z"))
(assert-false  (tn) (string>? "" "_"))
(assert-false  (tn) (string>? "" "a"))
(assert-false  (tn) (string>? "" "b"))
(assert-false  (tn) (string>? "" "z"))
(assert-false  (tn) (string>? "" "~"))
(assert-false  (tn) (string>? "" "\x7f"))
(tn "string>? \"\\n\"")
(assert-true   (tn) (string>? "\n" ""))
(assert-false  (tn) (string>? "\n" "\n"))
(assert-false  (tn) (string>? "\n" " "))
(assert-false  (tn) (string>? "\n" "!"))
(assert-false  (tn) (string>? "\n" "0"))
(assert-false  (tn) (string>? "\n" "9"))
(assert-false  (tn) (string>? "\n" "A"))
(assert-false  (tn) (string>? "\n" "B"))
(assert-false  (tn) (string>? "\n" "Z"))
(assert-false  (tn) (string>? "\n" "_"))
(assert-false  (tn) (string>? "\n" "a"))
(assert-false  (tn) (string>? "\n" "b"))
(assert-false  (tn) (string>? "\n" "z"))
(assert-false  (tn) (string>? "\n" "~"))
(assert-false  (tn) (string>? "\n" "\x7f"))
(tn "string>? \" \"")
(assert-true   (tn) (string>? " " ""))
(assert-true   (tn) (string>? " " "\n"))
(assert-false  (tn) (string>? " " " "))
(assert-false  (tn) (string>? " " "!"))
(assert-false  (tn) (string>? " " "0"))
(assert-false  (tn) (string>? " " "9"))
(assert-false  (tn) (string>? " " "A"))
(assert-false  (tn) (string>? " " "B"))
(assert-false  (tn) (string>? " " "Z"))
(assert-false  (tn) (string>? " " "_"))
(assert-false  (tn) (string>? " " "a"))
(assert-false  (tn) (string>? " " "b"))
(assert-false  (tn) (string>? " " "z"))
(assert-false  (tn) (string>? " " "~"))
(assert-false  (tn) (string>? " " "\x7f"))
(tn "string>? \"!\"")
(assert-true   (tn) (string>? "!" ""))
(assert-true   (tn) (string>? "!" "\n"))
(assert-true   (tn) (string>? "!" " "))
(assert-false  (tn) (string>? "!" "!"))
(assert-false  (tn) (string>? "!" "0"))
(assert-false  (tn) (string>? "!" "9"))
(assert-false  (tn) (string>? "!" "A"))
(assert-false  (tn) (string>? "!" "B"))
(assert-false  (tn) (string>? "!" "Z"))
(assert-false  (tn) (string>? "!" "_"))
(assert-false  (tn) (string>? "!" "a"))
(assert-false  (tn) (string>? "!" "b"))
(assert-false  (tn) (string>? "!" "z"))
(assert-false  (tn) (string>? "!" "~"))
(assert-false  (tn) (string>? "!" "\x7f"))
(tn "string>? \"0\"")
(assert-true   (tn) (string>? "0" ""))
(assert-true   (tn) (string>? "0" "\n"))
(assert-true   (tn) (string>? "0" " "))
(assert-true   (tn) (string>? "0" "!"))
(assert-false  (tn) (string>? "0" "0"))
(assert-false  (tn) (string>? "0" "9"))
(assert-false  (tn) (string>? "0" "A"))
(assert-false  (tn) (string>? "0" "B"))
(assert-false  (tn) (string>? "0" "Z"))
(assert-false  (tn) (string>? "0" "_"))
(assert-false  (tn) (string>? "0" "a"))
(assert-false  (tn) (string>? "0" "b"))
(assert-false  (tn) (string>? "0" "z"))
(assert-false  (tn) (string>? "0" "~"))
(assert-false  (tn) (string>? "0" "\x7f"))
(tn "string>? \"9\"")
(assert-true   (tn) (string>? "9" ""))
(assert-true   (tn) (string>? "9" "\n"))
(assert-true   (tn) (string>? "9" " "))
(assert-true   (tn) (string>? "9" "!"))
(assert-true   (tn) (string>? "9" "0"))
(assert-false  (tn) (string>? "9" "9"))
(assert-false  (tn) (string>? "9" "A"))
(assert-false  (tn) (string>? "9" "B"))
(assert-false  (tn) (string>? "9" "Z"))
(assert-false  (tn) (string>? "9" "_"))
(assert-false  (tn) (string>? "9" "a"))
(assert-false  (tn) (string>? "9" "b"))
(assert-false  (tn) (string>? "9" "z"))
(assert-false  (tn) (string>? "9" "~"))
(assert-false  (tn) (string>? "9" "\x7f"))
(tn "string>? \"A\"")
(assert-true   (tn) (string>? "A" ""))
(assert-true   (tn) (string>? "A" "\n"))
(assert-true   (tn) (string>? "A" " "))
(assert-true   (tn) (string>? "A" "!"))
(assert-true   (tn) (string>? "A" "0"))
(assert-true   (tn) (string>? "A" "9"))
(assert-false  (tn) (string>? "A" "A"))
(assert-false  (tn) (string>? "A" "B"))
(assert-false  (tn) (string>? "A" "Z"))
(assert-false  (tn) (string>? "A" "_"))
(assert-false  (tn) (string>? "A" "a"))
(assert-false  (tn) (string>? "A" "b"))
(assert-false  (tn) (string>? "A" "z"))
(assert-false  (tn) (string>? "A" "~"))
(assert-false  (tn) (string>? "A" "\x7f"))
(tn "string>? \"B\"")
(assert-true   (tn) (string>? "B" ""))
(assert-true   (tn) (string>? "B" "\n"))
(assert-true   (tn) (string>? "B" " "))
(assert-true   (tn) (string>? "B" "!"))
(assert-true   (tn) (string>? "B" "0"))
(assert-true   (tn) (string>? "B" "9"))
(assert-true   (tn) (string>? "B" "A"))
(assert-false  (tn) (string>? "B" "B"))
(assert-false  (tn) (string>? "B" "Z"))
(assert-false  (tn) (string>? "B" "_"))
(assert-false  (tn) (string>? "B" "a"))
(assert-false  (tn) (string>? "B" "b"))
(assert-false  (tn) (string>? "B" "z"))
(assert-false  (tn) (string>? "B" "~"))
(assert-false  (tn) (string>? "B" "\x7f"))
(tn "string>? \"Z\"")
(assert-true   (tn) (string>? "Z" ""))
(assert-true   (tn) (string>? "Z" "\n"))
(assert-true   (tn) (string>? "Z" " "))
(assert-true   (tn) (string>? "Z" "!"))
(assert-true   (tn) (string>? "Z" "0"))
(assert-true   (tn) (string>? "Z" "9"))
(assert-true   (tn) (string>? "Z" "A"))
(assert-true   (tn) (string>? "Z" "B"))
(assert-false  (tn) (string>? "Z" "Z"))
(assert-false  (tn) (string>? "Z" "_"))
(assert-false  (tn) (string>? "Z" "a"))
(assert-false  (tn) (string>? "Z" "b"))
(assert-false  (tn) (string>? "Z" "z"))
(assert-false  (tn) (string>? "Z" "~"))
(assert-false  (tn) (string>? "Z" "\x7f"))
(tn "string>? \"_\"")
(assert-true   (tn) (string>? "_" ""))
(assert-true   (tn) (string>? "_" "\n"))
(assert-true   (tn) (string>? "_" " "))
(assert-true   (tn) (string>? "_" "!"))
(assert-true   (tn) (string>? "_" "0"))
(assert-true   (tn) (string>? "_" "9"))
(assert-true   (tn) (string>? "_" "A"))
(assert-true   (tn) (string>? "_" "B"))
(assert-true   (tn) (string>? "_" "Z"))
(assert-false  (tn) (string>? "_" "_"))
(assert-false  (tn) (string>? "_" "a"))
(assert-false  (tn) (string>? "_" "b"))
(assert-false  (tn) (string>? "_" "z"))
(assert-false  (tn) (string>? "_" "~"))
(assert-false  (tn) (string>? "_" "\x7f"))
(tn "string>? \"a\"")
(assert-true   (tn) (string>? "a" ""))
(assert-true   (tn) (string>? "a" "\n"))
(assert-true   (tn) (string>? "a" " "))
(assert-true   (tn) (string>? "a" "!"))
(assert-true   (tn) (string>? "a" "0"))
(assert-true   (tn) (string>? "a" "9"))
(assert-true   (tn) (string>? "a" "A"))
(assert-true   (tn) (string>? "a" "B"))
(assert-true   (tn) (string>? "a" "Z"))
(assert-true   (tn) (string>? "a" "_"))
(assert-false  (tn) (string>? "a" "a"))
(assert-false  (tn) (string>? "a" "b"))
(assert-false  (tn) (string>? "a" "z"))
(assert-false  (tn) (string>? "a" "~"))
(assert-false  (tn) (string>? "a" "\x7f"))
(tn "string>? \"b\"")
(assert-true   (tn) (string>? "b" ""))
(assert-true   (tn) (string>? "b" "\n"))
(assert-true   (tn) (string>? "b" " "))
(assert-true   (tn) (string>? "b" "!"))
(assert-true   (tn) (string>? "b" "0"))
(assert-true   (tn) (string>? "b" "9"))
(assert-true   (tn) (string>? "b" "A"))
(assert-true   (tn) (string>? "b" "B"))
(assert-true   (tn) (string>? "b" "Z"))
(assert-true   (tn) (string>? "b" "_"))
(assert-true   (tn) (string>? "b" "a"))
(assert-false  (tn) (string>? "b" "b"))
(assert-false  (tn) (string>? "b" "z"))
(assert-false  (tn) (string>? "b" "~"))
(assert-false  (tn) (string>? "b" "\x7f"))
(tn "string>? \"z\"")
(assert-true   (tn) (string>? "z" ""))
(assert-true   (tn) (string>? "z" "\n"))
(assert-true   (tn) (string>? "z" " "))
(assert-true   (tn) (string>? "z" "!"))
(assert-true   (tn) (string>? "z" "0"))
(assert-true   (tn) (string>? "z" "9"))
(assert-true   (tn) (string>? "z" "A"))
(assert-true   (tn) (string>? "z" "B"))
(assert-true   (tn) (string>? "z" "Z"))
(assert-true   (tn) (string>? "z" "_"))
(assert-true   (tn) (string>? "z" "a"))
(assert-true   (tn) (string>? "z" "b"))
(assert-false  (tn) (string>? "z" "z"))
(assert-false  (tn) (string>? "z" "~"))
(assert-false  (tn) (string>? "z" "\x7f"))
(tn "string>? \"~\"")
(assert-true   (tn) (string>? "~" ""))
(assert-true   (tn) (string>? "~" "\n"))
(assert-true   (tn) (string>? "~" " "))
(assert-true   (tn) (string>? "~" "!"))
(assert-true   (tn) (string>? "~" "0"))
(assert-true   (tn) (string>? "~" "9"))
(assert-true   (tn) (string>? "~" "A"))
(assert-true   (tn) (string>? "~" "B"))
(assert-true   (tn) (string>? "~" "Z"))
(assert-true   (tn) (string>? "~" "_"))
(assert-true   (tn) (string>? "~" "a"))
(assert-true   (tn) (string>? "~" "b"))
(assert-true   (tn) (string>? "~" "z"))
(assert-false  (tn) (string>? "~" "~"))
(assert-false  (tn) (string>? "~" "\x7f"))
(tn "string>? \"\\x7f\"")
(assert-true   (tn) (string>? "\x7f" ""))
(assert-true   (tn) (string>? "\x7f" "\n"))
(assert-true   (tn) (string>? "\x7f" " "))
(assert-true   (tn) (string>? "\x7f" "!"))
(assert-true   (tn) (string>? "\x7f" "0"))
(assert-true   (tn) (string>? "\x7f" "9"))
(assert-true   (tn) (string>? "\x7f" "A"))
(assert-true   (tn) (string>? "\x7f" "B"))
(assert-true   (tn) (string>? "\x7f" "Z"))
(assert-true   (tn) (string>? "\x7f" "_"))
(assert-true   (tn) (string>? "\x7f" "a"))
(assert-true   (tn) (string>? "\x7f" "b"))
(assert-true   (tn) (string>? "\x7f" "z"))
(assert-true   (tn) (string>? "\x7f" "~"))
(assert-false  (tn) (string>? "\x7f" "\x7f"))
(tn "string>? alphabets")
(assert-false  (tn) (string>? "aa" "aa"))
(assert-true   (tn) (string>? "aa" "AA"))
(assert-true   (tn) (string>? "aa" "aA"))
(assert-true   (tn) (string>? "aa" "Aa"))
(assert-false  (tn) (string>? "AA" "aa"))
(assert-false  (tn) (string>? "aA" "aa"))
(assert-false  (tn) (string>? "Aa" "aa"))
(assert-false  (tn) (string>? "abc" "abc"))
(assert-true   (tn) (string>? "abc" "ABC"))
(assert-true   (tn) (string>? "abc" "ABc"))
(assert-false  (tn) (string>? "abc" "abcd"))
(assert-false  (tn) (string>? "ABC" "abc"))
(assert-false  (tn) (string>? "ABc" "abc"))
(assert-true   (tn) (string>? "abcd" "abc"))

;; string<=?
(tn "string<=? \"\"")
(assert-true   (tn) (string<=? "" ""))
(assert-true   (tn) (string<=? "" "\n"))
(assert-true   (tn) (string<=? "" " "))
(assert-true   (tn) (string<=? "" "!"))
(assert-true   (tn) (string<=? "" "0"))
(assert-true   (tn) (string<=? "" "9"))
(assert-true   (tn) (string<=? "" "A"))
(assert-true   (tn) (string<=? "" "B"))
(assert-true   (tn) (string<=? "" "Z"))
(assert-true   (tn) (string<=? "" "_"))
(assert-true   (tn) (string<=? "" "a"))
(assert-true   (tn) (string<=? "" "b"))
(assert-true   (tn) (string<=? "" "z"))
(assert-true   (tn) (string<=? "" "~"))
(assert-true   (tn) (string<=? "" "\x7f"))
(tn "string<=? \"\\n\"")
(assert-false  (tn) (string<=? "\n" ""))
(assert-true   (tn) (string<=? "\n" "\n"))
(assert-true   (tn) (string<=? "\n" " "))
(assert-true   (tn) (string<=? "\n" "!"))
(assert-true   (tn) (string<=? "\n" "0"))
(assert-true   (tn) (string<=? "\n" "9"))
(assert-true   (tn) (string<=? "\n" "A"))
(assert-true   (tn) (string<=? "\n" "B"))
(assert-true   (tn) (string<=? "\n" "Z"))
(assert-true   (tn) (string<=? "\n" "_"))
(assert-true   (tn) (string<=? "\n" "a"))
(assert-true   (tn) (string<=? "\n" "b"))
(assert-true   (tn) (string<=? "\n" "z"))
(assert-true   (tn) (string<=? "\n" "~"))
(assert-true   (tn) (string<=? "\n" "\x7f"))
(tn "string<=? \" \"")
(assert-false  (tn) (string<=? " " ""))
(assert-false  (tn) (string<=? " " "\n"))
(assert-true   (tn) (string<=? " " " "))
(assert-true   (tn) (string<=? " " "!"))
(assert-true   (tn) (string<=? " " "0"))
(assert-true   (tn) (string<=? " " "9"))
(assert-true   (tn) (string<=? " " "A"))
(assert-true   (tn) (string<=? " " "B"))
(assert-true   (tn) (string<=? " " "Z"))
(assert-true   (tn) (string<=? " " "_"))
(assert-true   (tn) (string<=? " " "a"))
(assert-true   (tn) (string<=? " " "b"))
(assert-true   (tn) (string<=? " " "z"))
(assert-true   (tn) (string<=? " " "~"))
(assert-true   (tn) (string<=? " " "\x7f"))
(tn "string<=? \"!\"")
(assert-false  (tn) (string<=? "!" ""))
(assert-false  (tn) (string<=? "!" "\n"))
(assert-false  (tn) (string<=? "!" " "))
(assert-true   (tn) (string<=? "!" "!"))
(assert-true   (tn) (string<=? "!" "0"))
(assert-true   (tn) (string<=? "!" "9"))
(assert-true   (tn) (string<=? "!" "A"))
(assert-true   (tn) (string<=? "!" "B"))
(assert-true   (tn) (string<=? "!" "Z"))
(assert-true   (tn) (string<=? "!" "_"))
(assert-true   (tn) (string<=? "!" "a"))
(assert-true   (tn) (string<=? "!" "b"))
(assert-true   (tn) (string<=? "!" "z"))
(assert-true   (tn) (string<=? "!" "~"))
(assert-true   (tn) (string<=? "!" "\x7f"))
(tn "string<=? \"0\"")
(assert-false  (tn) (string<=? "0" ""))
(assert-false  (tn) (string<=? "0" "\n"))
(assert-false  (tn) (string<=? "0" " "))
(assert-false  (tn) (string<=? "0" "!"))
(assert-true   (tn) (string<=? "0" "0"))
(assert-true   (tn) (string<=? "0" "9"))
(assert-true   (tn) (string<=? "0" "A"))
(assert-true   (tn) (string<=? "0" "B"))
(assert-true   (tn) (string<=? "0" "Z"))
(assert-true   (tn) (string<=? "0" "_"))
(assert-true   (tn) (string<=? "0" "a"))
(assert-true   (tn) (string<=? "0" "b"))
(assert-true   (tn) (string<=? "0" "z"))
(assert-true   (tn) (string<=? "0" "~"))
(assert-true   (tn) (string<=? "0" "\x7f"))
(tn "string<=? \"9\"")
(assert-false  (tn) (string<=? "9" ""))
(assert-false  (tn) (string<=? "9" "\n"))
(assert-false  (tn) (string<=? "9" " "))
(assert-false  (tn) (string<=? "9" "!"))
(assert-false  (tn) (string<=? "9" "0"))
(assert-true   (tn) (string<=? "9" "9"))
(assert-true   (tn) (string<=? "9" "A"))
(assert-true   (tn) (string<=? "9" "B"))
(assert-true   (tn) (string<=? "9" "Z"))
(assert-true   (tn) (string<=? "9" "_"))
(assert-true   (tn) (string<=? "9" "a"))
(assert-true   (tn) (string<=? "9" "b"))
(assert-true   (tn) (string<=? "9" "z"))
(assert-true   (tn) (string<=? "9" "~"))
(assert-true   (tn) (string<=? "9" "\x7f"))
(tn "string<=? \"A\"")
(assert-false  (tn) (string<=? "A" ""))
(assert-false  (tn) (string<=? "A" "\n"))
(assert-false  (tn) (string<=? "A" " "))
(assert-false  (tn) (string<=? "A" "!"))
(assert-false  (tn) (string<=? "A" "0"))
(assert-false  (tn) (string<=? "A" "9"))
(assert-true   (tn) (string<=? "A" "A"))
(assert-true   (tn) (string<=? "A" "B"))
(assert-true   (tn) (string<=? "A" "Z"))
(assert-true   (tn) (string<=? "A" "_"))
(assert-true   (tn) (string<=? "A" "a"))
(assert-true   (tn) (string<=? "A" "b"))
(assert-true   (tn) (string<=? "A" "z"))
(assert-true   (tn) (string<=? "A" "~"))
(assert-true   (tn) (string<=? "A" "\x7f"))
(tn "string<=? \"B\"")
(assert-false  (tn) (string<=? "B" ""))
(assert-false  (tn) (string<=? "B" "\n"))
(assert-false  (tn) (string<=? "B" " "))
(assert-false  (tn) (string<=? "B" "!"))
(assert-false  (tn) (string<=? "B" "0"))
(assert-false  (tn) (string<=? "B" "9"))
(assert-false  (tn) (string<=? "B" "A"))
(assert-true   (tn) (string<=? "B" "B"))
(assert-true   (tn) (string<=? "B" "Z"))
(assert-true   (tn) (string<=? "B" "_"))
(assert-true   (tn) (string<=? "B" "a"))
(assert-true   (tn) (string<=? "B" "b"))
(assert-true   (tn) (string<=? "B" "z"))
(assert-true   (tn) (string<=? "B" "~"))
(assert-true   (tn) (string<=? "B" "\x7f"))
(tn "string<=? \"Z\"")
(assert-false  (tn) (string<=? "Z" ""))
(assert-false  (tn) (string<=? "Z" "\n"))
(assert-false  (tn) (string<=? "Z" " "))
(assert-false  (tn) (string<=? "Z" "!"))
(assert-false  (tn) (string<=? "Z" "0"))
(assert-false  (tn) (string<=? "Z" "9"))
(assert-false  (tn) (string<=? "Z" "A"))
(assert-false  (tn) (string<=? "Z" "B"))
(assert-true   (tn) (string<=? "Z" "Z"))
(assert-true   (tn) (string<=? "Z" "_"))
(assert-true   (tn) (string<=? "Z" "a"))
(assert-true   (tn) (string<=? "Z" "b"))
(assert-true   (tn) (string<=? "Z" "z"))
(assert-true   (tn) (string<=? "Z" "~"))
(assert-true   (tn) (string<=? "Z" "\x7f"))
(tn "string<=? \"_\"")
(assert-false  (tn) (string<=? "_" ""))
(assert-false  (tn) (string<=? "_" "\n"))
(assert-false  (tn) (string<=? "_" " "))
(assert-false  (tn) (string<=? "_" "!"))
(assert-false  (tn) (string<=? "_" "0"))
(assert-false  (tn) (string<=? "_" "9"))
(assert-false  (tn) (string<=? "_" "A"))
(assert-false  (tn) (string<=? "_" "B"))
(assert-false  (tn) (string<=? "_" "Z"))
(assert-true   (tn) (string<=? "_" "_"))
(assert-true   (tn) (string<=? "_" "a"))
(assert-true   (tn) (string<=? "_" "b"))
(assert-true   (tn) (string<=? "_" "z"))
(assert-true   (tn) (string<=? "_" "~"))
(assert-true   (tn) (string<=? "_" "\x7f"))
(tn "string<=? \"a\"")
(assert-false  (tn) (string<=? "a" ""))
(assert-false  (tn) (string<=? "a" "\n"))
(assert-false  (tn) (string<=? "a" " "))
(assert-false  (tn) (string<=? "a" "!"))
(assert-false  (tn) (string<=? "a" "0"))
(assert-false  (tn) (string<=? "a" "9"))
(assert-false  (tn) (string<=? "a" "A"))
(assert-false  (tn) (string<=? "a" "B"))
(assert-false  (tn) (string<=? "a" "Z"))
(assert-false  (tn) (string<=? "a" "_"))
(assert-true   (tn) (string<=? "a" "a"))
(assert-true   (tn) (string<=? "a" "b"))
(assert-true   (tn) (string<=? "a" "z"))
(assert-true   (tn) (string<=? "a" "~"))
(assert-true   (tn) (string<=? "a" "\x7f"))
(tn "string<=? \"b\"")
(assert-false  (tn) (string<=? "b" ""))
(assert-false  (tn) (string<=? "b" "\n"))
(assert-false  (tn) (string<=? "b" " "))
(assert-false  (tn) (string<=? "b" "!"))
(assert-false  (tn) (string<=? "b" "0"))
(assert-false  (tn) (string<=? "b" "9"))
(assert-false  (tn) (string<=? "b" "A"))
(assert-false  (tn) (string<=? "b" "B"))
(assert-false  (tn) (string<=? "b" "Z"))
(assert-false  (tn) (string<=? "b" "_"))
(assert-false  (tn) (string<=? "b" "a"))
(assert-true   (tn) (string<=? "b" "b"))
(assert-true   (tn) (string<=? "b" "z"))
(assert-true   (tn) (string<=? "b" "~"))
(assert-true   (tn) (string<=? "b" "\x7f"))
(tn "string<=? \"z\"")
(assert-false  (tn) (string<=? "z" ""))
(assert-false  (tn) (string<=? "z" "\n"))
(assert-false  (tn) (string<=? "z" " "))
(assert-false  (tn) (string<=? "z" "!"))
(assert-false  (tn) (string<=? "z" "0"))
(assert-false  (tn) (string<=? "z" "9"))
(assert-false  (tn) (string<=? "z" "A"))
(assert-false  (tn) (string<=? "z" "B"))
(assert-false  (tn) (string<=? "z" "Z"))
(assert-false  (tn) (string<=? "z" "_"))
(assert-false  (tn) (string<=? "z" "a"))
(assert-false  (tn) (string<=? "z" "b"))
(assert-true   (tn) (string<=? "z" "z"))
(assert-true   (tn) (string<=? "z" "~"))
(assert-true   (tn) (string<=? "z" "\x7f"))
(tn "string<=? \"~\"")
(assert-false  (tn) (string<=? "~" ""))
(assert-false  (tn) (string<=? "~" "\n"))
(assert-false  (tn) (string<=? "~" " "))
(assert-false  (tn) (string<=? "~" "!"))
(assert-false  (tn) (string<=? "~" "0"))
(assert-false  (tn) (string<=? "~" "9"))
(assert-false  (tn) (string<=? "~" "A"))
(assert-false  (tn) (string<=? "~" "B"))
(assert-false  (tn) (string<=? "~" "Z"))
(assert-false  (tn) (string<=? "~" "_"))
(assert-false  (tn) (string<=? "~" "a"))
(assert-false  (tn) (string<=? "~" "b"))
(assert-false  (tn) (string<=? "~" "z"))
(assert-true   (tn) (string<=? "~" "~"))
(assert-true   (tn) (string<=? "~" "\x7f"))
(tn "string<=? \"\\x7f\"")
(assert-false  (tn) (string<=? "\x7f" ""))
(assert-false  (tn) (string<=? "\x7f" "\n"))
(assert-false  (tn) (string<=? "\x7f" " "))
(assert-false  (tn) (string<=? "\x7f" "!"))
(assert-false  (tn) (string<=? "\x7f" "0"))
(assert-false  (tn) (string<=? "\x7f" "9"))
(assert-false  (tn) (string<=? "\x7f" "A"))
(assert-false  (tn) (string<=? "\x7f" "B"))
(assert-false  (tn) (string<=? "\x7f" "Z"))
(assert-false  (tn) (string<=? "\x7f" "_"))
(assert-false  (tn) (string<=? "\x7f" "a"))
(assert-false  (tn) (string<=? "\x7f" "b"))
(assert-false  (tn) (string<=? "\x7f" "z"))
(assert-false  (tn) (string<=? "\x7f" "~"))
(assert-true   (tn) (string<=? "\x7f" "\x7f"))
(tn "string<=? alphabets")
(assert-true   (tn) (string<=? "aa" "aa"))
(assert-false  (tn) (string<=? "aa" "AA"))
(assert-false  (tn) (string<=? "aa" "aA"))
(assert-false  (tn) (string<=? "aa" "Aa"))
(assert-true   (tn) (string<=? "AA" "aa"))
(assert-true   (tn) (string<=? "aA" "aa"))
(assert-true   (tn) (string<=? "Aa" "aa"))
(assert-true   (tn) (string<=? "abc" "abc"))
(assert-false  (tn) (string<=? "abc" "ABC"))
(assert-false  (tn) (string<=? "abc" "ABc"))
(assert-true   (tn) (string<=? "abc" "abcd"))
(assert-true   (tn) (string<=? "ABC" "abc"))
(assert-true   (tn) (string<=? "ABc" "abc"))
(assert-false  (tn) (string<=? "abcd" "abc"))

;; string>=?
(tn "string>=? \"\"")
(assert-true   (tn) (string>=? "" ""))
(assert-false  (tn) (string>=? "" "\n"))
(assert-false  (tn) (string>=? "" " "))
(assert-false  (tn) (string>=? "" "!"))
(assert-false  (tn) (string>=? "" "0"))
(assert-false  (tn) (string>=? "" "9"))
(assert-false  (tn) (string>=? "" "A"))
(assert-false  (tn) (string>=? "" "B"))
(assert-false  (tn) (string>=? "" "Z"))
(assert-false  (tn) (string>=? "" "_"))
(assert-false  (tn) (string>=? "" "a"))
(assert-false  (tn) (string>=? "" "b"))
(assert-false  (tn) (string>=? "" "z"))
(assert-false  (tn) (string>=? "" "~"))
(assert-false  (tn) (string>=? "" "\x7f"))
(tn "string>=? \"\\n\"")
(assert-true   (tn) (string>=? "\n" ""))
(assert-true   (tn) (string>=? "\n" "\n"))
(assert-false  (tn) (string>=? "\n" " "))
(assert-false  (tn) (string>=? "\n" "!"))
(assert-false  (tn) (string>=? "\n" "0"))
(assert-false  (tn) (string>=? "\n" "9"))
(assert-false  (tn) (string>=? "\n" "A"))
(assert-false  (tn) (string>=? "\n" "B"))
(assert-false  (tn) (string>=? "\n" "Z"))
(assert-false  (tn) (string>=? "\n" "_"))
(assert-false  (tn) (string>=? "\n" "a"))
(assert-false  (tn) (string>=? "\n" "b"))
(assert-false  (tn) (string>=? "\n" "z"))
(assert-false  (tn) (string>=? "\n" "~"))
(assert-false  (tn) (string>=? "\n" "\x7f"))
(tn "string>=? \" \"")
(assert-true   (tn) (string>=? " " ""))
(assert-true   (tn) (string>=? " " "\n"))
(assert-true   (tn) (string>=? " " " "))
(assert-false  (tn) (string>=? " " "!"))
(assert-false  (tn) (string>=? " " "0"))
(assert-false  (tn) (string>=? " " "9"))
(assert-false  (tn) (string>=? " " "A"))
(assert-false  (tn) (string>=? " " "B"))
(assert-false  (tn) (string>=? " " "Z"))
(assert-false  (tn) (string>=? " " "_"))
(assert-false  (tn) (string>=? " " "a"))
(assert-false  (tn) (string>=? " " "b"))
(assert-false  (tn) (string>=? " " "z"))
(assert-false  (tn) (string>=? " " "~"))
(assert-false  (tn) (string>=? " " "\x7f"))
(tn "string>=? \"!\"")
(assert-true   (tn) (string>=? "!" ""))
(assert-true   (tn) (string>=? "!" "\n"))
(assert-true   (tn) (string>=? "!" " "))
(assert-true   (tn) (string>=? "!" "!"))
(assert-false  (tn) (string>=? "!" "0"))
(assert-false  (tn) (string>=? "!" "9"))
(assert-false  (tn) (string>=? "!" "A"))
(assert-false  (tn) (string>=? "!" "B"))
(assert-false  (tn) (string>=? "!" "Z"))
(assert-false  (tn) (string>=? "!" "_"))
(assert-false  (tn) (string>=? "!" "a"))
(assert-false  (tn) (string>=? "!" "b"))
(assert-false  (tn) (string>=? "!" "z"))
(assert-false  (tn) (string>=? "!" "~"))
(assert-false  (tn) (string>=? "!" "\x7f"))
(tn "string>=? \"0\"")
(assert-true   (tn) (string>=? "0" ""))
(assert-true   (tn) (string>=? "0" "\n"))
(assert-true   (tn) (string>=? "0" " "))
(assert-true   (tn) (string>=? "0" "!"))
(assert-true   (tn) (string>=? "0" "0"))
(assert-false  (tn) (string>=? "0" "9"))
(assert-false  (tn) (string>=? "0" "A"))
(assert-false  (tn) (string>=? "0" "B"))
(assert-false  (tn) (string>=? "0" "Z"))
(assert-false  (tn) (string>=? "0" "_"))
(assert-false  (tn) (string>=? "0" "a"))
(assert-false  (tn) (string>=? "0" "b"))
(assert-false  (tn) (string>=? "0" "z"))
(assert-false  (tn) (string>=? "0" "~"))
(assert-false  (tn) (string>=? "0" "\x7f"))
(tn "string>=? \"9\"")
(assert-true   (tn) (string>=? "9" ""))
(assert-true   (tn) (string>=? "9" "\n"))
(assert-true   (tn) (string>=? "9" " "))
(assert-true   (tn) (string>=? "9" "!"))
(assert-true   (tn) (string>=? "9" "0"))
(assert-true   (tn) (string>=? "9" "9"))
(assert-false  (tn) (string>=? "9" "A"))
(assert-false  (tn) (string>=? "9" "B"))
(assert-false  (tn) (string>=? "9" "Z"))
(assert-false  (tn) (string>=? "9" "_"))
(assert-false  (tn) (string>=? "9" "a"))
(assert-false  (tn) (string>=? "9" "b"))
(assert-false  (tn) (string>=? "9" "z"))
(assert-false  (tn) (string>=? "9" "~"))
(assert-false  (tn) (string>=? "9" "\x7f"))
(tn "string>=? \"A\"")
(assert-true   (tn) (string>=? "A" ""))
(assert-true   (tn) (string>=? "A" "\n"))
(assert-true   (tn) (string>=? "A" " "))
(assert-true   (tn) (string>=? "A" "!"))
(assert-true   (tn) (string>=? "A" "0"))
(assert-true   (tn) (string>=? "A" "9"))
(assert-true   (tn) (string>=? "A" "A"))
(assert-false  (tn) (string>=? "A" "B"))
(assert-false  (tn) (string>=? "A" "Z"))
(assert-false  (tn) (string>=? "A" "_"))
(assert-false  (tn) (string>=? "A" "a"))
(assert-false  (tn) (string>=? "A" "b"))
(assert-false  (tn) (string>=? "A" "z"))
(assert-false  (tn) (string>=? "A" "~"))
(assert-false  (tn) (string>=? "A" "\x7f"))
(tn "string>=? \"B\"")
(assert-true   (tn) (string>=? "B" ""))
(assert-true   (tn) (string>=? "B" "\n"))
(assert-true   (tn) (string>=? "B" " "))
(assert-true   (tn) (string>=? "B" "!"))
(assert-true   (tn) (string>=? "B" "0"))
(assert-true   (tn) (string>=? "B" "9"))
(assert-true   (tn) (string>=? "B" "A"))
(assert-true   (tn) (string>=? "B" "B"))
(assert-false  (tn) (string>=? "B" "Z"))
(assert-false  (tn) (string>=? "B" "_"))
(assert-false  (tn) (string>=? "B" "a"))
(assert-false  (tn) (string>=? "B" "b"))
(assert-false  (tn) (string>=? "B" "z"))
(assert-false  (tn) (string>=? "B" "~"))
(assert-false  (tn) (string>=? "B" "\x7f"))
(tn "string>=? \"Z\"")
(assert-true   (tn) (string>=? "Z" ""))
(assert-true   (tn) (string>=? "Z" "\n"))
(assert-true   (tn) (string>=? "Z" " "))
(assert-true   (tn) (string>=? "Z" "!"))
(assert-true   (tn) (string>=? "Z" "0"))
(assert-true   (tn) (string>=? "Z" "9"))
(assert-true   (tn) (string>=? "Z" "A"))
(assert-true   (tn) (string>=? "Z" "B"))
(assert-true   (tn) (string>=? "Z" "Z"))
(assert-false  (tn) (string>=? "Z" "_"))
(assert-false  (tn) (string>=? "Z" "a"))
(assert-false  (tn) (string>=? "Z" "b"))
(assert-false  (tn) (string>=? "Z" "z"))
(assert-false  (tn) (string>=? "Z" "~"))
(assert-false  (tn) (string>=? "Z" "\x7f"))
(tn "string>=? \"_\"")
(assert-true   (tn) (string>=? "_" ""))
(assert-true   (tn) (string>=? "_" "\n"))
(assert-true   (tn) (string>=? "_" " "))
(assert-true   (tn) (string>=? "_" "!"))
(assert-true   (tn) (string>=? "_" "0"))
(assert-true   (tn) (string>=? "_" "9"))
(assert-true   (tn) (string>=? "_" "A"))
(assert-true   (tn) (string>=? "_" "B"))
(assert-true   (tn) (string>=? "_" "Z"))
(assert-true   (tn) (string>=? "_" "_"))
(assert-false  (tn) (string>=? "_" "a"))
(assert-false  (tn) (string>=? "_" "b"))
(assert-false  (tn) (string>=? "_" "z"))
(assert-false  (tn) (string>=? "_" "~"))
(assert-false  (tn) (string>=? "_" "\x7f"))
(tn "string>=? \"a\"")
(assert-true   (tn) (string>=? "a" ""))
(assert-true   (tn) (string>=? "a" "\n"))
(assert-true   (tn) (string>=? "a" " "))
(assert-true   (tn) (string>=? "a" "!"))
(assert-true   (tn) (string>=? "a" "0"))
(assert-true   (tn) (string>=? "a" "9"))
(assert-true   (tn) (string>=? "a" "A"))
(assert-true   (tn) (string>=? "a" "B"))
(assert-true   (tn) (string>=? "a" "Z"))
(assert-true   (tn) (string>=? "a" "_"))
(assert-true   (tn) (string>=? "a" "a"))
(assert-false  (tn) (string>=? "a" "b"))
(assert-false  (tn) (string>=? "a" "z"))
(assert-false  (tn) (string>=? "a" "~"))
(assert-false  (tn) (string>=? "a" "\x7f"))
(tn "string>=? \"b\"")
(assert-true   (tn) (string>=? "b" ""))
(assert-true   (tn) (string>=? "b" "\n"))
(assert-true   (tn) (string>=? "b" " "))
(assert-true   (tn) (string>=? "b" "!"))
(assert-true   (tn) (string>=? "b" "0"))
(assert-true   (tn) (string>=? "b" "9"))
(assert-true   (tn) (string>=? "b" "A"))
(assert-true   (tn) (string>=? "b" "B"))
(assert-true   (tn) (string>=? "b" "Z"))
(assert-true   (tn) (string>=? "b" "_"))
(assert-true   (tn) (string>=? "b" "a"))
(assert-true   (tn) (string>=? "b" "b"))
(assert-false  (tn) (string>=? "b" "z"))
(assert-false  (tn) (string>=? "b" "~"))
(assert-false  (tn) (string>=? "b" "\x7f"))
(tn "string>=? \"z\"")
(assert-true   (tn) (string>=? "z" ""))
(assert-true   (tn) (string>=? "z" "\n"))
(assert-true   (tn) (string>=? "z" " "))
(assert-true   (tn) (string>=? "z" "!"))
(assert-true   (tn) (string>=? "z" "0"))
(assert-true   (tn) (string>=? "z" "9"))
(assert-true   (tn) (string>=? "z" "A"))
(assert-true   (tn) (string>=? "z" "B"))
(assert-true   (tn) (string>=? "z" "Z"))
(assert-true   (tn) (string>=? "z" "_"))
(assert-true   (tn) (string>=? "z" "a"))
(assert-true   (tn) (string>=? "z" "b"))
(assert-true   (tn) (string>=? "z" "z"))
(assert-false  (tn) (string>=? "z" "~"))
(assert-false  (tn) (string>=? "z" "\x7f"))
(tn "string>=? \"~\"")
(assert-true   (tn) (string>=? "~" ""))
(assert-true   (tn) (string>=? "~" "\n"))
(assert-true   (tn) (string>=? "~" " "))
(assert-true   (tn) (string>=? "~" "!"))
(assert-true   (tn) (string>=? "~" "0"))
(assert-true   (tn) (string>=? "~" "9"))
(assert-true   (tn) (string>=? "~" "A"))
(assert-true   (tn) (string>=? "~" "B"))
(assert-true   (tn) (string>=? "~" "Z"))
(assert-true   (tn) (string>=? "~" "_"))
(assert-true   (tn) (string>=? "~" "a"))
(assert-true   (tn) (string>=? "~" "b"))
(assert-true   (tn) (string>=? "~" "z"))
(assert-true   (tn) (string>=? "~" "~"))
(assert-false  (tn) (string>=? "~" "\x7f"))
(tn "string>=? \"\\x7f\"")
(assert-true   (tn) (string>=? "\x7f" ""))
(assert-true   (tn) (string>=? "\x7f" "\n"))
(assert-true   (tn) (string>=? "\x7f" " "))
(assert-true   (tn) (string>=? "\x7f" "!"))
(assert-true   (tn) (string>=? "\x7f" "0"))
(assert-true   (tn) (string>=? "\x7f" "9"))
(assert-true   (tn) (string>=? "\x7f" "A"))
(assert-true   (tn) (string>=? "\x7f" "B"))
(assert-true   (tn) (string>=? "\x7f" "Z"))
(assert-true   (tn) (string>=? "\x7f" "_"))
(assert-true   (tn) (string>=? "\x7f" "a"))
(assert-true   (tn) (string>=? "\x7f" "b"))
(assert-true   (tn) (string>=? "\x7f" "z"))
(assert-true   (tn) (string>=? "\x7f" "~"))
(assert-true   (tn) (string>=? "\x7f" "\x7f"))
(tn "string>=? alphabets")
(assert-true   (tn) (string>=? "aa" "aa"))
(assert-true   (tn) (string>=? "aa" "AA"))
(assert-true   (tn) (string>=? "aa" "aA"))
(assert-true   (tn) (string>=? "aa" "Aa"))
(assert-false  (tn) (string>=? "AA" "aa"))
(assert-false  (tn) (string>=? "aA" "aa"))
(assert-false  (tn) (string>=? "Aa" "aa"))
(assert-true   (tn) (string>=? "abc" "abc"))
(assert-true   (tn) (string>=? "abc" "ABC"))
(assert-true   (tn) (string>=? "abc" "ABc"))
(assert-false  (tn) (string>=? "abc" "abcd"))
(assert-false  (tn) (string>=? "ABC" "abc"))
(assert-false  (tn) (string>=? "ABc" "abc"))
(assert-true   (tn) (string>=? "abcd" "abc"))

;; string-ci<?
(tn "string-ci<? \"\"")
(assert-false  (tn) (string-ci<? "" ""))
(assert-true   (tn) (string-ci<? "" "\n"))
(assert-true   (tn) (string-ci<? "" " "))
(assert-true   (tn) (string-ci<? "" "!"))
(assert-true   (tn) (string-ci<? "" "0"))
(assert-true   (tn) (string-ci<? "" "9"))
(assert-true   (tn) (string-ci<? "" "A"))
(assert-true   (tn) (string-ci<? "" "B"))
(assert-true   (tn) (string-ci<? "" "Z"))
(assert-true   (tn) (string-ci<? "" "_"))
(assert-true   (tn) (string-ci<? "" "a"))
(assert-true   (tn) (string-ci<? "" "b"))
(assert-true   (tn) (string-ci<? "" "z"))
(assert-true   (tn) (string-ci<? "" "~"))
(assert-true   (tn) (string-ci<? "" "\x7f"))
(tn "string-ci<? \"\\n\"")
(assert-false  (tn) (string-ci<? "\n" ""))
(assert-false  (tn) (string-ci<? "\n" "\n"))
(assert-true   (tn) (string-ci<? "\n" " "))
(assert-true   (tn) (string-ci<? "\n" "!"))
(assert-true   (tn) (string-ci<? "\n" "0"))
(assert-true   (tn) (string-ci<? "\n" "9"))
(assert-true   (tn) (string-ci<? "\n" "A"))
(assert-true   (tn) (string-ci<? "\n" "B"))
(assert-true   (tn) (string-ci<? "\n" "Z"))
(assert-true   (tn) (string-ci<? "\n" "_"))
(assert-true   (tn) (string-ci<? "\n" "a"))
(assert-true   (tn) (string-ci<? "\n" "b"))
(assert-true   (tn) (string-ci<? "\n" "z"))
(assert-true   (tn) (string-ci<? "\n" "~"))
(assert-true   (tn) (string-ci<? "\n" "\x7f"))
(tn "string-ci<? \" \"")
(assert-false  (tn) (string-ci<? " " ""))
(assert-false  (tn) (string-ci<? " " "\n"))
(assert-false  (tn) (string-ci<? " " " "))
(assert-true   (tn) (string-ci<? " " "!"))
(assert-true   (tn) (string-ci<? " " "0"))
(assert-true   (tn) (string-ci<? " " "9"))
(assert-true   (tn) (string-ci<? " " "A"))
(assert-true   (tn) (string-ci<? " " "B"))
(assert-true   (tn) (string-ci<? " " "Z"))
(assert-true   (tn) (string-ci<? " " "_"))
(assert-true   (tn) (string-ci<? " " "a"))
(assert-true   (tn) (string-ci<? " " "b"))
(assert-true   (tn) (string-ci<? " " "z"))
(assert-true   (tn) (string-ci<? " " "~"))
(assert-true   (tn) (string-ci<? " " "\x7f"))
(tn "string-ci<? \"!\"")
(assert-false  (tn) (string-ci<? "!" ""))
(assert-false  (tn) (string-ci<? "!" "\n"))
(assert-false  (tn) (string-ci<? "!" " "))
(assert-false  (tn) (string-ci<? "!" "!"))
(assert-true   (tn) (string-ci<? "!" "0"))
(assert-true   (tn) (string-ci<? "!" "9"))
(assert-true   (tn) (string-ci<? "!" "A"))
(assert-true   (tn) (string-ci<? "!" "B"))
(assert-true   (tn) (string-ci<? "!" "Z"))
(assert-true   (tn) (string-ci<? "!" "_"))
(assert-true   (tn) (string-ci<? "!" "a"))
(assert-true   (tn) (string-ci<? "!" "b"))
(assert-true   (tn) (string-ci<? "!" "z"))
(assert-true   (tn) (string-ci<? "!" "~"))
(assert-true   (tn) (string-ci<? "!" "\x7f"))
(tn "string-ci<? \"0\"")
(assert-false  (tn) (string-ci<? "0" ""))
(assert-false  (tn) (string-ci<? "0" "\n"))
(assert-false  (tn) (string-ci<? "0" " "))
(assert-false  (tn) (string-ci<? "0" "!"))
(assert-false  (tn) (string-ci<? "0" "0"))
(assert-true   (tn) (string-ci<? "0" "9"))
(assert-true   (tn) (string-ci<? "0" "A"))
(assert-true   (tn) (string-ci<? "0" "B"))
(assert-true   (tn) (string-ci<? "0" "Z"))
(assert-true   (tn) (string-ci<? "0" "_"))
(assert-true   (tn) (string-ci<? "0" "a"))
(assert-true   (tn) (string-ci<? "0" "b"))
(assert-true   (tn) (string-ci<? "0" "z"))
(assert-true   (tn) (string-ci<? "0" "~"))
(assert-true   (tn) (string-ci<? "0" "\x7f"))
(tn "string-ci<? \"9\"")
(assert-false  (tn) (string-ci<? "9" ""))
(assert-false  (tn) (string-ci<? "9" "\n"))
(assert-false  (tn) (string-ci<? "9" " "))
(assert-false  (tn) (string-ci<? "9" "!"))
(assert-false  (tn) (string-ci<? "9" "0"))
(assert-false  (tn) (string-ci<? "9" "9"))
(assert-true   (tn) (string-ci<? "9" "A"))
(assert-true   (tn) (string-ci<? "9" "B"))
(assert-true   (tn) (string-ci<? "9" "Z"))
(assert-true   (tn) (string-ci<? "9" "_"))
(assert-true   (tn) (string-ci<? "9" "a"))
(assert-true   (tn) (string-ci<? "9" "b"))
(assert-true   (tn) (string-ci<? "9" "z"))
(assert-true   (tn) (string-ci<? "9" "~"))
(assert-true   (tn) (string-ci<? "9" "\x7f"))
(tn "string-ci<? \"A\"")
(assert-false  (tn) (string-ci<? "A" ""))
(assert-false  (tn) (string-ci<? "A" "\n"))
(assert-false  (tn) (string-ci<? "A" " "))
(assert-false  (tn) (string-ci<? "A" "!"))
(assert-false  (tn) (string-ci<? "A" "0"))
(assert-false  (tn) (string-ci<? "A" "9"))
(assert-false  (tn) (string-ci<? "A" "A"))
(assert-true   (tn) (string-ci<? "A" "B"))
(assert-true   (tn) (string-ci<? "A" "Z"))
(assert-false  (tn) (string-ci<? "A" "_"))
(assert-false  (tn) (string-ci<? "A" "a"))
(assert-true   (tn) (string-ci<? "A" "b"))
(assert-true   (tn) (string-ci<? "A" "z"))
(assert-true   (tn) (string-ci<? "A" "~"))
(assert-true   (tn) (string-ci<? "A" "\x7f"))
(tn "string-ci<? \"B\"")
(assert-false  (tn) (string-ci<? "B" ""))
(assert-false  (tn) (string-ci<? "B" "\n"))
(assert-false  (tn) (string-ci<? "B" " "))
(assert-false  (tn) (string-ci<? "B" "!"))
(assert-false  (tn) (string-ci<? "B" "0"))
(assert-false  (tn) (string-ci<? "B" "9"))
(assert-false  (tn) (string-ci<? "B" "A"))
(assert-false  (tn) (string-ci<? "B" "B"))
(assert-true   (tn) (string-ci<? "B" "Z"))
(assert-false  (tn) (string-ci<? "B" "_"))
(assert-false  (tn) (string-ci<? "B" "a"))
(assert-false  (tn) (string-ci<? "B" "b"))
(assert-true   (tn) (string-ci<? "B" "z"))
(assert-true   (tn) (string-ci<? "B" "~"))
(assert-true   (tn) (string-ci<? "B" "\x7f"))
(tn "string-ci<? \"Z\"")
(assert-false  (tn) (string-ci<? "Z" ""))
(assert-false  (tn) (string-ci<? "Z" "\n"))
(assert-false  (tn) (string-ci<? "Z" " "))
(assert-false  (tn) (string-ci<? "Z" "!"))
(assert-false  (tn) (string-ci<? "Z" "0"))
(assert-false  (tn) (string-ci<? "Z" "9"))
(assert-false  (tn) (string-ci<? "Z" "A"))
(assert-false  (tn) (string-ci<? "Z" "B"))
(assert-false  (tn) (string-ci<? "Z" "Z"))
(assert-false  (tn) (string-ci<? "Z" "_"))
(assert-false  (tn) (string-ci<? "Z" "a"))
(assert-false  (tn) (string-ci<? "Z" "b"))
(assert-false  (tn) (string-ci<? "Z" "z"))
(assert-true   (tn) (string-ci<? "Z" "~"))
(assert-true   (tn) (string-ci<? "Z" "\x7f"))
(tn "string-ci<? \"_\"")
(assert-false  (tn) (string-ci<? "_" ""))
(assert-false  (tn) (string-ci<? "_" "\n"))
(assert-false  (tn) (string-ci<? "_" " "))
(assert-false  (tn) (string-ci<? "_" "!"))
(assert-false  (tn) (string-ci<? "_" "0"))
(assert-false  (tn) (string-ci<? "_" "9"))
(assert-true   (tn) (string-ci<? "_" "A"))
(assert-true   (tn) (string-ci<? "_" "B"))
(assert-true   (tn) (string-ci<? "_" "Z"))
(assert-false  (tn) (string-ci<? "_" "_"))
(assert-true   (tn) (string-ci<? "_" "a"))
(assert-true   (tn) (string-ci<? "_" "b"))
(assert-true   (tn) (string-ci<? "_" "z"))
(assert-true   (tn) (string-ci<? "_" "~"))
(assert-true   (tn) (string-ci<? "_" "\x7f"))
(tn "string-ci<? \"a\"")
(assert-false  (tn) (string-ci<? "a" ""))
(assert-false  (tn) (string-ci<? "a" "\n"))
(assert-false  (tn) (string-ci<? "a" " "))
(assert-false  (tn) (string-ci<? "a" "!"))
(assert-false  (tn) (string-ci<? "a" "0"))
(assert-false  (tn) (string-ci<? "a" "9"))
(assert-false  (tn) (string-ci<? "a" "A"))
(assert-true   (tn) (string-ci<? "a" "B"))
(assert-true   (tn) (string-ci<? "a" "Z"))
(assert-false  (tn) (string-ci<? "a" "_"))
(assert-false  (tn) (string-ci<? "a" "a"))
(assert-true   (tn) (string-ci<? "a" "b"))
(assert-true   (tn) (string-ci<? "a" "z"))
(assert-true   (tn) (string-ci<? "a" "~"))
(assert-true   (tn) (string-ci<? "a" "\x7f"))
(tn "string-ci<? \"b\"")
(assert-false  (tn) (string-ci<? "b" ""))
(assert-false  (tn) (string-ci<? "b" "\n"))
(assert-false  (tn) (string-ci<? "b" " "))
(assert-false  (tn) (string-ci<? "b" "!"))
(assert-false  (tn) (string-ci<? "b" "0"))
(assert-false  (tn) (string-ci<? "b" "9"))
(assert-false  (tn) (string-ci<? "b" "A"))
(assert-false  (tn) (string-ci<? "b" "B"))
(assert-true   (tn) (string-ci<? "b" "Z"))
(assert-false  (tn) (string-ci<? "b" "_"))
(assert-false  (tn) (string-ci<? "b" "a"))
(assert-false  (tn) (string-ci<? "b" "b"))
(assert-true   (tn) (string-ci<? "b" "z"))
(assert-true   (tn) (string-ci<? "b" "~"))
(assert-true   (tn) (string-ci<? "b" "\x7f"))
(tn "string-ci<? \"z\"")
(assert-false  (tn) (string-ci<? "z" ""))
(assert-false  (tn) (string-ci<? "z" "\n"))
(assert-false  (tn) (string-ci<? "z" " "))
(assert-false  (tn) (string-ci<? "z" "!"))
(assert-false  (tn) (string-ci<? "z" "0"))
(assert-false  (tn) (string-ci<? "z" "9"))
(assert-false  (tn) (string-ci<? "z" "A"))
(assert-false  (tn) (string-ci<? "z" "B"))
(assert-false  (tn) (string-ci<? "z" "Z"))
(assert-false  (tn) (string-ci<? "z" "_"))
(assert-false  (tn) (string-ci<? "z" "a"))
(assert-false  (tn) (string-ci<? "z" "b"))
(assert-false  (tn) (string-ci<? "z" "z"))
(assert-true   (tn) (string-ci<? "z" "~"))
(assert-true   (tn) (string-ci<? "z" "\x7f"))
(tn "string-ci<? \"~\"")
(assert-false  (tn) (string-ci<? "~" ""))
(assert-false  (tn) (string-ci<? "~" "\n"))
(assert-false  (tn) (string-ci<? "~" " "))
(assert-false  (tn) (string-ci<? "~" "!"))
(assert-false  (tn) (string-ci<? "~" "0"))
(assert-false  (tn) (string-ci<? "~" "9"))
(assert-false  (tn) (string-ci<? "~" "A"))
(assert-false  (tn) (string-ci<? "~" "B"))
(assert-false  (tn) (string-ci<? "~" "Z"))
(assert-false  (tn) (string-ci<? "~" "_"))
(assert-false  (tn) (string-ci<? "~" "a"))
(assert-false  (tn) (string-ci<? "~" "b"))
(assert-false  (tn) (string-ci<? "~" "z"))
(assert-false  (tn) (string-ci<? "~" "~"))
(assert-true   (tn) (string-ci<? "~" "\x7f"))
(tn "string-ci<? \"\\x7f\"")
(assert-false  (tn) (string-ci<? "\x7f" ""))
(assert-false  (tn) (string-ci<? "\x7f" "\n"))
(assert-false  (tn) (string-ci<? "\x7f" " "))
(assert-false  (tn) (string-ci<? "\x7f" "!"))
(assert-false  (tn) (string-ci<? "\x7f" "0"))
(assert-false  (tn) (string-ci<? "\x7f" "9"))
(assert-false  (tn) (string-ci<? "\x7f" "A"))
(assert-false  (tn) (string-ci<? "\x7f" "B"))
(assert-false  (tn) (string-ci<? "\x7f" "Z"))
(assert-false  (tn) (string-ci<? "\x7f" "_"))
(assert-false  (tn) (string-ci<? "\x7f" "a"))
(assert-false  (tn) (string-ci<? "\x7f" "b"))
(assert-false  (tn) (string-ci<? "\x7f" "z"))
(assert-false  (tn) (string-ci<? "\x7f" "~"))
(assert-false  (tn) (string-ci<? "\x7f" "\x7f"))
(tn "string-ci<? alphabets")
(assert-false  (tn) (string-ci<? "aa" "aa"))
(assert-false  (tn) (string-ci<? "aa" "AA"))
(assert-false  (tn) (string-ci<? "aa" "aA"))
(assert-false  (tn) (string-ci<? "aa" "Aa"))
(assert-false  (tn) (string-ci<? "AA" "aa"))
(assert-false  (tn) (string-ci<? "aA" "aa"))
(assert-false  (tn) (string-ci<? "Aa" "aa"))
(assert-false  (tn) (string-ci<? "abc" "abc"))
(assert-false  (tn) (string-ci<? "abc" "ABC"))
(assert-false  (tn) (string-ci<? "abc" "ABc"))
(assert-true   (tn) (string-ci<? "abc" "abcd"))
(assert-false  (tn) (string-ci<? "ABC" "abc"))
(assert-false  (tn) (string-ci<? "ABc" "abc"))
(assert-false  (tn) (string-ci<? "abcd" "abc"))

;; string-ci>?
(tn "string-ci>? \"\"")
(assert-false  (tn) (string-ci>? "" ""))
(assert-false  (tn) (string-ci>? "" "\n"))
(assert-false  (tn) (string-ci>? "" " "))
(assert-false  (tn) (string-ci>? "" "!"))
(assert-false  (tn) (string-ci>? "" "0"))
(assert-false  (tn) (string-ci>? "" "9"))
(assert-false  (tn) (string-ci>? "" "A"))
(assert-false  (tn) (string-ci>? "" "B"))
(assert-false  (tn) (string-ci>? "" "Z"))
(assert-false  (tn) (string-ci>? "" "_"))
(assert-false  (tn) (string-ci>? "" "a"))
(assert-false  (tn) (string-ci>? "" "b"))
(assert-false  (tn) (string-ci>? "" "z"))
(assert-false  (tn) (string-ci>? "" "~"))
(assert-false  (tn) (string-ci>? "" "\x7f"))
(tn "string-ci>? \"\\n\"")
(assert-true   (tn) (string-ci>? "\n" ""))
(assert-false  (tn) (string-ci>? "\n" "\n"))
(assert-false  (tn) (string-ci>? "\n" " "))
(assert-false  (tn) (string-ci>? "\n" "!"))
(assert-false  (tn) (string-ci>? "\n" "0"))
(assert-false  (tn) (string-ci>? "\n" "9"))
(assert-false  (tn) (string-ci>? "\n" "A"))
(assert-false  (tn) (string-ci>? "\n" "B"))
(assert-false  (tn) (string-ci>? "\n" "Z"))
(assert-false  (tn) (string-ci>? "\n" "_"))
(assert-false  (tn) (string-ci>? "\n" "a"))
(assert-false  (tn) (string-ci>? "\n" "b"))
(assert-false  (tn) (string-ci>? "\n" "z"))
(assert-false  (tn) (string-ci>? "\n" "~"))
(assert-false  (tn) (string-ci>? "\n" "\x7f"))
(tn "string-ci>? \" \"")
(assert-true   (tn) (string-ci>? " " ""))
(assert-true   (tn) (string-ci>? " " "\n"))
(assert-false  (tn) (string-ci>? " " " "))
(assert-false  (tn) (string-ci>? " " "!"))
(assert-false  (tn) (string-ci>? " " "0"))
(assert-false  (tn) (string-ci>? " " "9"))
(assert-false  (tn) (string-ci>? " " "A"))
(assert-false  (tn) (string-ci>? " " "B"))
(assert-false  (tn) (string-ci>? " " "Z"))
(assert-false  (tn) (string-ci>? " " "_"))
(assert-false  (tn) (string-ci>? " " "a"))
(assert-false  (tn) (string-ci>? " " "b"))
(assert-false  (tn) (string-ci>? " " "z"))
(assert-false  (tn) (string-ci>? " " "~"))
(assert-false  (tn) (string-ci>? " " "\x7f"))
(tn "string-ci>? \"!\"")
(assert-true   (tn) (string-ci>? "!" ""))
(assert-true   (tn) (string-ci>? "!" "\n"))
(assert-true   (tn) (string-ci>? "!" " "))
(assert-false  (tn) (string-ci>? "!" "!"))
(assert-false  (tn) (string-ci>? "!" "0"))
(assert-false  (tn) (string-ci>? "!" "9"))
(assert-false  (tn) (string-ci>? "!" "A"))
(assert-false  (tn) (string-ci>? "!" "B"))
(assert-false  (tn) (string-ci>? "!" "Z"))
(assert-false  (tn) (string-ci>? "!" "_"))
(assert-false  (tn) (string-ci>? "!" "a"))
(assert-false  (tn) (string-ci>? "!" "b"))
(assert-false  (tn) (string-ci>? "!" "z"))
(assert-false  (tn) (string-ci>? "!" "~"))
(assert-false  (tn) (string-ci>? "!" "\x7f"))
(tn "string-ci>? \"0\"")
(assert-true   (tn) (string-ci>? "0" ""))
(assert-true   (tn) (string-ci>? "0" "\n"))
(assert-true   (tn) (string-ci>? "0" " "))
(assert-true   (tn) (string-ci>? "0" "!"))
(assert-false  (tn) (string-ci>? "0" "0"))
(assert-false  (tn) (string-ci>? "0" "9"))
(assert-false  (tn) (string-ci>? "0" "A"))
(assert-false  (tn) (string-ci>? "0" "B"))
(assert-false  (tn) (string-ci>? "0" "Z"))
(assert-false  (tn) (string-ci>? "0" "_"))
(assert-false  (tn) (string-ci>? "0" "a"))
(assert-false  (tn) (string-ci>? "0" "b"))
(assert-false  (tn) (string-ci>? "0" "z"))
(assert-false  (tn) (string-ci>? "0" "~"))
(assert-false  (tn) (string-ci>? "0" "\x7f"))
(tn "string-ci>? \"9\"")
(assert-true   (tn) (string-ci>? "9" ""))
(assert-true   (tn) (string-ci>? "9" "\n"))
(assert-true   (tn) (string-ci>? "9" " "))
(assert-true   (tn) (string-ci>? "9" "!"))
(assert-true   (tn) (string-ci>? "9" "0"))
(assert-false  (tn) (string-ci>? "9" "9"))
(assert-false  (tn) (string-ci>? "9" "A"))
(assert-false  (tn) (string-ci>? "9" "B"))
(assert-false  (tn) (string-ci>? "9" "Z"))
(assert-false  (tn) (string-ci>? "9" "_"))
(assert-false  (tn) (string-ci>? "9" "a"))
(assert-false  (tn) (string-ci>? "9" "b"))
(assert-false  (tn) (string-ci>? "9" "z"))
(assert-false  (tn) (string-ci>? "9" "~"))
(assert-false  (tn) (string-ci>? "9" "\x7f"))
(tn "string-ci>? \"A\"")
(assert-true   (tn) (string-ci>? "A" ""))
(assert-true   (tn) (string-ci>? "A" "\n"))
(assert-true   (tn) (string-ci>? "A" " "))
(assert-true   (tn) (string-ci>? "A" "!"))
(assert-true   (tn) (string-ci>? "A" "0"))
(assert-true   (tn) (string-ci>? "A" "9"))
(assert-false  (tn) (string-ci>? "A" "A"))
(assert-false  (tn) (string-ci>? "A" "B"))
(assert-false  (tn) (string-ci>? "A" "Z"))
(assert-true   (tn) (string-ci>? "A" "_"))
(assert-false  (tn) (string-ci>? "A" "a"))
(assert-false  (tn) (string-ci>? "A" "b"))
(assert-false  (tn) (string-ci>? "A" "z"))
(assert-false  (tn) (string-ci>? "A" "~"))
(assert-false  (tn) (string-ci>? "A" "\x7f"))
(tn "string-ci>? \"B\"")
(assert-true   (tn) (string-ci>? "B" ""))
(assert-true   (tn) (string-ci>? "B" "\n"))
(assert-true   (tn) (string-ci>? "B" " "))
(assert-true   (tn) (string-ci>? "B" "!"))
(assert-true   (tn) (string-ci>? "B" "0"))
(assert-true   (tn) (string-ci>? "B" "9"))
(assert-true   (tn) (string-ci>? "B" "A"))
(assert-false  (tn) (string-ci>? "B" "B"))
(assert-false  (tn) (string-ci>? "B" "Z"))
(assert-true   (tn) (string-ci>? "B" "_"))
(assert-true   (tn) (string-ci>? "B" "a"))
(assert-false  (tn) (string-ci>? "B" "b"))
(assert-false  (tn) (string-ci>? "B" "z"))
(assert-false  (tn) (string-ci>? "B" "~"))
(assert-false  (tn) (string-ci>? "B" "\x7f"))
(tn "string-ci>? \"Z\"")
(assert-true   (tn) (string-ci>? "Z" ""))
(assert-true   (tn) (string-ci>? "Z" "\n"))
(assert-true   (tn) (string-ci>? "Z" " "))
(assert-true   (tn) (string-ci>? "Z" "!"))
(assert-true   (tn) (string-ci>? "Z" "0"))
(assert-true   (tn) (string-ci>? "Z" "9"))
(assert-true   (tn) (string-ci>? "Z" "A"))
(assert-true   (tn) (string-ci>? "Z" "B"))
(assert-false  (tn) (string-ci>? "Z" "Z"))
(assert-true   (tn) (string-ci>? "Z" "_"))
(assert-true   (tn) (string-ci>? "Z" "a"))
(assert-true   (tn) (string-ci>? "Z" "b"))
(assert-false  (tn) (string-ci>? "Z" "z"))
(assert-false  (tn) (string-ci>? "Z" "~"))
(assert-false  (tn) (string-ci>? "Z" "\x7f"))
(tn "string-ci>? \"_\"")
(assert-true   (tn) (string-ci>? "_" ""))
(assert-true   (tn) (string-ci>? "_" "\n"))
(assert-true   (tn) (string-ci>? "_" " "))
(assert-true   (tn) (string-ci>? "_" "!"))
(assert-true   (tn) (string-ci>? "_" "0"))
(assert-true   (tn) (string-ci>? "_" "9"))
(assert-false  (tn) (string-ci>? "_" "A"))
(assert-false  (tn) (string-ci>? "_" "B"))
(assert-false  (tn) (string-ci>? "_" "Z"))
(assert-false  (tn) (string-ci>? "_" "_"))
(assert-false  (tn) (string-ci>? "_" "a"))
(assert-false  (tn) (string-ci>? "_" "b"))
(assert-false  (tn) (string-ci>? "_" "z"))
(assert-false  (tn) (string-ci>? "_" "~"))
(assert-false  (tn) (string-ci>? "_" "\x7f"))
(tn "string-ci>? \"a\"")
(assert-true   (tn) (string-ci>? "a" ""))
(assert-true   (tn) (string-ci>? "a" "\n"))
(assert-true   (tn) (string-ci>? "a" " "))
(assert-true   (tn) (string-ci>? "a" "!"))
(assert-true   (tn) (string-ci>? "a" "0"))
(assert-true   (tn) (string-ci>? "a" "9"))
(assert-false  (tn) (string-ci>? "a" "A"))
(assert-false  (tn) (string-ci>? "a" "B"))
(assert-false  (tn) (string-ci>? "a" "Z"))
(assert-true   (tn) (string-ci>? "a" "_"))
(assert-false  (tn) (string-ci>? "a" "a"))
(assert-false  (tn) (string-ci>? "a" "b"))
(assert-false  (tn) (string-ci>? "a" "z"))
(assert-false  (tn) (string-ci>? "a" "~"))
(assert-false  (tn) (string-ci>? "a" "\x7f"))
(tn "string-ci>? \"b\"")
(assert-true   (tn) (string-ci>? "b" ""))
(assert-true   (tn) (string-ci>? "b" "\n"))
(assert-true   (tn) (string-ci>? "b" " "))
(assert-true   (tn) (string-ci>? "b" "!"))
(assert-true   (tn) (string-ci>? "b" "0"))
(assert-true   (tn) (string-ci>? "b" "9"))
(assert-true   (tn) (string-ci>? "b" "A"))
(assert-false  (tn) (string-ci>? "b" "B"))
(assert-false  (tn) (string-ci>? "b" "Z"))
(assert-true   (tn) (string-ci>? "b" "_"))
(assert-true   (tn) (string-ci>? "b" "a"))
(assert-false  (tn) (string-ci>? "b" "b"))
(assert-false  (tn) (string-ci>? "b" "z"))
(assert-false  (tn) (string-ci>? "b" "~"))
(assert-false  (tn) (string-ci>? "b" "\x7f"))
(tn "string-ci>? \"z\"")
(assert-true   (tn) (string-ci>? "z" ""))
(assert-true   (tn) (string-ci>? "z" "\n"))
(assert-true   (tn) (string-ci>? "z" " "))
(assert-true   (tn) (string-ci>? "z" "!"))
(assert-true   (tn) (string-ci>? "z" "0"))
(assert-true   (tn) (string-ci>? "z" "9"))
(assert-true   (tn) (string-ci>? "z" "A"))
(assert-true   (tn) (string-ci>? "z" "B"))
(assert-false  (tn) (string-ci>? "z" "Z"))
(assert-true   (tn) (string-ci>? "z" "_"))
(assert-true   (tn) (string-ci>? "z" "a"))
(assert-true   (tn) (string-ci>? "z" "b"))
(assert-false  (tn) (string-ci>? "z" "z"))
(assert-false  (tn) (string-ci>? "z" "~"))
(assert-false  (tn) (string-ci>? "z" "\x7f"))
(tn "string-ci>? \"~\"")
(assert-true   (tn) (string-ci>? "~" ""))
(assert-true   (tn) (string-ci>? "~" "\n"))
(assert-true   (tn) (string-ci>? "~" " "))
(assert-true   (tn) (string-ci>? "~" "!"))
(assert-true   (tn) (string-ci>? "~" "0"))
(assert-true   (tn) (string-ci>? "~" "9"))
(assert-true   (tn) (string-ci>? "~" "A"))
(assert-true   (tn) (string-ci>? "~" "B"))
(assert-true   (tn) (string-ci>? "~" "Z"))
(assert-true   (tn) (string-ci>? "~" "_"))
(assert-true   (tn) (string-ci>? "~" "a"))
(assert-true   (tn) (string-ci>? "~" "b"))
(assert-true   (tn) (string-ci>? "~" "z"))
(assert-false  (tn) (string-ci>? "~" "~"))
(assert-false  (tn) (string-ci>? "~" "\x7f"))
(tn "string-ci>? \"\\x7f\"")
(assert-true   (tn) (string-ci>? "\x7f" ""))
(assert-true   (tn) (string-ci>? "\x7f" "\n"))
(assert-true   (tn) (string-ci>? "\x7f" " "))
(assert-true   (tn) (string-ci>? "\x7f" "!"))
(assert-true   (tn) (string-ci>? "\x7f" "0"))
(assert-true   (tn) (string-ci>? "\x7f" "9"))
(assert-true   (tn) (string-ci>? "\x7f" "A"))
(assert-true   (tn) (string-ci>? "\x7f" "B"))
(assert-true   (tn) (string-ci>? "\x7f" "Z"))
(assert-true   (tn) (string-ci>? "\x7f" "_"))
(assert-true   (tn) (string-ci>? "\x7f" "a"))
(assert-true   (tn) (string-ci>? "\x7f" "b"))
(assert-true   (tn) (string-ci>? "\x7f" "z"))
(assert-true   (tn) (string-ci>? "\x7f" "~"))
(assert-false  (tn) (string-ci>? "\x7f" "\x7f"))
(tn "string-ci>? alphabets")
(assert-false  (tn) (string-ci>? "aa" "aa"))
(assert-false  (tn) (string-ci>? "aa" "AA"))
(assert-false  (tn) (string-ci>? "aa" "aA"))
(assert-false  (tn) (string-ci>? "aa" "Aa"))
(assert-false  (tn) (string-ci>? "AA" "aa"))
(assert-false  (tn) (string-ci>? "aA" "aa"))
(assert-false  (tn) (string-ci>? "Aa" "aa"))
(assert-false  (tn) (string-ci>? "abc" "abc"))
(assert-false  (tn) (string-ci>? "abc" "ABC"))
(assert-false  (tn) (string-ci>? "abc" "ABc"))
(assert-false  (tn) (string-ci>? "abc" "abcd"))
(assert-false  (tn) (string-ci>? "ABC" "abc"))
(assert-false  (tn) (string-ci>? "ABc" "abc"))
(assert-true   (tn) (string-ci>? "abcd" "abc"))

;; string-ci<=?
(tn "string-ci<=? \"\"")
(assert-true   (tn) (string-ci<=? "" ""))
(assert-true   (tn) (string-ci<=? "" "\n"))
(assert-true   (tn) (string-ci<=? "" " "))
(assert-true   (tn) (string-ci<=? "" "!"))
(assert-true   (tn) (string-ci<=? "" "0"))
(assert-true   (tn) (string-ci<=? "" "9"))
(assert-true   (tn) (string-ci<=? "" "A"))
(assert-true   (tn) (string-ci<=? "" "B"))
(assert-true   (tn) (string-ci<=? "" "Z"))
(assert-true   (tn) (string-ci<=? "" "_"))
(assert-true   (tn) (string-ci<=? "" "a"))
(assert-true   (tn) (string-ci<=? "" "b"))
(assert-true   (tn) (string-ci<=? "" "z"))
(assert-true   (tn) (string-ci<=? "" "~"))
(assert-true   (tn) (string-ci<=? "" "\x7f"))
(tn "string-ci<=? \"\\n\"")
(assert-false  (tn) (string-ci<=? "\n" ""))
(assert-true   (tn) (string-ci<=? "\n" "\n"))
(assert-true   (tn) (string-ci<=? "\n" " "))
(assert-true   (tn) (string-ci<=? "\n" "!"))
(assert-true   (tn) (string-ci<=? "\n" "0"))
(assert-true   (tn) (string-ci<=? "\n" "9"))
(assert-true   (tn) (string-ci<=? "\n" "A"))
(assert-true   (tn) (string-ci<=? "\n" "B"))
(assert-true   (tn) (string-ci<=? "\n" "Z"))
(assert-true   (tn) (string-ci<=? "\n" "_"))
(assert-true   (tn) (string-ci<=? "\n" "a"))
(assert-true   (tn) (string-ci<=? "\n" "b"))
(assert-true   (tn) (string-ci<=? "\n" "z"))
(assert-true   (tn) (string-ci<=? "\n" "~"))
(assert-true   (tn) (string-ci<=? "\n" "\x7f"))
(tn "string-ci<=? \" \"")
(assert-false  (tn) (string-ci<=? " " ""))
(assert-false  (tn) (string-ci<=? " " "\n"))
(assert-true   (tn) (string-ci<=? " " " "))
(assert-true   (tn) (string-ci<=? " " "!"))
(assert-true   (tn) (string-ci<=? " " "0"))
(assert-true   (tn) (string-ci<=? " " "9"))
(assert-true   (tn) (string-ci<=? " " "A"))
(assert-true   (tn) (string-ci<=? " " "B"))
(assert-true   (tn) (string-ci<=? " " "Z"))
(assert-true   (tn) (string-ci<=? " " "_"))
(assert-true   (tn) (string-ci<=? " " "a"))
(assert-true   (tn) (string-ci<=? " " "b"))
(assert-true   (tn) (string-ci<=? " " "z"))
(assert-true   (tn) (string-ci<=? " " "~"))
(assert-true   (tn) (string-ci<=? " " "\x7f"))
(tn "string-ci<=? \"!\"")
(assert-false  (tn) (string-ci<=? "!" ""))
(assert-false  (tn) (string-ci<=? "!" "\n"))
(assert-false  (tn) (string-ci<=? "!" " "))
(assert-true   (tn) (string-ci<=? "!" "!"))
(assert-true   (tn) (string-ci<=? "!" "0"))
(assert-true   (tn) (string-ci<=? "!" "9"))
(assert-true   (tn) (string-ci<=? "!" "A"))
(assert-true   (tn) (string-ci<=? "!" "B"))
(assert-true   (tn) (string-ci<=? "!" "Z"))
(assert-true   (tn) (string-ci<=? "!" "_"))
(assert-true   (tn) (string-ci<=? "!" "a"))
(assert-true   (tn) (string-ci<=? "!" "b"))
(assert-true   (tn) (string-ci<=? "!" "z"))
(assert-true   (tn) (string-ci<=? "!" "~"))
(assert-true   (tn) (string-ci<=? "!" "\x7f"))
(tn "string-ci<=? \"0\"")
(assert-false  (tn) (string-ci<=? "0" ""))
(assert-false  (tn) (string-ci<=? "0" "\n"))
(assert-false  (tn) (string-ci<=? "0" " "))
(assert-false  (tn) (string-ci<=? "0" "!"))
(assert-true   (tn) (string-ci<=? "0" "0"))
(assert-true   (tn) (string-ci<=? "0" "9"))
(assert-true   (tn) (string-ci<=? "0" "A"))
(assert-true   (tn) (string-ci<=? "0" "B"))
(assert-true   (tn) (string-ci<=? "0" "Z"))
(assert-true   (tn) (string-ci<=? "0" "_"))
(assert-true   (tn) (string-ci<=? "0" "a"))
(assert-true   (tn) (string-ci<=? "0" "b"))
(assert-true   (tn) (string-ci<=? "0" "z"))
(assert-true   (tn) (string-ci<=? "0" "~"))
(assert-true   (tn) (string-ci<=? "0" "\x7f"))
(tn "string-ci<=? \"9\"")
(assert-false  (tn) (string-ci<=? "9" ""))
(assert-false  (tn) (string-ci<=? "9" "\n"))
(assert-false  (tn) (string-ci<=? "9" " "))
(assert-false  (tn) (string-ci<=? "9" "!"))
(assert-false  (tn) (string-ci<=? "9" "0"))
(assert-true   (tn) (string-ci<=? "9" "9"))
(assert-true   (tn) (string-ci<=? "9" "A"))
(assert-true   (tn) (string-ci<=? "9" "B"))
(assert-true   (tn) (string-ci<=? "9" "Z"))
(assert-true   (tn) (string-ci<=? "9" "_"))
(assert-true   (tn) (string-ci<=? "9" "a"))
(assert-true   (tn) (string-ci<=? "9" "b"))
(assert-true   (tn) (string-ci<=? "9" "z"))
(assert-true   (tn) (string-ci<=? "9" "~"))
(assert-true   (tn) (string-ci<=? "9" "\x7f"))
(tn "string-ci<=? \"A\"")
(assert-false  (tn) (string-ci<=? "A" ""))
(assert-false  (tn) (string-ci<=? "A" "\n"))
(assert-false  (tn) (string-ci<=? "A" " "))
(assert-false  (tn) (string-ci<=? "A" "!"))
(assert-false  (tn) (string-ci<=? "A" "0"))
(assert-false  (tn) (string-ci<=? "A" "9"))
(assert-true   (tn) (string-ci<=? "A" "A"))
(assert-true   (tn) (string-ci<=? "A" "B"))
(assert-true   (tn) (string-ci<=? "A" "Z"))
(assert-false  (tn) (string-ci<=? "A" "_"))
(assert-true   (tn) (string-ci<=? "A" "a"))
(assert-true   (tn) (string-ci<=? "A" "b"))
(assert-true   (tn) (string-ci<=? "A" "z"))
(assert-true   (tn) (string-ci<=? "A" "~"))
(assert-true   (tn) (string-ci<=? "A" "\x7f"))
(tn "string-ci<=? \"B\"")
(assert-false  (tn) (string-ci<=? "B" ""))
(assert-false  (tn) (string-ci<=? "B" "\n"))
(assert-false  (tn) (string-ci<=? "B" " "))
(assert-false  (tn) (string-ci<=? "B" "!"))
(assert-false  (tn) (string-ci<=? "B" "0"))
(assert-false  (tn) (string-ci<=? "B" "9"))
(assert-false  (tn) (string-ci<=? "B" "A"))
(assert-true   (tn) (string-ci<=? "B" "B"))
(assert-true   (tn) (string-ci<=? "B" "Z"))
(assert-false  (tn) (string-ci<=? "B" "_"))
(assert-false  (tn) (string-ci<=? "B" "a"))
(assert-true   (tn) (string-ci<=? "B" "b"))
(assert-true   (tn) (string-ci<=? "B" "z"))
(assert-true   (tn) (string-ci<=? "B" "~"))
(assert-true   (tn) (string-ci<=? "B" "\x7f"))
(tn "string-ci<=? \"Z\"")
(assert-false  (tn) (string-ci<=? "Z" ""))
(assert-false  (tn) (string-ci<=? "Z" "\n"))
(assert-false  (tn) (string-ci<=? "Z" " "))
(assert-false  (tn) (string-ci<=? "Z" "!"))
(assert-false  (tn) (string-ci<=? "Z" "0"))
(assert-false  (tn) (string-ci<=? "Z" "9"))
(assert-false  (tn) (string-ci<=? "Z" "A"))
(assert-false  (tn) (string-ci<=? "Z" "B"))
(assert-true   (tn) (string-ci<=? "Z" "Z"))
(assert-false  (tn) (string-ci<=? "Z" "_"))
(assert-false  (tn) (string-ci<=? "Z" "a"))
(assert-false  (tn) (string-ci<=? "Z" "b"))
(assert-true   (tn) (string-ci<=? "Z" "z"))
(assert-true   (tn) (string-ci<=? "Z" "~"))
(assert-true   (tn) (string-ci<=? "Z" "\x7f"))
(tn "string-ci<=? \"_\"")
(assert-false  (tn) (string-ci<=? "_" ""))
(assert-false  (tn) (string-ci<=? "_" "\n"))
(assert-false  (tn) (string-ci<=? "_" " "))
(assert-false  (tn) (string-ci<=? "_" "!"))
(assert-false  (tn) (string-ci<=? "_" "0"))
(assert-false  (tn) (string-ci<=? "_" "9"))
(assert-true   (tn) (string-ci<=? "_" "A"))
(assert-true   (tn) (string-ci<=? "_" "B"))
(assert-true   (tn) (string-ci<=? "_" "Z"))
(assert-true   (tn) (string-ci<=? "_" "_"))
(assert-true   (tn) (string-ci<=? "_" "a"))
(assert-true   (tn) (string-ci<=? "_" "b"))
(assert-true   (tn) (string-ci<=? "_" "z"))
(assert-true   (tn) (string-ci<=? "_" "~"))
(assert-true   (tn) (string-ci<=? "_" "\x7f"))
(tn "string-ci<=? \"a\"")
(assert-false  (tn) (string-ci<=? "a" ""))
(assert-false  (tn) (string-ci<=? "a" "\n"))
(assert-false  (tn) (string-ci<=? "a" " "))
(assert-false  (tn) (string-ci<=? "a" "!"))
(assert-false  (tn) (string-ci<=? "a" "0"))
(assert-false  (tn) (string-ci<=? "a" "9"))
(assert-true   (tn) (string-ci<=? "a" "A"))
(assert-true   (tn) (string-ci<=? "a" "B"))
(assert-true   (tn) (string-ci<=? "a" "Z"))
(assert-false  (tn) (string-ci<=? "a" "_"))
(assert-true   (tn) (string-ci<=? "a" "a"))
(assert-true   (tn) (string-ci<=? "a" "b"))
(assert-true   (tn) (string-ci<=? "a" "z"))
(assert-true   (tn) (string-ci<=? "a" "~"))
(assert-true   (tn) (string-ci<=? "a" "\x7f"))
(tn "string-ci<=? \"b\"")
(assert-false  (tn) (string-ci<=? "b" ""))
(assert-false  (tn) (string-ci<=? "b" "\n"))
(assert-false  (tn) (string-ci<=? "b" " "))
(assert-false  (tn) (string-ci<=? "b" "!"))
(assert-false  (tn) (string-ci<=? "b" "0"))
(assert-false  (tn) (string-ci<=? "b" "9"))
(assert-false  (tn) (string-ci<=? "b" "A"))
(assert-true   (tn) (string-ci<=? "b" "B"))
(assert-true   (tn) (string-ci<=? "b" "Z"))
(assert-false  (tn) (string-ci<=? "b" "_"))
(assert-false  (tn) (string-ci<=? "b" "a"))
(assert-true   (tn) (string-ci<=? "b" "b"))
(assert-true   (tn) (string-ci<=? "b" "z"))
(assert-true   (tn) (string-ci<=? "b" "~"))
(assert-true   (tn) (string-ci<=? "b" "\x7f"))
(tn "string-ci<=? \"z\"")
(assert-false  (tn) (string-ci<=? "z" ""))
(assert-false  (tn) (string-ci<=? "z" "\n"))
(assert-false  (tn) (string-ci<=? "z" " "))
(assert-false  (tn) (string-ci<=? "z" "!"))
(assert-false  (tn) (string-ci<=? "z" "0"))
(assert-false  (tn) (string-ci<=? "z" "9"))
(assert-false  (tn) (string-ci<=? "z" "A"))
(assert-false  (tn) (string-ci<=? "z" "B"))
(assert-true   (tn) (string-ci<=? "z" "Z"))
(assert-false  (tn) (string-ci<=? "z" "_"))
(assert-false  (tn) (string-ci<=? "z" "a"))
(assert-false  (tn) (string-ci<=? "z" "b"))
(assert-true   (tn) (string-ci<=? "z" "z"))
(assert-true   (tn) (string-ci<=? "z" "~"))
(assert-true   (tn) (string-ci<=? "z" "\x7f"))
(tn "string-ci<=? \"~\"")
(assert-false  (tn) (string-ci<=? "~" ""))
(assert-false  (tn) (string-ci<=? "~" "\n"))
(assert-false  (tn) (string-ci<=? "~" " "))
(assert-false  (tn) (string-ci<=? "~" "!"))
(assert-false  (tn) (string-ci<=? "~" "0"))
(assert-false  (tn) (string-ci<=? "~" "9"))
(assert-false  (tn) (string-ci<=? "~" "A"))
(assert-false  (tn) (string-ci<=? "~" "B"))
(assert-false  (tn) (string-ci<=? "~" "Z"))
(assert-false  (tn) (string-ci<=? "~" "_"))
(assert-false  (tn) (string-ci<=? "~" "a"))
(assert-false  (tn) (string-ci<=? "~" "b"))
(assert-false  (tn) (string-ci<=? "~" "z"))
(assert-true   (tn) (string-ci<=? "~" "~"))
(assert-true   (tn) (string-ci<=? "~" "\x7f"))
(tn "string-ci<=? \"\\x7f\"")
(assert-false  (tn) (string-ci<=? "\x7f" ""))
(assert-false  (tn) (string-ci<=? "\x7f" "\n"))
(assert-false  (tn) (string-ci<=? "\x7f" " "))
(assert-false  (tn) (string-ci<=? "\x7f" "!"))
(assert-false  (tn) (string-ci<=? "\x7f" "0"))
(assert-false  (tn) (string-ci<=? "\x7f" "9"))
(assert-false  (tn) (string-ci<=? "\x7f" "A"))
(assert-false  (tn) (string-ci<=? "\x7f" "B"))
(assert-false  (tn) (string-ci<=? "\x7f" "Z"))
(assert-false  (tn) (string-ci<=? "\x7f" "_"))
(assert-false  (tn) (string-ci<=? "\x7f" "a"))
(assert-false  (tn) (string-ci<=? "\x7f" "b"))
(assert-false  (tn) (string-ci<=? "\x7f" "z"))
(assert-false  (tn) (string-ci<=? "\x7f" "~"))
(assert-true   (tn) (string-ci<=? "\x7f" "\x7f"))
(tn "string-ci<=? alphabets")
(assert-true   (tn) (string-ci<=? "aa" "aa"))
(assert-true   (tn) (string-ci<=? "aa" "AA"))
(assert-true   (tn) (string-ci<=? "aa" "aA"))
(assert-true   (tn) (string-ci<=? "aa" "Aa"))
(assert-true   (tn) (string-ci<=? "AA" "aa"))
(assert-true   (tn) (string-ci<=? "aA" "aa"))
(assert-true   (tn) (string-ci<=? "Aa" "aa"))
(assert-true   (tn) (string-ci<=? "abc" "abc"))
(assert-true   (tn) (string-ci<=? "abc" "ABC"))
(assert-true   (tn) (string-ci<=? "abc" "ABc"))
(assert-true   (tn) (string-ci<=? "abc" "abcd"))
(assert-true   (tn) (string-ci<=? "ABC" "abc"))
(assert-true   (tn) (string-ci<=? "ABc" "abc"))
(assert-false  (tn) (string-ci<=? "abcd" "abc"))

;; string-ci>=?
(tn "string-ci>=? \"\"")
(assert-true   (tn) (string-ci>=? "" ""))
(assert-false  (tn) (string-ci>=? "" "\n"))
(assert-false  (tn) (string-ci>=? "" " "))
(assert-false  (tn) (string-ci>=? "" "!"))
(assert-false  (tn) (string-ci>=? "" "0"))
(assert-false  (tn) (string-ci>=? "" "9"))
(assert-false  (tn) (string-ci>=? "" "A"))
(assert-false  (tn) (string-ci>=? "" "B"))
(assert-false  (tn) (string-ci>=? "" "Z"))
(assert-false  (tn) (string-ci>=? "" "_"))
(assert-false  (tn) (string-ci>=? "" "a"))
(assert-false  (tn) (string-ci>=? "" "b"))
(assert-false  (tn) (string-ci>=? "" "z"))
(assert-false  (tn) (string-ci>=? "" "~"))
(assert-false  (tn) (string-ci>=? "" "\x7f"))
(tn "string-ci>=? \"\\n\"")
(assert-true   (tn) (string-ci>=? "\n" ""))
(assert-true   (tn) (string-ci>=? "\n" "\n"))
(assert-false  (tn) (string-ci>=? "\n" " "))
(assert-false  (tn) (string-ci>=? "\n" "!"))
(assert-false  (tn) (string-ci>=? "\n" "0"))
(assert-false  (tn) (string-ci>=? "\n" "9"))
(assert-false  (tn) (string-ci>=? "\n" "A"))
(assert-false  (tn) (string-ci>=? "\n" "B"))
(assert-false  (tn) (string-ci>=? "\n" "Z"))
(assert-false  (tn) (string-ci>=? "\n" "_"))
(assert-false  (tn) (string-ci>=? "\n" "a"))
(assert-false  (tn) (string-ci>=? "\n" "b"))
(assert-false  (tn) (string-ci>=? "\n" "z"))
(assert-false  (tn) (string-ci>=? "\n" "~"))
(assert-false  (tn) (string-ci>=? "\n" "\x7f"))
(tn "string-ci>=? \" \"")
(assert-true   (tn) (string-ci>=? " " ""))
(assert-true   (tn) (string-ci>=? " " "\n"))
(assert-true   (tn) (string-ci>=? " " " "))
(assert-false  (tn) (string-ci>=? " " "!"))
(assert-false  (tn) (string-ci>=? " " "0"))
(assert-false  (tn) (string-ci>=? " " "9"))
(assert-false  (tn) (string-ci>=? " " "A"))
(assert-false  (tn) (string-ci>=? " " "B"))
(assert-false  (tn) (string-ci>=? " " "Z"))
(assert-false  (tn) (string-ci>=? " " "_"))
(assert-false  (tn) (string-ci>=? " " "a"))
(assert-false  (tn) (string-ci>=? " " "b"))
(assert-false  (tn) (string-ci>=? " " "z"))
(assert-false  (tn) (string-ci>=? " " "~"))
(assert-false  (tn) (string-ci>=? " " "\x7f"))
(tn "string-ci>=? \"!\"")
(assert-true   (tn) (string-ci>=? "!" ""))
(assert-true   (tn) (string-ci>=? "!" "\n"))
(assert-true   (tn) (string-ci>=? "!" " "))
(assert-true   (tn) (string-ci>=? "!" "!"))
(assert-false  (tn) (string-ci>=? "!" "0"))
(assert-false  (tn) (string-ci>=? "!" "9"))
(assert-false  (tn) (string-ci>=? "!" "A"))
(assert-false  (tn) (string-ci>=? "!" "B"))
(assert-false  (tn) (string-ci>=? "!" "Z"))
(assert-false  (tn) (string-ci>=? "!" "_"))
(assert-false  (tn) (string-ci>=? "!" "a"))
(assert-false  (tn) (string-ci>=? "!" "b"))
(assert-false  (tn) (string-ci>=? "!" "z"))
(assert-false  (tn) (string-ci>=? "!" "~"))
(assert-false  (tn) (string-ci>=? "!" "\x7f"))
(tn "string-ci>=? \"0\"")
(assert-true   (tn) (string-ci>=? "0" ""))
(assert-true   (tn) (string-ci>=? "0" "\n"))
(assert-true   (tn) (string-ci>=? "0" " "))
(assert-true   (tn) (string-ci>=? "0" "!"))
(assert-true   (tn) (string-ci>=? "0" "0"))
(assert-false  (tn) (string-ci>=? "0" "9"))
(assert-false  (tn) (string-ci>=? "0" "A"))
(assert-false  (tn) (string-ci>=? "0" "B"))
(assert-false  (tn) (string-ci>=? "0" "Z"))
(assert-false  (tn) (string-ci>=? "0" "_"))
(assert-false  (tn) (string-ci>=? "0" "a"))
(assert-false  (tn) (string-ci>=? "0" "b"))
(assert-false  (tn) (string-ci>=? "0" "z"))
(assert-false  (tn) (string-ci>=? "0" "~"))
(assert-false  (tn) (string-ci>=? "0" "\x7f"))
(tn "string-ci>=? \"9\"")
(assert-true   (tn) (string-ci>=? "9" ""))
(assert-true   (tn) (string-ci>=? "9" "\n"))
(assert-true   (tn) (string-ci>=? "9" " "))
(assert-true   (tn) (string-ci>=? "9" "!"))
(assert-true   (tn) (string-ci>=? "9" "0"))
(assert-true   (tn) (string-ci>=? "9" "9"))
(assert-false  (tn) (string-ci>=? "9" "A"))
(assert-false  (tn) (string-ci>=? "9" "B"))
(assert-false  (tn) (string-ci>=? "9" "Z"))
(assert-false  (tn) (string-ci>=? "9" "_"))
(assert-false  (tn) (string-ci>=? "9" "a"))
(assert-false  (tn) (string-ci>=? "9" "b"))
(assert-false  (tn) (string-ci>=? "9" "z"))
(assert-false  (tn) (string-ci>=? "9" "~"))
(assert-false  (tn) (string-ci>=? "9" "\x7f"))
(tn "string-ci>=? \"A\"")
(assert-true   (tn) (string-ci>=? "A" ""))
(assert-true   (tn) (string-ci>=? "A" "\n"))
(assert-true   (tn) (string-ci>=? "A" " "))
(assert-true   (tn) (string-ci>=? "A" "!"))
(assert-true   (tn) (string-ci>=? "A" "0"))
(assert-true   (tn) (string-ci>=? "A" "9"))
(assert-true   (tn) (string-ci>=? "A" "A"))
(assert-false  (tn) (string-ci>=? "A" "B"))
(assert-false  (tn) (string-ci>=? "A" "Z"))
(assert-true   (tn) (string-ci>=? "A" "_"))
(assert-true   (tn) (string-ci>=? "A" "a"))
(assert-false  (tn) (string-ci>=? "A" "b"))
(assert-false  (tn) (string-ci>=? "A" "z"))
(assert-false  (tn) (string-ci>=? "A" "~"))
(assert-false  (tn) (string-ci>=? "A" "\x7f"))
(tn "string-ci>=? \"B\"")
(assert-true   (tn) (string-ci>=? "B" ""))
(assert-true   (tn) (string-ci>=? "B" "\n"))
(assert-true   (tn) (string-ci>=? "B" " "))
(assert-true   (tn) (string-ci>=? "B" "!"))
(assert-true   (tn) (string-ci>=? "B" "0"))
(assert-true   (tn) (string-ci>=? "B" "9"))
(assert-true   (tn) (string-ci>=? "B" "A"))
(assert-true   (tn) (string-ci>=? "B" "B"))
(assert-false  (tn) (string-ci>=? "B" "Z"))
(assert-true   (tn) (string-ci>=? "B" "_"))
(assert-true   (tn) (string-ci>=? "B" "a"))
(assert-true   (tn) (string-ci>=? "B" "b"))
(assert-false  (tn) (string-ci>=? "B" "z"))
(assert-false  (tn) (string-ci>=? "B" "~"))
(assert-false  (tn) (string-ci>=? "B" "\x7f"))
(tn "string-ci>=? \"Z\"")
(assert-true   (tn) (string-ci>=? "Z" ""))
(assert-true   (tn) (string-ci>=? "Z" "\n"))
(assert-true   (tn) (string-ci>=? "Z" " "))
(assert-true   (tn) (string-ci>=? "Z" "!"))
(assert-true   (tn) (string-ci>=? "Z" "0"))
(assert-true   (tn) (string-ci>=? "Z" "9"))
(assert-true   (tn) (string-ci>=? "Z" "A"))
(assert-true   (tn) (string-ci>=? "Z" "B"))
(assert-true   (tn) (string-ci>=? "Z" "Z"))
(assert-true   (tn) (string-ci>=? "Z" "_"))
(assert-true   (tn) (string-ci>=? "Z" "a"))
(assert-true   (tn) (string-ci>=? "Z" "b"))
(assert-true   (tn) (string-ci>=? "Z" "z"))
(assert-false  (tn) (string-ci>=? "Z" "~"))
(assert-false  (tn) (string-ci>=? "Z" "\x7f"))
(tn "string-ci>=? \"_\"")
(assert-true   (tn) (string-ci>=? "_" ""))
(assert-true   (tn) (string-ci>=? "_" "\n"))
(assert-true   (tn) (string-ci>=? "_" " "))
(assert-true   (tn) (string-ci>=? "_" "!"))
(assert-true   (tn) (string-ci>=? "_" "0"))
(assert-true   (tn) (string-ci>=? "_" "9"))
(assert-false  (tn) (string-ci>=? "_" "A"))
(assert-false  (tn) (string-ci>=? "_" "B"))
(assert-false  (tn) (string-ci>=? "_" "Z"))
(assert-true   (tn) (string-ci>=? "_" "_"))
(assert-false  (tn) (string-ci>=? "_" "a"))
(assert-false  (tn) (string-ci>=? "_" "b"))
(assert-false  (tn) (string-ci>=? "_" "z"))
(assert-false  (tn) (string-ci>=? "_" "~"))
(assert-false  (tn) (string-ci>=? "_" "\x7f"))
(tn "string-ci>=? \"a\"")
(assert-true   (tn) (string-ci>=? "a" ""))
(assert-true   (tn) (string-ci>=? "a" "\n"))
(assert-true   (tn) (string-ci>=? "a" " "))
(assert-true   (tn) (string-ci>=? "a" "!"))
(assert-true   (tn) (string-ci>=? "a" "0"))
(assert-true   (tn) (string-ci>=? "a" "9"))
(assert-true   (tn) (string-ci>=? "a" "A"))
(assert-false  (tn) (string-ci>=? "a" "B"))
(assert-false  (tn) (string-ci>=? "a" "Z"))
(assert-true   (tn) (string-ci>=? "a" "_"))
(assert-true   (tn) (string-ci>=? "a" "a"))
(assert-false  (tn) (string-ci>=? "a" "b"))
(assert-false  (tn) (string-ci>=? "a" "z"))
(assert-false  (tn) (string-ci>=? "a" "~"))
(assert-false  (tn) (string-ci>=? "a" "\x7f"))
(tn "string-ci>=? \"b\"")
(assert-true   (tn) (string-ci>=? "b" ""))
(assert-true   (tn) (string-ci>=? "b" "\n"))
(assert-true   (tn) (string-ci>=? "b" " "))
(assert-true   (tn) (string-ci>=? "b" "!"))
(assert-true   (tn) (string-ci>=? "b" "0"))
(assert-true   (tn) (string-ci>=? "b" "9"))
(assert-true   (tn) (string-ci>=? "b" "A"))
(assert-true   (tn) (string-ci>=? "b" "B"))
(assert-false  (tn) (string-ci>=? "b" "Z"))
(assert-true   (tn) (string-ci>=? "b" "_"))
(assert-true   (tn) (string-ci>=? "b" "a"))
(assert-true   (tn) (string-ci>=? "b" "b"))
(assert-false  (tn) (string-ci>=? "b" "z"))
(assert-false  (tn) (string-ci>=? "b" "~"))
(assert-false  (tn) (string-ci>=? "b" "\x7f"))
(tn "string-ci>=? \"z\"")
(assert-true   (tn) (string-ci>=? "z" ""))
(assert-true   (tn) (string-ci>=? "z" "\n"))
(assert-true   (tn) (string-ci>=? "z" " "))
(assert-true   (tn) (string-ci>=? "z" "!"))
(assert-true   (tn) (string-ci>=? "z" "0"))
(assert-true   (tn) (string-ci>=? "z" "9"))
(assert-true   (tn) (string-ci>=? "z" "A"))
(assert-true   (tn) (string-ci>=? "z" "B"))
(assert-true   (tn) (string-ci>=? "z" "Z"))
(assert-true   (tn) (string-ci>=? "z" "_"))
(assert-true   (tn) (string-ci>=? "z" "a"))
(assert-true   (tn) (string-ci>=? "z" "b"))
(assert-true   (tn) (string-ci>=? "z" "z"))
(assert-false  (tn) (string-ci>=? "z" "~"))
(assert-false  (tn) (string-ci>=? "z" "\x7f"))
(tn "string-ci>=? \"~\"")
(assert-true   (tn) (string-ci>=? "~" ""))
(assert-true   (tn) (string-ci>=? "~" "\n"))
(assert-true   (tn) (string-ci>=? "~" " "))
(assert-true   (tn) (string-ci>=? "~" "!"))
(assert-true   (tn) (string-ci>=? "~" "0"))
(assert-true   (tn) (string-ci>=? "~" "9"))
(assert-true   (tn) (string-ci>=? "~" "A"))
(assert-true   (tn) (string-ci>=? "~" "B"))
(assert-true   (tn) (string-ci>=? "~" "Z"))
(assert-true   (tn) (string-ci>=? "~" "_"))
(assert-true   (tn) (string-ci>=? "~" "a"))
(assert-true   (tn) (string-ci>=? "~" "b"))
(assert-true   (tn) (string-ci>=? "~" "z"))
(assert-true   (tn) (string-ci>=? "~" "~"))
(assert-false  (tn) (string-ci>=? "~" "\x7f"))
(tn "string-ci>=? \"\\x7f\"")
(assert-true   (tn) (string-ci>=? "\x7f" ""))
(assert-true   (tn) (string-ci>=? "\x7f" "\n"))
(assert-true   (tn) (string-ci>=? "\x7f" " "))
(assert-true   (tn) (string-ci>=? "\x7f" "!"))
(assert-true   (tn) (string-ci>=? "\x7f" "0"))
(assert-true   (tn) (string-ci>=? "\x7f" "9"))
(assert-true   (tn) (string-ci>=? "\x7f" "A"))
(assert-true   (tn) (string-ci>=? "\x7f" "B"))
(assert-true   (tn) (string-ci>=? "\x7f" "Z"))
(assert-true   (tn) (string-ci>=? "\x7f" "_"))
(assert-true   (tn) (string-ci>=? "\x7f" "a"))
(assert-true   (tn) (string-ci>=? "\x7f" "b"))
(assert-true   (tn) (string-ci>=? "\x7f" "z"))
(assert-true   (tn) (string-ci>=? "\x7f" "~"))
(assert-true   (tn) (string-ci>=? "\x7f" "\x7f"))
(tn "string-ci>=? alphabets")
(assert-true   (tn) (string-ci>=? "aa" "aa"))
(assert-true   (tn) (string-ci>=? "aa" "AA"))
(assert-true   (tn) (string-ci>=? "aa" "aA"))
(assert-true   (tn) (string-ci>=? "aa" "Aa"))
(assert-true   (tn) (string-ci>=? "AA" "aa"))
(assert-true   (tn) (string-ci>=? "aA" "aa"))
(assert-true   (tn) (string-ci>=? "Aa" "aa"))
(assert-true   (tn) (string-ci>=? "abc" "abc"))
(assert-true   (tn) (string-ci>=? "abc" "ABC"))
(assert-true   (tn) (string-ci>=? "abc" "ABc"))
(assert-false  (tn) (string-ci>=? "abc" "abcd"))
(assert-true   (tn) (string-ci>=? "ABC" "abc"))
(assert-true   (tn) (string-ci>=? "ABc" "abc"))
(assert-true   (tn) (string-ci>=? "abcd" "abc"))

(total-report)
