# amazon.rb $Revision: 1.27.2.5 $: Making link with image to Amazon using Amazon ECS.
#
# see document: #{@lang}/amazon.rb
#
# Copyright (C) 2005 TADA Tadashi <sho@spc.gr.jp>
# You can redistribute it and/or modify it under GPL2.
#
require 'net/http'
require 'timeout'

# do not change these variables
@amazon_subscription_id = '1CVA98NEF1G753PFESR2'
@amazon_require_version = '2005-07-26'

def amazon_call_ecs( asin )
	limittime = 10

	aid =  @conf['amazon.aid'] || ''
	aid = 'cshs-22' if aid.length == 0

	url =  @amazon_ecs_url.dup
	url << "?Service=AWSECommerceService"
	url << "&SubscriptionId=#{@amazon_subscription_id}"
	url << "&AssociateTag=#{aid}"
	url << "&Operation=ItemLookup"
	url << "&ItemId=#{asin}"
	url << "&ResponseGroup=Medium"
	url << "&Version=#{@amazon_require_version}"

	proxy_host = nil
	proxy_port = 8080
	if /^([^:]+):(\d+)$/ =~ @conf['amazon.proxy'] then
		proxy_host = $1
		proxy_port = $2.to_i
	end

	xml = nil
	timeout( 10 ) do
		begin
			if %r|http://([^:/]*):?(\d*)(/.*)| =~ url then
				host = $1
				port = $2.to_i
				path = $3
				port = 80 if port == 0
			end
			Net::HTTP.version_1_1
			Net::HTTP.Proxy( proxy_host.untaint, proxy_port.untaint ).start( host.untaint, port.untaint ) do |http|
				response, = http.get( path )
				xml = response.body
			end
		rescue Net::ProtoRetriableError => err
			item_url = err.response['location']
			retry
		rescue
			raise 'getting item was failed'
		end
	end
	xml
end

def amazon_to_html( item, with_image = true, label = nil, pos = 'amazon' )
	with_image = false if @mode == 'categoryview'
	author = ''
	item.scan( %r|<Author>(.*?)</Author>|m ) do |a|
		author << a[0] << '/'
	end
	author = author.empty? ? '' : "(#{author.chop})"

	unless label then
		title = item.scan( %r|<Title>(.*?)</Title>|m )[0][0]
		label = "#{title}#{author}"
	end

	image = ''
	if with_image then
		size = case @conf['amazon.imgsize']
			when 0; 'Large' 
			when 2; 'Small'
			else;   'Medium'
		end
		begin
			image_item = item.scan( %r|<#{size}Image>(.*?)</#{size}Image>|m )[0][0]
			url = image_item.scan( %r|<URL>(.*?)</URL>|m )[0][0]
			w = image_item.scan( %r|<Width.*?>(.*?)</Width>|m )[0][0]
			h = image_item.scan( %r|<Height.*?>(.*?)</Height>|m )[0][0]
			image = <<-HTML
			<img class="#{pos}"
			src="#{url}" height="#{h}" width="#{w}"
			alt="#{label}" title="#{label}">
			HTML
		rescue NameError
			if @conf['amazon.nodefault'] then
				image = CGI::escapeHTML(label)
			else
				base = @conf['amazon.default_image_base'] || 'http://www.tdiary.org/images/amazondefaults/'
				name = case @conf['amazon.imgsize']
				when 0; 'large'
				when 2; 'small'
				else;   'medium'
				end
				size = case @conf['amazon.imgsize']
				when 0; [500, 380]
				when 2; [75, 57]
				else;   [160, 122]
				end
				image = <<-HTML
				<img class="#{pos}"
				src="#{base}#{name}.png"
				height="#{size[0]}"
				width="#{size[1]}"
				alt="#{CGI::escapeHTML(label)}" title="#{CGI::escapeHTML(label)}">
				HTML
			end
		end
		image.gsub!( /\t/, '' )
	end

	if with_image and @conf['amazon.hidename'] || pos != 'amazon' then
		label = ''
	end

	detail = item.scan( %r|<DetailPageURL>(.*?)</DetailPageURL>|m )[0][0]
	%Q|<a href="#{detail}">#{image}#{label}</a>|
end

def amazon_secure_html( asin, with_image, label, pos = 'amazon' )
	with_image = false if @mode == 'categoryview'
	label = asin unless label

	image = ''
	if with_image and @conf['amazon.secure-cgi'] then
		image = <<-HTML
		<img class="#{pos}"
		src="#{@conf['amazon.secure-cgi']}?asin=#{asin};size=#{@conf['amazon.imgsize']}"
		alt="#{CGI::escapeHTML(label)}" title="#{CGI::escapeHTML(label)}">
		HTML
	end
	image.gsub!( /\t/, '' )

	if with_image and @conf['amazon.hidename'] || pos != 'amazon' then
		label = ''
	end

	url =  "#{@amazon_url}/#{asin}"
	url << "/#{@conf['amazon.aid']}" if @conf['amazon.aid'] and @conf['amazon.aid'].length > 0
	url << "/ref=nosim/"
	%Q|<a href="#{url}">#{image}#{CGI::escapeHTML(label)}</a>|
end

def amazon_get( asin, with_image = true, label = nil, pos = 'amazon' )
	asin = asin.to_s.strip # delete white spaces

	if @conf.secure then
		amazon_secure_html( asin, with_image, label, pos )
	else
		begin
			cache = "#{@cache_path}/amazon"
			Dir::mkdir( cache ) unless File::directory?( cache )
			begin
				xml = File::open( "#{cache}/#{asin}.xml", 'r' ) {|f| f.read}
			rescue Errno::ENOENT
				xml =  amazon_call_ecs( asin )
				File::open( "#{cache}/#{asin}.xml", 'wb' ) {|f| f.write( xml )}
			end
			xml = @amazon_encoder.call( xml )

			item = xml.scan( %r|<Item>(.*)</Item>|m )[0][0]
			amazon_to_html( item, with_image, label, pos )
		rescue TimeoutError
			asin
		rescue
			"#{label ? label : asin}"
		end
	end
end

unless @conf.secure and not @conf['amazon.secure-cgi'] then
	add_conf_proc( 'amazon', @amazon_label_conf ) do
		amazon_conf_proc
	end
end

def amazon_conf_proc
	if @mode == 'saveconf' then
		unless @conf.secure and not @conf['amazon.secure-cgi'] then
			@conf['amazon.imgsize'] = @cgi.params['amazon.imgsize'][0].to_i
			@conf['amazon.hidename'] = (@cgi.params['amazon.hidename'][0] == 'true')
			unless @conf.secure then
				@conf['amazon.nodefault'] = (@cgi.params['amazon.nodefault'][0] == 'true')
				if @cgi.params['amazon.clearcache'][0] == 'true' then
					Dir["#{@cache_path}/amazon/*"].each do |cache|
						File::delete( cache.untaint )
					end
				end
			end
		end
		unless @conf['amazon.hideconf'] then
			@conf['amazon.aid'] = @cgi.params['amazon.aid'][0]
		end
	end

	result = ''
	unless @conf.secure and not @conf['amazon.secure-cgi'] then
		result << <<-HTML
			<h3>#{@amazon_label_imgsize}</h3>
			<p><select name="amazon.imgsize">
				<option value="0"#{if @conf['amazon.imgsize'] == 0 then " selected" end}>#{@amazon_label_large}</option>
				<option value="1"#{if @conf['amazon.imgsize'] == 1 then " selected" end}>#{@amazon_label_regular}</option>
				<option value="2"#{if @conf['amazon.imgsize'] == 2 then " selected" end}>#{@amazon_label_small}</option>
			</select></p>
			<h3>#{@amazon_label_title}</h3>
			<p><select name="amazon.hidename">
				<option value="true"#{if @conf['amazon.hidename'] then " selected" end}>#{@amazon_label_hide}</option>
				<option value="false"#{if not @conf['amazon.hidename'] then " selected" end}>#{@amazon_label_show}</option>
			</select></p>
		HTML
		unless @conf.secure then
			result << <<-HTML
				<h3>#{@amazon_label_notfound}</h3>
				<p><select name="amazon.nodefault">
					<option value="true"#{if @conf['amazon.nodefault'] then " selected" end}>#{@amazon_label_usetitle}</option>
					<option value="false"#{if not @conf['amazon.nodefault'] then " selected" end}>#{@amazon_label_usedefault}</option>
				</select></p>
				<h3>#{@amazon_label_clearcache}</h3>
				<p><input type="checkbox" name="amazon.clearcache" value="true">#{@amazon_label_clearcache_desc}</input></p>
			HTML
		end
	end
	unless @conf['amazon.hideconf'] then
		result << <<-HTML
			<h3>#{@amazon_label_aid}</h3>
			<p>#{@amazon_label_aid_desc}</p>
			<p><input name="amazon.aid" value="#{CGI::escapeHTML( @conf['amazon.aid'] ) if @conf['amazon.aid']}"></p>
		HTML
	end
	result
end
def isbn_image( asin, label = nil )
	amazon_get( asin, true, label )
end

def isbn_image_left( asin, label = nil )
	amazon_get( asin, true, label, 'left' )
end

def isbn_image_right( asin, label = nil )
	amazon_get( asin, true, label, 'right' )
end

def isbn( asin, label = nil )
	amazon_get( asin, false, label )
end

# for compatibility
alias isbnImgLeft isbn_image_left
alias isbnImgRight isbn_image_right
alias isbnImg isbn_image
alias amazon isbn_image
