/* Copyright (C) 2002 Jean-Marc Valin 
   File: lbr_48k_tables.c

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   
   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
   
   - Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
   
   - Neither the name of the Xiph.org Foundation nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.
   
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


const int dummy_epic_48k_variable=0;
#ifdef EPIC_48K

const signed char gain_cdbk_ulbr[256] = {
-31, -48, -30, 10,
-19, -10, -18, 25,
-33, -22, -45, 12,
-5, -56, -43, 31,
-30, -56, -3, 28,
-59, -17, -52, 31,
-41, -60, -58, 32,
-64, -47, -22, 29,
-30, -31, -31, 2,
-29, -14, -31, 11,
-22, -37, -58, 21,
-31, -44, 13, 29,
-37, 0, 1, 35,
-46, -55, -35, 20, 
-56, -14, -53, 32,
-8, 1, -36, 31,
-29, -15, -27, 13,
-29, -39, -28, 7,
-43, -5, 3, 37,
-51, -27, -54, 23,
10, -46, -36, 30,
3, -3, -42, 37,
-27, 16, -22, 32,
-34, -52, 13, 34,
-31, -21, -28, 8,
-34, -45, -40, 12,
-20, -48, 4, 32,
-40, -27, 16, 31,
-6, 11, -44, 41,
-35, 12, -5, 37,
19, -33, -37, 29,
-29, 18, -32, 27,
-29, -23, -19, 13,
16, -47, -28, 34,
-34, -30, 17, 27,
-20, 2, -26, 26,
-38, -40, -36, 9,
15, -14, -40, 37,
-39, 14, -9, 38,
-15, 25, -39, 41,
-26, 19, -32, 29,
-39, 17, -14, 37,
10, -36, -26, 26,
14, -13, -40, 37,
-29, -21, -12, 17,
-8, 19, -39, 41,
-36, -18, 15, 33,
-32, -38, -38, 6,
-19, 4, -23, 29,
-38, -7, 11, 37,
9, -10, -39, 35,
-37, 24, -19, 37,
-34, -5, -8, 27,
-20, 23, -41, 38,
-4, 17, -31, 39,
-17, -26, -26, 14,
-24, 28, -36, 36,
-7, 15, -39, 40,
-42, 16, -11, 40,
-29, 14, -6, 38,
-36, 28, -27, 35,
-21, 5, -26, 27,
11, -9, -39, 37,
-38, -7, 13, 38
};


const signed char exc_12_32_table[384] = {
34, 55, 9, 55, 4, 44, -2, 25, 4, -6, 13, -22, 
20, 26, -13, -56, -37, 18, 5, 28, 4, 10, 6, -7, 
37, -24, -31, 22, 12, -6, -4, -7, 2, 0, -3, -2, 
-16, -13, -1, 9, -2, 4, 6, 5, -3, 3, 8, -1, 
-1, -6, -2, -1, 8, 24, 19, 33, -73, -53, 6, -18, 
14, 7, 11, 8, -33, -94, -5, 7, 0, 44, 1, 19, 
-9, -7, -34, -16, 8, 2, 5, 0, 3, 1, -2, 3, 
-22, 6, -2, 12, 16, 30, 39, 25, 25, 2, 10, -2, 
-1, -40, -6, -51, -5, -48, -9, -33, -14, -1, -24, 15, 
104, 39, 12, -9, -20, -12, -30, -10, -31, -7, -30, -8, 
-71, -53, -4, -11, 9, -10, 7, -10, 10, -1, 11, 8, 
24, 14, 6, -3, 10, 8, 8, 11, -6, 11, 0, -2, 
-6, -2, 1, -1, -3, 8, -41, 27, 57, -7, 11, -16, 
-61, 50, 10, -10, 4, -13, 14, -7, 1, 5, -4, 4, 
0, 2, -1, -2, -1, 1, 1, 0, -1, -1, -2, -3, 
-3, -15, 69, 60, 10, -10, -10, -29, -21, -7, -16, 2, 
24, -32, 24, -18, -14, -2, -11, 11, -6, 10, 1, 3, 
24, -10, 14, 18, -13, 17, -16, 4, -3, -21, -3, -11, 
-19, 12, -14, 26, 20, -9, 24, -15, 18, 1, -32, -2, 
-1, 8, -3, 4, 11, -47, 7, 46, -4, -10, -10, -2, 
-24, 29, -33, 6, -20, -3, 0, -12, 5, -30, 8, -13, 
28, 9, 5, -11, 0, -14, -13, -22, -12, -8, -4, 1, 
-6, 28, 45, -18, -31, -5, 1, 2, 1, 5, 0, -3, 
-19, -10, 10, 27, 8, -16, -28, -9, 2, -5, 8, -1, 
100, -49, 4, -43, 25, -7, 1, 9, -13, 13, -18, 13, 
-1, -1, 0, 2, -2, -8, 9, -46, -7, 70, 23, 7, 
-103, 20, 8, 42, -5, 21, -4, 4, 1, -8, 16, -8, 
3, 3, 8, 4, 7, -3, -3, -4, 9, 6, 2, 13, 
6, 3, -15, 11, -43, 31, 40, -13, 12, -21, -2, -3, 
-10, -9, 16, -35, 31, -3, -12, 8, -34, 7, 12, 22, 
-3, -4, -7, -12, 24, 53, -19, -43, 4, -3, -4, 6, 
-18, -30, -58, -17, -11, 17, 23, 34, 30, 28, 28, 15, 
};


const signed char cdbk_lsp_vlbr[5120]={
23, 34, 108, 100, 102, 82, 69, 48, 52, 25,
0, -37, -55, -78, -111, -79, 58, 57, 45, 32,
27, -9, -12, -14, -41, -29, -17, -41, 44, 35,
-24, -68, -72, 61, 100, 73, 100, 80, 70, 37,
12, -5, 22, 11, -10, -40, -33, -17, 19, 12,
-20, -57, -94, -92, 56, 71, 48, 31, 22, -5,
41, 28, 6, -6, -12, -39, -18, -16, -30, -23,
65, 54, 41, 28, 23, 9, 26, 18, 22, 6,
17, -16, -33, -54, -87, -79, 8, -8, 44, 35,
-20, -62, -78, 22, 78, 47, 44, 33, 26, 14,
8, 1, 45, 47, 72, 68, 55, 31, 36, 17,
-27, -68, -86, -65, -10, 23, 8, -22, -31, 25,
-4, -38, -55, -68, -96, -118, -39, 30, 28, 31,
-21, -66, -47, 99, 91, 68, 78, 56, 64, 36,
33, 22, 13, -13, -36, -22, 44, 37, 54, 33,
-31, -76, -106, -100, -5, 21, 7, -17, 13, 48,
-26, -65, -84, -84, -46, 67, 97, 66, 58, 31,
-20, -52, -32, -20, 3, 16, 27, 40, 54, 29,
-6, -35, -56, -64, -8, -31, -36, 21, 26, -3,
32, 23, 1, -23, -19, -44, -45, -7, 10, -10,
-24, -55, 2, 67, 72, 85, 90, 74, 77, 45,
-21, -58, -45, -49, 16, 34, 13, -15, -16, 16,
8, -31, -34, -61, -83, 10, 24, 8, 56, 25,
-8, -49, -74, -95, -123, -77, 6, 40, 46, 42,
-21, -60, -59, -34, -12, 27, 8, -19, -48, -17,
-25, -66, -78, -73, -81, -16, 14, 0, -2, 33,
78, 79, 69, 49, 44, 32, 50, 44, 46, 22,
24, 9, -4, -18, -37, -56, 22, 34, 22, 11,
-19, -59, -85, -41, 46, 72, 60, 33, 29, -3,
-21, -66, -70, 65, 92, 57, 61, 41, 40, 23,
-4, -41, -60, -72, -102, -106, 4, 56, 57, 31,
-5, -48, -62, -91, -109, 1, 76, 54, 72, 39,
-21, -61, -86, -46, -34, -39, 42, 25, 15, 12,
5, -16, -36, -56, 5, 18, 11, 13, 52, 23,
12, -6, 30, 40, 59, 40, 27, 8, 19, 6,
25, 8, -9, -19, -25, -53, -40, -38, -46, -4,
-17, -59, -83, 2, 58, 29, 18, -2, -17, -5,
-35, -80, -111, -117, -41, -9, 14, 23, 36, 56,
48, 67, 93, 71, 77, 91, 110, 95, 83, 47,
-25, -62, -97, -93, 76, 96, 73, 52, 61, 28,
-9, -55, -46, 49, 33, 8, 1, -25, 28, 23,
-10, -47, -60, -45, -62, -58, 56, 57, 48, 28,
34, 12, -9, 0, 34, 4, 6, 11, 3, -18,
21, -9, -16, -13, -39, -41, 14, -8, 33, 28,
-7, -49, -61, 15, 34, 3, 2, -13, -28, -17,
-14, -50, -46, -65, -76, -13, -10, -29, -30, 22,
-28, -68, -97, -98, -8, 38, 36, 26, 25, 15,
6, -33, -9, 1, -28, -11, -19, -24, 61, 36,
-15, -60, -19, 81, 58, 52, 42, 28, 66, 36,
-15, -52, -71, -15, 11, -13, 38, 28, 11, -4,
34, 1, -9, -27, -57, -19, 36, 6, 14, 0,
-1, -43, -14, 16, -12, -5, -14, -29, -33, -32,
-13, -57, -75, -100, -111, 1, 2, 13, 48, 33,
12, 16, 100, 85, 69, 49, 40, 29, 46, 23,
-4, -26, -41, -44, -7, -26, -39, -27, 18, 0,
-4, -47, -51, 17, 7, -19, 13, -10, -16, 9,
-24, -63, -93, -53, 25, 14, 73, 51, 35, 8,
-34, -77, -106, -83, -51, -47, 2, 12, 41, 53,
-13, -47, -67, -44, 42, 20, 24, 33, 21, -3,
11, -15, -29, -51, -79, -88, 22, 56, 43, 20,
11, -22, -37, -1, 61, 40, 28, 24, 22, -6,
-3, -33, -50, -66, -93, -100, -16, -16, 3, 41,
-18, -58, -82, -5, 95, 78, 56, 39, 30, 1,
-6, -47, -28, -26, -36, 49, 55, 51, 71, 35,
-6, -50, -42, -4, -32, -1, -1, -18, 67, 40,
-23, -63, -56, -48, -32, 0, -14, -43, -46, 25,
-17, -61, -63, 13, -1, 28, 23, 10, 67, 36,
45, 92, 124, 111, 108, 86, 77, 56, 57, 28,
50, 35, 13, 3, -2, -32, 3, 14, 6, -8,
12, -17, -24, -42, -67, -23, 67, 49, 64, 38,
-21, -60, -90, -45, 32, 6, 7, -3, -15, 9,
-16, -62, -73, 50, 46, 18, 7, -13, 63, 39,
19, -16, -19, 20, 5, -15, 16, -9, 5, 8,
-11, -46, -42, -39, -55, -68, -62, -27, -18, 23,
-23, -61, -67, -71, -29, 44, 32, 10, -15, -12,
-6, -45, -43, -40, -67, -22, 42, 19, 61, 38,
9, -13, -38, -37, 40, 30, 15, 9, 11, -16,
0, -18, -29, -34, -17, -44, -50, -3, 47, 15,
-3, -46, -26, 20, -10, 16, 20, -2, 43, 18,
-23, -46, 46, 91, 99, 100, 99, 79, 72, 42,
-1, -44, -33, -36, -56, 22, 17, 4, 71, 37,
0, -38, -49, 0, -1, -30, -21, -35, -44, -6,
-32, -74, -101, -98, -14, -21, -23, 7, 26, 45,
8, -28, -44, -63, -96, -84, 34, 21, 13, 23,
10, -24, -38, -17, -29, -53, -16, -41, -14, 23,
-19, -61, -76, -12, 97, 99, 79, 60, 59, 25,
5, -11, -26, -54, -26, -8, -13, 3, 25, 4,
17, 16, 4, -24, -1, 42, 60, 63, 70, 37,
10, -27, -22, -43, -62, -7, -16, 10, 75, 40,
-26, -64, -96, -106, -3, 73, 73, 46, 55, 29,
-2, -45, -43, 45, 46, 17, 37, 10, 30, 32,
21, -2, -18, -28, -47, -63, -38, -56, -3, 27,
-17, -48, -9, 9, 3, 28, 50, 58, 73, 44,
8, -14, -32, -56, -81, -106, -35, 41, 53, 26,
1, -38, -51, -66, -100, -61, 32, 17, 66, 42,
17, 5, -6, -21, -26, -52, -36, 23, 56, 22,
6, -20, -31, -22, -19, -48, 16, 38, 22, -2,
-25, -67, -93, -51, 82, 62, 71, 69, 63, 35,
-12, -51, -71, -60, -76, -91, -14, 41, 35, 20,
-16, -31, 22, 32, 55, 80, 98, 91, 85, 49,
-21, -63, -92, -6, 57, 27, 36, 11, 60, 39,
-7, -45, -67, -81, -114, -110, 0, 24, 23, 45,
-18, -55, -61, -56, -60, -64, -32, -2, 58, 36,
-3, -33, -51, -24, 19, -10, -19, 4, 14, -15,
-19, -59, -81, -12, 7, -12, 36, 16, 48, 36,
17, -13, -32, -49, -78, -95, -1, -3, -10, 25,
15, 5, 41, 59, 108, 101, 103, 81, 70, 35,
-14, -52, -37, 15, 93, 83, 66, 50, 47, 15,
-3, -31, -49, -52, -9, -31, -10, 37, 62, 27,
-15, -56, -82, -17, 75, 56, 36, 22, 7, -16,
-24, -63, -93, -84, 25, 94, 98, 65, 60, 31,
-2, -45, -39, -61, -61, 48, 35, 32, 54, 18,
-19, -51, -45, -57, -28, -8, 10, 14, 38, 26,
-2, -46, -38, 45, 26, 22, 48, 21, 63, 40,
-22, -61, -73, -75, -67, -31, 13, 18, 51, 34,
-12, -2, -1, -17, -3, -27, -3, 6, -1, -15,
-16, -59, -78, 10, 36, 9, 4, -18, 33, 22,
-25, -62, -97, -107, 39, 87, 69, 46, 42, 12,
11, -7, -30, -36, 19, 2, -10, -7, -4, -24,
11, -8, 25, 28, 28, 5, -4, -10, 5, -2,
-10, -48, -37, -17, -38, -9, -2, -19, -30, -22,
-23, -61, -79, -81, -2, 15, -4, 17, 20, 2,
25, -14, -3, -10, -38, 1, 14, -14, -9, -27,
2, -18, -38, -36, -11, -39, -36, -28, -36, -11,
32, 59, 127, 124, 127, 108, 91, 68, 64, 34,
3, -32, -37, -10, -25, -46, 12, 1, -17, -24,
-29, -69, -102, -100, 2, -7, 11, 14, 1, 31,
30, -6, -4, -16, -44, -5, 3, -9, 66, 40,
-9, -45, -52, -5, 37, 19, 26, 6, 51, 32,
-31, -73, -96, -45, -25, -37, -15, -16, 32, 39,
3, -15, 18, 21, 28, 33, 58, 58, 69, 42,
-31, -73, -99, -99, -48, 14, 21, 5, 2, 39,
7, -35, -20, 29, 2, -8, -8, -28, 38, 26,
-5, -39, -64, -36, 15, -15, -11, -21, -23, 5,
-8, -51, -56, 15, -1, -14, -8, -31, 36, 22,
-8, -53, -68, -98, -101, 42, 49, 38, 41, 12,
10, -27, -22, 4, -23, -21, 30, -1, 22, 26,
-13, -56, -42, 31, 9, -1, -10, -2, 22, -4,
15, 8, 56, 57, 45, 55, 57, 46, 72, 44,
-7, -53, -26, 53, 21, 17, 0, 0, 74, 41,
3, -18, -2, 0, 19, 17, 42, 36, 47, 26,
24, -7, -23, -34, -62, -60, 6, -22, 18, 25,
-11, -42, -46, -61, -83, -99, -67, -11, 28, 39,
30, -3, -10, -1, -24, -30, -1, -28, 15, 18,
19, -15, -10, -6, -35, -26, 33, 10, 56, 39,
-13, -53, -82, -42, 53, 37, 18, 10, -3, -21,
-21, -60, -89, -46, 89, 94, 71, 46, 42, 9,
-2, -34, -44, -46, -64, -84, -1, 37, 16, 0,
-17, -51, -65, -64, -7, -17, -29, -11, 52, 27,
22, -15, -16, -39, -55, 26, 36, 21, 62, 28,
-2, -26, -38, -49, -55, -80, -75, 8, 20, 9,
-6, -47, -61, -82, -103, -17, -15, -25, 53, 40,
-8, -47, -66, -18, 56, 43, 25, 29, 39, 3,
-27, -66, -86, -69, -50, -59, -34, -1, 19, 42,
3, -20, 2, 21, 72, 57, 52, 36, 31, 7,
-12, -49, -61, -13, -1, -33, 5, 37, 26, 2,
-27, -69, -92, -62, 2, 43, 88, 67, 64, 36,
0, -40, -4, -6, -20, 43, 33, 25, 50, 20,
14, -20, -30, -44, -73, -37, -24, -47, 26, 20,
31, 53, 111, 118, 127, 126, 121, 99, 85, 46,
-14, -45, -51, -39, 24, 5, -6, 17, 46, 14,
-4, -43, -45, -70, -63, 8, 14, 58, 78, 39,
-8, -47, -66, -84, -114, -55, 10, -8, 32, 40,
28, 22, 42, 26, 8, -21, -16, -6, 22, 10,
24, 10, 34, 31, 35, 31, 46, 39, 59, 36,
-4, -43, -62, -10, 20, -14, 2, 14, -6, -19,
-21, -62, -89, -22, 62, 33, 30, 16, 15, 15,
0, -22, -31, -45, -58, -80, -66, 13, 68, 34,
-16, -45, -6, 7, -6, -17, -14, -15, 2, 2,
10, -5, -22, -38, -40, -70, -60, -15, -23, 0,
22, -11, -22, -39, -67, -25, 30, 5, 58, 37,
-21, -47, 6, 43, 37, 45, 65, 66, 73, 43,
2, -25, -40, -53, -72, -94, -35, 24, 9, 8,
-3, 0, -3, -9, 4, -23, -10, 20, 43, 14,
-2, -41, -60, -9, 57, 32, 17, 16, 6, -19,
1, -31, -36, -36, -54, -68, -77, -75, 21, 37,
-19, -32, 79, 90, 92, 81, 67, 47, 52, 28,
-6, -36, -57, -62, 27, 40, 21, 11, 9, -19,
-10, -47, -49, -59, -74, -18, -14, -30, 25, 18,
-23, -69, -82, 60, 66, 40, 75, 54, 65, 38,
-19, -57, -92, -68, 66, 58, 34, 18, 1, -16,
-29, -68, -99, -88, -37, -38, 13, 8, 5, 40,
-22, -63, -75, 14, 15, 7, 75, 58, 59, 34,
-23, -62, -82, -39, -31, -53, -27, 5, -3, 20,
13, -26, -20, 22, 2, -3, 35, 13, 54, 39,
32, 5, -13, -22, -45, -58, -1, -20, -19, 7,
30, 46, 70, 55, 89, 88, 91, 67, 56, 28,
-13, -50, -63, -25, -28, -50, -23, -32, -34, 19,
-13, -54, -65, -9, -20, -37, 29, 6, 11, 25,
0, -40, -55, -78, -107, -25, 47, 20, 34, 16,
-20, -58, -96, -103, 38, 43, 27, 30, 15, -1,
-16, -49, -52, -66, -80, -57, -44, -39, 6, 38,
0, -38, 5, 13, -8, 23, 24, 1, 7, -9,
-18, -56, -64, -7, 38, 13, 11, 32, 28, 0,
14, -3, -20, -17, 4, -26, -34, -8, 19, -9,
-23, -60, -83, -38, -8, -32, 11, 19, -1, -5,
-5, -47, -12, 56, 38, 22, 18, -8, -5, -8,
18, -4, -24, -16, 27, 2, -6, 5, 25, -5,
13, 0, -19, -35, -23, -45, -59, -30, 19, 3,
19, -12, -23, 1, -7, -35, -14, -32, -23, 4,
-23, -64, -67, -22, -27, -5, -5, -20, 20, 5,
20, 11, 83, 92, 85, 89, 69, 53, 80, 48,
15, -2, -21, -29, -18, -48, -52, -12, -11, -21,
-6, -38, -55, -68, -9, 33, 22, 19, 25, -1,
-8, -46, -49, -67, -64, 16, 8, -6, 32, 15,
3, -25, -46, -46, 39, 50, 34, 21, 46, 14,
8, -33, -37, -68, -82, 31, 34, 13, 19, -6,
33, 0, 5, -7, -32, 2, 22, -3, 35, 17,
-23, -62, -91, -64, 6, 3, 36, 26, 7, -3,
-12, -54, -60, 26, 46, 16, 30, 22, 8, -4,
-23, -61, -40, 31, 58, 73, 88, 77, 74, 41,
-2, -42, -49, 13, 5, -15, 22, -4, 26, 27,
-13, -54, -39, 18, 2, -8, -12, 34, 56, 23,
-20, -31, 27, 23, 24, 28, 39, 33, 47, 27,
36, 17, -4, -20, -30, -61, -8, 20, 0, -15,
-10, -51, -72, -82, -111, -73, 34, 25, 19, 38,
-10, -45, -63, -55, -46, -75, -45, 34, 34, 12,
6, -18, 29, 26, 7, -9, 0, 5, 38, 22,
-7, -52, -16, 69, 43, 26, 23, 2, 51, 34,
-12, -51, -59, -78, -88, 15, 20, 0, -14, 12,
-3, -36, -59, -45, 60, 49, 28, 20, 16, -13,
-28, -70, -90, 9, 67, 48, 90, 77, 70, 38,
-10, -39, -58, -54, 15, -12, 3, 35, 27, -3,
12, -1, 28, 29, 55, 53, 80, 65, 51, 23,
-17, -61, -39, 74, 56, 43, 75, 51, 58, 36,
-30, -71, -93, -43, -29, -26, 4, -19, -14, 37,
3, -13, -31, -38, 11, -5, -22, -11, 43, 14,
-25, -65, -80, -79, -71, 3, 37, 32, 20, 9,
-20, -60, -77, -26, 18, 43, 44, 24, 22, -3,
-4, -42, -22, -19, -45, -32, -35, -39, -46, 1,
-25, -59, -27, -10, -7, -4, 7, 13, 25, 12,
8, -25, -32, -47, -74, -32, 27, 6, 25, 7,
41, 40, 62, 64, 64, 50, 54, 42, 49, 25,
-21, -63, -88, -21, 16, -3, -4, -26, 57, 38,
8, -25, -34, 2, -8, -28, 2, -22, 12, 23,
-19, -49, 10, 71, 84, 71, 66, 48, 42, 22,
-20, -58, -89, -57, 62, 44, 33, 36, 25, -1,
-22, -55, -27, 1, 43, 37, 46, 50, 51, 26,
1, -38, -46, 22, 34, 4, 20, -2, 3, 9,
-4, -42, -49, -75, -89, -24, -25, 19, 71, 39,
5, -28, -45, -43, -63, -75, -17, -38, 14, 30,
-4, -36, -62, -59, -29, -43, -4, -16, 11, 23,
-19, -57, -82, -39, 26, 2, -2, 20, 11, -10,
-28, -68, -92, -70, 9, -1, -15, -30, 11, 31,
1, -22, -41, -49, -30, -58, -48, 8, 4, -9,
38, 41, 108, 115, 96, 98, 103, 84, 86, 51,
15, 1, 58, 46, 26, 6, 16, 18, 41, 24,
4, -34, -14, -27, -42, 20, 18, 2, 23, 1,
-22, -59, -83, -70, -22, -42, -26, 29, 29, 15,
-14, -34, 11, -1, -21, -35, -3, 1, 29, 16,
-16, -57, -78, -7, 17, -13, 8, -13, -6, 22,
-22, -32, -21, -20, 20, -4, 10, 13, 12, -4,
8, -30, -30, -46, -71, -4, 3, -11, 4, -11,
16, 5, -15, -21, 3, -23, -25, -19, -28, -32,
-28, -68, -98, -101, -34, 19, 71, 52, 49, 30,
-18, -57, -82, -56, -56, -66, 15, 12, 1, 29,
-21, -62, -76, -27, -33, -38, 18, 30, 54, 32,
3, -36, -10, -17, -34, -3, -8, 32, 63, 27,
1, -30, -44, -20, -13, -49, -25, 3, -14, -18,
-26, -68, -80, -46, -28, 17, 42, 37, 58, 34,
30, 26, 57, 55, 49, 25, 16, 3, 24, 11,
35, 35, 67, 57, 60, 82, 114, 103, 93, 55,
18, -8, -23, -32, -53, -68, 15, 11, -6, -7,
-2, -43, -29, 0, -28, -5, -5, -15, 25, -1,
4, -13, -35, -45, 14, -6, -2, 19, 16, -9,
-30, -72, -93, -93, -73, -10, -15, 6, 30, 45,
-23, -58, -50, -55, -74, -60, -23, 0, 6, 21,
-4, -40, -63, -24, 7, -19, 4, -18, 27, 28,
-12, 1, 88, 76, 74, 88, 93, 90, 80, 44,
-13, -59, -43, 52, 27, 21, 15, 12, 42, 11,
22, -14, -17, -33, -57, -4, 5, -18, 40, 18,
-3, -23, -43, -44, 8, -16, -14, -4, -20, -29,
35, 45, 75, 82, 111, 117, 125, 105, 89, 51,
-3, -38, -57, -30, 79, 71, 48, 33, 33, 0,
-17, -62, -57, 66, 67, 35, 29, 5, 22, 17,
3, -31, -34, -21, -44, -49, 42, 23, 24, 26,
-23, -62, -74, -49, -30, -30, -37, -50, 9, 35,
-17, -57, -71, -81, -45, 61, 58, 37, 31, 9,
3, -7, 28, 14, -2, 0, 40, 41, 58, 33,
-11, -51, -74, -17, 40, 12, 8, 13, -4, -22,
-16, -46, -31, -35, -49, -49, -26, -9, -7, -7,
17, -9, -24, -41, -68, -73, 38, 33, 19, 16,
-15, -50, -47, -16, -24, -21, 59, 56, 53, 30,
-14, -54, -57, 2, -17, -33, -34, -21, 4, -4,
-23, -62, -93, -72, 48, 31, 21, 6, 3, 17,
-18, -63, -79, 44, 68, 36, 45, 20, 57, 37,
-29, -72, -99, -111, -86, -31, 7, 25, 39, 55,
-14, -49, -53, -63, -80, -31, 24, 13, 1, -1,
-9, -45, -55, -27, -31, -63, -23, 25, 13, -5,
-20, -61, -80, 7, 44, 16, 54, 40, 32, 17,
24, 7, -8, -43, -62, -54, -11, 7, 35, 27,
-12, -55, -59, -48, -69, -4, -1, -12, 68, 39,
-12, -31, 52, 63, 53, 34, 29, 22, 36, 19,
-26, -66, -97, -79, 50, 41, 40, 48, 54, 28,
-2, -37, -41, -2, -11, -30, 29, 16, 4, -2,
40, 49, 56, 37, 39, 40, 64, 59, 67, 39,
11, -5, 20, 14, 25, 16, 25, 22, 37, 17,
-3, -43, -46, -10, -35, -38, -35, -39, 67, 43,
-7, -47, -33, -39, -60, -12, -18, 11, 43, 11,
-25, -65, -91, -76, -91, -81, 0, 13, 34, 50,
-9, -50, -52, 17, 0, -4, 43, 18, 63, 42,
-8, -15, 15, 41, 56, 35, 51, 45, 51, 29,
0, -14, -24, -36, -43, -70, -39, 27, 33, 5,
-25, -62, -81, -66, -12, -26, -16, -4, -13, 21,
-29, -68, -60, -24, -3, 11, 18, 19, 30, 20,
1, -35, -42, -30, -57, -51, 13, -17, 3, 22,
-8, -27, -12, -2, -7, -21, 36, 41, 34, 12,
-17, -56, -62, -72, -73, -17, -26, 9, 16, 13,
11, -21, -37, -3, 16, -17, 1, -3, -18, -19,
15, -20, -19, -22, -49, -30, -7, -29, 3, -2,
17, -4, 11, 6, 51, 40, 36, 34, 48, 22,
-19, -55, -29, 37, 68, 49, 45, 33, 42, 23,
7, -30, -22, 3, -22, -36, -36, -54, 20, 22,
20, 2, -15, -39, -59, -85, -10, 37, 21, 2,
-15, -54, -77, -54, 74, 70, 48, 32, 51, 20,
-25, -64, -70, -75, -52, 17, 6, -20, -30, 26,
-13, -55, -15, 39, 16, 42, 30, 33, 62, 28,
-21, -56, -30, -35, 6, 13, -4, -29, 33, 27,
-17, -55, -75, -31, 3, -28, -26, 16, 18, -4,
-13, -44, -60, -52, -9, -36, -38, 1, -9, -9,
-12, -50, -77, -70, 43, 47, 28, 13, 43, 16,
-13, -57, -80, -104, -113, -30, 43, 45, 52, 39,
3, -28, -42, -37, -58, -67, 23, 4, 38, 33,
-21, -64, -74, -22, 43, 83, 81, 56, 62, 32,
34, 26, 23, 9, 14, 17, 26, 16, 37, 19,
-5, -48, -49, -75, -65, 9, -6, 41, 45, 15,
32, 30, 63, 83, 90, 91, 100, 84, 85, 52,
-19, -54, -68, -71, 11, 30, 13, 1, 63, 37,
44, 76, 99, 87, 117, 113, 103, 77, 64, 32,
-16, -45, -12, 30, 27, 15, 57, 49, 42, 22,
9, -15, -31, -28, -36, -61, -13, -18, -33, -5,
-12, -55, -8, 82, 64, 47, 42, 21, 27, 9,
-15, -56, -74, -12, -19, -28, 7, -16, 53, 38,
-7, -45, -64, -55, -74, -80, 35, 45, 24, 15,
-25, -48, -34, -42, -6, -27, -9, 9, 13, -7,
-25, -65, -84, -35, 30, 14, 24, 39, 48, 28,
-22, -62, -86, -51, 64, 104, 94, 61, 62, 31,
16, -15, -25, -28, -55, -56, -10, -23, 52, 36,
10, -10, -22, -46, -71, -92, -45, -13, 16, 26,
-22, -65, -84, 17, 85, 55, 66, 48, 55, 31,
-1, -38, -33, -25, -49, -15, 18, -10, 41, 30,
-3, -24, -47, -60, -30, -46, -17, -13, -27, 1,
-7, -41, -61, -54, -50, -78, -28, 5, -2, 20,
17, -12, -27, -4, 8, -27, -5, 23, 14, -12,
-36, -81, -111, -75, -17, -9, 9, 9, 39, 49,
-13, -59, -54, 68, 51, 32, 35, 14, 64, 38,
-11, -44, -69, -57, 11, -11, -5, 3, -16, -15,
34, 36, 41, 16, -8, -24, 11, 23, 48, 28,
-17, -42, 8, 17, 45, 69, 71, 55, 49, 23,
3, -30, -46, -64, -95, -109, 2, 39, 19, 19,
25, -13, -7, 16, -11, -5, 8, -11, 52, 33,
-8, -37, -57, -60, 13, 7, -14, -4, 20, -7,
7, -31, 9, 44, 20, 22, 29, 10, 52, 31,
3, -22, -36, -53, -80, -77, -35, -41, 54, 41,
-21, -59, -87, -83, 12, 69, 57, 36, 32, 2,
6, -14, -34, -42, -4, -32, -27, 10, 4, -20,
-11, -56, -59, 25, 8, -5, -9, -26, 68, 43,
22, 13, 40, 39, 73, 81, 95, 88, 82, 45,
-18, -62, -79, 28, 60, 28, 29, 3, 23, 25,
6, -31, -39, -55, -85, -32, 7, -17, 48, 30,
7, -24, -42, -8, 39, 10, 7, 11, 1, -20,
-1, -36, -26, -30, -48, 2, 46, 26, 35, 14,
-17, -57, -56, -10, -4, 26, 22, 6, -4, -16,
-18, -55, -59, -67, -86, -50, 3, 29, 29, 16,
-25, -61, -33, 2, 26, 25, 23, 10, 24, 16,
26, 15, -8, -20, 6, -21, -16, 3, 0, -22,
13, -17, -26, -12, -31, -48, 15, -3, 1, 14,
4, -27, -33, -21, -29, -53, -52, -64, -42, 22,
-11, -41, -42, -40, -42, -64, 0, 48, 50, 19,
-13, -47, -42, -56, -50, 10, 3, -9, -30, -16,
-4, -47, -12, 14, -13, 21, 13, 6, 73, 40,
-15, -50, -63, -41, -31, -55, -60, -13, 28, 15,
-6, -50, -56, -81, -95, 30, 29, 21, 71, 35,
-14, -58, -65, 37, 40, 9, 18, -10, -4, 20,
31, 33, 79, 106, 119, 103, 100, 77, 64, 33,
14, 7, 56, 81, 97, 85, 85, 61, 45, 20,
-24, -66, -74, -51, -17, 16, 5, -21, 22, 26,
-1, -25, -38, -24, -2, -35, -26, 21, 34, 1,
20, 15, 75, 59, 39, 26, 48, 43, 50, 29,
26, 1, -15, -4, -9, -38, 9, 2, -9, -8,
20, 14, 19, 13, 2, -16, 24, 25, 19, 3,
-8, -41, -58, -78, -109, -106, -27, 9, 53, 46,
17, 5, -13, -25, -24, -54, -20, 2, -21, -25,
-11, -50, -48, 19, 10, -7, 46, 26, 24, 17,
-28, -68, -69, -50, -49, -33, -7, 10, 20, 21,
4, -36, -21, 38, 19, 1, 25, -3, 20, 22,
-18, -58, -87, -44, 82, 73, 49, 31, 19, -7,
-21, -61, -78, -44, -58, -66, -9, -23, 10, 40,
-25, -66, -76, -33, -33, 6, 16, -6, -21, 5,
-27, -69, -77, 5, -2, -7, 6, 9, 24, 6,
1, -41, -41, -58, -79, 25, 69, 43, 68, 36,
-28, -67, -85, -71, -34, 0, 14, 12, -2, 4,
-2, -33, -55, -37, 37, 25, 6, 6, 29, -4,
-8, -25, -11, -9, 40, 23, 17, 25, 37, 12,
-21, -27, 52, 60, 47, 58, 76, 70, 69, 38,
23, 15, 22, -8, -32, -50, -10, 3, 31, 21,
-10, -44, -67, -61, -29, -54, 8, 39, 21, 4,
31, 18, 30, 36, 46, 28, 50, 42, 35, 13,
-21, -57, -24, -16, -15, 14, 3, -25, -17, 20,
23, 6, 24, 35, 90, 72, 64, 55, 55, 23,
7, -28, -42, -19, -36, -50, -15, -40, 29, 28,
-21, -59, -66, -59, -6, 85, 83, 53, 54, 26,
2, -20, -42, -52, -27, -49, 5, 9, -9, -8,
-18, -56, -84, -72, 24, 51, 32, 20, 13, -10,
-13, -53, -64, -39, -63, -40, 24, 0, 34, 29,
0, -31, -45, -63, -90, -53, 3, -18, -9, 24,
-13, -57, -71, 27, 19, -3, 25, -3, 45, 35,
12, -9, -26, -40, -51, -78, -24, 11, -9, -6,
-12, -49, -45, -33, -50, -48, -46, -52, 2, 25,
-14, -56, -84, -108, -122, -50, 4, 22, 42, 53,
-6, -44, -54, -28, -41, -61, 19, 25, 6, 1,
-32, -75, -95, -38, -1, -15, 7, 14, 23, 23,
11, 12, 37, 30, 38, 51, 80, 80, 82, 47,
-19, -56, -69, -82, -98, -64, -29, 2, 28, 42,
-18, -49, 3, 34, 41, 39, 32, 18, 21, 7,
-8, 23, 39, 30, 30, 27, 41, 36, 44, 23,
-16, -49, -69, -46, 1, -27, 41, 48, 35, 15,
6, -32, -36, 5, -17, -30, 2, -16, 51, 35,
-23, -64, -91, -21, 71, 44, 52, 44, 40, 21,
-22, -55, -40, -20, 62, 52, 38, 29, 27, 5,
-27, -69, -75, -6, -8, 3, -2, -30, -42, 13,
2, -29, -42, -10, 29, 2, 15, 30, 26, 0,
-27, -69, -85, -75, -54, -8, -14, -31, 16, 42,
-2, -44, -54, -75, -101, -6, 4, -3, 32, 13,
7, -3, -22, -43, -14, -27, -24, -11, -14, -12,
-18, -57, -85, -66, 47, 86, 75, 45, 42, 10,
18, 3, 39, 76, 80, 48, 48, 41, 44, 21,
-13, -51, -73, -22, -15, -41, 3, -4, -22, 3,
-10, -50, -63, -9, -23, -42, -6, -30, 11, 28,
15, -11, -29, -39, -57, -71, -23, -40, -33, 20,
-2, -40, -48, -5, -21, -25, 31, 7, 53, 35,
-19, -63, -72, 39, 34, 16, 37, 17, 54, 31,
-18, -49, -28, -27, -40, -29, 4, 4, 19, 11,
-1, -43, -41, 24, 15, -12, -4, -31, -4, 23,
-11, -46, -79, -74, 34, 21, 9, 15, 3, -13,
-16, -51, -56, -55, 8, 62, 50, 30, 43, 14,
-1, -25, -27, -32, -46, -62, -66, -36, 53, 32,
-12, -49, -77, -50, 2, -21, 23, 6, 14, 21,
-5, -47, -58, -77, -105, -14, 30, 9, 73, 44,
-24, -52, -4, 10, 13, 13, 27, 27, 42, 24,
-10, -38, -27, -15, -24, -52, -53, 1, 14, -6,
-17, -45, -13, 2, 19, 53, 83, 79, 76, 43,
-21, -62, -86, -48, 40, 17, 14, -9, 40, 30,
-1, -32, -51, -33, -3, -35, 2, 17, -2, -12,
-21, -60, -85, -70, 33, 73, 58, 37, 67, 36,
-1, -45, -39, 37, 17, 3, 18, -8, 53, 35,
-8, -47, -65, -61, -87, -93, 9, 9, 2, 33,
-13, -55, -56, -19, -29, 14, 17, 6, 55, 28,
5, 1, -7, -23, -26, -56, -39, 14, 11, -13,
-28, -69, -89, -74, -83, -45, 1, 0, 16, 45,
-3, 5, 91, 104, 119, 111, 97, 76, 72, 39,
19, 5, -12, -34, -41, -72, -67, 14, 21, 1,
-17, -49, 15, 27, 13, 6, 2, 12, 27, 10,
-10, -30, 18, 36, 93, 87, 87, 69, 58, 26,
37, 32, 64, 54, 53, 67, 78, 73, 80, 48,
48, 46, 38, 9, -1, 8, 47, 44, 58, 33,
-23, -61, -88, -76, 27, 14, 9, 36, 36, 10,
-24, -66, -88, -97, -55, 20, 19, 16, 52, 31,
4, -16, -1, -8, 2, 0, 15, 13, 29, 14,
-9, -44, -66, -72, 8, 32, 37, 38, 46, 16,
-22, -65, -62, 30, 22, 51, 57, 45, 68, 38,
-4, -42, -53, -33, -54, -53, -4, -18, 62, 40,
-5, -37, -61, -41, 35, 15, -2, -3, -12, -28,
-18, -65, -55, 90, 80, 49, 44, 21, 59, 36,
5, -16, -31, -32, -37, -62, -19, -11, 9, 16,
-22, -60, -67, -51, -61, -35, -5, -18, -27, 24,
-18, -55, -39, -42, -40, 20, 25, 6, 6, 7,
0, -25, -42, -50, -59, -84, -31, -13, -22, 17,
-32, -73, -100, -89, -21, -10, 18, 38, 31, 23,
-15, -54, -57, -13, -18, -41, -32, 17, 50, 21,
-16, -57, -71, -10, -8, -26, -38, -47, 42, 25,
-17, -58, -82, -7, 33, 3, 30, 11, 13, 24,
-23, -61, -97, -83, 82, 81, 57, 39, 31, 2,
26, 32, 104, 86, 62, 55, 77, 70, 74, 43,
-8, -29, -33, -52, -74, -73, -17, 14, 39, 25,
-21, -60, -68, -22, 43, 37, 51, 54, 64, 36,
-5, -30, -50, -52, 22, 7, 10, 13, 0, -20,
-15, -53, -61, -34, -50, -25, 15, 6, 0, -14,
-10, -51, -60, 20, 77, 50, 34, 22, 8, -8,
-8, -45, -52, -59, -76, -35, -43, -49, 47, 40,
41, 44, 53, 40, 41, 30, 38, 31, 46, 24,
19, 3, -15, -26, -16, -45, -13, 24, 18, -5,
-3, -39, -54, -35, -49, -70, 2, -6, -19, 15,
-13, -53, -36, 6, -3, 45, 50, 30, 33, 10,
15, -25, -16, -4, -32, 7, 23, 6, 67, 36,
-21, -58, -87, -71, 10, -12, -16, 19, 10, 0,
9, -15, -6, 25, 31, 7, 30, 28, 20, 2,
2, -28, -42, -50, -67, -75, 12, 12, -4, 8,
-17, -63, -58, 56, 49, 36, 60, 38, 37, 14,
-13, -48, -38, -29, -44, -25, -20, -33, 38, 20,
2, -37, -42, -1, -18, -42, 3, -17, -19, 12,
-20, -60, -73, -7, 12, -13, -22, -38, 4, 10,
-8, -41, -63, -65, 42, 63, 45, 31, 31, 0,
-4, -46, -38, -9, -35, 15, 50, 27, 67, 39,
3, -7, -13, -34, -51, -47, 9, 39, 54, 29,
-29, -71, -89, -52, -39, -6, 3, 2, 38, 28,
-14, -42, -13, -15, -19, 0, 20, 12, 37, 25,
11, -26, -24, -40, -65, -11, -13, -27, 65, 37,
0, -31, -46, -17, -21, -45, 11, -2, 25, 24,
51, 91, 102, 87, 85, 63, 57, 42, 48, 23,
-4, -34, -56, -70, -10, -14, 4, 18, 3, -8,
-23, -59, -39, -44, -42, -14, -10, -23, -4, 17,
-2, 4, 35, 63, 69, 75, 82, 63, 78, 48,
-17, -55, -60, -3, -4, -19, 4, -4, -18, -29,
2, -20, -36, -50, -32, -59, -16, 30, 16, -6,
-12, -47, 24, 68, 45, 46, 41, 32, 65, 37,
-4, -40, -54, -67, -96, -66, -9, -25, 42, 38,
-15, 13, 58, 58, 84, 104, 119, 104, 89, 51,
-15, -24, -9, -24, -27, -50, -7, 28, 29, 6,
-7, -33, -35, -49, -65, -53, -37, -10, 33, 14,
31, 19, 46, 72, 67, 45, 83, 68, 63, 41,
-14, -53, -59, -17, 55, 79, 64, 39, 43, 10,
};

const signed char cdbk_lsp2_vlbr[160]={
-20, -30, -24, 17, 7, -13, -21, 61, 56, 16,
12, 1, 10, 77, 32, 3, 7, 3, -25, -31,
-4, 2, -36, -83, 18, 5, -5, 5, 11, 23,
-2, -1, -11, -12, -20, -28, 68, 50, -17, -20,
5, 2, 1, 20, 17, 4, -52, -66, 36, 24,
-4, -10, 7, -15, -32, 80, 37, 8, -13, -29,
33, 37, 28, 15, 8, 14, 35, 18, 50, 36,
-4, -1, 4, -7, 3, 3, -11, -58, -75, 13,
13, 21, 24, -11, -12, -38, -72, 33, 15, -12,
-44, -17, 83, 21, 2, 7, 0, 4, 0, -1,
-25, -42, -51, 33, 20, 15, 30, -13, 9, 32,
6, 2, -8, 7, -38, -77, 6, -13, -7, 32,
48, 57, 32, -12, -10, -4, 2, -15, -29, -29,
2, 10, -9, -16, 79, 44, 7, 12, -5, -18,
-23, -29, -35, -3, -3, -18, -34, -3, -39, -50,
-5, -10, -8, -37, -76, 11, -4, -19, 30, 16,
};

#endif
