/****************************************************************************
** Implementation of class XineInfo
**
** Created: Thu Jun 10 07:53:05 2004
**      by: Varol Okan using the kate editor
**
** This class collects all possible information about
** the current set stream.
**
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <qfileinfo.h>

#include "xineinfo.h"


/****************************************************************************
** CreateXineEngine class
**
** This class will create a xine_t object as a background task.
**
** Usually to create and initialize a xint_t - object takes a few 
** seconds. This is especially disturbing if you start a Dialog, or an
** application and it takes too long to start up.
**
** With this class the object will be created in the background and 
** initialized before returning it to its creator object.
**
*****************************************************************************/
#include <qapplication.h>
#include <qmessagebox.h>
#include <qdir.h>
CreateXineEngine::CreateXineEngine (xine_t **ppXinePointer, QString qsConfigFile)
{
	m_ppXineEngine = ppXinePointer;
	m_qsConfigFile = qsConfigFile;
	start ();	// This will start a new thread and execute the run() function in this thread.
//	run ();	// Okay  stay in the same task and you are safe ...
}

CreateXineEngine::~CreateXineEngine ()
{

}

void CreateXineEngine::run ()
{
	xine_t *pXineEngine = xine_new();

	if (QFile::exists(m_qsConfigFile))
		xine_config_load (pXineEngine, (const char *)m_qsConfigFile);

	xine_init(pXineEngine);

	// FIXME:
	// remove this sleep() when I can figure out why QDVDAuthor is crashing when leaving this thread.
//	uint iForOneYear = 30758400;
//	sleep (iForOneYear);
}

/* The original version ...
void CreateXineEngine::run ()
{
	bool bSave = false;
	xine_t *pXineEngine = xine_new();

	if (!pXineEngine)	{
		QApplication::beep();
		QMessageBox::warning (NULL, QString ("Error creating Xine object."),
			QString ("I could not create the Xine object.\n"), 
			QMessageBox::Ok ,  QMessageBox::NoButton);
		return;
	}

	if (QFile::exists(m_qsConfigFile))
		xine_config_load (pXineEngine, (const char *)m_qsConfigFile);
	else
		bSave = true;

	xine_init(pXineEngine);

	if (bSave)	{
		printf ("No config file found, will create \n%s\n", (const char *) m_qsConfigFile);
		// First we check if the directory exists or if we should create it first ...
		QString qsDirPath = QDir::homeDirPath() + QString ("/.qdvdauthor");
		QDir theDir(qsDirPath);
		if (!theDir.exists())
			theDir.mkdir (qsDirPath);
		xine_config_save  (pXineEngine, (char *)((const char *)m_qsConfigFile));
	}
	// Here we set the original pointer to the new xine_t - object 
	*m_ppXineEngine = pXineEngine;
	// FIXME:
	// remove this sleep() when I can figure out why QDVDAuthor is crashing when leaving this thread.
	uint iForOneYear = 30758400;
	sleep (iForOneYear);
}
*/

