/****************************************************************************
** Interface to the GUI.
**
** Created: Fri Jun 18 22:48:00 2004
**      by: Varol Okan using kate editor
**
**
****************************************************************************/

#ifndef DIALOGCHAPTERS_H
#define DIALOGCHAPTERS_H

#include "uidialogchapters.h"
#include "../sourcefileentry.h"

class MediaInterface;
class StartStopSlider;
class StartStopControl;

class DialogChapters : public uiDialogChapters
{
	Q_OBJECT
public:
	 DialogChapters (QWidget * parent, const char * name = 0, WFlags f = 0 );
	~DialogChapters ();

	void initMe(SourceFileInfo *,  const void *, int=0);
	void initMe(SourceFileEntry *, const void *, int=0);
	SourceFileInfo  *getSourceFileInfo  ();
	SourceFileEntry *getSourceFileEntry ();

private:
	void preview ();
	void play    ();
	void pause   ();

protected slots:
	virtual void slotAddChapter   ();
	virtual void slotDelChapters  ();
	virtual void slotAutoChapters ();
	virtual void slotPreview      ();
	virtual void slotCurrentChanged (QListBoxItem *);
	virtual void accept ();
	virtual void slotNewPosition(int, const QString &);

private:
	SourceFileInfo    m_sourceFileInfo;
	SourceFileEntry   m_sourceFileEntry;
	MediaInterface   *m_pMediaInterface;
	StartStopControl *m_pStartStopControl;
	QString           m_qsPosition;
	int               m_iMovieLength;
	// TODO: delete these two old entries ...
//	QLabel           *m_pLabelSlider;
};

#endif // DIALOGCHAPTERS_H
