/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: od_sl.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: fridrich_strba $ $Date: 2007/05/18 15:44:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef INCLUDED_OD_SL_CXX
#define INCLUDED_OD_SL_CXX

#include <memory>
#include <odiapi/qname/QName.hxx>
#include <odiapi/xxml/XXmlReader.hxx>
#include <odiapi/props/Properties.hxx>
#include <WriterFilterDllApi.hxx>
#include <map>

class WRITERFILTER_DLLPUBLIC ODSLHandler : public writerfilter::xxml::ContentHandler
{
public:
	static std::auto_ptr<ODSLHandler> createODSLHandler(odiapi::props::PropertyPool::Pointer_t propertyPool, writerfilter::xxml::ContentHandler &bridgeHandler);
	virtual const std::map<writerfilter::QName_t, odiapi::props::PropertyPoolHandle_Pointer_t>& getStyles(void) = 0;
};


#endif /*  INCLUDED_OD_SL_CXX */

