/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salsound.h,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 20:42:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_SALSOUND_H
#define _SV_SALSOUND_H

#ifndef _SV_SALSOUND_HXX
#include <vcl/salsound.hxx>
#endif

// ------------
// - SalSound -
// ------------

namespace vcl_sal { class VSound; }

class X11SalSound : public SalSound
{
// public for VSound sub classes
public:
	// the real sound
	vcl_sal::VSound*		m_pVSound;
	
	// the sound to play
	ByteString				m_aSoundFile;
	
	// state data
	bool					m_bLoop;
	bool					m_bPlaying;
	bool					m_bPaused;
	
	ULONG					m_nStartTime;
	ULONG					m_nPlayTime;
	
	static ULONG			s_nSoundState;
	
	void changeStateStop();
	void changeStatePause();
	void changeStateCont();
	void changeStatePlay();
	void setError( ULONG );
public:
    X11SalSound();
	virtual ~X11SalSound();
	
    // overload all pure virtual methods
    virtual bool		IsValid();
    virtual bool		Init( const String&	rSoundName,
                              ULONG&		rSoundLen );
   	virtual void		Play( ULONG nStartTime, ULONG nPlayTime, bool bLoop );
	virtual void		Stop();
	virtual void		Pause();
	virtual void		Continue();
    virtual bool		IsLoopMode() const;
	virtual bool		IsPlaying() const;
    virtual bool		IsPaused() const;
	
	static void Release();
};

#endif // _SV_SALSOUND_HXX
