/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewobjectcontactlist.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 18:47:52 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACTLIST_HXX
#include <svx/sdr/contact/viewobjectcontactlist.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWOBJECTCONTACT_HXX
#include <svx/sdr/contact/viewobjectcontact.hxx>
#endif

#ifndef _SVDPAGE_HXX
#include <svx/svdpage.hxx>
#endif

#ifndef _SVDOBJ_HXX
#include <svx/svdobj.hxx>
#endif

#ifndef _SDR_CONTACT_VIEWCONTACT_HXX
#include <svx/sdr/contact/viewcontact.hxx>
#endif

#ifndef _SDR_CONTACT_DISPLAYINFO_HXX
#include <svx/sdr/contact/displayinfo.hxx>
#endif

// for SOLARIS compiler include of algorithm part of _STL is necesary to
// get access to basic algos like ::std::find
#include <algorithm>

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace contact
	{
		ViewObjectContactList::ViewObjectContactList()
		:	mnCount(0L)
		{
		}

		ViewObjectContactList::~ViewObjectContactList()
		{
			DBG_ASSERT(mnCount == 0L, "ViewObjectContactList::~ViewObjectContactList is not empty (!)");
		}

		ViewObjectContact* ViewObjectContactList::GetObject(sal_uInt32 nIndex) const
		{
			DBG_ASSERT(nIndex < mnCount, "ViewObjectContactList::GetObject() out of range (!)");

			if(1L < mnCount)
			{
				return (*maUnion.mpVOCVector)[nIndex];
			}
			else if(1L == mnCount)
			{
				return maUnion.mpVOContact;
			}
			else
			{
				return 0L;
			}
		}

		ViewObjectContact* ViewObjectContactList::GetLastObjectAndRemove()
		{
			if(1L < mnCount)
			{
				ViewObjectContact* pLastObject = maUnion.mpVOCVector->back();
				maUnion.mpVOCVector->pop_back();

				if(1L == --mnCount)
				{
					// simplify vector to simple pointer again
					ViewObjectContact* pObject = (*maUnion.mpVOCVector)[0];
					delete maUnion.mpVOCVector;
					maUnion.mpVOContact = pObject;
				}

				return pLastObject;
			}
			else if(1L == mnCount)
			{
				mnCount = 0L;
				return maUnion.mpVOContact;
			}

			DBG_ASSERT(sal_False, "ViewObjectContactList::GetLastObjectAndRemove() at empty list (!)");
			return 0L;
		}

		void ViewObjectContactList::Clear()
		{
			if(1L < mnCount)
			{
				delete maUnion.mpVOCVector;
			}

			mnCount = 0L;
		}

		void ViewObjectContactList::Append(ViewObjectContact* pNew)
		{
			DBG_ASSERT(pNew, "ViewObjectContactList::Insert() with empty poiter (!)");

			if(0L == mnCount)
			{
				maUnion.mpVOContact = pNew;
			}
			else if(1L == mnCount)
			{
				ViewObjectContactVector* pNewVector = new ViewObjectContactVector;
				pNewVector->push_back(maUnion.mpVOContact);
				pNewVector->push_back(pNew);
				maUnion.mpVOCVector = pNewVector;
			}
			else
			{
				maUnion.mpVOCVector->push_back(pNew);
			}

			mnCount++;
		}

		sal_Bool ViewObjectContactList::Remove(ViewObjectContact* pOld)
		{
			sal_Bool bRetval(sal_False);
			DBG_ASSERT(pOld, "ViewObjectContactList::Remove() with empty poiter (!)");

			if(1L < mnCount)
			{
				const ViewObjectContactVector::iterator aFindResult = ::std::find(maUnion.mpVOCVector->begin(), maUnion.mpVOCVector->end(), pOld);
				
				if(aFindResult != maUnion.mpVOCVector->end())
				{
					maUnion.mpVOCVector->erase(aFindResult);
					bRetval = sal_True;

					if(1L == --mnCount)
					{
						// simplify vector to simple pointer again
						ViewObjectContact* pObject = (*maUnion.mpVOCVector)[0];
						delete maUnion.mpVOCVector;
						maUnion.mpVOContact = pObject;
					}
				}
			}
			else if(1L == mnCount)
			{
				if(maUnion.mpVOContact == pOld)
				{
					bRetval = sal_True;
					mnCount = 0L;
				}
			}

			return bRetval;
		}

		sal_Bool ViewObjectContactList::Contains(ViewObjectContact* pOld)
		{
			DBG_ASSERT(pOld, "ViewObjectContactList::Contains() with empty poiter (!)");

			if(1L < mnCount)
			{
				const ViewObjectContactVector::iterator aFindResult = ::std::find(maUnion.mpVOCVector->begin(), maUnion.mpVOCVector->end(), pOld);
				return (aFindResult != maUnion.mpVOCVector->end());
			}
			else if(1L == mnCount)
			{
				return (maUnion.mpVOContact == pOld);
			}

			return sal_False;
		}

		// This method only recursively clears the draw hierarchy structure between the
		// DrawObjectContacts, it does not delete any to make them reusable.
		void ViewObjectContactList::ClearDrawHierarchy()
		{
			for(sal_uInt32 a(0); a < Count(); a++)
			{
				ViewObjectContact* pCandidate = GetObject(a);
				DBG_ASSERT(pCandidate, "Corrupt ViewObjectContactList (!)");

				// reset parent-pointer of VOContact
				pCandidate->SetParent(0L);

				// clear and reset sub-list
				pCandidate->ClearDrawHierarchy();
			}

			// clear this list
			Clear();
		}

		// This method recursively rebuilds the draw hierarchy structure in parallel
		// to the SdrObject structure.
		void ViewObjectContactList::BuildDrawHierarchy(
			ObjectContact& rObjectContact, ViewContact& rSourceNode, ViewObjectContact* pParent)
		{
			DBG_ASSERT(Count() == 0L, "BuildDrawHierarchy with not-empty ViewObjectContactList (!)");
			const sal_uInt32 nObjectCount(rSourceNode.GetObjectCount());

			for(sal_uInt32 a(0); a < nObjectCount; a++)
			{
				ViewContact& rViewContact = rSourceNode.GetViewContact(a);

				// Get the ViewObjectContact for this ViewContact and this DrawContact. This creates such an object
				// on demand and adds it to the ViewObjectContactList of the ViewContact.
				ViewObjectContact& rViewObjectContact = rViewContact.GetViewObjectContact(rObjectContact);

				// Now add it to the local list
				Append(&rViewObjectContact);

				// set parent at ViewObjectContact. Do this before calling
				// BuildDrawHierarchy below to evtl. use the valid parent.
				if(pParent)
				{
					rViewObjectContact.SetParent(pParent);
				}

				// is there a sub hierarchy?
				if(rViewContact.GetObjectCount())
				{
					rViewObjectContact.BuildDrawHierarchy(rObjectContact, rViewContact);
				}
			}
		}

		// This method recursively checks the draw hierarchy structure in parallel
		// to the SdrObject structure and rebuilds the invalid parts.
		void ViewObjectContactList::CheckDrawHierarchy(ObjectContact& rObjectContact)
		{
			for(sal_uInt32 a(0); a < Count(); a++)
			{
				ViewObjectContact* pCandidate = GetObject(a);
				DBG_ASSERT(pCandidate, "Corrupt ViewObjectContactList (!)");

				// recursively check the draw hierarchy.
				pCandidate->CheckDrawHierarchy(rObjectContact);
			}
		}

		// If DrawHierarchy is handled by a object itself, the sub-objects are set 
		// to be equally painted to that object
		void ViewObjectContactList::CopyPaintFlagsFromParent(const ViewObjectContact& rParent)
		{
			for(sal_uInt32 a(0); a < Count(); a++)
			{
				ViewObjectContact* pCandidate = GetObject(a);
				DBG_ASSERT(pCandidate, "Corrupt ViewObjectContactList (!)");

				// recursively set DrawHierarchy to use parent
				pCandidate->CopyPaintFlagsFromParent(rParent);
			}
		}
	} // end of namespace contact
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////
// eof
