/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: editsel.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2007/06/27 17:56:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_svx.hxx"

#include <eeng_pch.hxx>

#include <editsel.hxx>
#include <impedit.hxx>
#include <svx/editview.hxx>

//	----------------------------------------------------------------------
//	class EditSelFunctionSet
//	----------------------------------------------------------------------
EditSelFunctionSet::EditSelFunctionSet()
{
	pCurView = NULL;
}

void __EXPORT EditSelFunctionSet::CreateAnchor()
{
	if ( pCurView )
		pCurView->pImpEditView->CreateAnchor();
}

void __EXPORT EditSelFunctionSet::DestroyAnchor()
{
	// Nur bei Mehrfachselektion
}

BOOL __EXPORT EditSelFunctionSet::SetCursorAtPoint( const Point& rPointPixel, BOOL )
{
	if ( pCurView )
		return pCurView->pImpEditView->SetCursorAtPoint( rPointPixel );

	return FALSE;
}

BOOL __EXPORT EditSelFunctionSet::IsSelectionAtPoint( const Point& rPointPixel )
{
	if ( pCurView )
		return pCurView->pImpEditView->IsSelectionAtPoint( rPointPixel );

    return FALSE;
}

void __EXPORT EditSelFunctionSet::DeselectAtPoint( const Point& )
{
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !  Implementieren, wenn Mehrfachselektion moeglich  !
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
}

void __EXPORT EditSelFunctionSet::BeginDrag()
{
	// Nur bei Mehrfachselektion
}


void __EXPORT EditSelFunctionSet::DeselectAll()
{
	if ( pCurView )
		pCurView->pImpEditView->DeselectAll();
}

//	----------------------------------------------------------------------
//	class EditSelectionEngine
//	----------------------------------------------------------------------
EditSelectionEngine::EditSelectionEngine() : SelectionEngine( (Window*)0 )
{
	// Wegen Bug OV: (1994)
	// 1995: RangeSelection lassen, SingleSelection nur fuer ListBoxen geeignet!
	SetSelectionMode( RANGE_SELECTION );
	EnableDrag( TRUE );
}

void EditSelectionEngine::SetCurView( EditView* pNewView )
{
	if ( GetFunctionSet() )
		((EditSelFunctionSet*)GetFunctionSet())->SetCurView( pNewView );

	if ( pNewView )
		SetWindow( pNewView->GetWindow() );
	else
		SetWindow( (Window*)0 );
}

EditView* EditSelectionEngine::GetCurView()
{
	EditView* pView = 0;
	if ( GetFunctionSet() )
		pView = ((EditSelFunctionSet*)GetFunctionSet())->GetCurView();

	return pView;
}

