/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ainfotext.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 19:55:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SDR_ANIMATION_AINFOTEXT_HXX
#define _SDR_ANIMATION_AINFOTEXT_HXX

#ifndef _SDR_ANIMATION_ANIMATIONINFO_HXX
#include <svx/sdr/animation/animationinfo.hxx>
#endif

//////////////////////////////////////////////////////////////////////////////
// predeclarations

class SdrObject;
class SdrTextObj;

//////////////////////////////////////////////////////////////////////////////

namespace sdr
{
	namespace animation
	{
		class AInfoBlinkText : public AInfoMixer
		{
			// The animated object
			SdrObject&								mrObject;

		protected:
			// The blink frequency in ms
			sal_uInt32								mnFrequency;

			// The repeat count, init to 0L which means endless
			sal_uInt32								mnRepeat;

			// bitfield
			// Flag to decide if text will be shown when animation has ended
			unsigned								mbVisisbleWhenStopped : 1;
			unsigned								mbVisisbleWhenStarted : 1;

		private:
			// Create the BasicMixer, called from GetBasicMixer on demand
			virtual sdr::mixer::BasicMixer* CreateBasicMixer();

		protected:
			// local initializations
			void ImplInit();

			// calculate the MixerState value for given time
			virtual double GetMixerState(sal_uInt32 nTime, sdr::contact::DisplayInfo& rDisplayInfo) const;

		public:
			// basic constructor.
			AInfoBlinkText(SdrObject& rObject, sal_uInt32 nDefaultFrequency = 250L);

			// destructor
			virtual ~AInfoBlinkText();

			// test if to register at ObjectAnimator again after given time.
			// Fill in the new time value and return accordingly.
			virtual sal_Bool DoRegisterAgain(sal_uInt32 nTime, sal_uInt32& rNewTime, const AnimationState& rAssociatedAS) const;

			// React on changes of the object of this AnimationInfo.
			virtual void ActionChanged();

			// access to SdrObject
			SdrObject& GetSdrObject() const
			{
				return mrObject;
			}

			// Access to VisibleWhenSTarted flags
			sal_Bool IsVisibleWhenStarted() const;
			sal_Bool IsVisibleWhenStopped() const;

			// Decide if animation is allowed for the given VOC. Default always returns
			// sal_True. Maybe necessary to switch off for accessibility (e.g.)
			virtual sal_Bool IsAnimationAllowed(const sdr::contact::ViewObjectContact& rVOContact) const;
		};
	} // end of namespace animation
} // end of namespace sdr

//////////////////////////////////////////////////////////////////////////////

#endif //_SDR_ANIMATION_AINFOTEXT_HXX

// eof
