/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: nr2function.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 08:00:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef COSV_NR2FUNCTION_HXX
#define COSV_NR2FUNCTION_HXX

// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
                 
namespace cosv
{

                                          
/** Allows to call a function by a number.
*/                 
class Nr2Function
{
  public:               
    typedef void (*FUNC)();
  
    // LIFECYCLE                               
                        Nr2Function()
                            :   aFunctions() { aFunctions.push_back(FUNC(0)); }
    intt                AddFunction(
                            FUNC                i_function )
                            { aFunctions.push_back(i_function);
                              return aFunctions.size() - 1; }
                        ~Nr2Function()  {}
                        
    // OPERATIONS
    /// @param  i_nr    [1 <= i_nr < @->aFunctions.size()]
    void                Call(
                            intt                i_nr ) const
                            { (*aFunctions[i_nr])(); }
  private:
    std::vector<FUNC>   aFunctions;                             
};


/** Allows to call a member function by a number.
*/                 
template <class CLASS>
class Nr2MemberFunction
{
  public: 
    typedef void (CLASS::*FUNC)();
                
    // LIFECYCLE                               
                        Nr2MemberFunction(
                            CLASS &             i_host )
                            :   aFunctions(),
                                rHost(i_host) { aFunctions.push_back(FUNC(0)); }
                            
    intt                AddFunction(
                            FUNC                i_function )
                            { aFunctions.push_back(i_function);
                              return aFunctions.size() - 1; }
                        ~Nr2MemberFunction() {}
                        
    // OPERATIONS
    /// @param i_nr     [1 <= i_nr < @->aFunctions.size()]
    void                Call(
                            intt                i_nr ) const
                            { (rHost.*aFunctions[i_nr])(); }
    // INQUIRY                            
    CLASS &             Host() const            { return rHost; }
                        
  private:
    std::vector<FUNC>   aFunctions;                             
    CLASS &             rHost;  
};


/** Allows to call a function with 1 parameter by a number.
*/                 
template <class PARA1>
class Nr2FunctionP1
{
  public:               
    typedef void (*FUNC)(PARA1);
  
    // LIFECYCLE                               
                        Nr2FunctionP1()
                            :   aFunctions() { aFunctions.push_back(FUNC(0)); }
    intt                AddFunction(
                            FUNC                i_function )
                            { aFunctions.push_back(i_function);
                              return aFunctions.size() - 1; }
                        ~Nr2FunctionP1()  {}
                        
    // OPERATIONS
    /// @param i_nr     [1 <= i_nr < @->aFunctions.size()]
    void                Call(
                            intt                i_nr,
                            PARA1               i_param ) const
                            { (*aFunctions[i_nr])(i_param); }
  private:
    std::vector<FUNC>   aFunctions;                             
};


/** Allows to call a member function with one parameter by a number.
*/                 
template <class CLASS, class PARA1>
class Nr2MemberFunctionP1
{
  public: 
    typedef void (CLASS::*FUNC)(PARA1);
                
    // LIFECYCLE                               
                        Nr2MemberFunctionP1(
                            CLASS &             i_host )
                            :   aFunctions(),
                                rHost(i_host) { aFunctions.push_back(FUNC(0)); }
                            
    intt                AddFunction(
                            FUNC                i_function )
                            { aFunctions.push_back(i_function);
                              return aFunctions.size() - 1; }
                        ~Nr2MemberFunctionP1() {}
                        
    // OPERATIONS             
    /// @param i_nr     [1 <= i_nr < @->aFunctions.size()]
    void                Call(
                            intt                i_nr,
                            PARA1               i_param ) const
                            { (rHost.*aFunctions[i_nr])(i_param); }
    // INQUIRY                            
    CLASS &             Host() const            { return rHost; }

  private:
    std::vector<FUNC>   aFunctions;                             
    CLASS &             rHost;  
};


}   // namespace cosv


#endif
