/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: cpp_defs.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 16:03:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_CPP_CPP_DEFS_HXX
#define ARY_CPP_CPP_DEFS_HXX



// USED SERVICES
	// BASE CLASSES
#include <ary/re.hxx>
	// COMPONENTS
#include <ary/info/codeinfo.hxx>
	// PARAMETERS
#include <ary/ids.hxx>


namespace ary
{

namespace cpp
{


/** Describes a C/C++ #define statement. May be a define or a macro, for which
    two cases the two different constructors are to be used.

    This class is used by cpp::PreProcessor.
*/
class CppDefinition : public RepositoryEntity
{
  public:
    typedef StringVector str_vector;

    virtual             ~CppDefinition() {}

    // INQUIRY
    const udmstri &     DefinedName() const;
	Lid			        Location() const;
    const str_vector &  DefinitionText() const;

    // ACCESS
  protected:
                        CppDefinition(
                            Did                 i_nId,
                            const udmstri &     i_sName,
                            Lid                 i_nDeclaringFile );
  private:
    // Interface RepositoryEntity:
	virtual Rid			inq_Id() const;
	virtual const Documentation &
            	        inq_Info() const;
    virtual void        do_Add_Documentation(
	                        DYN Documentation & let_drInfo );
    // Locals
    virtual const str_vector &
                        inq_DefinitionText() const = 0;

    // DATA
    Did                 nId;
    udmstri             sName;
    Lid                 nLocation;
	Dyn<ary::Documentation>
                        pInfo;
};



// IMPLEMENTATION

inline const udmstri &
CppDefinition::DefinedName() const
    { return sName; }
inline Lid
CppDefinition::Location() const
    { return nLocation; }
inline const CppDefinition::str_vector &
CppDefinition::DefinitionText() const
    { return inq_DefinitionText(); }



}   // end namespace cpp
}   // end namespace ary



#endif


