/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: GeneratorHeap.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:57:46 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

final class GeneratorHeap {
    private static final int        InitSize = 128;
    private int                     _heapSize = 0;
    private ConceptGroupGenerator[] _heap;
    private int                     _size = InitSize;
    private int                     _free = 0;
  
    public GeneratorHeap() {
	_heap = new ConceptGroupGenerator[InitSize];
    }
  
    public void reset() {
	_free = 0;
    }
  
    public void addGenerator(ConceptGroupGenerator gen) {
	if (_free == _size) {
	    final ConceptGroupGenerator[] newArray =
		new ConceptGroupGenerator[_size *= 2];
	    System.arraycopy(_heap, 0, newArray, 0, _free);
	    _heap = newArray;
	}
	_heap[_free++] = gen;
    }
    
    private void buildHeap() {
	for (int i = _heapSize/2; i >= 0; i--) {
	    heapify(i);
	}
    }

    private void heapify(int root) {
	for (int smallest;;) {
	    final int right = (root + 1) << 1;
	    final int left = right - 1;
	    smallest = left<_heapSize &&
		_heap[left].position() < _heap[root].position()
		? left : root;
	    if (right<_heapSize &&
		_heap[right].position()<_heap[smallest].position()) {
		smallest = right;
	    }
	    if (smallest != root) {
		final ConceptGroupGenerator temp = _heap[smallest];
		_heap[smallest] = _heap[root];
		_heap[root] = temp;
		root = smallest;
	    }
	    else {
		break;
	    }
	}
    }

    public boolean start(RoleFiller[] array) throws Exception {
	if ((_heapSize = _free) > 0) {
	    for (int i = 0; i < _free; i++) {
		_heap[i].next();
	    }
	    buildHeap();
	    _heap[0].generateFillers(array);
	    return true;
	}
	else {
	    return false;
	}
    }

    public boolean start() throws Exception {
	if ((_heapSize = _free) > 0) {
	    for (int i = 0; i < _free; i++) {
		_heap[i].step();
	    }
	    buildHeap();
	    return true;
	}
	else {
	    return false;
	}
    }

    public boolean next(RoleFiller[] array) throws Exception {
	if (_heapSize > 0) {
	    if (!_heap[0].next()) { // no more
		if (_heapSize > 1) {
		    _heap[0] = _heap[--_heapSize];
		}
		else {
		    _heapSize = 0;
		    return false;
		}
	    }
	    heapify(0);
	    _heap[0].generateFillers(array);
	    return true;
	}
	else {
	    return false;
	}
    }
    
    public boolean next() throws Exception {
	if (_heapSize > 0) {
	    if (!_heap[0].step()) { // no more
		if (_heapSize > 1) {
		    _heap[0] = _heap[--_heapSize];
		}
		else {
		    _heapSize = 0;
		    return false;
		}
	    }
	    heapify(0);
	    return true;
	}
	else {
	    return false;
	}
    }

    public int position() {
	return _heap[0].position();
    }
    
    public int getConcept() throws Exception {
	return _heap[0].getConcept();
    }
}
