/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ConceptList.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:44:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.util;

public final class ConceptList
implements NonnegativeIntegerGenerator, CompressorIterator {
  private ByteArrayDecompressor _list;
  private byte _k;
  private int  _value = 0;

  public ConceptList(byte[] array, int index) {
    _k = array[index];
    _list = new ByteArrayDecompressor(array, index + 1);
  }
  
  // callback
  public void value(int val) {
    _value += val;
  }
  
  public int first() throws Exception {
    _value = 0;
    return _list.readNext(_k, this) ? _value : END;
  }

  public int next() throws Exception {
    return _list.readNext(_k, this) ? _value : END;
  }
}
